(function (mod) {
    if (typeof exports == "object" && typeof module == "object") // CommonJS
        mod(require("../../lib/codemirror"));
    else if (typeof define == "function" && define.amd) // AMD
        define(["../../lib/codemirror"], mod);
    else // Plain browser env
        mod(CodeMirror);
})(function (CodeMirror) {
    "use strict";

    let yigoFnKw = "";
    let db;
    /***
     * 打开
     * @returns {Promise<unknown>}
     */
    function openDB(dbName) {
        return new Promise((resolve, reject) => {
            // 判断是否已经打开数据库
            if (DESIGNER.DesignerFormulaCacheDB) {
                resolve(DESIGNER.DesignerFormulaCacheDB);
            } else {
                const request = window.indexedDB.open(dbName || 'formuladb');
                // 首次创建数据库
                request.onupgradeneeded = function(event) {
                    const db = event.target.result;
                    let objectStore;
                    if (!db.objectStoreNames.contains('DesignerFormulaCache')) {
                        objectStore = db.createObjectStore('DesignerFormulaCache', { keyPath: 'name' });
                        objectStore.createIndex('name', 'name', { unique: false });
                    }
                }
                request.onsuccess = function(event) {
                    db = request.result;
                    resolve(request.result);
                }
                request.onerror = function(error) {
                    reject(error);
                }
            }
        })
    }

    async function getDB() {
        db = DESIGNER.DesignerFormulaCacheDB;
    }

    getDB().then(()=>{
        console.log("数据库创建成功");
    });

    async function getItem(name, key = 'object') {
        if (!db) {
            db = await openDB();
        }
        return new Promise((resolve, reject) => {
            const request = db.transaction([name], 'readwrite')
                .objectStore(name)
                .get(key);
            request.onsuccess = (event) => {
                if (request.result) {
                    resolve(request.result.value);
                } else {
                    resolve(request.result);
                }
            }
            request.onerror = (error) => {
                reject(error);
            }
        });
    }

    async function getKeyWords() {
        yigoFnKw = await getItem("DesignerFormulaCache", "yigoFnKw");
    }

    getKeyWords().then(()=>console.log("读取yigoFnKw成功"));

    // 从后台获取关键字
    function getKeyWordsFromBackend() {
        let keyWordsReturn = "";
        // 从后台重新获取关键字
        let params = {
            cmd: "ExpAutoComplete",
            service: "DesignService",
            dataType: "initKeyWords",
            currentFormKey : ""
        };
        let getSyncKeyWords = function (params) {
            let url = Svr.SvrMgr.ServletURL;
            let r = new Svr.Request();
            return r.getSyncData(url, params);
        };
        let result = getSyncKeyWords(params);
        if (!result) {
            console.log("请求后台函数提醒功能失败");
            return;
        }
        let rs = $.parseJSON(result);
        if (rs) {
            if (rs.errors) {
                console.log(rs.errors);
                return;
            }
            if (rs.keyWords && rs.keyWords.length > 0) {
                keyWordsReturn = rs.keyWords[0];
            }
        } else {
            console.log("rs为：" + rs);
        }
        return keyWordsReturn;
    }

    CodeMirror.defineMode("yigo", function (config, parserConfig) {
        var jsonldMode = parserConfig.jsonld;
        var isOperatorChar = /[+\-*&%=<>!?|~^@]/;

        function parseWords(str) {
            if (!str) {
                return "";
            }
            var obj = {},
                words = str.split(" ");
            for (var i = 0; i < words.length; ++i) obj[words[i]] = true;
            return obj;
        }

        // 关键字
        let keywords;
        if (!yigoFnKw) {
            yigoFnKw = getKeyWordsFromBackend();
        } else {
            keywords = parseWords(yigoFnKw);
        }

        let type, content;

        function ret(tp, style, cont) {
            type = tp;
            content = cont;
            return style;
        }

        function tokenBase(stream, state) {
            var beforeParams = state.beforeParams;
            state.beforeParams = false;
            var ch = stream.next();

            if (ch == '"' || ch == "'") {
                state.tokenize = tokenString(ch);
                return state.tokenize(stream, state);
            } else if (ch == "." && stream.match(/^\d[\d_]*(?:[eE][+\-]?[\d_]+)?/)) {
                return ret("number", "number");
            } else if (ch == '[') {
                stream.skipTo(']');
                stream.eat(']');
                return ret("string", "string");
            } else if (/\d/.test(ch)) {
                stream.eatWhile(/[\w\.]/);
                return "number";
            } else {
                if (ch == ";" || ch == "(" || ch == ")" || ch == "=" || ch == ">" || ch == "<"
                    || ch == "!" || ch == "," || ch == "{" || ch == "}" || ch == "+" || ch == "-"
                    || ch == "*" || ch == "/" || ch == "%" || ch == "&" || ch == "|" || ch == "^") {
                    return null;
                }
                stream.eatWhile(/[a-zA-Z0-9_.]/);
                var word = stream.current();
                if (!keywords) {
                    yigoFnKw = getKeyWordsFromBackend();
                    keywords = parseWords(yigoFnKw);
                }
                if (keywords && keywords.propertyIsEnumerable(word)) {
                    state.beforeParams = true;
                    return "keyword";
                }
                return null;
            }
        }

        function tokenString(quote) {
            return function (stream, state) {
                var escaped = false,
                    next;
                if (jsonldMode && stream.peek() == "@" && stream.match(isJsonldKeyword)) {
                    state.tokenize = tokenBase;
                    return ret("jsonld-keyword", "meta");
                }
                while ((next = stream.next()) != null) {
                    if (next == quote && !escaped) break;
                    escaped = !escaped && next == "\\";
                }
                if (!escaped) state.tokenize = tokenBase;
                return ret("string", "string");
            };
        }

        return {
            startState: function () {
                return {
                    tokenize: tokenBase,
                    beforeParams: false,
                    inParams: false
                };
            },
            token: function (stream, state) {
                if (stream.eatSpace()) return null;
                return state.tokenize(stream, state);
            }
        };

    });

    CodeMirror.registerHelper("hint", "yigo", function (cm) {
        //自动补全
        var hintList = ['LoadData', 'GetDictValue', 'Mid'];

        var cur = cm.getCursor(),
            token = cm.getTokenAt(cur);
        var start = token.start,
            end = cur.ch
        var str = token.string

        var list = hintList.filter(function (item) {
            return item.indexOf(str) === 0
        })

        if (list.length) return {
            list: list,
            from: CodeMirror.Pos(cur.line, start),
            to: CodeMirror.Pos(cur.line, end)
        };
    });

    CodeMirror.defineMIME("text/x-yigo", "yigo");

});