package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceLoad;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceSave;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.enhance.*;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

public class EnhanceOperUtil extends HandleSettingImpl {

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
//        SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaEnhanceLoad enhanceLoad = new MetaEnhanceLoad(AppRunType.App);
        enhanceLoad.load(document);
        MetaEnhance enhance = (MetaEnhance) enhanceLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        (new MetaEnhanceSave(enhance)).save(designSettingMetaResolver, filePath);
    }

    @Override
    public void reload(String filePath) throws Exception {

    }

    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        // 从当前表单的document中获取表格数据
        DataTable serviceDataTable = document.get("ED_EnhanceService");
        DataTable functionDataTable = document.get("ED_EnhanceFunction");
        serviceDataTable.setShowDeleted(true);
        functionDataTable.setShowDeleted(true);

        if (isTableChange(serviceDataTable)) {
            serviceDataTable.setShowDeleted(false);
            // 先将子节点都删除，后面再依次创建
            rootNode.deleteChildByTagName(MetaExtService.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtSysService.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtImportService.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtExportService.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtPostExportService.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtDataProcess.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtAttachmentProcess.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtDocumentService.TAG_NAME);
            if (serviceDataTable.size() > 0) {
                for (int i = 0; i < serviceDataTable.size(); i++) {
                    String description = serviceDataTable.getString(i, "Description");
                    String serviceImpl = serviceDataTable.getString(i, "ServiceImpl");
                    String serviceType = serviceDataTable.getString(i, "ServiceType");
                    String serviceName = serviceDataTable.getString(i, "Name");
                    String subTagName;
                    String nameAttr = "Name";
                    String descriptionAttr = "Description";
                    String implAttr = "Impl";
                    if (MetaExtSysService.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaService.TAG_NAME;
                    } else if (MetaExtService.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaService.TAG_NAME;
                    } else if (MetaExtImportService.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaImportService.TAG_NAME;
                    } else if (MetaExtExportService.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaExportService.TAG_NAME;
                    } else if (MetaExtPostExportService.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaPostExportService.TAG_NAME;
                    } else if (MetaExtDataProcess.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaDataProcess.TAG_NAME;
                    } else if (MetaExtAttachmentProcess.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaAttachmentProcess.TAG_NAME;
                    } else if (MetaExtDocumentService.TAG_NAME.equals(serviceType)) {
                        subTagName = MetaDocumentService.TAG_NAME;
                    } else {
                        continue;
                    }
                    TagNode serviceNode = rootNode.getOrCreateChildByTagName(serviceType);
                    ;
                    TagNode subServiceNode = new TagNode(subTagName, null);
                    ;
                    subServiceNode.setAttribute(nameAttr, serviceName);
                    subServiceNode.setAttribute(implAttr, serviceImpl);
                    if (StringUtils.isNotEmpty(description)) {
                        subServiceNode.setAttribute(descriptionAttr, description);
                    }
                    serviceNode.addNode(subServiceNode);
                }
            }
        }
        if (isTableChange(functionDataTable)) {
            functionDataTable.setShowDeleted(false);
            // 先将子节点都删除，后面再依次创建
            rootNode.deleteChildByTagName(MetaExtReportFunction.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtUIFunction.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtMidFunction.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtStartListener.TAG_NAME);
            rootNode.deleteChildByTagName(MetaExtUpdateListener.TAG_NAME);
            if (functionDataTable.size() > 0) {
                for (int i = 0; i < functionDataTable.size(); i++) {
                    String functionDescription = functionDataTable.getString(i, "FunctionDescription");
                    String functionProvider = functionDataTable.getString(i, "FunctionProvider");
                    String functionType = functionDataTable.getString(i, "FunctionType");
                    String subTagName;
                    String descriptionAttr = "Description";
                    String implAttr = "Provider";
                    int index = -1;
                    if (MetaExtReportFunction.TAG_NAME.equals(functionType)) {
                        subTagName = MetaFunction.TAG_NAME;
                        index = 1;
                    } else if (MetaExtUIFunction.TAG_NAME.equals(functionType)) {
                        subTagName = MetaUIFunction.TAG_NAME;
                    } else if (MetaExtMidFunction.TAG_NAME.equals(functionType)) {
                        subTagName = MetaMidFunction.TAG_NAME;
                        index = 0;
                    } else if (MetaExtStartListener.TAG_NAME.equals(functionType)) {
                        subTagName = MetaStartListener.TAG_NAME;
                        implAttr = "Impl";
                        index = 3;
                    } else if (MetaExtUpdateListener.TAG_NAME.equals(functionType)) {
                        subTagName = MetaUpdateListener.TAG_NAME;
                        implAttr = "Impl";
                    } else {
                        continue;
                    }
                    TagNode serviceNode;
                    if (index > -1) {
                        serviceNode = rootNode.getOrCreateChildByTagName(functionType, index);
                    } else {
                        serviceNode = rootNode.getOrCreateChildByTagName(functionType);
                    }
                    TagNode subServiceNode = new TagNode(subTagName, null);
                    ;
                    subServiceNode.setAttribute(implAttr, functionProvider);
                    if (StringUtils.isNotEmpty(functionDescription)) {
                        subServiceNode.setAttribute(descriptionAttr, functionDescription);
                    }
                    serviceNode.addNode(subServiceNode);

                }
            }
        }
    }

}
