package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.advancedqueries.AdvancedQueriesConstant;
import com.bokesoft.erp.advancedqueries.AdvancedQueryUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.commondefvest.ERPCommonDefVestDiffProcessor;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CommonDefProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.mergesingle.util.FormToolOperUtil;
import com.bokesoft.yes.design.newproject.DesignCommonDefMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefCollectionLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefCollectionSave;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.commondef.extend.MetaCommonDefCollection;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CommonDefVestCollectionOperJsonUtil extends HandleSettingImpl {
	@Override
	public void reload(String filePath) throws Throwable {
//		String projectKey = LoadFileTree.getProjectKey(filePath);
//
//		TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
//		String solutionKey = treeNode.solutionKey;
//		CommonDefProcessor.getInstance().reloadCommonDef(projectKey, solutionKey);
		ERPCommonDefVestDiffProcessor.commonDefVestDiffProcessor(MetaFactory.getGlobalInstance());
	}

	public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
		DataTable ED_CommonDefVestCollection = document.get("ED_CommonDefVestCollection");
		DataTable collecTable = document.get(ConstantUtil.TBL_OPERATION_TOOLBAR_DETAIL);
		DataTable fieldTable = document.get(ConstantUtil.TBL_OPERATIONS);
		DataTable macroDetail = document.get(ConstantUtil.TBL_MACRO_FORMULA);
		DataTable statusCollection = document.get(ConstantUtil.TBL_STATUS_LIST);
		XmlTreeWithPath xmlTree = diff.getXmlTree();
		xmlTree.xmlTree.getRoot().getChildren().clear();
		if (!document.get("ED_CommonDefVestCollection").isEmpty()) {
			for (int i = 0; i < ED_CommonDefVestCollection.size(); i++) {
				String scope = ED_CommonDefVestCollection.getString(i, "Scope");
				Long oid = ED_CommonDefVestCollection.getLong(i, "OID");
				TagNode commonDef = new TagNode("CommonDef", null);
				commonDef.setAttribute("Scope", scope);
				xmlTree.xmlTree.getRoot().addNode(commonDef);

				DataTable collecTable1 = collecTable.deepClone();//
				collecTable1.setFilter("POID==" + oid);
				collecTable1.filter();
				DataTable macroDetail1 = macroDetail.deepClone();//
				macroDetail1.setFilter("POID==" + oid);
				macroDetail1.filter();
				DataTable statusCollection2 = statusCollection.deepClone();//
				statusCollection2.setFilter("POID==" + oid);
				statusCollection2.filter();

				dealOperationToobar(commonDef, collecTable1, fieldTable, macroDetail1);
				dealStatus(statusCollection2, commonDef);
			}
		} else {
			TagNode root = xmlTree.xmlTree.getRoot();
			root.getChildren().clear();
		}
		MergeSingleDiffUtil.genSingleXmlDiff(xmlTree.xmlTree.getRoot(), diff);
	}

	private void dealStatus(DataTable statusCollection, TagNode root) {
		if (!statusCollection.isEmpty()) {
			TagNode tagNode = root.getOrCreateChildByTagName(MetaStatusCollection.TAG_NAME);
			if (tagNode == null) {
				tagNode = new TagNode(MetaStatusCollection.TAG_NAME, null);
				root.addNode(tagNode, 2);
			} else {
				tagNode.deleteChildByTagName("Status");
			}
			dealStatusList(statusCollection, tagNode);
		} else {
			root.deleteChildByTagName(MetaStatusCollection.TAG_NAME);
		}
	}

	@Override
	public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
		// 修改Setting直接保存到xml文件中不再生成临时文件
		String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
		String filePath = diff.getFilePath();
		org.w3c.dom.Document document = DomHelper.createDocument(xml);
		MetaCommonDefCollectionLoad metaCommonDefLoad = new MetaCommonDefCollectionLoad(AppRunType.App);
		metaCommonDefLoad.load(document);
		MetaCommonDefCollection metaCommonDef = (MetaCommonDefCollection) metaCommonDefLoad.getRootMetaObject();
		for (MetaCommonDef commonDef : metaCommonDef) {
			dealMetaCommonDef(commonDef);
		}

		DesignCommonDefMetaResolver designCommonDefMetaResolver = new DesignCommonDefMetaResolver();
		(new MetaCommonDefCollectionSave(metaCommonDef)).save(designCommonDefMetaResolver, filePath);
		if (diff.getNewXmlFragment() != null) {
			jsonObject.put("newXml", diff.getNewXmlFragment());
		} else {
			jsonObject.put("newXml", xmlTree.xmlTree.getOrgXml());
		}
		jsonObject.put("xmlPath", StringUtil.isBlankOrNull(filePath) ? filePath : FilePathHelper.toFrontFilePath(filePath));
	}

	private void dealMetaCommonDef(MetaCommonDef metaCommonDef) {
		if (metaCommonDef.getScriptCollection() == null) {
			return;
		}
		for (MetaScript metaScript : metaCommonDef.getScriptCollection()) {
			if (metaScript.getVerb() == -1) {
				// FormVerb的parse方法转换Other错误，此处修正
				metaScript.setVerb(FormVerb.Other);
			}
		}
	}

	public void dealStatusList(DataTable statusCollection, TagNode tagNode) {
//		List<AbstractNode> childs = tagNode.getChildren();
		for (int j = 0; j < statusCollection.size(); j++) {
			String keyDetail = statusCollection.getString(j, "Key");
			String statusCaption = statusCollection.getString(j, "Caption");
			Integer statusValue = statusCollection.getInt(j, "StatusValue");
			boolean standalone = statusCollection.getBoolean(j, "IsStandalone");
			int state = statusCollection.getState(j);
			if (state == RowState.NEW || state == RowState.MODIFIED || state == RowState.NORMAL) {
				TagNode script = new TagNode(ConstantUtil.STATUS, null);
				script.setAttribute(ConstantUtil.KEY, keyDetail);
				if (StringUtils.isNotEmpty(statusCaption)) {
					script.setAttribute(ConstantUtil.CAPTION, statusCaption);
				}
				if (statusValue != -1) {
					script.setAttribute(ConstantUtil.VALUE, String.valueOf(statusValue));
				}


				script.setAttribute(MetaConstants.STATUS_STANDALONE, String.valueOf(standalone));

				tagNode.addNode(script);
			} else if (state == RowState.DELETED) {
				List<AbstractNode> childrenDelete = tagNode.getChildren();
				for (Iterator<AbstractNode> iterator = childrenDelete.iterator(); iterator.hasNext(); ) {
					AbstractNode dren = iterator.next();
					if (dren instanceof TagNode) {
						String chridrenName = ((TagNode) dren).getTagName();
						if (ConstantUtil.STATUS.equalsIgnoreCase(chridrenName)
								&& ((TagNode) dren).getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(keyDetail)) {
							iterator.remove();
						}
					}
				}
			}
		}
	}

	public static void dealOperationToobar(TagNode rootNode, DataTable collecTable, DataTable fieldTable, DataTable marcoTable) throws Throwable {
		FormToolOperUtil.dealOperationCollection(collecTable, fieldTable, rootNode, false, false, null, null);
		FormToolOperUtil.dealMacroCollection(marcoTable, rootNode, false, null);
	}
}
