package com.bokesoft.yes.design.search.text;

import java.io.File;
import java.util.ArrayList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.design.search.FileSearchResult;

/**
 * 匹配文件的行
 */
public class LineElement {

	/** 文件信息 */
	private final File fParent;

	/** 行号 */
	private final int fLineNumber;

	/** 匹配字符的开始位置, 行开始的字符 */
	private final int fLineStartOffset;

	/** 匹配字符的结束位置(匹配字符并不一定是真实的) */
	// private final int fLineEndOffset;

	/** 行内容 */
	private final String fLineContents;

	// public LineElement(File parent, int lineNumber, int lineStartOffset, int
	// lineEndOffset, String lineContents) {
	public LineElement(File parent, int lineNumber, int lineStartOffset, String lineContents) {
		fParent = parent;
		fLineNumber = lineNumber;
		fLineStartOffset = lineStartOffset;
		// fLineEndOffset = lineEndOffset;
		fLineContents = lineContents;
	}

	public File getParent() {
		return fParent;
	}

	/**
	 * 行号
	 * 
	 * @return
	 */
	public int getLine() {
		return fLineNumber;
	}

	/**
	 * 行内容
	 * 
	 * @return
	 */
	public String getContents() {
		return fLineContents;
	}

	/**
	 * 匹配到的行开始位置
	 * 
	 * @return
	 */
	public int getOffset() {
		return fLineStartOffset;
	}

	/**
	 * 位置是否在匹配字符内
	 * 
	 * @param offset
	 * @return
	 */
	public boolean contains(int offset) {
		return fLineStartOffset <= offset && offset < fLineStartOffset + fLineContents.length();
	}

	/**
	 * 获取行内容长度
	 * 
	 * @return
	 */
	public int getLength() {
		return fLineContents.length();
	}

	public FileMatch[] getMatchs(FileSearchResult result) {
		ArrayList<FileMatch> res = new ArrayList<>();
		Match[] matches = result.getMatches(fParent);
		for (Match match : matches) {
			FileMatch curr = (FileMatch) match;
			if (curr.getLineElement() == this) {
				res.add(curr);
			}
		}
		return res.toArray(new FileMatch[res.size()]);
	}

	public int getNumberOfMatches(FileSearchResult result) {
		int count = 0;
		Match[] matches = result.getMatches(fParent);
		for (Match match : matches) {
			FileMatch curr = (FileMatch) match;
			if (curr.getLineElement() == this) {
				count++;
			}
		}

		return count;
	}

	@Override
	public String toString() {
		JSONObject jsonObj = new JSONObject();
		JSONHelper.writeToJSON(jsonObj, "Content", this.getContents());
		JSONHelper.writeToJSON(jsonObj, "Length", this.getLength());

		return jsonObj.toString();
	}

}
