package com.bokesoft.yes.design.search.replace;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.io.FileUtils;

/**
 * 文件内容替换
 */
public class FileContentReplacer {

	public static String getReplaceFileContent(File file, String replacementText, List<MatchReplace> matchs)
			throws IOException {
		Collections.sort(matchs, new Comparator<MatchReplace>() {

			@Override
			public int compare(MatchReplace o1, MatchReplace o2) {
				int x = o1.getfOffset(), y = o2.getfOffset();
				return (x < y) ? 1 : ((x == y) ? 0 : -1);
			}

		});

		String fileContent = FileUtils.readFileToString(file, "UTF-8");
		StringBuffer buffer = new StringBuffer(fileContent);

		MatchReplace match = null;
		String matchStr = null;
		String targetText = null;
		for (int i = 0; i < matchs.size(); i++) {
			match = matchs.get(i);
			matchStr = match.getMatchStr();

			targetText = fileContent.substring(match.getfOffset(), match.getfOffset() + matchStr.length());

			if (matchStr.equals(targetText)) {
				fileContent.replace(targetText, replacementText);
				buffer.replace(match.getfOffset(), match.getfOffset() + targetText.length(), replacementText);
			}
		}

		return buffer.toString();
	}

	/**
	 * 替换
	 * 
	 * @param file            文件
	 * @param targetText      目标字符
	 * @param replacementText 替换字符
	 * @throws IOException
	 */
	public static void replaceContentInFile(File file, String replacementText, List<MatchReplace> matchs)
			throws IOException {

		Collections.sort(matchs, new Comparator<MatchReplace>() {

			@Override
			public int compare(MatchReplace o1, MatchReplace o2) {
				int x = o1.getfOffset(), y = o2.getfOffset();
				return (x < y) ? 1 : ((x == y) ? 0 : -1);
			}

		});

		String fileContent = FileUtils.readFileToString(file, "UTF-8");
		StringBuffer buffer = new StringBuffer(fileContent);

		MatchReplace match = null;
		String matchStr = null;
		String targetText = null;
		for (int i = 0; i < matchs.size(); i++) {
			match = matchs.get(i);
			matchStr = match.getMatchStr();

			targetText = fileContent.substring(match.getfOffset(), match.getfOffset() + matchStr.length());

			if (matchStr.equals(targetText)) {
				fileContent.replace(targetText, replacementText);
				buffer.replace(match.getfOffset(), match.getfOffset() + targetText.length(), replacementText);
			}
		}

		FileUtils.writeStringToFile(file, buffer.toString(), "UTF-8");
	}

//	public static void main(String[] args) {
//		try {
//			File file = new File("D:\\TestMatch\\AppDef.xml");
//
//			List<MatchReplace> matchs = new ArrayList<>();
//			// matchs.add(new MatchReplace("Caption", 40));
//			// matchs.add(new MatchReplace("Caption", 167));
//
//			String replacement = "CMD";
//
//			System.out.println(matchs);
//
//			replaceContentInFile(file, replacement, matchs);
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
//	}

}
