package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NewGridFiledOperUtil extends SingleSettingImpl {

	private List<UICommand> result1 = new ArrayList<>();

	public List<UICommand> getUiCommands(Diff diff) {
		return result1;
	}

	@Override
	public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
// 普通马甲不会走到这里来所以不用判断
		result1.add(UICommand.reloadFormKey(diff.formKey));
		result1.add(UICommand.reloadXmlSource(diff.getFilePath()));
		DataTable headTable = document.get("ED_NewCompModal");
		Boolean isNewDataSource = headTable.getBoolean("IsNewDataSource");
		Boolean isAllowMultiSelection = headTable.getBoolean("IsAllowMultiSelection");
		String ItemKey = headTable.getString("DictItemkey");
		String dataElementKey = headTable.getString("DataElementKey");
		String DynamicDictItemkey = headTable.getString("DynamicDictItemkey");
		String controlType = ControlType.toString(headTable.getInt("ControlType"));
		XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
		XmlTreeWithPath xmlTree = diff.getXmlTree();
//		String sideType = headTable.getString("SideType");
		String sideKey = diff.sideKey;

		//根据获取原单的位置
		TagNode tagNode3 = vestXmlTree.xmlTree.getTagNode(MetaGridColumn.TAG_NAME + "@" + sideKey);
		String xmlTreeKey = "Grid@" + diff.parentKey;

		MetaGrid grid = (MetaGrid) diff.getMetaForm().componentByKey(diff.parentKey);
//		IDLookup.getIDLookup(diff.getMetaForm()).get
		Integer columnIndex = grid.getColumnIndex(sideKey);
		if (columnIndex == null){
			//判断是否在第一层
			MetaGridColumn gridColumn = grid.findColumnByKey( sideKey);
			if (gridColumn == null || gridColumn.hasChildren()){
				throw new Throwable("当前选中非子叶无法处理！");
			}
			columnIndex = gridColumn.getColumnCollection().indexOf(gridColumn);
		}
		TagNode parentNode = null;
		List<String> strings = new ArrayList<>();
		if (tagNode3!=null){
			strings.add(tagNode3.getPrimaryKey());
			QuoteGridFiledOperUtil.getParent(tagNode3, xmlTree.xmlTree.getTagNode(xmlTreeKey), strings);
			if (parentNode == null){
				parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
			}
			for (int i = strings.size() - 2; i >= 0; i--) {
				if (strings.get(i).contains("@")) {
					parentNode = parentNode.getOrCreateChildByKey(strings.get(i).split("@")[0], strings.get(i).split("@")[1]);
				} else {
					parentNode = parentNode.getOrCreateChildByKey(strings.get(i), "");
				}
			}
			parentNode = parentNode.getParent();
		} else {
			parentNode = xmlTree.xmlTree.getTagNode(MetaGridColumn.TAG_NAME +"@"+ diff.sideKey).getParent();
		}

		String columnKey = null;
		String tableKey = null;
		if (isNewDataSource) {
			columnKey = headTable.getString("ColumnKey");
		}
		TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
		//获取马甲
		String key = headTable.getString(ConstantUtil.KEY);
		TagNode tagNode1 = new TagNode(MetaGridColumn.TAG_NAME, null);
		tagNode1.setAttribute(ConstantUtil.KEY, key);
		String caption = headTable.getString(ConstantUtil.CAPTION);
		tagNode1.setAttribute(ConstantUtil.CAPTION, caption);
		tagNode1.setAttribute(ConstantUtil.WIDTH, "80px");
		tagNode1.setAttribute("SideKey", grid.getLeafColumn(columnIndex).getKey());
		tagNode1.setAttribute("InsertAfter", String.valueOf(diff.insertAfter));
		parentNode.addNode(tagNode1);
		TagNode gridRowCollectionTagNode = fieldNode.getOrCreateChildByTagName(ConstantUtil.GRID_ROW_COLLECTION);
		//判断原单有几行
		List<TagNode> tagNodeChildrenByTagName = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).getOrCreateChildByTagName(ConstantUtil.GRID_ROW_COLLECTION).getTagNodeChildrenByTagName(ConstantUtil.GRID_ROW);
		int i = 0;
		String tmpKey = key;
		for (TagNode tagNode : tagNodeChildrenByTagName) {
			String rowKey = tagNode.getAttributes().get(ConstantUtil.KEY);
			TagNode rowNode = gridRowCollectionTagNode.getOrCreateChildByKey(tagNode.getTagName(), rowKey);
			TagNode cell = new TagNode(ConstantUtil.GRID_CELL, null);
			if (i != 0) {
				tmpKey = tmpKey + i;
			}

			cell.setAttribute(ConstantUtil.KEY, tmpKey);
			cell.setAttribute(ConstantUtil.CELL_TYPE, controlType);
			cell.setAttribute(ConstantUtil.CAPTION, caption);
			MetaGridCell gridCell = grid.getRowCollection().get(tagNodeChildrenByTagName.indexOf(tagNode)).get(columnIndex);
			cell.setAttribute("SideKey", gridCell.getKey());
			cell.setAttribute("InsertAfter", String.valueOf(diff.insertAfter));

			rowNode.addNode(cell);
			i++;
			if (columnKey != null) {
				TagNode dataBinding = cell.getOrCreateChildByTagName("DataBinding");
				dataBinding.setAttribute(ConstantUtil.COLUMN_KEY, columnKey);
				tableKey = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).findFirstTagNodeByTagName("GridRow").getAttributes().get("TableKey");
			}
			if ("NumberEditor".equals(controlType)) {
				TagNode formatNode = cell.getOrCreateChildByTagName("CellFormat");
				formatNode.setAttribute("HAlign", "Right");
			} else if ("Dict".equals(controlType)) {
				if (StringUtils.isNotEmpty(ItemKey)) {
					cell.setAttribute(ConstantUtil.ITEM_KEY, ItemKey);
					if (ItemKey.endsWith("__Dic")) {
						cell.setAttribute(Property.StateMask.name, "Enable|Disable|Discard");
					}
				} else {
					throw new Throwable("ItemKey为空，请检查配置");
				}
				cell.setAttribute(Property.AllowMultiSelection.name, isAllowMultiSelection.toString());
			} else if ("DynamicDict".equals(controlType)) {
				if (StringUtils.isNotEmpty(DynamicDictItemkey)) {
					cell.setAttribute(ConstantUtil.REF_KEY, DynamicDictItemkey);
				} else {
					cell.setAttribute(ConstantUtil.REF_KEY, "true");
				}
			}
			XmlDiffProcessor.addDomainPropertyToNode(cell, controlType, dataElementKey);
		}
		if (StringUtils.isNotEmpty(tableKey)) {
			//处理数据对象
			String refObjectKey = diff.getMetaForm().getDataSource().getRefObjectKey();
			if (refObjectKey.isEmpty()) {//neilian
				TagNode vestroot = vestXmlTree.xmlTree.getRoot();
				TagNode root = xmlTree.xmlTree.getRoot();
				String Key = vestroot.findFirstTagNodeByTagName(ConstantUtil.DATA_OBJECT).getAttributes().get(ConstantUtil.KEY);
				TagNode tagNode = root.getOrCreateChildByTagName(ConstantUtil.DATA_SOURCE, 0).getOrCreateChildByKey(ConstantUtil.DATA_OBJECT, Key).getOrCreateChildByTagName(MetaTableCollection.TAG_NAME);
				columnProcessor(diff, tagNode, tableKey, columnKey, caption, dataElementKey, headTable, isAllowMultiSelection, controlType, key);
				fieldNode = xmlTree.xmlTree.getRoot();
			} else {//外联
				result1.add(UICommand.reloadXmlSource(diff.getDataObjectfilePath()));
				XmlTreeWithPath dataObjectXmlTree = diff.getDataObjectXmlTree();
				String vestPath = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
				MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
				TagNode tagNode = dataObjectXmlTree.xmlTree.getRoot().getOrCreateChildByTagName(MetaTableCollection.TAG_NAME);
				columnProcessor(diff, tagNode, tableKey, columnKey, caption, dataElementKey, headTable, isAllowMultiSelection, controlType, key);
				String newXmlFragment = DesignIOMetaUtil.formToXml(dataObjectXmlTree.xmlTree.getRoot());
				XmlFileProcessor.instance.saveTempFile(diff.getDataObjectfilePath(), newXmlFragment, dataObject.getProjectKey());
				String tempVestPath = XmlFileProcessor.instance.getTmpFile(vestPath);
				vestPath = StringUtils.isNotBlank(tempVestPath) ? tempVestPath : vestPath;
				DataObjectHelper.reload(null, refObjectKey, vestPath, null);
			}
		}
		result1.add(new UICommand("GetType", "columnheader"));
		result1.add(UICommand.refreshMenuTree(diff.formKey)); //列的key
		result1.add(UICommand.locate(key)); //列的key
		setTagNode(fieldNode);
	}

	private static void columnProcessor(Diff diff, TagNode tagNode, String tableKey, String columnKey, String caption, String dataElementKey, DataTable headTable, Boolean isAllowMultiSelection, String controlType, String key) throws Throwable {
		TagNode table = tagNode.getOrCreateChildByKey(MetaTable.TAG_NAME, tableKey);
		TagNode column = table.getOrCreateChildByKey(MetaColumn.TAG_NAME, columnKey);
		column.setAttribute(ConstantUtil.CAPTION, caption);
		if (StringUtils.isEmpty(dataElementKey)) {
			column.setAttribute(ConstantUtil.DATA_TYPE, XmlDiffProcessor.getDatatypeContainerMultiDict(headTable.getInt("ControlType"), isAllowMultiSelection));
		} else {
			column.setAttribute(ConstantUtil.DataElementKey, dataElementKey);
		}
		if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
			XmlDiffProcessor.codeAndNameWithDictComponent(diff, key, tableKey, column);
		}
		if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatypeContainerMultiDict(headTable.getInt("ControlType"), isAllowMultiSelection))) {
			column.setAttribute(ConstantUtil.LENGTH, "255");
		}
	}
}
