package com.bokesoft.yes.design.io;

import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.TextNode;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;

import java.lang.reflect.Method;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesignIOMetaUtil {
	/**
	 * 根据PanelKey取MetaPanel对象
	 *
	 * @param metaForm
	 * @param panelKey
	 * @return
	 */
	public static MetaPanel getMetaPanel(MetaForm metaForm, String panelKey) {
		MetaBlock metaBlock = (MetaBlock) metaForm.getMetaBody().get(0);
		MetaPanel metaPanel = (MetaPanel) metaBlock.getRoot();
		return loadPanel(metaPanel, panelKey);
	}

	private static MetaPanel loadPanel(MetaPanel metaPanel, String panelKey) {
		if (panelKey.equals(metaPanel.getKey())) {
			return metaPanel;
		}
        if (!(metaPanel instanceof MetaGridLayoutPanel)) {
			for (MetaComponent metaComponent : metaPanel.getComponentArray()) {
				if (!metaComponent.isPanel()) {
					continue;
				}
				return loadPanel((MetaPanel) metaComponent, panelKey);
			}
		}
		return null;
	}

	public static AbstractMetaObject getMetaComponent(MetaForm metaForm, String fieldKey) throws Throwable {
		return IDLookup.reloadIDLookup(metaForm).getMetaObjectColumnByKey(fieldKey);

	}

	public static AbstractMetaObject getMetaComponentForListView(MetaForm metaForm, String fieldKey) throws Throwable {
		return IDLookup.getIDLookup(metaForm).getMetaObjectColumnByKey(fieldKey);

	}

	/**
	 * 取Panel的子控件顺序
	 *
	 * @param metaPanel
	 * @return
	 */
	public static String getChildrenOrderInfo(MetaPanel metaPanel) {
		StringBuilder result = new StringBuilder();
		for (MetaComponent metaComponent : metaPanel.getComponentArray()) {
			if (result.length() > 0) {
				result.append(";");
			}
			result.append(metaComponent.getKey());
		}
		return result.toString();
	}

	/**
	 * 取配置对象的值
	 *
	 * @param metaComponent
	 * @param propertyKey
	 * @return
	 * @throws Throwable
	 */
	public static Object getPropertyValue(MetaComponent metaComponent, String propertyKey) throws Throwable {
		String getName = null;
		if (propertyKey.equals("Tip")) {
			getName = "getTool" + propertyKey;
		} else {
			getName = "get" + propertyKey;
		}
		Class<?> clazz = metaComponent.getClass();
		Method method = null;
		try {
			method = clazz.getMethod(getName);
		} catch (NoSuchMethodException e) {

		}
		if (Objects.isNull(method)) {
			//方法为get开头，或者Is开头
			getName = "is" + propertyKey;
			method = clazz.getMethod(getName);
		}
		Object result;
		if (method != null) {
			result = method.invoke(metaComponent);
		} else {
			throw new RuntimeException("对象" + metaComponent + "的属性" + propertyKey + "取不到值 。");
		}
		if ("Orientation".equals(propertyKey)) {
			result = OrientationType.toString((int) result);
		} else if ("ControlType".equals(propertyKey)) {
			result = ControlType.toString((int) result);
		}
		return result;
	}

	//取表格中字段值
	public static Object getGridPropertyValue(MetaGridCell metaObject, String propertyKey) throws Throwable {
		String getName = null;
		if (propertyKey.equals("Tip")) {
			getName = "getTool" + propertyKey;
		} else {
			getName = "get" + propertyKey;
		}
		Class<?> clazz = metaObject.getClass();
		Method method = null;
		try {
			method = clazz.getMethod(getName);
		} catch (NoSuchMethodException e) {
		}
		Object result;
		if (method != null) {
			result = method.invoke(metaObject);
		} else {
			throw new RuntimeException("对象" + metaObject + "的属性" + propertyKey + "取不到值 。");
		}
		if ("Orientation".equals(propertyKey)) {
			result = OrientationType.toString((int) result);
		} else if ("CellType".equals(propertyKey)) {
			result = ControlType.toString((int) result);
		}
		return result;
	}

	//取ListView中字段值
	public static Object getListViewPropertyValue(MetaListViewColumn metaObject, String propertyKey) throws Throwable {
		String getName = "get" + propertyKey;
		Class<?> clazz = metaObject.getClass();
		Method method = null;
		try {
			method = clazz.getMethod(getName);
		} catch (NoSuchMethodException e) {
		}
		Object result;
		if (method != null) {
			result = method.invoke(metaObject);
		} else {
			throw new RuntimeException("对象" + metaObject + "的属性" + propertyKey + "取不到值 。");
		}
		if ("Orientation".equals(propertyKey)) {
			result = OrientationType.toString((int) result);
		} else if ("ColumnType".equals(propertyKey)) {
			result = ControlType.toString((int) result);
		}
		return result;
	}

	/**
	 * 设置配置对象的值
	 *
	 * @param metaComponent
	 * @param propertyKey
	 * @return
	 * @throws Throwable
	 */
	public static void setPropertyValue(MetaComponent metaComponent, String propertyKey, Object value) throws Throwable {
		if ("Orientation".equals(propertyKey)) {
			value = OrientationType.parse((String) value);
		} else if ("ControlType".equals(propertyKey)) {
			value = ControlType.parse((String) value);
		}
		String getName = "set" + propertyKey;
		Class<?> clazz = metaComponent.getClass();
		Method method = null;
		try {
			method = clazz.getMethod(getName, String.class);
			value = TypeConvertor.toString(value);
			method.invoke(metaComponent, value);
		} catch (NoSuchMethodException e) {
			try {
				method = clazz.getMethod(getName, Integer.class);
				value = TypeConvertor.toInteger(value);
				method.invoke(metaComponent, value);
			} catch (NoSuchMethodException e1) {
			}
		}
		if (Objects.isNull(method)) {
			throw new RuntimeException("对象" + metaComponent + "的属性" + propertyKey + "无法设置值 。");
		}
	}

	//设置配置对象的值 （表格中字段）
	public static void setGridPropertyValue(MetaGridCell metaGridCell, String propertyKey, Object value) throws Throwable {
		if ("Orientation".equals(propertyKey)) {
			value = OrientationType.parse((String) value);
		} else if ("CellType".equals(propertyKey)) {
			value = ControlType.parse((String) value);
		}
		String getName = "set" + propertyKey;
		Class<?> clazz = metaGridCell.getClass();
		Method method = null;
		try {
			method = clazz.getMethod(getName, String.class);
			value = TypeConvertor.toString(value);
			method.invoke(metaGridCell, value);
		} catch (NoSuchMethodException e) {
			try {
				method = clazz.getMethod(getName, Integer.class);
				value = TypeConvertor.toInteger(value);
				method.invoke(metaGridCell, value);
			} catch (NoSuchMethodException e1) {
			}
		}
		if (Objects.isNull(method)) {
			throw new RuntimeException("对象" + metaGridCell + "的属性" + propertyKey + "无法设置值 。");
		}
	}

	//设置配置对象的值 （ListView中字段）
	public static void setListViewPropertyValue(MetaListViewColumn metaListViewColumn, String propertyKey, Object value) throws Throwable {
		String getName = "set" + propertyKey;
		if ("Orientation".equals(propertyKey)) {
			value = OrientationType.parse((String) value);
		} else if (ConstantUtil.COLUMN_KEY.equals(propertyKey)) {
			getName = "setData" + propertyKey;
		}
		Class<?> clazz = metaListViewColumn.getClass();
		Method method = null;
		try {
			method = clazz.getMethod(getName, String.class);
			value = TypeConvertor.toString(value);
			method.invoke(metaListViewColumn, value);
		} catch (NoSuchMethodException e) {
			try {
				method = clazz.getMethod(getName, Integer.class);
				value = TypeConvertor.toInteger(value);
				method.invoke(metaListViewColumn, value);
			} catch (NoSuchMethodException e1) {
			}
		}
		if (Objects.isNull(method)) {
			throw new RuntimeException("对象" + metaListViewColumn + "的属性" + propertyKey + "无法设置值 。");
		}
	}

	/**
	 * 根据正则表达式取字符串中的值
	 *
	 * @param s       <OperationCollection>
	 * @param pattern <([A-Za-z_]\w*)\s
	 * @return
	 */
	public static String getSubString(String s, String pattern) {
		Pattern r = Pattern.compile(pattern);
		Matcher m = r.matcher(s);
		if (m.find()) {
			return m.group(1);
		}
		throw new RuntimeException("字符串" + s + "中没有找到" + pattern);
	}

	public static String getXml(TagNode node) {
		beforeToXml(node);
		String result = node.toXml(0);
		if (result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n")) {
			result = result.substring("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n".length());
		}
		if (result.endsWith("\r\n")) {
			result = result.substring(0, result.length() - 2);
		}
		return result;
	}
	public static String formToXml(TagNode node) {
		beforeToXml(node);
		String result = node.toXml(0);
		if (result.endsWith("\r\n")) {
			result = result.substring(0, result.length() - 2);
		}
		return result;
	}
	public static String orderAndgetXml(String key,TagNode node){
		beforeToXml(node);
		TagNode tagNode =null;
		Integer nodeX = 0,nodeY = 0,index = 0;
		List<AbstractNode> children = node.getChildren();
		for (int i=0;i<children.size();i++){
			AbstractNode childnode = children.get(i);
			if(!(childnode instanceof TagNode)){
				continue;
			}
			String nodeKey= ((TagNode) childnode).getAttributes().get("Key");
			if(nodeKey!=null && nodeKey.equals(key)){
				tagNode = (TagNode) childnode;
				nodeX = Integer.valueOf(tagNode.getAttributes().get("X"));
				nodeY = Integer.valueOf(tagNode.getAttributes().get("Y"));
				children.remove(i);
			}
		}
		for (int i=children.size()-1;i>=0;i--) {
			AbstractNode childnode = children.get(i);
			if(childnode instanceof TagNode  && ((TagNode) childnode).hasAttribute("X") &&((TagNode) childnode).hasAttribute("Y")){
				Integer x= Integer.valueOf(((TagNode) childnode).getAttributes().get("X"));
				Integer y= Integer.valueOf(((TagNode) childnode).getAttributes().get("Y"));
				if(y<nodeY || (y.equals(nodeY) && x<=nodeX)){
					   index= ++i;
					   children.add(index,tagNode);
					   break;
				}
			}
		}
		if(index==0){
			children.add(index,tagNode);
		}
		String result = node.toXml(0);
		if (result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n")) {
			result = result.substring("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n".length());
		}
		if (result.endsWith("\r\n")) {
			result = result.substring(0, result.length() - 2);
		}
		return result;
	}

	public static String getXmlWithHead(TagNode node) {
		beforeToXml(node);
		String result = node.toXml(0);
		if (result.endsWith("\r\n")) {
			result = result.substring(0, result.length() - 2);
		}
		return result;
	}

	/**
	 * 我们现在XmlTree的用法和XmlTree的原实现者cbb不同，原实现者是将原XmlTree设置到一个新的XmlTree并保存，我们要做一些调整
	 *
	 * @param node
	 */
	private static void beforeToXml(TagNode node) {
		for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
			String property = entry.getKey();
			String value = entry.getValue();
			if (value != null) {
				value = value.replaceAll("&amp;", "&").replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&quot;", "\"");
			}
			node.setAttributeNotRemove(property, value);
		}
		List<AbstractNode> preComments = node.getPreComment();
		if (preComments != null && preComments.size() > 0) {
			preComments.clear();
		}
		List<AbstractNode> postComments = node.getLastComment();
		if (postComments != null && postComments.size() > 0) {
			postComments.clear();
		}
		for (Iterator<AbstractNode> it = node.getChildren().iterator(); it.hasNext(); ) {
			AbstractNode child = it.next();
			if (child instanceof TagNode) {
				beforeToXml((TagNode) child);
			} else if (child instanceof TextNode) {
				TextNode textChild = (TextNode) child;
				if (textChild.getText().matches("\\s*")) { // 都是空格
					it.remove();
				}
			}
		}
	}

	/**
	 * 取第一行
	 *
	 * @param content
	 * @return
	 */
	public static String getFirstLine(String content) {
		int pos = content.indexOf("\n");
		return pos >= 0 ? content.substring(0, pos) : null;
	}

	/**
	 * 取第二行
	 *
	 * @param content
	 * @return
	 */
	public static String getSecondLine(String content) {
		int pos = content.indexOf("\n");
		int pos2 = content.indexOf("\n", pos + 1);
		return content.substring(pos + 1, pos2);
	}
}

