package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class WebDataMapDesign extends DesignerServiceCmd {
	public static final String CMD = "WebDataMapDesign";
	/**
	 * 工程Key
	 */
	private String projectKey;
	/**
	 * 路径
	 */
	private String filePath;
	/**
	 * 源formkey
	 */
	private String sourceFormKey;
	/**
	 * 目标表单
	 */
	private String targetFormKey;
	/**
	 * 映射标识
	 */
	private String key;
	/**
	 * 映射说明
	 */
	private String caption;
	/**
	 * 关联数据映射标识
	 */
	private String extend;

	/**
	 * 操作标识
	 */
	private int type;
	/**
	 * 常量CONST_ONE
	 */
	public static final int CONST_ONE = 1;
	/***常量CONST_TWO*/
	public static final int CONST_TWO = 2;
	/***常量true*/
	public static final String CONST_TRUE = "true";
	/***常量false*/
	public static final String CONST_FALSE = "false";
	/***常量result*/
	public static final String CONST_RESULT = "result";
	/***BPM操作类*/
	private static final DataMapOperJsonUtil datamapoperUtil;

	static {
		datamapoperUtil = new DataMapOperJsonUtil();
	}

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
		projectKey = (String) arguments.get("projectKey");
		sourceFormKey = (String) arguments.get(ConstantUtil.SOURCE_FORM_KEY);
		targetFormKey = (String) arguments.get(ConstantUtil.TARGET_FORM_KEY);
		key = (String) arguments.get("key");
		caption = (String) arguments.get("caption");
		extend = (String) arguments.get("extend");
		type = Integer.parseInt(String.valueOf(arguments.get("type")));
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		JSONObject result = new JSONObject();
		IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
		//是否是新增操作
		if (CONST_ONE == type) {
			//新增情况下判断是否已存在当前源数据映射的数据映射马甲
			if(datamapoperUtil.existDataMapVest(extend, globalInstance)){
				result.put("code", 1);
				result.put("msg", "新增数据映射马甲失败：已存在" + extend + "的数据映射马甲");
			}else{
				Map<String, String> res = datamapoperUtil.createDataMapXml(projectKey, sourceFormKey, targetFormKey, key, caption, "0", extend);
				if (CONST_TRUE.equals(res.get(CONST_RESULT))) {
					// 设置文件路径
					this.filePath = FilePathHelper.toBackFilePath(res.get("filePath"));
					// 成功
					result.put("code", 0);
					result.put("msg", "新增文件成功");
					result.put("filePath", this.filePath);
					//实体处理
					String projectKey = LoadFileTree.getProjectKey(filePath);
					try {
						ReloadForm.reloadCustom(projectKey, key);
					} catch (Exception e) {

					}
					//前端重新装载xml文件命令
					List<UICommand> uiCommands = new ArrayList<>();
					uiCommands.add(UICommand.reloadFileTree(this.filePath));
					uiCommands.add(UICommand.reloadMenuTree());
					result.put("uICommands", UICommand.toJson(uiCommands));
					result.put("caption", this.caption);
					result.put("version", "V1");
				} else {
					result.put("code", 1);
					result.put("msg", "新增文件失败,标识存在");
				}
			}
		} else if (CONST_TWO == type) {
			// 修改
			/*JSONObject jsonFileContent = getJsonFileContent(this.filePath);
			String sourceForm = jsonFileContent.getJSONObject(ConstantUtil.DATA_MAPPROPS).getJSONObject(ConstantUtil.DATA_MAPPROPS)
					.getJSONObject(ConstantUtil.SRC_FORM_KEY).getString("value");
			String targetForm = jsonFileContent.getJSONObject(ConstantUtil.DATA_MAPPROPS).getJSONObject(ConstantUtil.DATA_MAPPROPS)
					.getJSONObject(ConstantUtil.TGT_FORM_KEY).getString("value");

			MetaForm sourceMetaForm = globalInstance.getMetaForm(sourceForm);
			MetaForm targetMetaForm = globalInstance.getMetaForm(targetForm);
			String sourceCaption = sourceMetaForm.getCaption();
			String targetCaption = targetMetaForm.getCaption();
			String extend = (String) jsonFileContent.get("extend");
			List<ERPMetaMap> metaDataMapList = globalInstance.getMetaCustomObjects(ERPMetaMap.class);
			String linkDataMapCaption = getLinkCaption(extend, metaDataMapList);
			String dataMapPath = LoadFileTree.getDataMapPathByKey(extend);
			result.put("jsonFileContent", jsonFileContent);
			result.put("sourceCaption", sourceCaption);
			result.put("targetCaption", targetCaption);
			result.put("sourceForm", sourceForm);
			result.put("targetForm", targetForm);*/
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(this.filePath));
			// 获取根节点
			Element root = document.getRootElement();
			JSONObject jsonFileContent = new JSONObject();
			String extend = root.attributeValue("Extend");
			jsonFileContent.put("extend", extend);
			result.put("jsonFileContent",jsonFileContent);
			List<ERPMetaMap> metaDataMapList = globalInstance.getMetaCustomObjects(ERPMetaMap.class);
			String linkDataMapCaption = getLinkCaption(extend, metaDataMapList);
			result.put("linkDataMapCaption", linkDataMapCaption);
			String dataMapPath = LoadFileTree.getDataMapPathByKey(extend);
			result.put("linkDataMapPath", dataMapPath);
			// 设置json null值输出，并以空字符串方式显示
			return JSONObject.toJSONString(result,
					SerializerFeature.WriteMapNullValue,
					SerializerFeature.WriteNullStringAsEmpty,
					SerializerFeature.DisableCircularReferenceDetect);
		}
		return result;

	}

	public static JSONObject getJsonFileContent(String filePath) throws Throwable {
		return datamapoperUtil.convertXmlToJson(filePath);
	}

	/**
	 * @param extend
	 * @param metaDataMapList
	 * @return 返回caption
	 */
	private String getLinkCaption(String extend, List<ERPMetaMap> metaDataMapList) {
		String linkDataMapCaption = null;
		for (ERPMetaMap erpMetaMap : metaDataMapList) {
			if (StringUtils.isEmpty(extend)) {
				break;
			}
			if (erpMetaMap.getKey().equals(extend)) {
				linkDataMapCaption = erpMetaMap.getCaption();
				break;
			}
		}
		return linkDataMapCaption;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new WebDataMapDesign();
	}
}
