package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class UnMakeXmlFileCmd extends DesignerServiceCmd {
    public static final String CMD = "UnMakeXmlFile";

    /**
     * 表单Key，若文件是模板，表单Key指模板文件被打开的FormKey
     */
    private String uiFormKey;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        uiFormKey = (String) arguments.get("uiFormKey");
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        List<UICommand> result = new ArrayList<>();

        String filePath = LoadFileTree.getPathByFormKey(uiFormKey);
        String type = "Form";
        if (StringUtils.isEmpty(filePath)) {
            filePath = LoadFileTree.getDataMigrationPathByKey(uiFormKey);
            type = ConstantUtil.DATA_MIGRATION;
        }
        if (StringUtils.isEmpty(filePath)) {
            filePath = LoadFileTree.getBPMPathByKey(uiFormKey);
            type = "BPM";
        }
        if (StringUtils.isEmpty(filePath)) {
            filePath = LoadFileTree.getPathByDataObject(uiFormKey);
            type = ConstantUtil.DATA_OBJECT;
        }
        if (StringUtils.isEmpty(filePath)) {
            filePath = LoadFileTree.getDataMapPathByKey(uiFormKey);
            type = "DataMap";
        }
        if (StringUtils.isEmpty(filePath)) {
            return null;
        }
        XmlFileProcessor.instance.getUndoContent(result, type, filePath, uiFormKey);
        return UICommand.toJson(result);
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new UnMakeXmlFileCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
