package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PasteComponentCmd extends DesignerServiceCmd {
    public static final String CMD = "PasteComponent";

    private String srcFormKey;
    private String srcCompKey;
    private String formKey;
    private String parentKey;
    private String x;
    private String y;
    private String sideKey;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        srcFormKey = (String) arguments.get("srcFormKey");
        srcCompKey = (String) arguments.get("srcCompKey");
        formKey = (String) arguments.get("formKey");
        parentKey = (String) arguments.get("parentKey");
        x = (String) arguments.get("x");
        y = (String) arguments.get("y");
        sideKey = (String) arguments.get("sideKey");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        if (StringUtils.startsWith(srcCompKey, "Column:")) {
            return this.copyGridComp();
        } else {
            return this.copyHeadComp();
        }
    }

    private JSONArray copyHeadComp() throws Throwable {
        MetaForm srcMetaForm = MetaFactory.getGlobalInstance().getMetaForm(srcFormKey);
        MetaComponent srcComp = srcMetaForm.componentByKey(srcCompKey);
        if (Objects.isNull(srcComp)) {
            return null;
        }

        String srcFormPath = LoadFileTree.getPathByFormKey(srcFormKey);
        XmlTreeWithPath srcXmlTreeWithPath = XmlTreeWithPath.parseFilePath(srcFormPath, false);
        TagNode tagNode = srcXmlTreeWithPath.xmlTree.getTagNode(srcComp.getTagName() + "@" + srcCompKey);

        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        int keySuffix = this.getKeySuffix(metaForm, srcCompKey);
        String fieldKey = srcComp.getKey() + keySuffix;
        tagNode.setAttribute(ConstantUtil.KEY, fieldKey);
        tagNode.setAttribute(ConstantUtil.CAPTION, srcComp.getCaption() + keySuffix);
        tagNode.setAttribute(ConstantUtil.X, x);
        tagNode.setAttribute(ConstantUtil.Y, y);
        if (!StringUtils.equals(formKey, srcFormKey)) {
            tagNode.deleteChildByTagName(MetaDataBinding.TAG_NAME);
        }

        MetaComponent parentComp = metaForm.componentByKey(parentKey);
        String formPath = LoadFileTree.getPathByFormKey(formKey);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(formPath, false);
        TagNode parentNode = xmlTreeWithPath.xmlTree.getTagNode(parentComp.getTagName() + "@" + parentKey);
        TagNode rowDefNode = parentNode.findFirstTagNodeByTagName(ConstantUtil.ROW_DEF_COLLECTION);
        List<AbstractNode> childNodeList = parentNode.getChildren();
        childNodeList.add(childNodeList.indexOf(rowDefNode) - 1, tagNode);

        String fileContent = xmlTreeWithPath.xmlTree.getRoot().toXml(0, false);
        fileContent = RegExUtils.replaceAll(fileContent, "[\r\n]+(\\s*[\r\n]+)*", "\r\n");

        XmlFileProcessor.instance.saveTempFile(formPath, fileContent, metaForm.getProjectKey());
        DesignReloadMetaObject.reloadMetaFormRollbackError(formKey);

        List<UICommand> resultList = new ArrayList<>();
        resultList.add(UICommand.refreshMenuTree(formKey));
        resultList.add(UICommand.reloadFormKey(formKey));
        resultList.add(UICommand.locate(fieldKey));
        resultList.add(UICommand.reloadXmlSource(formPath));
        return UICommand.toJson(resultList);
    }

    private JSONArray copyGridComp() throws Throwable {
        String srcFormPath = LoadFileTree.getPathByFormKey(srcFormKey);
        XmlTreeWithPath srcXmlTreeWithPath = XmlTreeWithPath.parseFilePath(srcFormPath, false);

        srcCompKey = StringUtils.substringAfter(srcCompKey, "Column:");
        TagNode srcHeadNode = srcXmlTreeWithPath.xmlTree.getTagNode(MetaGridColumn.TAG_NAME + "@" + srcCompKey);
        TagNode srcCellNode = srcXmlTreeWithPath.xmlTree.getTagNode(MetaGridCell.TAG_NAME + "@" + srcCompKey);

        String srcCompCaption = srcHeadNode.getAttributes().get(ConstantUtil.CAPTION);
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        int keySuffix = this.getKeySuffix(metaForm, srcCompKey);
        String fieldKey = srcCompKey + keySuffix;

        srcHeadNode.setAttribute(ConstantUtil.KEY, fieldKey);
        srcHeadNode.setAttribute(ConstantUtil.CAPTION, srcCompCaption + keySuffix);

        srcCellNode.setAttribute(ConstantUtil.KEY, fieldKey);
        srcCellNode.setAttribute(ConstantUtil.CAPTION, srcCompCaption + keySuffix);
        if (!StringUtils.equals(formKey, srcFormKey)) {
            srcCellNode.deleteChildByTagName(MetaDataBinding.TAG_NAME);
        }

        MetaComponent parentComp = metaForm.componentByKey(parentKey);
        String formPath = LoadFileTree.getPathByFormKey(formKey);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(formPath, false);
        TagNode parentNode = xmlTreeWithPath.xmlTree.getTagNode(parentComp.getTagName() + "@" + parentKey);

        sideKey = StringUtils.substringAfter(sideKey, "Column:");

        TagNode columnsNode = parentNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
        TagNode sideColumnNode = xmlTreeWithPath.xmlTree.getTagNode("GridColumn@" + sideKey);
        List<AbstractNode> childrenNode = columnsNode.getChildren();
        childrenNode.add(childrenNode.indexOf(sideColumnNode) + 1, srcHeadNode);

        TagNode cellsNode = parentNode.findFirstTagNodeByTagName(ConstantUtil.GRID_ROW);
        TagNode sideCellNode = xmlTreeWithPath.xmlTree.getTagNode(MetaGridCell.TAG_NAME + "@" + sideKey);
        List<AbstractNode> childCellNodeList = cellsNode.getChildren();
        childCellNodeList.add(childCellNodeList.indexOf(sideCellNode) + 1, srcCellNode);

        String fileContent = xmlTreeWithPath.xmlTree.getRoot().toXml(0, false);
        fileContent = RegExUtils.replaceAll(fileContent, "[\r\n]+(\\s*[\r\n]+)*", "\r\n");

        XmlFileProcessor.instance.saveTempFile(formPath, fileContent, metaForm.getProjectKey());
        DesignReloadMetaObject.reloadMetaFormRollbackError(formKey);

        List<UICommand> resultList = new ArrayList<>();
        resultList.add(UICommand.refreshMenuTree(formKey));
        resultList.add(UICommand.reloadFormKey(formKey));
        resultList.add(UICommand.locate(fieldKey));
        resultList.add(UICommand.reloadXmlSource(formPath));
        return UICommand.toJson(resultList);
    }

    private int getKeySuffix(MetaForm metaForm, String compKey) {
        List<MetaComponent> allComponents = metaForm.getAllComponents();
        List<MetaComponent> allDetailComps = new ArrayList<>();
        for (int j = 0; j < metaForm.getAllDetailComponents().size(); j++) {
            MetaComponent component = metaForm.getAllDetailComponents().get(j);
            recursiveAddCompToList(component, allDetailComps);
        }
        allComponents.addAll(allDetailComps);
        Set<String> keys = allComponents.stream().map(MetaComponent::getKey).collect(Collectors.toSet());

        int i = 0;
        String tmpKey = compKey + i;
        while (keys.contains(tmpKey)) {
            i = i + 1;
            tmpKey = compKey + i;
        }
        return i;
    }

    private void recursiveAddCompToList(MetaComponent component, List<MetaComponent> allDetailComps) {
        if (!allDetailComps.contains(component)) {
            allDetailComps.add(component);
        }
        if (component.getComponentCount() > 0) {
            for (int i = 0; i < component.getComponentCount(); i++) {
                MetaComponent subComp = component.getComponent(i);
                recursiveAddCompToList(subComp, allDetailComps);
            }
        }
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new PasteComponentCmd();
    }

    @Override
    public String getCmd() {
        return PasteComponentCmd.CMD;
    }
}
