package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

/**
 *
 */
public class NewEntryCmd extends DesignerServiceCmd {
    public static final String CMD = "NewEntry";
    private String subKey;
    //	private String subType;
    private String subCaption;
    private String subOpen;
    private String subVisible;
    private String subIcon;
    private String subOnClick;
    private String parentKey;
    private String filePath;
    private String sideKey;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        subKey = TypeConvertor.toString(arguments.get("subKey")).trim();
//		subType = TypeConvertor.toString(arguments.get("subType")).trim();
        subCaption = TypeConvertor.toString(arguments.get("subCaption")).trim();
        subVisible = TypeConvertor.toString(arguments.get("subVisible")).trim();
        subOpen = TypeConvertor.toString(arguments.get("subOpen")).trim();
        subIcon = TypeConvertor.toString(arguments.get("subIcon")).trim();
        subOnClick = TypeConvertor.toString(arguments.get("subOnClick")).trim();
        parentKey = TypeConvertor.toString(arguments.get("parentKey")).trim();
        filePath = FilePathHelper.toBackFilePath(TypeConvertor.toString(arguments.get("filePath")).trim());
        sideKey = TypeConvertor.toString(arguments.get("sideKey")).trim();
    }

    /**
     * 新增菜单组
     */
    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        boolean isInJar = LoadFileTree.getTreeNode(filePath).isInJar;
        if (isInJar) {
            throw new Exception("不能在jar中创建菜单");
        }
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        //	EntryProcessor.instance.NewProject(ProjectKey, ProjectCaption,SolutionKey);
        // 创建SAX读取器
        try {
            SAXReader reader = new SAXReader();
            // 加载文档
            Document document = reader.read(filePath);
            LinkedHashMap<String, String> xmlTreeMapKeys = new LinkedHashMap();
            xmlTreeMapKeys.put("root", "/");
            getChildElement(document.getRootElement(), xmlTreeMapKeys);
            if (xmlTreeMapKeys.containsKey("EntryItem@" + subKey) || xmlTreeMapKeys.containsKey("Entry@" + subKey)) {//存在
                return null;
            }
            String path = xmlTreeMapKeys.get("Entry" + "@" + parentKey);
            Element node = (Element) document.selectSingleNode(path);
            List<Element> elements = node.elements();
            Element element = DocumentHelper.createElement("Entry");
            if (StringUtils.isNotEmpty(subKey)) {
                element.addAttribute(ConstantUtil.KEY, subKey);
            }
            if (StringUtils.isNotEmpty(subCaption)) {
                element.addAttribute(ConstantUtil.CAPTION, subCaption);
            }
            if (StringUtils.isNotEmpty(subVisible)) {
                element.addAttribute(ConstantUtil.VISIBLE, subVisible);
            }
            if (StringUtils.isNotEmpty(subOpen)) {
                element.addAttribute("Open", subOpen);
            }
            if (StringUtils.isNotEmpty(subIcon)) {
                element.addAttribute("Icon", subIcon);
            }
            if (StringUtils.isNotEmpty(subOnClick)) {
                //移动端不处理
                //	entry.setAttribute("OnClick",subOnClick);
            }
            if (sideKey.equals("first")) {
                elements.add(0, element);
            } else if (sideKey.equals("last")) {
                elements.add(element);
            } else {
                String side = xmlTreeMapKeys.get("Entry" + "@" + sideKey);
                if (StringUtils.isEmpty(side)) {
                    side = xmlTreeMapKeys.get("EntryItem" + "@" + sideKey);
                }
                int i = elements.indexOf((Element) document.selectSingleNode(side));
                elements.add(i + 1, element);
            }
            OutputFormat format = getOutputFormat();
            fileOutputStream = new FileOutputStream(filePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            
            String[] paths = StringUtils.split(filePath, File.separator);
			final String projectKey = paths[paths.length - 2];
			
            EntryProcessor.instance.reloadEntry(projectKey);
            List<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadXmlSource(FilePathHelper.toFrontFilePath(filePath)));
            result.add(UICommand.reloadMenuTree());
            return UICommand.toJson(result);
        } catch (Exception e) {
            throw e;
        } finally {
            closeFileStream(fileOutputStream, writer);
        }
    }

    /***
     * 关闭文件流
     * @param fileOutputStream 文件输出流
     * @param writer 写对象
     */
    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (null != fileOutputStream) {
                fileOutputStream.close();
            }
            if (null != writer) {
                writer.close();
            }
        } catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    /*
     * 递归方法，获取所有节点
     */
    public void getChildElement(Element element, LinkedHashMap<String, String> xmlTreeMapKeys) {
        String key = element.attributeValue("Key");
        xmlTreeMapKeys.put(element.getName() + "@" + key, element.getUniquePath());
        List<Element> elements = element.elements();
        if (element != null) {
            for (Element element2 : elements) {
                getChildElement(element2, xmlTreeMapKeys);
            }
        }
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new NewEntryCmd();
    }


    @Override
    public String getCmd() {
        return CMD;
    }
}
