package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSON;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.logging.Logger;

public class LoadXmlAttrDataCmd extends DesignerServiceCmd {
    public static final String CMD = "LoadXmlAttrData";

    //xml属性文件
    public static final String XMLATTR_JSON_FILE = "/json/xmlAttrs.json";
    private static final Logger logger = Logger.getLogger(LoadXmlAttrDataCmd.class.getName());

    @Override
    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {

    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        Map<String, String> xmlAttrsMap = readXmlAttrsFromJsonFile();
        JSONObject jsonObject = this.setXmlAttrList(xmlAttrsMap);
        return jsonObject.toString();
    }

    private static Map<String, String> readXmlAttrsFromJsonFile() throws Throwable {
        InputStream inputStream = null;
        Reader reader = null;
        BufferedReader bufferedReader = null;
        Map<String, String> tempMap = new HashMap<>();
        try {
            // json文件内容
            StringBuffer jsonFileContent;
            jsonFileContent = new StringBuffer();
            inputStream = LoadXmlAttrDataCmd.class.getResourceAsStream(XMLATTR_JSON_FILE);
            reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(reader);
            String read = "";
            while ((read = bufferedReader.readLine()) != null) {
                jsonFileContent.append(read + "\n");
            }
            tempMap = (Map<String, String>) JSON.parse((jsonFileContent.toString()).trim());
        } catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            return tempMap;
        } finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                } catch (IOException e) {
                    logger.warning("close bufferedReader exception:" + ExceptionUtils.getStackTrace(e));
                }
            }
            if (null != reader) {
                try {
                    reader.close();
                } catch (IOException e) {
                    logger.warning("close reader exception:" + ExceptionUtils.getStackTrace(e));
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    logger.warning("close inputStream exception:" + ExceptionUtils.getStackTrace(e));
                }
            }
        }
        return tempMap;
    }

    private JSONObject setXmlAttrList(Map<String, String> xmlAttrsMap) {
        JSONObject jsonObject = new JSONObject();
        if (xmlAttrsMap.size() < 1) {
            return jsonObject;
        }
        List<String> xmlAttrsList = new ArrayList<>();
        List<String> xmlAttrsDtlList = new ArrayList<>();
        for (String attrName : xmlAttrsMap.keySet()) {
            HashMap<String, Object> attrMap = JSON.parseObject(JSON.toJSONString(xmlAttrsMap.get(attrName)), HashMap.class);
            xmlAttrsList.add(StringUtils.join(attrMap.keySet().toArray(), "@~@"));
            xmlAttrsDtlList.add(StringUtils.join(attrMap.values(), "@~@"));
        }
        jsonObject.append("tagNamesList", StringUtils.join(xmlAttrsMap.keySet().toArray(), "@~~@"));
        jsonObject.append("xmlAttrsList", StringUtils.join(xmlAttrsList, "@~~@"));
        jsonObject.append("xmlAttrsDtlList", StringUtils.join(xmlAttrsDtlList, "@~~@"));
        return jsonObject;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadXmlAttrDataCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
