package com.bokesoft.yes.design.cmd;

import java.net.InetAddress;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 取服务端机器名，用于测试代码
 */
public class GetHostNameCmd extends DesignerServiceCmd {

	public static final String CMD = "GetHostName";

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		String hostName = InetAddress.getLocalHost().getHostName();
		return hostName;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetHostNameCmd();
	}
}
