package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

import java.util.HashMap;

public class DesignService extends GeneralService<DefaultContext> {

	@Override
	public String getServiceName() {
		return "DesignService";
	}

	@Override
	public IServiceProvider<DefaultContext> newInstance() {
		return new DesignService();
	}

	@Override
	protected Object[][] getCmdImplTable() {
		return new Object[][]{
				{AppDesignLoginCmd.CMD, new AppDesignLoginCmd()},
				{UnMakeXmlFileCmd.CMD, new UnMakeXmlFileCmd()},
				{ReMakeXmlFileCmd.CMD, new ReMakeXmlFileCmd()},
				{CommitDiffCmd.CMD, new CommitDiffCmd()},
				{LoadFileContentCmd.CMD, new LoadFileContentCmd()},
				{SaveFileContentCmd.CMD, new SaveFileContentCmd()},
				{ReMigrateCmd.CMD, new ReMigrateCmd()},
				{SaveFilesByFormKeyCmd.CMD, new SaveFilesByFormKeyCmd()},
				{SaveFilesCmd.CMD, new SaveFilesCmd()},
				{LoadFilePathsByFormKeyCmd.CMD, new LoadFilePathsByFormKeyCmd()},
				{LoadParentPathsByPathCmd.CMD, new LoadParentPathsByPathCmd()},
				{GetMetaDesignerFormCmd.CMD, new GetMetaDesignerFormCmd()},
				{GetReMakeXmlFileCountCmd.CMD, new GetReMakeXmlFileCountCmd()},
				{SearchFilePathCmd.CMD, new SearchFilePathCmd()},
				{ExpAutoCompleteCmd.CMD, new ExpAutoCompleteCmd()},
				{ FormulaServiceCmd.CMD, new FormulaServiceCmd() },
				{NewFormCmd.CMD, new NewFormCmd()},
				{NewExtensionFormCmd.CMD, new NewExtensionFormCmd()},
				{NewExpandFormCmd.CMD, new NewExpandFormCmd()},
				{NewExpandFormProcesCmd.CMD, new NewExpandFormProcesCmd()},
				{DeleteXmlFileCmd.CMD, new DeleteXmlFileCmd()},
				{CancelXmlFileCmd.CMD, new CancelXmlFileCmd()},
				{GetHostNameCmd.CMD, new GetHostNameCmd()},
				{WebBpmDesignCmd.CMD, new WebBpmDesignCmd()},
				{NewDomainORDataElementCmd.CMD, new NewDomainORDataElementCmd()},
				{ReductionXmlCmd.CMD, new ReductionXmlCmd()},
				{WebDataMapDesign.CMD, new WebDataMapDesign()},
				{WebDataMigration.CMD, new WebDataMigration()},
				{WebPrintDesign.CMD, new WebPrintDesign()},
				{WebExcelDesign.CMD, new WebExcelDesign()},
				{NewDataObjectCmd.CMD, new NewDataObjectCmd()},
				{GetmacroformulaCmd.CMD, new GetmacroformulaCmd()},
				{RefreshDataObjectCmd.CMD, new RefreshDataObjectCmd()},
				{ReviseProjectCmd.CMD, new ReviseProjectCmd()},
				{ParseFormulaCmd.CMD, new ParseFormulaCmd()},
				{AddSelectComponentCmd.CMD, new AddSelectComponentCmd()},
				{SetEnvironmentRunTypeCmd.CMD, new SetEnvironmentRunTypeCmd()},
				{RebuildTableCmd.CMD, new RebuildTableCmd()},
				{NewEntryCmd.CMD, new NewEntryCmd()},
				{DeleteEntryCmd.CMD, new DeleteEntryCmd()},
				{UpdateEntryCmd.CMD, new UpdateEntryCmd()},
				{SetDataObjectSourceCmd.CMD, new SetDataObjectSourceCmd()},
				{SetSourceDataObjectCmd.CMD, new SetSourceDataObjectCmd()},
				{NewEntryItemCmd.CMD, new NewEntryItemCmd()},
				{CopyFormCmd.CMD, new CopyFormCmd()},
				{FillMacroCmd.CMD, new FillMacroCmd()},
				{CheckKeyAndFileNameCmd.CMD, new CheckKeyAndFileNameCmd()},
				{CheckViewExistCmd.CMD, new CheckViewExistCmd()},
				{NewSolutionCmd.CMD, new NewSolutionCmd()},
				{ImportSolutionCmd.CMD, new ImportSolutionCmd()},
				{CheckNumPrecisionCmd.CMD, new CheckNumPrecisionCmd()},
				{LoadFilesSearchDataCmd.CMD, new LoadFilesSearchDataCmd()},
				{ReplaceFileSearchResultCmd.CMD, new ReplaceFileSearchResultCmd()},
				{LoadSearchFilesContentCmd.CMD, new LoadSearchFilesContentCmd()},
				{ReductionSnapshotXmlCmd.CMD, new ReductionSnapshotXmlCmd()},
				{GetPropertyDefineXmlCmd.CMD, new GetPropertyDefineXmlCmd()},
				{LoadDesignerGridTreeOneLevelCmd.CMD, new LoadDesignerGridTreeOneLevelCmd()},
				{LoadXmlAttrDataCmd.CMD,new LoadXmlAttrDataCmd()},
				{NewCompositeComponentCmd.CMD, new NewCompositeComponentCmd(),},
				{SetComponentGridCmd.CMD, new SetComponentGridCmd()},
				{CheckKeyLengthCmd.CMD, new CheckKeyLengthCmd()},
				{PasteComponentCmd.CMD, new PasteComponentCmd()},
				{LoadNodeAttrByPathCmd.CMD, new LoadNodeAttrByPathCmd()}
		};
	}

	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		return null;
	}

	public static HashMap<String, IServiceCmd<?>> prototype = null;

	static {
		DesignService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(DesignService.prototype, new DesignService());
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context, String cmd) {
		return (IServiceCmd<DefaultContext>) DesignService.prototype.get(cmd);
	}

}
