package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

/**
 * 取消XML文件的修改或新增
 */
public class CancelXmlFileCmd extends DesignerServiceCmd {

    public static final String CMD = "CancelXmlFile";

    private String filePath;
    /**
     * 文件内容
     */
    private String content;
    private String projectKey;
    private DocumentRecordDirty formDocument;
    private String uiFormKey;
    private String documentFormKey;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
        content = (String) arguments.get("content");
        projectKey = LoadFileTree.getProjectKey(filePath);
        if (arguments.containsKey("formDocument")) {
            String docStr = (String) arguments.get("formDocument");
            documentFormKey = (String) arguments.get("documentFormKey");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(documentFormKey);
            formDocument = new DocumentRecordDirty(metaForm, false);
            uiFormKey = (String) arguments.get("uiFormKey");
            try {
                formDocument.fromJSON(new JSONObject(docStr));
            } catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        String secondLine = DesignIOMetaUtil.getSecondLine(content);
        String key = "";
        String objectType = "";
        if (!isGeneralConfiguration(secondLine)) {
            objectType = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");
            key = DesignIOMetaUtil.getSubString(secondLine, "Key=\"([A-Za-z_]\\w*)\"");
        } else {
            objectType = "CommonDef";
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        List<UICommand> result = new ArrayList<UICommand>();
        boolean isNew = !(new File(filePath).exists());
        boolean reloadMenuTree = false;
        if (isNew) {
            MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(key);
            metaFactory.getMetaFormList().remove(key);
            MetaForm form = metaFormProfile.getForm();
            if (StringUtils.isEmpty(form.getDataSource().getRefObjectKey())) {
                metaFactory.getDataObjectList().remove(key);
            }
			/*RecycleForm recycleForm = XmlFileProcessor.recycleToTmpFormAndFileMap.get("Entry@Entry" + key);
			String filePath = recycleForm.getFilePath();
			String content = recycleForm.getContent();
			//将xml重新写入文件夹
			FileUtils.writeStringToFile(new File(filePath), content, "UTF-8");
			EntryProcessor.instance.reloadEntry(EntryProcessor.STR_DefaultProjectKey);//暂时写死
			reloadMenuTree = true;*/
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            reloadMenuTree = deleteEntryNode(iMetaFactory, key);
            XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + key);
        }
        if (MetaProcess.TAG_NAME.equals(objectType)) {
            XmlFileProcessor.instance.clearTmpFile(filePath);
            XmlFileProcessor.dealWithObject(result, "BPM", filePath, key, filePath);
        } else if (MetaMap.TAG_NAME.equals(objectType)) {
            XmlFileProcessor.instance.clearTmpFile(filePath);
            XmlFileProcessor.dealWithObject(result, "DataMap", filePath, key, filePath);
        } else if (MetaDataMigration.TAG_NAME.equals(objectType)) {
            XmlFileProcessor.instance.clearTmpFile(filePath);
            XmlFileProcessor.dealWithObject(result, ConstantUtil.DATA_MIGRATION, filePath, key, filePath);
        } else if (MetaCommonDef.TAG_NAME.equals(objectType)) {
            result.add(UICommand.reloadXmlSource(filePath));
        } else {
            String nowActiveFormPath = null;//当修改带有数据对象的form的数据源时需要同时重载对应的form
            List<MetaFormProfile> reloadMetaFormProfiles = null;
            if (objectType.equals(MetaForm.TAG_NAME)) {

                if (!isNew) {
                    String path = LoadFileTree.getPathByFormKey(key);
                    // 若要更新MetaDataObject，需要先更新MetaDataObject后处理MetaForm，这样才能正确处理NoDB及合并模板的DataObject
                    XmlTreeWithPath parse1 = XmlTreeWithPath.parseFilePathNotLoadTmp(path);
                    XmlTreeWithPath tmpParse1 = XmlTreeWithPath.parseFilePath(path);
                    String refObjectKey1 = parse1.xmlTree.getRoot().getOrCreateChildByTagName(ConstantUtil.DATA_SOURCE).getAttributes().get("RefObjectKey");
                    String tmpRefObjectKey1 = tmpParse1.xmlTree.getRoot().getOrCreateChildByTagName(ConstantUtil.DATA_SOURCE).getAttributes().get("RefObjectKey");
                    if (Objects.equals(refObjectKey1, tmpRefObjectKey1)) {
                        if (StringUtils.isNotEmpty(refObjectKey1)) {//引入数据对象表单
                            MetaForm metaForm1 = metaFactory.getMetaForm(key);
                            String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
                            if (StringUtils.isEmpty(refObjectKey)) {
                                metaForm1.getDataSource().setRefObjectKey(refObjectKey1);
                                refObjectKey = refObjectKey1;
                            }
                            String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
                            String pathByFormKey = LoadFileTree.getPathByFormKey(key);
                            XmlFileProcessor.instance.clearTmpFile(s);
                            XmlFileProcessor.instance.clearTmpFile(pathByFormKey);

                            DataObjectHelper.reload(null,refObjectKey, s, filePath);
                            result.add(UICommand.reloadXmlSource(s));
                        }
                        reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(null,key, filePath ,null);
                    } else {//修改数据对象来源后的取消
                        if (StringUtils.isNotEmpty(refObjectKey1)) {//引入数据对象表单
                            MetaForm metaForm1 = metaFactory.getMetaForm(key);
                            String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
                            if (StringUtils.isEmpty(refObjectKey)) {
                                //	metaForm1.getDataSource().setRefObjectKey(refObjectKey1);
                                refObjectKey = refObjectKey1;
                            }
                            String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
                            String pathByFormKey = LoadFileTree.getPathByFormKey(key);
                            XmlFileProcessor.instance.clearTmpFile(s);
                            XmlFileProcessor.instance.clearTmpFile(pathByFormKey);
                            reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(null,key, filePath, null);
//						reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(refObjectKey, s, filePath);
                            result.add(UICommand.reloadXmlSource(s));
                        } else {
                            MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(key);
                            reloadMetaFormProfiles = new ArrayList<>();
                            reloadMetaFormProfiles.add(metaFormProfile);
                            MetaForm metaForm = metaFactory.getMetaForm(key);
                            String refObjectKey = metaForm.getDataSource().getRefObjectKey();
                            String resource1 = LoadFileTree.getResource(filePath,projectKey);
                            ReloadForm.reloadFormKey(metaFactory, key, resource1);
                            if (StringUtils.isNotEmpty(refObjectKey)) {//当前是外联数据对象,额外处理数据对象
                                String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
                                reloadMetaFormProfiles = DataObjectHelper.reload(null,refObjectKey, s, s);
                                reloadMetaFormProfiles.add(metaFormProfile);
                            }
                        }
                    }

                }
            } else if (objectType.equals(MetaDataObject.TAG_NAME)) {
                MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
                MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(key);
                String extend = metaDataObjectProfile.getExtend();
                if (StringUtils.isNotBlank(extend)) {
                    String s = LoadFileTree.loadFilePathByDataObjectFieldKey(extend);
                    DataObjectHelper.reload(null,extend, s, null);
                }
                if (isNew) {
                    dataObjectList.remove(key);
                } else {
                    String s = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
                    reloadMetaFormProfiles = DataObjectHelper.reload(null,key, s, filePath);
                }
            }
            //String nextActiveFilePath = filePath;
            if (isNew) {
                //nextActiveFilePath = LoadFileTree.getNextFilePath(filePath);
                LoadFileTree.removeFilePath(filePath);
            }
            if (isNew && objectType.equals(MetaForm.TAG_NAME)) {
                //result.add(UICommand.reloadFileTree(nextActiveFilePath));
                result.add(UICommand.closeFilePath(filePath));
                result.add(UICommand.closeFormKey(key));
                if (reloadMenuTree) {
                    result.add(UICommand.reloadMenuTree());
                    result.add(UICommand.freshFileTree());
                }
            } else {
                result.add(UICommand.reloadXmlSource(filePath));
                //用于解决修改组件并且修改数据源的情况下的取消
                if (nowActiveFormPath != null && nowActiveFormPath.length() >= 0) {
                    result.add(UICommand.reloadXmlSource(nowActiveFormPath));
                }
                if (secondLine.contains("Extend")) {
                    result.add(UICommand.reloadFormKey(key));
                } else {
                    if (reloadMetaFormProfiles != null) {
                        for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
                            result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
                        }
                    }
                }
            }
            XmlFileProcessor.instance.clearTmpFile(filePath);
        }
        processDocumentDirty(result,formDocument,context);
        return UICommand.toJson(result);
    }

    //删除菜单节点
    private boolean deleteEntryNode(IMetaFactory iMetaFactory, String key) throws Throwable {
        DeleteXmlFileCmd deleteXmlFileCmd = new DeleteXmlFileCmd();
        LinkedHashMap<String, String> allItems = deleteXmlFileCmd.getAllItems();
        AtomicBoolean isRemove = new AtomicBoolean(false);

        // 创建SAX读取器
        SAXReader reader = new SAXReader();
        OutputFormat format = getOutputFormat();

        for (Map.Entry<String, String> entry : allItems.entrySet()) {
            String keya = entry.getKey();
            String formKey = entry.getValue();

            if (formKey.equals(key) || formKey.startsWith("FormKey=" + key)) {
                int fistIndex = keya.indexOf("/");
                String projectKey = keya.substring(0, fistIndex);

                String entryPath = iMetaFactory.getProjectResolver(projectKey).getPath("") + "Entry.xml";
                Document document = reader.read(new File(entryPath));
                FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
                XMLWriter writer = new XMLWriter(fileOutputStream, format);

                keya = keya.substring(fistIndex);

                String substring = keya.substring(1);
                int endIndex = substring.lastIndexOf("/");

                Element nodes = (Element) document.getRootElement().selectSingleNode(substring.substring(0, endIndex));
                Element node = (Element) document.getRootElement().selectSingleNode(substring);
                if (Objects.isNull(nodes)) {
                    nodes = document.getRootElement();
                }
                if (nodes != null) {
                    isRemove.set(nodes.remove(node));
                }

                writer.write(document);

                EntryProcessor.instance.reloadEntry(projectKey);
            }
        }

        return isRemove.get();
    }
    private void processDocumentDirty(List<UICommand> uiCommands , DocumentRecordDirty formDocument, DefaultContext context) throws Throwable {
        // TODO: 判断是否有脏数据
        if (Objects.isNull(formDocument)) {
            return;
        }
        if (DesignActionUtil.getPreferencesInfo("IsShowData").equals("false")) {
            return;
        }
        if(!uiFormKey.equals(documentFormKey)){
            return;
        }
        String formKey = formDocument.getMetaForm().getKey();

        MetaFormDiffProcessor.instance.synchronizedDocumentDataSource(formDocument);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(formKey);
        String extend = metaFormProfile.getExtend();
        //是马甲或者视图不做处理
        if (StringUtils.isNotBlank(extend) && !metaFormProfile.getMergeToSource()) {
            return;
        }
        if (metaFormProfile.getForm().getFormType() == FormType.View) {
            return;
        }
        context.setFormKey(formDocument.getMetaForm().getKey());
        context.setDocument(formDocument);
        RichDocumentContext parentContext = (RichDocumentContext) context.getParentContext();
        if (Objects.isNull(parentContext)) {
            parentContext = new RichDocumentContext(context);
            parentContext.setDocument(formDocument);
            context.setParentContext(parentContext);
        }
        formDocument.setContext(parentContext);
        //以json的形式返回脏数据
        try {//当嵌入模板时这个会报错就不进行
            formDocument.setMetaForm(metaFormProfile.getForm());
            JSONObject documentDirty = formDocument.getDirtyJSON(parentContext);
            uiCommands.add(UICommand.processDocumentDirty(formKey, documentDirty));
        } catch (Throwable e) {//不处理
            LogSvr.getInstance().error("", e);
        }
    }
    private boolean isGeneralConfiguration(String line){
        return line.equals("<CommonDef>") || line.startsWith("<Setting")
                || line.equals("<RightsDefinition>") || line.equals("<Enhance>")
                || line.equals("<DataElementDef>") || line.equals("<DomainDef>")
                || line.equals("<IOSetting>") || line.startsWith("<Solution");
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new CancelXmlFileCmd();
    }
}
