package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 *文件名: AddSelectComponentCmd
 *创建者: zhangk
 *创建时间:2022/9/21 11:48
 */
public class AddSelectComponentCmd extends DesignerServiceCmd {
	public static final String CMD = "AddSelectComponent";
	private String formKey;
	private String enterPanel;
	private String component;
	//	private String gridKey;
	private String prefix;
	private String suffix;
	private Boolean isCreateLike;
	private Boolean isCreateOK;
	private Boolean isCreateReset;

	@Override
	public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {

		formKey = TypeConvertor.toString(arguments.get("formKey")).trim();
		enterPanel = TypeConvertor.toString(arguments.get("enterPanel"));
		component = TypeConvertor.toString(arguments.get("component")).trim();
//		gridKey = TypeConvertor.toString(arguments.get("gridKey")).trim();
		prefix = TypeConvertor.toString(arguments.get("prefix")).trim();
		if (StringUtils.isEmpty(prefix)) {
			prefix = "Head_";
		}
		suffix = TypeConvertor.toString(arguments.get("suffix")).trim();
		isCreateLike = TypeConvertor.toBoolean(arguments.get("isCreateLike"));
		isCreateOK = TypeConvertor.toBoolean(arguments.get("isCreateOK"));
		isCreateReset = TypeConvertor.toBoolean(arguments.get("isCreateReset"));

	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
		boolean mergeDiff = false;
		List<UICommand> result = new ArrayList<UICommand>();
		String pathByFormKey = LoadFileTree.getPathByFormKey(formKey);
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(pathByFormKey);
		TagNode ptagNode = xmlTreeWithPath.xmlTree.getTagNode(ControlType.STR_GRIDLAYOUTPANEL + "@" + enterPanel);
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaFormProfile formProfile = metaFactory.getMetaFormList().get(formKey);
		MetaForm form = formProfile.getForm();
		IDLookup idLookup = IDLookup.getIDLookup(form);
		MetaGridLayoutPanel metaGridLayoutPanel = (MetaGridLayoutPanel) form.componentByKey(enterPanel);
		MetaColumnDefCollection metaColumnDefCollection = metaGridLayoutPanel.getMetaColumnDefCollection();
		MetaRowDefCollection metaRowDefCollection = metaGridLayoutPanel.getMetaRowDefCollection();
		int maxY = metaRowDefCollection.size() - 1;
		int maxX = metaColumnDefCollection.size() - 1;
		if (StringUtils.isNotEmpty(component)) {
			String[] queryConditionsSplit = component.split(",");
			int index = 0;
			for (int i = 1; i <= queryConditionsSplit.length;  i++) {
				String queryCondition = queryConditionsSplit[i-1];
				MetaGridCell cell = idLookup.getGridCellByKey(queryCondition);
				String key = cell.getKey();
				String caption = cell.getCaption();
				int controlType = cell.getCellType();
				String tableKey = cell.getTableKey();
				String columnKey = cell.getColumnKey();
				TagNode tagNode = new TagNode(ControlType.toString(controlType), null);
				tagNode.setAttribute("Key", prefix + key + suffix);
				tagNode.setAttribute("Caption", caption);
				String columnIndex = String.valueOf(((i - 1) % (maxX + 1)));
				String rowIndex = String.valueOf(index);
				tagNode.setAttribute("X", columnIndex);
				tagNode.setAttribute("Y", rowIndex);
				tagNode.setAttribute("Visible", "true");
				tagNode.setAttribute("Enable", "true");
				if (i % (maxX + 1) == 0) {
					index++;
				}
				if(index > maxY){
					index = maxY;
				}
				if (controlType == ControlType.DICT) {
					MetaDictProperties properties = (MetaDictProperties) cell.getProperties();
					tagNode.setAttribute("ItemKey", properties.getItemKey());
				} else if (controlType == ControlType.COMBOBOX) {
					MetaComboBoxProperties properties = (MetaComboBoxProperties) cell.getProperties();
					int sourceType = properties.getSourceType();
					tagNode.setAttribute("SourceType", ComboBoxSourceType.format(sourceType));
					if (sourceType == ComboBoxSourceType.FORMULA) {
						if (properties.getFormulaItems() != null) {
							TagNode formulaItems = new TagNode("FormulaItems", null);
							tagNode.addNode(formulaItems);
							formulaItems.setCDataValue(properties.getFormulaItems().getContent());
						}
					} else if (sourceType == ComboBoxSourceType.ITEMS) {
						TagNode node = xmlTreeWithPath.xmlTree.getTagNode("GridCell@" + key);
						List<AbstractNode> items = node.getChildrenByTagName("Item");
						if (items.size() > 0) {
							for (AbstractNode item : items) {
								node.addNode(item);
							}
						}

					}
				}
				ptagNode.addNode(tagNode, ptagNode.getChildren().size() - 6);

				TagNode condition = new TagNode(MetaCondition.TAG_NAME, null);
				tagNode.addNode(condition);
				if (controlType == ControlType.UTCDATEPICKER || controlType == ControlType.DATEPICKER ||
						controlType == ControlType.NUMBEREDITOR) {//metaCondition处理
					condition.setAttribute("CondSign", CondSign.S_BETWEEN);
					condition.setAttribute("Group", queryCondition);
					condition.setAttribute("GroupHead", "true");

					TagNode tagNode1 = new TagNode(ControlType.toString(controlType), null);
					tagNode1.setAttribute("Visible", "true");
					tagNode1.setAttribute("Enable", "true");
					tagNode1.setAttribute("Key", prefix + key + suffix + "_Comp2");
					tagNode1.setAttribute("Caption", caption + "(结束)");
					tagNode1.setAttribute("X", columnIndex);
					tagNode1.setAttribute("Y", rowIndex);
					TagNode condition1 = new TagNode(MetaCondition.TAG_NAME, null);
					condition1.setAttribute("CondSign", CondSign.S_BETWEEN);
					condition1.setAttribute("Group", queryCondition);
					condition1.setAttribute("GroupTail", "true");
					tagNode1.addNode(condition1);
					ptagNode.addNode(tagNode1, ptagNode.getChildren().size() - 6);
				} else if (controlType == ControlType.DICT || controlType == ControlType.CHECKLISTBOX) {
					condition.setAttribute("CondSign", CondSign.S_IN);
				} else if (controlType == ControlType.COMBOBOX) {
					condition.setAttribute("CondSign", CondSign.S_EQ);
				} else {
					condition.setAttribute("CondSign", CondSign.S_LIKE);
				}
				condition.setAttribute("TableKey", tableKey);
				condition.setAttribute("ColumnKey", columnKey);
			}
			mergeDiff = true;
		}
		if (isCreateOK) {//添加查询按钮
			TagNode tagNode = new TagNode(ControlType.STR_BUTTON, null);
			ptagNode.addNode(tagNode, ptagNode.getChildren().size() - 6);
			tagNode.setAttribute("X", String.valueOf(maxX - 2 <= 0 ? 0 : maxX - 2));
			tagNode.setAttribute("Y", String.valueOf(maxY));
			tagNode.setAttribute("Visible", "true");
			tagNode.setAttribute("Enable", "true");
			tagNode.setAttribute("Key", prefix + "Query" + suffix);
			tagNode.setAttribute("Caption", "查询");
			TagNode onClick = new TagNode("OnClick", null);
			tagNode.addNode(onClick);
			onClick.setCDataValue("DealCondition();LoadData();ShowData();");
			mergeDiff = true;
		}
		if (isCreateReset) {//添加重置按钮
			TagNode tagNode = new TagNode(ControlType.STR_BUTTON, null);
			ptagNode.addNode(tagNode, ptagNode.getChildren().size() - 6);
			tagNode.setAttribute("X", String.valueOf(maxX));
			tagNode.setAttribute("Y", String.valueOf(maxY));
			tagNode.setAttribute("Visible", "true");
			tagNode.setAttribute("Enable", "true");
			tagNode.setAttribute("Key", prefix + "Reset" + suffix);
			tagNode.setAttribute("Caption", "重置");
			TagNode onClick = new TagNode("OnClick", null);
			tagNode.addNode(onClick);
			onClick.setCDataValue("ResetCondition();");
			mergeDiff = true;
		}
		if (isCreateLike) {//添加用户喜好组件
			TagNode tagNode = new TagNode(ControlType.STR_EMBED, null);
			tagNode.setAttribute("X", "0");
			tagNode.setAttribute("Y", String.valueOf(maxY-1));
			tagNode.setAttribute("Visible", "true");
			tagNode.setAttribute("Enable", "true");
			tagNode.setAttribute("XSpan", String.valueOf(maxY));
			tagNode.setAttribute("Key", prefix + "FavoriteEmbed" + suffix);
			tagNode.setAttribute("Caption", "查询变式模板");
			tagNode.setAttribute("FormKey", "V_Favorite_Impl");
			tagNode.setAttribute("IncludeDataTable", "false");
			tagNode.setAttribute("RootKey", "FavoritePanel");
			ptagNode.addNode(tagNode, ptagNode.getChildren().size() - 6);
			mergeDiff = true;
		}
		if (mergeDiff) {
			Diff diff = new Diff("", formKey, true);
			diff.setMetaForm(form);
			XmlDiffProcessor.genXmlDiff(xmlTreeWithPath, ptagNode, diff, true);
			ArrayList<Diff> diffs = new ArrayList<>();
			diffs.add(diff);
			Map<String, String> tmpFiles = XmlFileProcessor.instance.processDiff(diffs, false);
			String xmlError = MetaFormDiffProcessor.instance.processDiffReloadForm(null,tmpFiles);
			result.add(UICommand.reloadFormKey(formKey));
			result.add(UICommand.refreshMenuTree(enterPanel));
			result.add(UICommand.reloadXmlSource(pathByFormKey));
			result.add(UICommand.locate(enterPanel));
			if (!"操作成功".equals(xmlError)) {
				result.add(UICommand.showError(xmlError));
			} else {
				result.add(UICommand.showTip("操作成功"));
			}

		}


		return UICommand.toJson(result);
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new AddSelectComponentCmd();
	}

	@Override
	public String getCmd() {
		return CMD;
	}
}
