package com.bokesoft.yes.design;

import com.bokesoft.yes.design.constant.ConstantUtil;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class Property {
	public static final Property IsRoot = new Property("IsRoot", true, false);
	public static final Property Item = new Property("Item", true, false);
	public static final Property BuddyKey = new Property("BuddyKey", false, false);
	public static final Property CellKey = new Property("CellKey", true, false);
	public static final Property Cache = new Property("Cache", true, false);
	public static final Property BindingCellKey = new Property("BindingCellKey", true, false);//关联单元格标识
	public static final Property ItemChanged = new Property("ItemChanged", true, false);//切换事件
	public static final Property IsGroupHead = new Property("IsGroupHead", true, false);
	public static final Property DataObject = new Property(ConstantUtil.DATA_OBJECT, true, true);
	public static final Property FormulaItems = new Property("FormulaItems", true, false);
	public static final Property Orientation = new Property("Orientation", false, false);//拆分方向
	public static final Property FormType = new Property("FormType", true, false);
	public static final Property Platform = new Property("Platform", true, false);
	public static final Property Extend = new Property("Extend", true, false);
	public static final Property SourceForm = new Property("SourceForm", true, false);
	public static final Property ViewKey = new Property("ViewKey", true, false);
	public static final Property LinkedFormKey = new Property("LinkedFormKey", true, false);
	public static final Property MergeToSource = new Property("MergeToSource", true, false);
	public static final Property UseVariant = new Property("UseVariant", true, false);
	public static final Property UserData = new Property("UserData", true, false);
	public static final Property I18N = new Property("I18N", true, false);
	public static final Property FormDisplay = new Property("FormDisplay", true, false);
	public static final Property InitState = new Property("InitState", true, false);
	public static final Property OnLoad = new Property("OnLoad", true, false);
	public static final Property ConfirmClose = new Property("ConfirmClose", true, false);
	public static final Property key = new Property(ConstantUtil.KEY, true, false);
	public static final Property caption = new Property(ConstantUtil.CAPTION, false, false);
	public static final Property CaptionFull = new Property("CaptionFull", false, false);
	public static final Property CaptionEn = new Property("CaptionEn", false, false);
	public static final Property CaptionEnFull = new Property("CaptionEnFull", false, false);
	public static final Property description = new Property(ConstantUtil.DESCRIPTION, false, false);
	public static final Property condition = new Property("Condition", true, false);
	public static final Property buddyCaption = new Property("BuddyCaption", false, false);//label标题
	public static final Property enable = new Property(ConstantUtil.ENABLE, true, false);
	public static final Property visible = new Property(ConstantUtil.VISIBLE, true, false);
	public static final Property x = new Property(ConstantUtil.X, false, false);
	public static final Property y = new Property(ConstantUtil.Y, false, false);
	public static final Property buddyX = new Property("BuddyX", false, false);//label x
	public static final Property buddyY = new Property("BuddyY", false, false);//label y
	public static final Property itemKey = new Property("ItemKey", true, false);  //字典标识
	public static final Property textField = new Property("TextField", true, false);  //字典：显示字段
	public static final Property formulaText = new Property("FormulaText", true, false);  //字典：表达式显示值
	public static final Property required = new Property("Required", true, false);
	public static final Property tableKey = new Property(ConstantUtil.TABLE_KEY, true, false);
	public static final Property columnKey = new Property(ConstantUtil.COLUMN_KEY, true, false);
	public static final Property defaultValue = new Property("DefaultValue", true, false);
	public static final Property SourceType = new Property("SourceType", true, false);
	public static final Property LinkType = new Property("LinkType", true, false);  //子明细关联类型
	public static final Property defaultFomulaValue = new Property(ConstantUtil.DEFAULT_FORMULA_VALUE, true, false);
	public static final Property CheckRule = new Property(ConstantUtil.CHECK_RULE, true, false);
	public static final Property Root = new Property("Root", true, false);
	public static final Property Layout = new Property("Layout", true, false);
	public static final Property Separate = new Property("Separate", false, false);
	public static final Property ItemFilter = new Property("ItemFilter", true, false);
	public static final Property valueChanged = new Property("ValueChanged", true, false);
	public static final Property ValueChangeAction = new Property("ValueChangeAction", true, false);
	public static final Property onClick = new Property("OnClick", true, false);
	public static final Property KeyEnter = new Property("KeyEnter", true, false); //回车事件
	public static final Property associationTable = new Property("AssociationTable", true, false);
	public static final Property rowInsert = new Property("RowInsert", true, false);
	public static final Property rowDelete = new Property("RowDelete", true, false);
	public static final Property onRowDelete = new Property("OnRowDelete", true, false);
	public static final Property rowClick = new Property("RowClick", true, false);
	public static final Property rowDblClick = new Property("RowDblClick", true, false);
	public static final Property focusRowChanged = new Property("FocusRowChanged", true, false);
	public static final Property action = new Property(ConstantUtil.ACTION, true, false);
	public static final Property DataObjectCheckRule = new Property("DataObjectCheckRule", true, true);
	public static final Property ColumnExpandTwo = new Property("ColumnExpandTwo", true, false);
	public static final Property onSelect = new Property("OnSelect", true, false);
	public static final Property OnCollapse = new Property("OnCollapse", true, false);
	public static final Property OnExpand = new Property("OnExpand", true, false);
	//依赖字段
	public static final Property ValueDependency = new Property("ValueDependency", true, false);
	//是否去尾零
	public static final Property StripTrailingZeros = new Property("StripTrailingZeros", false, false);
	//小数位数
	public static final Property Scale = new Property("Scale", false, true);
	public static final Property Editable = new Property("Editable", true, false);
	public static final Property dataColumnKey = new Property("DataColumnKey", true, true);
	public static final Property integerValue = new Property("IntegerValue", true, true);
	// 数值精度
	public static final Property Precision = new Property("Precision", false, true);
	// 四舍五入
	public static final Property RoundingMode = new Property("RoundingMode", false, true);
	// 零值字符串
	public static final Property ZeroString = new Property("ZeroString", false, true);
	// 负数前景色
	public static final Property NegtiveForeColor = new Property("NegtiveForeColor", false, false);
	/**
	 * 字段属性
	 */
	public static final Property Fieldinformation = new Property("Fieldinformation", true, false);
	/**
	 * 表头字段所在的Panel的Key
	 */
	public static final Property ownerPanelKey = new Property("ownerPlanKey", true, false);
	/**
	 * 最大长度
	 */
	public static final Property maxLength = new Property("MaxLength", false, false);
	/**
	 * 是否单行显示
	 */
	public static final Property SingleLine = new Property("SingleLine", false, false);
	/**
	 * 最大行数
	 */
	public static final Property MaxLines = new Property("MaxLines", false, false);
	/**
	 * 超出截断类型
	 */
	public static final Property LineBreakMode = new Property("LineBreakMode", false, false);
	/**
	 * 编辑样式
	 */
	public static final Property EditType = new Property("EditType", false, false);
	/**
	 * 时分组件是否显示时分秒
	 */
	public static final Property Second = new Property("Second", false, false);
	/**
	 * 分隔线是否仅显示
	 */
	public static final Property OnlyShow = new Property("OnlyShow", false, false);

	/**
	 * 图片是否剪切
	 */
	public static final Property ImageCut = new Property("ImageCut", false, false);
	/**
	 * 图片是否拉伸
	 */
	public static final Property Stretch = new Property("Stretch", false, false);
	/**
	 * 图片最大值
	 */
	public static final Property MaxSize = new Property("MaxSize", false, false);
	/**
	 * 图片半径
	 */
	public static final Property Radius = new Property("Radius", false, false);
	/**
	 * 是否选择字段
	 */
	public static final Property IsSelect = new Property("IsSelect", true, false);
	/**
	 * 是否单选
	 */
	public static final Property SingleSelect = new Property("SingleSelect", true, false);
	/**
	 * 源字段
	 */
	public static final Property SourceFields = new Property("SourceFields", true, false);
	/**
	 * 背景图片
	 */
	public static final Property BackImage = new Property("BackImage", false, false);
	/**
	 * 背景图片位置
	 */
	public static final Property BackImagePosition = new Property("BackImagePosition", false, false);
	/**
	 * 水平重复填充
	 */
	public static final Property BackImageRepeatX = new Property("BackImageRepeatX", false, false);
	/**
	 * 垂直重复填充
	 */
	public static final Property BackImageRepeatY = new Property("BackImageRepeatY", false, false);
	/**
	 * 触发事件
	 */
	public static final Property Activate = new Property("Activate", false, false);
	/**
	 * Xspan
	 */
	public static final Property XSpan = new Property("XSpan", false, false);
	public static final Property YSpan = new Property("YSpan", false, false);
	public static final Property isVestDelet = new Property("isVestDelet", false, false);
	public static final Property Tag = new Property(ConstantUtil.TAG, true, false);
	public static final Property OnPostShow = new Property("OnPostShow", true, false);
	public static final Property CellType = new Property("CellType", true, false);
	/*外部标识*/
	public static final Property RefKey = new Property(ConstantUtil.REF_KEY, true, false);
	//所属组
	public static final Property GroupKey = new Property("GroupKey", true, false);
	public static final Property AllowMultiSelection = new Property("AllowMultiSelection", true, false);
	public static final Property RowKey = new Property("RowKey", true, false);
	public static final Property RowType = new Property("RowType", true, false);
	public static final Property RowKeywords = new Property("RowKeywords", true, false);
	public static final Property RowVisible = new Property("RowVisible", true, false);
	public static final Property RowTableKey = new Property("RowTableKey", true, false);
	public static final Property RowDetailKey = new Property("RowDetailKey", true, false);
	public static final Property RowGroupKey = new Property("RowGroupKey", true, false);
	public static final Property RowHeight = new Property("RowHeight", true, false);
	public static final Property RowRefKey = new Property("RowRefKey", true, false);
	public static final Property RowDefaultLayer = new Property("RowDefaultLayer", true, false);
	public static final Property CellGroupType = new Property("CellGroupType", true, false);
	public static final Property CopyNew = new Property("CopyNew", true, false);
	public static final Property NewEmptyRow = new Property("NewEmptyRow", true, false);
	public static final Property CanInsert = new Property("CanInsert", true, false);
	public static final Property CanDelete = new Property("CanDelete", true, false);
	public static final Property CanShift = new Property("CanShift", true, false);
	public static final Property BestWidth = new Property("BestWidth", true, false);
	public static final Property ShowRowHead = new Property("ShowRowHead", true, false);
	public static final Property SerialSeq = new Property("SerialSeq", true, false);
	public static final Property SelectionMode = new Property("SelectionMode", true, false);
	public static final Property PageLoadType = new Property("PageLoadType", true, false);
	public static final Property PageRowCount = new Property("PageRowCount", false, false);
	public static final Property PageIndicatorCount = new Property("PageIndicatorCount", false, false);
	public static final Property RowRange = new Property("RowRange", false, false);
	public static final Property SerialRowNum = new Property("SerialRowNum", false, false);
	public static final Property Option = new Property("Option", false, false);
	public static final Property DisabledOption = new Property("DisabledOption", false, false);
	public static final Property DefaultFitWidth = new Property("DefaultFitWidth", false, false);
	public static final Property BindingGridKey = new Property("BindingGridKey", true, false);
	public static final Property FormKey = new Property(ConstantUtil.FORM_KEY, true, false);
	public static final Property RootKey = new Property("RootKey", true, false);
	public static final Property IncludeDataTable = new Property("IncludeDataTable", true, false);
	public static final Property InvalidChars = new Property(ConstantUtil.INVALID_CHARS, false, false);
	public static final Property ForceLayout = new Property("ForceLayout", false, false);
	public static final Property OddColumnColor = new Property("OddColumnColor", true, false);
	public static final Property Tip = new Property("Tip", false, false);
	public static final Property QueryType = new Property("QueryType", true, true);
	public static final Property Type = new Property(ConstantUtil.TYPE, true, false);
	public static final Property Statement = new Property("Statement", true, true);
	public static final Property OverflowX = new Property(ConstantUtil.OVERFLOW_X, false, false);
	public static final Property OverflowY = new Property(ConstantUtil.OVERFLOW_Y, false, false);
	public static final Property ColumnType = new Property("ColumnType", true, false);
	public static final Property Value = new Property("Value", true, false);
	public static final Property FormulaCaption = new Property("FormulaCaption", true, false);
	public static final Property CaptionDependency = new Property("CaptionDependency", true, false);
	public static final Property AbbrCaption = new Property("AbbrCaption", false, false);
	public static final Property FormulaAbbrCaption = new Property("FormulaAbbrCaption", true, false);
	public static final Property Width = new Property("Width", false, false);
	public static final Property Height = new Property("Height", false, false);
	public static final Property HeightUnit = new Property("HeightUnit", false, false);
	public static final Property WidthUnit = new Property("WidthUnit", false, false);
	public static final Property Sortable = new Property("Sortable", true, false);
	public static final Property Freeze = new Property("Freeze", false, false);
	public static final Property ExpandType = new Property("ExpandType", true, false);
	public static final Property RowExpand = new Property("RowExpand", true, false);
	public static final Property ExpandDependency = new Property("ExpandDependency", true, false);
	public static final Property ExpandSourceType = new Property("ExpandSourceType", true, false);
	public static final Property ColumnExpand = new Property("ColumnExpand", true, false);
	public static final Property GridHeadColumn = new Property("GridHeadColumn", true, false);
	public static final Property DataOperationToobar = new Property("DataOperationToobar", true, false);
	public static final Property ShowZero = new Property("ShowZero", false, false);
	public static final Property HAlign = new Property("HAlign", false, false);
	public static final Property VAlign = new Property("VAlign", false, false);
	public static final Property EnableDependency = new Property("EnableDependency", false, false);
	public static final Property VisibleDependency = new Property("VisibleDependency", true, false);
	public static final Property CheckDependency = new Property("CheckDependency", true, false);
	public static final Property PromptText = new Property("PromptText", false, false);
	public static final Property ItemKeySource = new Property("ItemKeySource", true, false);
	public static final Property ItemKeySourceType = new Property("ItemKeySourceType", true, false);
	public static final Property Independent = new Property("Independent", true, false);
	public static final Property StateMask = new Property("StateMask", true, false);
	public static final Property StateMaskFormula = new Property("StateMaskFormula", true, false);
	public static final Property UseGroupingSeparator = new Property("UseGroupingSeparator", true, false);
	public static final Property Keywords = new Property("Keywords", true, false);
	public static final Property RowTree = new Property("RowTree", true, false);
	public static final Property isGroupHead = new Property("isGroupHead", true, false);
	public static final Property DblClick = new Property("DblClick", true, false);
	public static final Property FormulaItemKey = new Property("FormulaItemKey", true, false);
	public static final Property ImageSource = new Property("ImageSource", false, false);
	public static final Property Case = new Property("Case", true, false);
	public static final Property CaseType = new Property("CaseType", true, false);
	public static final Property Trim = new Property("Trim", false, false);
	public static final Property TabOrder = new Property("TabOrder", false, false);
	public static final Property ErrorInfo = new Property("ErrorInfo", true, false);
	public static final Property Merge = new Property("Merge", true, false);
	public static final Property AsQuery = new Property("AsQuery", true, false);
	public static final Property CellSortType = new Property("CellSortType", true, false);
	public static final Property SelectOnFocus = new Property("SelectOnFocus", true, false);
	public static final Property CheckedType = new Property("CheckedType", false, false);
	public static final Property UnCheckedType = new Property("UnCheckedType", false, false);
	public static final Property Padding = new Property("Padding", false, false);
	public static final Property Image = new Property("Image", false, false);
	public static final Property URL = new Property("URL", false, false);
	public static final Property TargetShowType = new Property("TargetShowType", true, false);
	public static final Property FormulaURL = new Property("FormulaURL", true, false);
	public static final Property Clearable = new Property("Clearable", false, false);
	public static final Property ValueChanging = new Property("ValueChanging", true, false);
	public static final Property ValueValidation = new Property("ValueValidation", true, false);
	public static final Property ForeColor = new Property("ForeColor", false, false);
	public static final Property BackColor = new Property("BackColor", false, false);
	public static final Property RowBackColor = new Property("RowBackColor", false, false);
	public static final Property HighlightColor = new Property("HighlightColor", false, false);
	public static final Property Font = new Property("Font", false, false);
	public static final Property Name = new Property("Name", false, false);
	public static final Property Bold = new Property("Bold", false, false);
	public static final Property Size = new Property("Size", false, false);
	public static final Property Italic = new Property("Italic", false, false);
	public static final Property Underline = new Property("Underline", false, false);
	public static final Property UnderlineColor = new Property("UnderlineColor", false, false);
	public static final Property PreIcon = new Property("PreIcon", false, false);
	public static final Property EmbedText = new Property("EmbedText", false, false);
	public static final Property HoldFocus = new Property("HoldFocus", false, false);
	public static final Property Icon = new Property("Icon", false, false);
	public static final Property CssClass = new Property("CssClass", false, false);
	public static final Property Class = new Property("Class", false, false);
	public static final Property Format = new Property("Format", true, false);
	public static final Property DateFormat = new Property("DateFormat", true, false);
	public static final Property OnlyDate = new Property("OnlyDate", false, false);
	public static final Property SelectedIcon = new Property("SelectedIcon", false, false);
	public static final Property IconLocation = new Property("IconLocation", false, false);
	public static final Property IconLocation1 = new Property("IconLocation1", false, false);
	public static final Property InitVisible = new Property("InitVisible", false, false);
	public static final Property InitEnable = new Property("InitEnable", false, false);
	public static final Property MinHeight = new Property("MinHeight", false, false);
	public static final Property Weight = new Property("Weight", false, false);
	public static final Property Margin = new Property("Margin", false, false);
	public static final Property TopMargin = new Property("TopMargin", false, false);
	public static final Property BottomMargin = new Property("BottomMargin", false, false);
	public static final Property LeftMargin = new Property("LeftMargin", false, false);
	public static final Property RightMargin = new Property("RightMargin", false, false);
	public static final Property PopWidth = new Property("PopWidth", false, false);
	public static final Property PopHeight = new Property("PopHeight", false, false);
	public static final Property Resizable = new Property("Resizable", false, false);
	public static final Property Authenticate = new Property("Authenticate", true, false);
	public static final Property HasNavigationBar = new Property("HasNavigationBar", false, false);
	public static final Property ScreenOrientation = new Property("ScreenOrientation", false, false);
	public static final Property FullScreenType = new Property("FullScreenType", false, false);
	public static final Property StatusBarColor = new Property("StatusBarColor", false, false);
	public static final Property OffLine = new Property("OffLine", false, false);
	public static final Property AliasKey = new Property("AliasKey", true, false);
	public static final Property TransFormKey = new Property("TransFormKey", false, false);
	public static final Property DeliveryClass = new Property("DeliveryClass", false, false);
	public static final Property WrapText = new Property("WrapText", false, false);
	public static final Property EndEditByNav = new Property("EndEditByNav", false, false);
	public static final Property HideGroup4Editing = new Property("HideGroup4Editing", false, false);
	public static final Property PromptData = new Property("PromptData", false, false);
	public static final Property BorderStyle = new Property("BorderStyle", false, false);
	public static final Property BorderColor = new Property("BorderColor", false, false);
	public static final Property BorderRadius = new Property("BorderRadius", false, false);
	public static final Property BorderWidth = new Property("BorderWidth", false, false);
	public static final Property TopPadding = new Property("TopPadding", false, false);
	public static final Property RightPadding = new Property("RightPadding", false, false);
	public static final Property BottomPadding = new Property("BottomPadding", false, false);
	public static final Property LeftPadding = new Property("LeftPadding", false, false);
	public static final Property IgnoreRights = new Property("IgnoreRights", true, false);
	public static final Property UseFormulaModel = new Property("UseFormulaModel", true, false);
	public static final Property GridDefaultSortField = new Property("GridDefaultSortField", false, false);
	// 明细检查规则
	public static final Property UICheckRule = new Property("UICheckRule", true, false);
	//全局下拉项
	public static final Property GlobalItems = new Property("GlobalItems", true, false);

	public static final Property TextShowType = new Property("TextShowType", false, false);

	//按钮上传类型
	public static final Property UploadType = new Property("UploadType", false, false);
	public static final Property WebBrowserSourceType = new Property("WebBrowserSourceType", false, false);
	public final String name;
	public final boolean changeScope;
	public final boolean changeTable;

	//关闭事件
	public static final Property OnClose = new Property("OnClose", true, false);

	//图表属性
	public static final Property ChartType = new Property("ChartType", true, false);
	public static final Property Title = new Property("Title", false, false);
	public static final Property SeriesAxisTitle = new Property("SeriesAxisTitle", false, false);
	public static final Property CategoryAxisTitle = new Property("CategoryAxisTitle", false, false);
	public static final Property SeriesInRow = new Property("SeriesInRow", false, false);
	public static final Property ChartSourceType = new Property("ChartSourceType", true, false);
	public static final Property DataSource = new Property("DataSource", true, false);

	//表格属性
	public static final Property Zoom = new Property("Zoom", false, false);
	public static final Property Custom = new Property("Custom", true, false);
	public static final Property Locate = new Property("Locate", false, false);

	//FlexGridLayout面板属性
	public static final Property ColumnCount = new Property("ColumnCount", false, false);
	public static final Property ColumnGap = new Property("ColumnGap", false, false);
	public static final Property RowGap = new Property("RowGap", false, false);

	//单元格合并属性
	public static final Property IsMergedHead = new Property("IsMergedHead", false, false);
	public static final Property MergedRowSpan = new Property("MergedRowSpan", false, false);
	public static final Property MergedColumnSpan = new Property("MergedColumnSpan", false, false);
	public static final Property IsMerged = new Property("IsMerged", false, false);
	public static final Property TCode = new Property("TCode", false, false);
	public static final Property Activity = new Property("Activity", false, false);

	// 移动控件新增
	// button
	public static final Property UploadFile = new Property("UploadFile", false, false);
	public static final Property OnlyIcon = new Property("OnlyIcon", false, false);
	public static final Property ClickAnim = new Property("ClickAnim", false, false);
	public static final Property NeedAuthenticate = new Property("NeedAuthenticate", false, false);

	// checkbox
	public static final Property HideButton = new Property("HideButton", false, false);

	// checklistbox
	public static final Property Style = new Property("Style", false, false);
	public static final Property PopAnim = new Property("PopAnim", false, false);

	// combobox
	public static final Property PromptSize = new Property("PromptSize", false, false);

	// numberEditor
	public static final Property ImeOptions = new Property("ImeOptions", false, false);
	public static final Property OnFocus = new Property("OnFocus", false, false);
	public static final Property Suffix = new Property("Suffix", false, false);
	public static final Property Prefix = new Property("Prefix", false, false);
	public static final Property FormulaText = new Property("FormulaText", false, false);
	public static final Property AllowNull = new Property("AllowNull", false, false);
	public static final Property DisableKeyboard = new Property("DisableKeyboard", false, false);

	// texteditor
	public static final Property ShowWordLimit = new Property("ShowWordLimit", false, false);
	public static final Property Mask = new Property("Mask", false, false);
	public static final Property EmbedTextSize = new Property("EmbedTextSize", false, false);
	public static final Property EmbedTextColor = new Property("EmbedTextColor", false, false);

	// image
	public static final Property ImageScaleType = new Property("ImageScaleType", false, false);
	public static final Property PromptImage = new Property("PromptImage", false, false);
	public static final Property FileName = new Property("FileName", false, false);
	public static final Property ViewMode = new Property("ViewMode", false, false);
	public static final Property ViewOpt = new Property("ViewOpt", false, false);
	public static final Property MaskImage = new Property("MaskImage", false, false);
	public static final Property ShowThumbnail = new Property("ShowThumbnail", false, false);
	public static final Property UploadProgress = new Property("UploadProgress", false, false);
	public static final Property MaxShowSize = new Property("MaxShowSize", false, false);

	// progressbar
	public static final Property MaxPos = new Property("MaxPos", false, false);
	public static final Property MinPos = new Property("MinPos", false, false);
	public static final Property StepValue = new Property("StepValue", false, false);
	public static final Property Dynamic = new Property("Dynamic", false, false);
	public static final Property BarColor = new Property("BarColor", false, false);
	public static final Property ProgressColor = new Property("ProgressColor", false, false);
	public static final Property Repeat = new Property("Repeat", false, false);

	// togglebutton
	public static final Property TextOn = new Property("TextOn", false, false);
	public static final Property TextOff = new Property("TextOff", false, false);
	public static final Property IconOn = new Property("IconOn", false, false);
	public static final Property IconOff = new Property("IconOff", false, false);

	// PasswordEditor
	public static final Property SafeInput = new Property("SafeInput", false, false);
	public static final Property ShowSwitchIcon = new Property("ShowSwitchIcon", false, false);
	public static final Property ShowPlainText = new Property("ShowPlainText", false, false);
	public static final Property Spacing = new Property("Spacing", false, false);

	// StepEditor
	public static final Property MinValue = new Property("MinValue", false, false);
	public static final Property MaxValue = new Property("MaxValue", false, false);
	public static final Property Step = new Property("Step", false, false);
	public static final Property ShowType = new Property("ShowType", false, false);

	// ScoreBar
	public static final Property Count = new Property("Count", false, false);
	public static final Property SupportHalf = new Property("SupportHalf", false, false);

	// countdown
	public static final Property EndCaption = new Property("EndCaption", false, false);
	public static final Property MaxTime = new Property("MaxTime", false, false);
	public static final Property OnFinish = new Property("OnFinish", false, false);
	public static final Property Stepper = new Property("Stepper", false, false);

	// countup
	public static final Property RollingType = new Property("RollingType", false, false);
	public static final Property RollingLines = new Property("RollingLines", false, false);

	// DateRangePicker
	public static final Property RangeSeparator = new Property("RangeSeparator", false, false);
	public static final Property StartPlaceholder = new Property("StartPlaceholder", false, false);
	public static final Property EndPlaceholder = new Property("EndPlaceholder", false, false);

	// TimeZoneDatePicker
	public static final Property ShowTimeOff = new Property("ShowTimeOff", false, false);

	// videoPlayer
	public static final Property Path = new Property("Path", false, false);

	// barcoder
	public static final Property CodeType = new Property("CodeType", false, false);

	// NoticeBar
	public static final Property ActionIcon = new Property("ActionIcon", false, false);
	public static final Property Scrollable = new Property("Scrollable", false, false);

	// PriceLabel
	public static final Property PreText = new Property("PreText", false, false);
	public static final Property DecimalDigits = new Property("DecimalDigits", false, false);
	public static final Property ShowThousandth = new Property("ShowThousandth", false, false);

	// RelativeTime
	public static final Property Interval = new Property("Interval", false, false);

	// BPMGraph
	public static final Property ViewTag = new Property("ViewTag", false, false);
	public static final Property ProcessKey = new Property("ProcessKey", false, false);
	public static final Property ProcessVer = new Property("ProcessVer", false, false);
	public static final Property ProcessPath = new Property("ProcessPath", false, false);
	public static final Property OID = new Property("OID", false, false);

	// webbrowser
	public static final Property URLPrefix = new Property("URLPrefix", false, false);

	// chart
	public static final Property ShowValues = new Property("ShowValues", false, false);
	public static final Property Fill = new Property("Fill", false, false);
	public static final Property HasAnimation = new Property("HasAnimation", false, false);

	//TableRow
	public static final Property HasGroupHead = new Property("HasGroupHead", false, false);
	public static final Property HasGroupTail = new Property("HasGroupTail", false, false);
	public static final Property Indicator = new Property("Indicator", false, false);
	public static final Property IndicatorKey = new Property("IndicatorKey", false, false);
	public static final Property PromptRowCount = new Property("PromptRowCount", false, false);
	public static final Property ShowTotalRowCount = new Property("ShowTotalRowCount", false, false);
	public static final Property HasSubDetail = new Property("HasSubDetail", false, false);
	public static final Property Source = new Property("Source", false, false);
	public static final Property Target = new Property("Target", false, false);
	public static final Property LinkList = new Property("LinkList", false, false);
	public static final Property LinkFields = new Property("LinkFields", false, false);
	public static final Property GroupColumnKeys = new Property("GroupColumnKeys", false, false);
	public static final Property GroupCollapse = new Property("GroupCollapse", false, false);
	public static final Property HoverHead = new Property("HoverHead", false, false);
	public static final Property IsShowTopMargin = new Property("IsShowTopMargin", false, false);
	public static final Property SelectColor = new Property("SelectColor", false, false);
	public static final Property SeparatorStyle = new Property("SeparatorStyle", false, false);
	public static final Property SeparatorRadius = new Property("SeparatorRadius", false, false);
	public static final Property SeparatorOffset = new Property("SeparatorOffset", false, false);

	//Container
	public static final Property HasTabGroup = new Property("HasTabGroup", false, false);
	public static final Property DefaultFormKey = new Property("DefaultFormKey", false, false);
	public static final Property FormulaFormKey = new Property("FormulaFormKey", false, false);

	//TabGroup
	public static final Property Direction = new Property("Direction", false, false);
	public static final Property TabMode = new Property("TabMode", false, false);
	public static final Property IndicatorHeight = new Property("IndicatorHeight", false, false);
	public static final Property IndicatorColor = new Property("IndicatorColor", false, false);

	//TabItem
	public static final Property Text = new Property("Text", false, false);

	// EditView
	public static final Property ShowHead = new Property("ShowHead", false, false);
	public static final Property DefaultSelectRow = new Property("DefaultSelectRow", false, false);
	public static final Property ItemAnim = new Property("ItemAnim", false, false);
	public static final Property LayoutAnim = new Property("LayoutAnim", false, false);
	public static final Property ScrollXY = new Property("ScrollXY", false, false);
	public static final Property EditRowFormKey = new Property("EditRowFormKey", false, false);
	public static final Property LayoutType = new Property("LayoutType", false, false);
	public static final Property LayoutOrientation = new Property("LayoutOrientation", false, false);
	public static final Property EditViewRowBackColor = new Property("EditViewRowBackColor", false, false);
	public static final Property EditViewRowHighlightColor = new Property("EditViewRowHighlightColor", false, false);
	public static final Property EditViewRowTopMargin = new Property("EditViewRowTopMargin", false, false);
	public static final Property SeparatorColor = new Property("SeparatorColor", false, false);
	
	
	// Carousel
	public static final Property ShowDots = new Property("ShowDots", false, false);
	public static final Property Autoplay = new Property("Autoplay", false, false);
	public static final Property AutoplayInterval = new Property("AutoplayInterval", false, false);
	public static final Property Infinite = new Property("Infinite", false, false);
	
	// PopView
	public static final Property OnShow = new Property("OnShow", true, false);
	
	// 移动基础组件属性
	public static final Property ErrorStringID = new Property("ErrorStringID", false, false);
	public static final Property RequiredIcon = new Property("RequiredIcon", false, false);
	public static final Property CheckRulePassIcon = new Property("CheckRulePassIcon", false, false);
	public static final Property CheckRuleErrorIcon = new Property("CheckRuleErrorIcon", false, false);
	
	// 移动字典
	public static final Property IsDynamic = new Property("IsDynamic", false, false);
	public static final Property IsAllowMultiSelection = new Property("IsAllowMultiSelection", false, false);
	public static final Property IsCompDict = new Property("IsCompDict", false, false);
	public static final Property IgnoreRight = new Property("IgnoreRight", false, false);
	public static final Property LoadType = new Property("LoadType", false, false);
	public static final Property IsPromptData = new Property("IsPromptData", false, false);
	public static final Property QueryMatchType = new Property("QueryMatchType", false, false);
	
	// hoverButton
	public static final Property Location = new Property("Location", false, false);
	
	// ScoreBar
	public static final Property SelectIcon = new Property("SelectIcon", false, false);
	
	// 移动label
	public static final Property ExpandCaption = new Property("ExpandCaption", false, false);
	
	// 移动tabpanel
	public static final Property TabPosition = new Property("TabPosition", false, false);

	// SlidingLayoutPanel
	public static final Property SlipPosition = new Property("SlipPosition", false, false);
	public static final Property LeftWidth = new Property("LeftWidth", false, false);
	public static final Property SetParameter = new Property("SetParameter", false, false);
	public static final Property GetParameter = new Property("GetParameter", false, false);

	private static final Map<String, Property> PROPERTY_LIST = new HashMap<>();

	public String getName() {
		return this.name;
	}

	private Property(String name, boolean changeScope, boolean changeTable) {
		this.name = name;
		this.changeScope = changeScope;
		this.changeTable = changeTable;
	}

	/**
	 * 反射获取 test
	 * static初始化map集合 获取时直接获取
	 */
	static {
		genPropertyList();
	}

	public static void genPropertyList() {
		Class<Property> propertyClass = Property.class;
		Field[] fields = propertyClass.getFields();
		Property tmpObject = new Property("", true, true);
		for (Field field : fields) {
			try {
				// 只获取字段类型是Property的
				if (!propertyClass.getName().equals(field.getType().getName())) {
					continue;
				}
				Property property = (Property) field.get(tmpObject);
				PROPERTY_LIST.put(property.getName(), property);
			} catch (IllegalAccessException e) {
				throw new RuntimeException(e);
			}
		}
	}

	public static Property getProperty(String name) {
		if (PROPERTY_LIST.size() == 0) {
			genPropertyList();
		}
		if (!PROPERTY_LIST.containsKey(name)) {
			return null;
		}
		return PROPERTY_LIST.get(name);
	}

	@Override
	public String toString() {
		return name;
	}
}
