package com.bokesoft.erp.entity.util;

import java.util.List;

import com.bokesoft.entity.BaseContextAction;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yigo.struct.env.Env;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.struct.datatable.DataTable;

/**
 * 带实体管理功能的中间层二次开发基类,包含了com.bokesoft.yigo.entity.ITableEntityManager和com.
 * bokesoft.yigo.entity.TableEntityManagerMid这两个接口的方法.<br>
 * 为什么不直接实现这两个接口,因为这两个接口中的find()因为泛型的原因重复,编译不通过.
 */
public class EntityDesigerContextAction extends BaseContextAction {
	protected RichDocumentContext _context;

	public EntityDesigerContextAction(RichDocumentContext _context) {
		this._context = _context;
	}

	public RichDocumentContext getMidContext() {
		return this._context;
	}

	public Env getEnv() throws Throwable {
		return _context.getEnv();
	}

	public Long getClientID() throws Throwable {
		return _context.getClientID();
	}

	public Long getUserID() throws Throwable {
		return _context.getEnv().getUserID();
	}



	/**
	 * 取表单数据对象
	 * 
	 * @return
	 * @throws Throwable
	 */
	public RichDocument getDocument() throws Throwable {
		return getMidContext().getRichDocument();
	}
	public RichDocument getRichDocument() throws Throwable {
		return getMidContext().getRichDocument();
	}

	/**
	 * 针对表实体计算表达式
	 * 
	 * @param expression
	 * @param description
	 * @return
	 * @throws Throwable
	 */
	public Object evalFormula(String expression, String description) throws Throwable {
		return getMidContext().evalFormula(expression, description);
	}

}
