package com.bokesoft.erp.all.controller;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperXmlUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDataMapVo;
import com.bokesoft.yes.design.vo.ResponseResult;

import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;

/**
 * 数据映射数据处理Controller
 */
@Controller
@RequestMapping("/dataMapAttributes")
public class MapAttributesController {
	private static final Logger logger = Logger.getLogger(MapAttributesController.class.getName());
	/**
	 * 工具类
	 */
	private final DataMapOperXmlUtil dataMapOperJsonUtil;
	/**
	 * 数据迁移工具类
	 */
	private final DataMigrationOperXmlUtil dataMigrationOperXmlUtil;

	public MapAttributesController() {
		dataMapOperJsonUtil = new DataMapOperXmlUtil();
		dataMigrationOperXmlUtil = new DataMigrationOperXmlUtil();
	}

	/***
	 * 更新xml
	 * @param jsonDataMapVo 请求参数对象
	 * @return 响应结果
	 */
	@PostMapping(value = "/dataMapUpdateXml")
	@ResponseBody
	public ResponseResult<JSONArray> dataMapUpdateXml(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		String filePath = jsonDataMapVo.getFilePath();
		if (StringUtils.isEmpty(filePath)) {
			response.setCode(1);
			response.setMsg("请求参数filePath值为空，不能操作");
			return response;
		}

		String content = jsonDataMapVo.getContent();
		if (StringUtils.isEmpty(content)) {
			response.setCode(1);
			response.setMsg("请求参数content值为空，不能操作");
			return response;
		}

		try {
			response = dataMapOperJsonUtil.dataMapUpdateXml(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("更新xml失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("更新xml失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 获取表单的所有字段并传送给前端
	 *
	 * @return 返回值
	 */
	@PostMapping("/getFormField")
	@ResponseBody
	public ResponseResult<JSONArray> getFormField(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			String tempPath = XmlFileProcessor.instance.getTmpFile(jsonDataMapVo.getFilePath());
			if (StringUtils.isBlank(tempPath)) {
				tempPath = jsonDataMapVo.getFilePath();
			}
			Element element = DataMapOperJsonUtil.getElement(tempPath);
			return dataMapOperJsonUtil.getFormField(jsonDataMapVo, element);
		} catch (Exception e) {
			logger.warning("获取表单数据源字段失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取表单数据源字段失败，失败信息为:" + e.getMessage());
		}
		return response;
	}

	/**
	 * 获取表单的所有字段用于layui数据表格渲染
	 *
	 * @return 返回值
	 */
	@PostMapping("/findAllFormField")
	@ResponseBody
	public ResponseResult<JSONArray> findAllFormField(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			String formKey = jsonDataMapVo.getFormKey();
			//如果源表单和目标表单相同的话就进行拆分拿到真正的formKey
			if (StringUtils.isNotEmpty(formKey)) {
				formKey = formKey.split("__")[0];
			}
			String filePath = jsonDataMapVo.getFilePath();
			String tmpFile = XmlFileProcessor.instance.getTmpFile(filePath);
			if (tmpFile != null) {
				filePath = tmpFile;
			}
			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
			Element element = DataMapOperJsonUtil.getElement(filePath);
			String name = element.getName();
			String nodeName = jsonDataMapVo.getNodeName();
			if (ConstantUtil.MAP.equals(name)) {//数据映射
				formKey = getFormKey(jsonDataMapVo, element, nodeName);
			} else {
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
				}
			}

			JSONArray nodesJsonArray = new JSONArray();
			TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
			MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
			MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;
			if (ConstantUtil.MAP.equals(name)) {//数据映射
				MetaTableCollection tableCollection = null;
				String extend = element.attributeValue("Extend");
				String mergeToSource = element.attributeValue("MergeToSource");
				boolean isFilter = StringUtils.isNotEmpty(extend) && StringUtils.isNotEmpty(mergeToSource);
				String formKey1  = getFormKey(jsonDataMapVo, element, nodeName);
				MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
				IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
				if (metaForm != null) {//表单
					tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
				} else if (metaDataObject != null) {//数据对象表单
					tableCollection = metaDataObject.getTableCollection();
				}
				if (tableCollection != null) {
					for (int i = 0; i < tableCollection.size(); i++) {
						MetaTable metaColumns = tableCollection.get(i);
						int finalI = i + 1;
						String finalTable = metaColumns.getKey();
						Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
						if (MapUtils.isEmpty(columKeysAndFieldKeys)){
							continue;
						}
						if (!metaColumns.getKey().contains("_NODB")) {
							Collection<MetaColumn> elementMap = metaColumns.items();
							if (elementMap != null) {
								for (MetaColumn metaColumn : elementMap) {
									if (!metaColumn.getKey().contains("_NODB")) {
										List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
										if (CollectionUtils.isEmpty(fieldKeys)) {
											continue;
										}
										for (String fieldKey : fieldKeys) {

												if (isFilter) {
													Map<String, String> map =
															DataMapOperXmlUtil.filterFiledMap(extend, metaForm1);
													if (!map.containsValue(fieldKey)) {
														dataMapOperJsonUtil.setArray(formKey, nodesJsonArray, finalI, finalTable,
																metaColumn, false, false, nodeName, metaColumns,
																xmlTreeWithPath, idLookup,fieldKey);
													}
												} else {
													dataMapOperJsonUtil.setArray(formKey, nodesJsonArray, finalI, finalTable,
															metaColumn, false, false, nodeName, metaColumns,
															xmlTreeWithPath, idLookup,fieldKey);

												}
											}


									}
								}
							}
						}
					}
				}
			} else if (ConstantUtil.DATA_MIGRATION.equals(name)) {//数据迁移
				dataMapOperJsonUtil.setLayuiArrayUniversal(formKey, metaForm, metaDataObject, nodesJsonArray, true, false
						, nodeName, xmlTreeWithPath);
			}
			result.setCode(0);
			result.setMsg("获取表单字段成功");
			result.setData(nodesJsonArray);
		} catch (Throwable e) {
			logger.warning("获取表单字段异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取表单字段失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	private String getFormKey(@RequestBody JsonDataMapVo jsonDataMapVo, Element element, String nodeName) {
		String formKey1 = null;
		if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
			formKey1 = element.attributeValue(ConstantUtil.SRC_FORM_KEY);
		} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
			formKey1 = element.attributeValue(ConstantUtil.TGT_FORM_KEY);
		} else {
			String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
			List<Element> feedbackElements = element.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
			for (Element element1 : feedbackElements) {
				if (objectKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
					formKey1 = element1.attributeValue(ConstantUtil.FORM_KEY);
					break;
				}
			}
		}
		return formKey1;
	}


	/**
	 * 根据tableKey去获取对应的字段
	 *
	 */
	@PostMapping("/getTableKeyField")
	@ResponseBody
	public ResponseResult<JSONArray> getTableKeyField(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.getTableKeyField(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取表单数据源字段失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取表单数据源字段失败，失败信息为:" + e.getMessage());
		}
		return response;
	}

	/**
	 * 根据tableKey去获取对应的字段,并返回Tree需要的数据格式渲染数据表格
	 *
	 */
	@PostMapping("/findTabaleKeyField")
	@ResponseBody
	public ResponseResult<JSONArray> findTableKeyField(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.getTreeFields(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取表单数据源字段失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取表单数据源字段失败，失败信息为:" + e.getMessage());
		}
		return response;
	}

	/**
	 * 删除字段
	 *
	 */
	@PostMapping("/deleteField")
	@ResponseBody
	public ResponseResult<JSONArray> deleteField(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.getdeleteField(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取表单数据源字段失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取表单数据源字段失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 获取字段信息
	 *
	 */
	@PostMapping("/fieldInfo")
	@ResponseBody
	public ResponseResult<JSONArray> fieldInfo(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.fieldInfo(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取字段信息失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取字段信息失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 连线信息
	 *
	 */
	@PostMapping("/ligatureinfo")
	@ResponseBody
	public ResponseResult<JSONArray> ligatureinfo(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.ligatureinfo(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("连线信息获取失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("连线信息获取失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 获取字段信息
	 *
	 */
	@PostMapping("/getTargetTableList")
	@ResponseBody
	public ResponseResult<JSONArray> getTargetTableList(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.getTargetTableList(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取目标表失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取目标表失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}
	/**
	 * 获取源数据映射字段列表信息
	 *
	 */
	@PostMapping("/getSourceFieldList")
	@ResponseBody
	public ResponseResult<JSONArray> getSourceFieldList(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.getSourceFieldList(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取目标表失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取目标表失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 获取参照主表字段
	 *
	 */
	@PostMapping("/getRefFieldKey")
	@ResponseBody
	public ResponseResult<JSONArray> getRefFieldKey(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.getRefFieldKey(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取主表字段失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取主表字段失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 添加目标字段
	 *
	 */
	@PostMapping("/setTargetField")
	@ResponseBody
	public ResponseResult<JSONArray> setTargetField(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.setTargetField(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("添加目标字段失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("添加目标字段失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 验证目标字段
	 *
	 */
	@PostMapping("/isConnected")
	@ResponseBody
	public ResponseResult<Boolean> isConnected(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<Boolean> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.isConnected(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("判断连线异常，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("判断连线失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 获取所有FormKey
	 *
	 */
	@PostMapping("/getAllFormkey")
	@ResponseBody
	public ResponseResult<JSONArray> getAllFormkey(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.getAllFormkey(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取所有表单失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取所有表单失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 动态获取面板坐标
	 *
	 */
	@PostMapping("/coordinateData")
	@ResponseBody
	public ResponseResult<JSONArray> coordinateData(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.coordinateData(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取坐标失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取坐标失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}


	/**
	 * 更新连线XMl
	 *
	 */
	@PostMapping("/updateLigatureXML")
	@ResponseBody
	public ResponseResult<JSONArray> updateLigatureXML(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.updateLigatureXML(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取坐标失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取坐标失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

	/**
	 * 删除反填表单处理方法
	 *
	 */
	@PostMapping("/handleDeleteXML")
	@ResponseBody
	public ResponseResult<JSONArray> handleDeleteXML(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.handleDeleteXML(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("删除反填表单失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("删除反填表单失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}


////////////////////////////////////////////////////数据迁移数据处理///////////////////////////////////////////////////

	/**
	 * 获取表单的所有字段并传送给前端
	 *
	 * @return 返回值
	 */
	@PostMapping("/getMigrationField")
	@ResponseBody
	public ResponseResult<JSONArray> getMigrationField(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			Element element = DataMapOperJsonUtil.getElement(jsonDataMapVo.getFilePath());
			return dataMigrationOperXmlUtil.getMigrationField(jsonDataMapVo, element);
		} catch (Exception e) {
			logger.warning("获取数据对象字段失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取数据对象字段失败，失败信息为:" + e.getMessage());
		}
		return response;
	}

	/**
	 * 状态字段标识
	 *
	 */
	@PostMapping("/getStatusFideldKey")
	@ResponseBody
	public ResponseResult<JSONArray> getStatusFideldKey(@RequestBody JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMigrationOperXmlUtil.getStatusFideldKey(jsonDataMapVo);
		} catch (Exception e) {
			logger.warning("获取状态字段标识异常，异常信息为:" + ExceptionUtils.getStackTrace(e));
			response.setCode(999);
			response.setMsg("获取状态字段标识异常，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return response;
	}

}
