/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.attachmentPreview;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.cmd.attachmentPreview.IAttachmentPreview;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.converter.ExcelToHtmlConverter;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;

public class XlsAttachmentPreview
implements IAttachmentPreview {
    @Override
    public boolean isSupport(String string) throws Throwable {
        return string.equalsIgnoreCase("xls");
    }

    @Override
    public boolean isBlob() {
        return false;
    }

    @Override
    public boolean isShowInPDF() {
        return false;
    }

    @Override
    public String preview(byte[] byArray) throws Throwable {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
        try {
            Object object;
            Object object2;
            Object object3;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteArrayOutputStream = new ByteArrayOutputStream();
            ExcelToHtmlConverter excelToHtmlConverter = new ExcelToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            excelToHtmlConverter.setOutputColumnHeaders(false);
            excelToHtmlConverter.setOutputRowNumbers(false);
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)byteArrayInputStream);
            int n = 0;
            while (n < hSSFWorkbook.getNumberOfSheets()) {
                if (hSSFWorkbook.getSheetAt(n) != null) {
                    String string = StringUtils.leftPad((String)" ", (int)(n + 1), (String)" ");
                    hSSFWorkbook.setSheetName(n, string);
                }
                ++n;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n2 = 0;
            while (n2 < hSSFWorkbook.getNumberOfSheets()) {
                object3 = hSSFWorkbook.getSheetAt(n2);
                if (object3 != null) {
                    int n3 = 0;
                    while (n3 < object3.getLastRowNum()) {
                        object2 = object3.getRow(n3);
                        if (object2 != null) {
                            int n4 = 0;
                            while (n4 < object2.getLastCellNum()) {
                                HSSFHyperlink object4;
                                object = object2.getCell(n4);
                                if (object != null && (object4 = object.getHyperlink()) != null && !StringUtil.isBlankOrNull((String)object4.getAddress())) {
                                    hashMap.put(object4.getLabel(), object4.getAddress());
                                }
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            excelToHtmlConverter.processWorkbook(hSSFWorkbook);
            Document document = excelToHtmlConverter.getDocument();
            object3 = new DOMSource(document);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            object2 = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object2).newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "html");
            transformer.transform((Source)object3, streamResult);
            object = "";
            if (byteArrayOutputStream.size() > 0) {
                object = byteArrayOutputStream.toString("UTF-8");
            }
            if (!StringUtil.isBlankOrNull((String)object) && hashMap.size() > 0) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    object = ((String)object).replace(TypeConvertor.toString(entry.getKey()), "<a href = " + entry.getValue() + " target=\"_blank\">" + entry.getKey() + "</a>");
                }
            }
            Object object4 = object;
            return object4;
        }
        catch (OfficeXmlFileException officeXmlFileException) {
            throw new Exception("\u5f53\u524d\u9884\u89c8\u9644\u4ef6\u4e0d\u662f97-2003\u683c\u5f0fExcel\u6587\u6863\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f", officeXmlFileException);
        }
        catch (Throwable throwable) {
            throw new Exception("\u9884\u89c8\u6570\u636e\u51fa\u73b0\u9519\u8bef", throwable);
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    public static float getTop(HSSFWorkbook hSSFWorkbook, Integer n, Integer n2, int n3) {
        HSSFSheet hSSFSheet;
        float f = 0.0f;
        int n4 = 0;
        while (n4 < n) {
            hSSFSheet = hSSFWorkbook.getSheetAt(n4);
            Integer n5 = hSSFSheet.getLastRowNum() + 1;
            f += XlsAttachmentPreview.getTop(hSSFSheet, n5, 0);
            ++n4;
        }
        hSSFSheet = hSSFWorkbook.getSheetAt(n.intValue());
        return f += XlsAttachmentPreview.getTop(hSSFSheet, n2, n3);
    }

    public static float getTop(HSSFSheet hSSFSheet, Integer n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        while (n3 < n) {
            HSSFRow hSSFRow = hSSFSheet.getRow(n3);
            if (hSSFRow != null) {
                f += hSSFRow.getHeightInPoints();
            }
            ++n3;
        }
        if (n2 != 0) {
            f += (float)n2 / 20.0f;
        }
        return f;
    }

    public static float getLeft(HSSFSheet hSSFSheet, Integer n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        while (n3 < n) {
            float f2 = hSSFSheet.getColumnWidthInPixels(n3);
            f += f2;
            ++n3;
        }
        if (n2 != 0) {
            float f3 = 32.0f;
            f += (float)n2 / f3;
        }
        return f;
    }
}

