/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.util.deparser;

import java.util.Iterator;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.replace.Replace;
import net.boke.jsqlparser.statement.select.SelectVisitor;
import net.boke.jsqlparser.statement.select.SubSelect;

public class ReplaceDeParser
implements ItemsListVisitor {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;
    protected SelectVisitor selectVisitor;

    public ReplaceDeParser() {
    }

    public ReplaceDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuffer buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void deParse(Replace replace) {
        this.buffer.append("REPLACE ");
        this.buffer.append(replace.getTable().getWholeTableName());
        if (replace.getItemsList() != null) {
            if (replace.getColumns() != null) {
                this.buffer.append(" (");
                int i = 0;
                while (i < replace.getColumns().size()) {
                    Column column = (Column)replace.getColumns().get(i);
                    this.buffer.append(column.getWholeColumnName());
                    if (i < replace.getColumns().size() - 1) {
                        this.buffer.append(", ");
                    }
                    ++i;
                }
                this.buffer.append(") ");
            } else {
                this.buffer.append(" ");
            }
        } else {
            this.buffer.append(" SET ");
            int i = 0;
            while (i < replace.getColumns().size()) {
                Column column = (Column)replace.getColumns().get(i);
                this.buffer.append(String.valueOf(column.getWholeColumnName()) + "=");
                Expression expression = (Expression)replace.getExpressions().get(i);
                expression.accept(this.expressionVisitor);
                if (i < replace.getColumns().size() - 1) {
                    this.buffer.append(", ");
                }
                ++i;
            }
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            expression.accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }
}

