/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.util.deparser;

import java.util.Iterator;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.select.SelectVisitor;
import net.boke.jsqlparser.statement.select.SubSelect;

public class InsertDeParser
implements ItemsListVisitor {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;
    protected SelectVisitor selectVisitor;

    public InsertDeParser() {
    }

    public InsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuffer buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void deParse(Insert insert) {
        Column column;
        this.buffer.append("INSERT INTO ");
        this.buffer.append(insert.getTable().getWholeTableName()).append(" ");
        if (insert.getColumns() != null) {
            this.buffer.append("(");
            Iterator iter = insert.getColumns().iterator();
            while (iter.hasNext()) {
                column = (Column)iter.next();
                this.buffer.append(column.getColumnName());
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
        insert.getItemsList().accept(this);
        if (insert.isUseOnDuplicateKeyUpdate()) {
            this.buffer.append(" on duplicate key update ");
            int i = 0;
            while (i < insert.getUpdateColumns().size()) {
                column = (Column)insert.getUpdateColumns().get(i);
                this.buffer.append(String.valueOf(column.getWholeColumnName()) + "=");
                Expression expression = (Expression)insert.getUpdateExpList().get(i);
                expression.accept(this.expressionVisitor);
                if (i < insert.getUpdateColumns().size() - 1) {
                    this.buffer.append(", ");
                }
                ++i;
            }
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            expression.accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }
}

