/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.statement.update;

import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.StatementVisitor;

public class Update
implements Statement {
    private Table table;
    private Expression where;
    private List columns;
    private List expressions;
    private Table dataSourceTable;
    private boolean ignore;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Table getDataSourceTable() {
        return this.dataSourceTable;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public void setDataSourceTable(Table name) {
        this.dataSourceTable = name;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List getColumns() {
        return this.columns;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void setColumns(List list) {
        this.columns = list;
    }

    public void setExpressions(List list) {
        this.expressions = list;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("UPDATE ");
        if (this.isIgnore()) {
            buffer.append("IGNORE ");
        }
        buffer.append(this.getTable().toString());
        if (this.getDataSourceTable() != null) {
            buffer.append(", ").append(this.getDataSourceTable().toString());
        }
        buffer.append(" SET ");
        int i = 0;
        while (i < this.getColumns().size()) {
            Column column = (Column)this.getColumns().get(i);
            buffer.append(String.valueOf(column.getWholeColumnName()) + "=");
            Expression expression = (Expression)this.getExpressions().get(i);
            buffer.append(expression.toString());
            if (i < this.getColumns().size() - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        if (this.getWhere() != null) {
            buffer.append(" WHERE ");
            buffer.append(this.getWhere().toString());
        }
        return buffer.toString();
    }
}

