/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.source;

import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.sql.Field;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class TableSource
extends AbstractQuerySource<Table> {
    public TableSource(Table table) throws SQLException {
        super(table, table.getAliasName());
    }

    @Override
    protected void buildSubSource(Table item) throws SQLException {
    }

    @Override
    public String getAlias() {
        if (StringUtil.isBlankOrNull((String)this.alias)) {
            return ((Table)this.getSqlItem()).getAliasName();
        }
        return this.alias;
    }

    @Override
    public AbstractSqlElement getResultItem(String columnName, String tableAlias) {
        if (!(StringUtil.isBlankOrStrNull((String)tableAlias) || StringUtil.isBlankOrNull((String)((Table)this.getSqlItem()).getAlias()) || tableAlias.equalsIgnoreCase(((Table)this.getSqlItem()).getAlias()))) {
            return null;
        }
        if (this.isResultColumn(columnName)) {
            Column column = new Column(new Table(null, ((Table)this.getSqlItem()).getAliasName()), columnName);
            column.bindQuerySource(this);
            SelectExpressionItem item = new SelectExpressionItem(column);
            item.bindQuerySource(this.getParentSource());
            return item;
        }
        return null;
    }

    @Override
    public boolean isResultColumn(String columnName) {
        LinkedHashMapIgnoreCase<MetaColumn> mapColumns = this.getMetaColumns();
        if (mapColumns == null) {
            return false;
        }
        return mapColumns.containsKey(columnName);
    }

    @Override
    public Field getField(String columnName) throws SQLException {
        MetaColumn metaColumn = this.getMetaColumn(columnName);
        if (metaColumn == null) {
            throw new SQLException(String.valueOf(((Table)this.getSqlItem()).getName()) + " not exist column:'" + columnName + "'");
        }
        return this.createField(metaColumn);
    }

    @Override
    public List<Field> getAllFields() throws Throwable {
        return this.getResultFields();
    }

    @Override
    public List<Field> getResultFields() throws Throwable {
        ArrayList<Field> list = new ArrayList<Field>();
        LinkedHashMapIgnoreCase<MetaColumn> mapColumns = this.getMetaColumns();
        if (mapColumns == null) {
            return null;
        }
        for (MetaColumn column : mapColumns.values()) {
            list.add(this.createField(column));
        }
        return list;
    }

    private Field createField(MetaColumn column) {
        String name = ((Table)this.getSqlItem()).getName();
        return new Field(name, column);
    }

    @Override
    public Field parseColumn2Field(String columnAlias, Column column) throws SQLException {
        return this.getField(column.getColumnName());
    }

    @Override
    public AbstractSqlElement getResultItemInSubSources(String columnName) {
        return this.getResultItem(columnName, null);
    }

    @Override
    public AbstractQuerySource<?> deepMatchSource(String tableName, String tableAlias) {
        if (!StringUtil.isBlankOrNull((String)tableAlias) && tableAlias.equalsIgnoreCase(this.getAlias())) {
            return this;
        }
        if (tableName.equalsIgnoreCase(((Table)this.getSqlItem()).getAliasName())) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public TableSource getFirstTableSource() {
        return this;
    }

    public String getTableName() {
        return ((Table)this.getSqlItem()).getName();
    }

    private MetaColumn getMetaColumn(String columnKey) throws SQLException {
        LinkedHashMapIgnoreCase<MetaColumn> mapColumns = this.getMetaColumns();
        if (mapColumns == null) {
            return null;
        }
        return (MetaColumn)mapColumns.get(columnKey);
    }

    private LinkedHashMapIgnoreCase<MetaColumn> getMetaColumns() {
        String name = ((Table)this.getSqlItem()).getName();
        try {
            return DataObjects.getInstance().getColumnsByTableName(name);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static TableSource newInstance(Table table) throws SQLException {
        return new TableSource(table);
    }
}

