/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.source;

import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.sql.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.ISourceBindable;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.query.source.TableSource;
import net.boke.jsqlparser.query.source.part.QueryJoinOn;
import net.boke.jsqlparser.query.util.SourceHelperUtil;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuerySource<T extends ISourceBindable> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractQuerySource.class);
    private T sqlItem = null;
    private AbstractQuerySource<?> parentSource = null;
    protected LinkedHashMapIgnoreCase<AbstractQuerySource<?>> mapFromSources = null;
    private ArrayList<QueryJoinOn> listJoinOn = null;
    protected String alias = null;
    private boolean isUnion = false;

    public AbstractQuerySource(T sqlItem, String alias) throws SQLException {
        this.sqlItem = sqlItem;
        this.alias = alias;
        sqlItem.bindQuerySource(this);
        this.buildSubSource(sqlItem);
    }

    public String getAlias() {
        return this.alias;
    }

    public T getSqlItem() {
        return this.sqlItem;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public boolean isNoSplit() {
        return false;
    }

    public Field parseSelectItem2Field(SelectExpressionItem item) throws SQLException {
        SelectExpressionItem selectExpressionItem = item;
        String columnAlias = selectExpressionItem.getAlias();
        Expression expression = selectExpressionItem.getExpression();
        if (expression instanceof Column) {
            return this.parseColumn2Field(columnAlias, (Column)expression);
        }
        if (expression instanceof JdbcParameter) {
            throw new RuntimeException("\u5206\u5e93\u5206\u8868 \u672a\u652f\u6301 parseSelectItem2Field:" + expression.toString());
        }
        if (expression instanceof SubSelect) {
            Object subItem = null;
            SelectBody body = ((SubSelect)expression).getSelectBody();
            if (body instanceof PlainSelect) {
                subItem = SourceHelperUtil.getFirstSelectItem((PlainSelect)body);
            } else if (body instanceof Union) {
                subItem = SourceHelperUtil.getFirstSelectItem((PlainSelect)((Union)body).getPlainSelects().get(0));
            }
            if (subItem instanceof SelectExpressionItem) {
                return this.parseSelectItem2Field((SelectExpressionItem)subItem);
            }
            throw new RuntimeException("\u5206\u5e93\u5206\u8868:" + selectExpressionItem.toString() + " \u5b57\u6bb5\u6ca1\u6709\u5904\u7406");
        }
        if (expression instanceof Expression) {
            return new Field(columnAlias, SourceHelperUtil.getCalcItemDataType(expression));
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868:" + selectExpressionItem.toString() + " \u5b57\u6bb5\u6ca1\u6709\u5904\u7406");
    }

    public Field parseColumn2Field(String columnAlias, Column column) throws SQLException {
        if (column.getQuerySource() == null) {
            return null;
        }
        Field field = column.getQuerySource().getField(column.getColumnName());
        field.setAlias(StringUtil.isBlankOrNull((String)columnAlias) ? column.getColumnName() : columnAlias);
        field.setColumnName(column.getColumnName());
        return field;
    }

    public void addJoinOn(QueryJoinOn joinOn) {
        this.ensureJoinOnList().add(joinOn);
    }

    public boolean isJoinSource() {
        if (this.listJoinOn == null) {
            return false;
        }
        return this.listJoinOn.size() > 0;
    }

    public List<QueryJoinOn> getJoinOnList() {
        return this.ensureJoinOnList();
    }

    public AbstractQuerySource<?> getSourceByTableAlias(String alias) {
        if (this.mapFromSources == null) {
            return null;
        }
        return (AbstractQuerySource)this.mapFromSources.get(alias);
    }

    public Collection<AbstractQuerySource<?>> getSubSources() {
        if (this.mapFromSources == null) {
            return Collections.emptyList();
        }
        return this.mapFromSources.values();
    }

    public AbstractQuerySource<?> getFirstSubSource() {
        if (this.mapFromSources == null) {
            return null;
        }
        Iterator iterator = this.mapFromSources.values().iterator();
        if (iterator.hasNext()) {
            AbstractQuerySource source = (AbstractQuerySource)iterator.next();
            return source;
        }
        return null;
    }

    public AbstractQuerySource<?> getSourceByColumn(Column column) throws SQLException {
        return this.matchSubSourceByColumn(column);
    }

    public AbstractQuerySource<?> deepMatchSource(String tableName, String tableAlias) {
        if (!StringUtil.isBlankOrNull((String)tableAlias) && tableAlias.equalsIgnoreCase(this.getAlias())) {
            return this;
        }
        if (this.mapFromSources == null) {
            return null;
        }
        AbstractQuerySource<?> result = null;
        for (AbstractQuerySource source : this.mapFromSources.values()) {
            result = source.deepMatchSource(tableName, tableAlias);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private AbstractQuerySource<?> matchSubSourceByElement(AbstractSqlElement elem) throws SQLException {
        List<Column> columns = SourceHelperUtil.getLinkedColumns(elem);
        for (Column column : columns) {
            AbstractQuerySource<?> result = this.matchSubSourceByColumn(column);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private AbstractQuerySource<?> matchSubSourceByColumn(Column column) throws SQLException {
        Table table = column.getTable();
        if (table != null && table.getAliasName() != null) {
            if (table.getAliasName().equalsIgnoreCase(this.getAlias())) {
                return this;
            }
            AbstractQuerySource<?> result = this.matchSourceByAlias(table.getAliasName());
            if (result != null) {
                return result;
            }
        }
        return this.matchSubSourceByColumnName(column.getColumnName());
    }

    private AbstractQuerySource<?> matchSourceByAlias(String alias) {
        if (alias != null && alias.equalsIgnoreCase(this.getAlias())) {
            return this;
        }
        if (this.mapFromSources == null) {
            return null;
        }
        for (AbstractQuerySource source : this.mapFromSources.values()) {
            AbstractQuerySource<?> result = source.matchSourceByAlias(alias);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private AbstractQuerySource<?> matchSubSourceByColumnName(String columnName) throws SQLException {
        if (this.mapFromSources == null) {
            return null;
        }
        for (AbstractQuerySource source : this.mapFromSources.values()) {
            if (source.isResultColumn(columnName)) {
                return source;
            }
            AbstractSqlElement elem = source.getResultItem(columnName, null);
            AbstractQuerySource<?> result = source.matchSubSourceByElement(elem);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean isResultItemInSubSources(String columnName) {
        if (this.mapFromSources == null) {
            return false;
        }
        for (AbstractQuerySource subSource : this.mapFromSources.values()) {
            if (!subSource.isResultColumn(this.alias)) continue;
            return true;
        }
        return false;
    }

    public void addFromSource(AbstractQuerySource<?> fromSource) {
        if ("TmpOnlyOneRow".equalsIgnoreCase(fromSource.getAlias())) {
            return;
        }
        this.ensureMapSourceFromBlocks().put(fromSource.getAlias(), fromSource);
        fromSource.setParentSource(this);
    }

    public void setParentSource(AbstractQuerySource<?> parentBlock) {
        this.parentSource = parentBlock;
    }

    public AbstractQuerySource<?> getParentSource() {
        return this.parentSource;
    }

    public boolean isTable() {
        return false;
    }

    protected LinkedHashMapIgnoreCase<AbstractQuerySource<?>> ensureMapSourceFromBlocks() {
        if (this.mapFromSources == null) {
            this.mapFromSources = new LinkedHashMapIgnoreCase();
        }
        return this.mapFromSources;
    }

    private ArrayList<QueryJoinOn> ensureJoinOnList() {
        if (this.listJoinOn == null) {
            this.listJoinOn = new ArrayList();
        }
        return this.listJoinOn;
    }

    public void clearAll() {
        this.sqlItem = null;
        this.parentSource = null;
        if (this.listJoinOn != null) {
            this.listJoinOn.clear();
            this.listJoinOn = null;
        }
        if (this.mapFromSources != null) {
            for (AbstractQuerySource source : this.mapFromSources.values()) {
                source.clearAll();
            }
            this.mapFromSources.clear();
            this.mapFromSources = null;
        }
    }

    public void bindPartsSource() throws SQLException {
        if (this.listJoinOn != null) {
            for (QueryJoinOn joinOn : this.listJoinOn) {
                joinOn.bindSource();
            }
        }
        if (this.mapFromSources != null) {
            for (AbstractQuerySource source : this.mapFromSources.values()) {
                source.bindPartsSource();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public AbstractQuerySource<?> getRoot() {
        source = this.getParentSource();
        if (source != null) ** GOTO lbl5
        return this;
lbl-1000:
        // 1 sources

        {
            source = source.getParentSource();
lbl5:
            // 2 sources

            ** while (source.getParentSource() != null)
        }
lbl6:
        // 1 sources

        return source;
    }

    public boolean isResultColumn(String columnName, String tableAlias) {
        if (!StringUtil.isBlankOrNull((String)tableAlias) && !StringUtil.isBlankOrNull((String)this.getAlias())) {
            return tableAlias.equalsIgnoreCase(this.getAlias());
        }
        return this.isResultColumn(columnName);
    }

    public boolean isResultColumn(Column column) {
        boolean result;
        AbstractQuerySource<?> columnSource = column.getQuerySource();
        boolean bl = columnSource == null ? false : (result = columnSource == this || columnSource.getSqlItem() == this.getSqlItem());
        if (!result) {
            String tableAlias = column.getTable() == null ? "" : column.getTable().getAliasName();
            return this.isResultColumn(column.getColumnName(), tableAlias);
        }
        return result;
    }

    public AbstractSqlElement getResultItem(Column column) {
        String tableAlias;
        String string = tableAlias = column.getTable() == null ? "" : column.getTable().getAliasName();
        if (!StringUtil.isBlankOrNull((String)tableAlias) && tableAlias.equalsIgnoreCase(this.getAlias())) {
            tableAlias = null;
        }
        return this.getResultItem(column.getColumnName(), tableAlias);
    }

    public AbstractSqlElement getResultItem(String columnName) throws SQLException {
        return this.getResultItem(columnName, null);
    }

    public SelectItem getFinalSelectItemFromSub(Column column, boolean isForChangeField) {
        return this.getFinalSelectItemFromSources(column, this.getSubSources(), isForChangeField);
    }

    public SelectItem getFinalSelectItem(Column column, boolean isForChangeField) {
        Column subColumn;
        SelectItem subResult;
        SelectItem selectItem = (SelectItem)((Object)this.getResultItem(column));
        if (this.isTable() && selectItem != null) {
            return selectItem;
        }
        if (SourceHelperUtil.isSelectItemFromTable(selectItem)) {
            return selectItem;
        }
        if (selectItem instanceof SelectExpressionItem && ((SelectExpressionItem)selectItem).getExpression() instanceof Column && (subResult = this.getFinalSelectItemFromSources(subColumn = (Column)((SelectExpressionItem)selectItem).getExpression(), this.getSubSources(), isForChangeField)) != null) {
            if (subResult.getQuerySource().isNoSplit() && isForChangeField) {
                return selectItem;
            }
            return subResult;
        }
        return selectItem;
    }

    private SelectItem getFinalSelectItemFromSources(Column column, Collection<AbstractQuerySource<?>> subSources, boolean isForChangeField) {
        SelectItem result = null;
        for (AbstractQuerySource<?> subSource : subSources) {
            if (column.getTable() == null || column.getTable().getName() == null || column.getTable().getName().equalsIgnoreCase(subSource.getAlias())) {
                result = subSource.getFinalSelectItem(column, isForChangeField);
            }
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public TableSource getFirstTableSource() {
        for (AbstractQuerySource<?> subSource : this.getSubSources()) {
            TableSource tableSource = subSource.getFirstTableSource();
            if (tableSource == null) continue;
            return tableSource;
        }
        return null;
    }

    protected abstract void buildSubSource(T var1) throws SQLException;

    public abstract boolean isResultColumn(String var1);

    public abstract Field getField(String var1) throws SQLException;

    public abstract List<Field> getAllFields() throws Throwable;

    public abstract List<Field> getResultFields() throws Throwable;

    public abstract AbstractSqlElement getResultItem(String var1, String var2);

    public abstract AbstractSqlElement getResultItemInSubSources(String var1);
}

