/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.expression.operators;

import com.bokesoft.yes.mid.dbcache.parsedsql.CheckedSql;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedDelete;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedInsert;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedOther;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSqls;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedUpdate;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParametricCheck {
    private static Logger logger = LoggerFactory.getLogger(SqlParametricCheck.class);
    public boolean flag = true;
    public boolean hasSubSelect = false;
    private static String checkModel = "log";
    private static List<String> list = Arrays.asList("GeneralDBManager", "StatementWithLog", "PreparedStatementWithLog", "MultiDBPreparedStatement", "SqlParametricCheck", "RichDocumentContext", "EntityContextAction", "EntityContext", "TableEntityManager", "NativeMethodAccessorImpl");

    public void checkSelectSQL(String sql) throws Throwable {
        this.flag = true;
        if (checkModel.equals("ignore") || sql.contains("YBS_DataLog")) {
            return;
        }
        if (CheckedSql.sqlList.contains(sql)) {
            return;
        }
        try {
            ItemsList itemsList;
            ParsedSql parsedSql = ParsedSqls.getInstance().createParsedSql(sql.toLowerCase());
            if (parsedSql instanceof ParsedSelect) {
                Statement statement = parsedSql.getStatement();
                if (statement instanceof Select) {
                    FromItem fromItem;
                    JdbcParameter rowCountJdbcParameterValue;
                    PlainSelect selectBody = (PlainSelect)((Select)statement).getSelectBody();
                    Limit limit = selectBody.getLimit();
                    if (limit != null && limit.getOffset() > 0L && limit.getRowCount() > 0L) {
                        JdbcParameter offsetJdbcParameterValue = limit.getOffsetJdbcParameterValue();
                        JdbcParameter rowCountJdbcParameterValue2 = limit.getRowCountJdbcParameterValue();
                        if (offsetJdbcParameterValue == null || rowCountJdbcParameterValue2 == null) {
                            this.flag = false;
                        }
                    } else if (limit != null && limit.getRowCount() > 0L && (rowCountJdbcParameterValue = limit.getRowCountJdbcParameterValue()) == null) {
                        this.flag = false;
                    }
                    if (!((fromItem = selectBody.getFromItem()) instanceof Table) && fromItem instanceof SubSelect) {
                        SubSelect subSelect = (SubSelect)fromItem;
                        SelectBody body = subSelect.getSelectBody();
                        if (subSelect.getSelectBody() instanceof Union) {
                            List plainSelects = ((Union)body).getPlainSelects();
                            for (Object plainSelect : plainSelects) {
                                if (!(plainSelect instanceof PlainSelect)) continue;
                                this.hasSubSelect = true;
                                this.checkSelectSQL(plainSelect.toString());
                            }
                        } else {
                            String string = body.toString();
                            this.checkSelectSQL(string);
                        }
                    }
                    if (selectBody.getJoins() != null && selectBody.getJoins().size() > 0) {
                        List joins = selectBody.getJoins();
                        for (Object join : joins) {
                            FromItem rightItem;
                            if (!(join instanceof Join) || !((rightItem = ((Join)join).getRightItem()) instanceof SubSelect)) continue;
                            String string = ((SubSelect)rightItem).getSelectBody().toString();
                            this.hasSubSelect = true;
                            this.checkSelectSQL(string);
                        }
                    }
                }
                Expression expression = parsedSql.getWhereClause();
                this.sqlParametric(expression);
            } else if (parsedSql instanceof ParsedDelete) {
                Expression expression = parsedSql.getWhereClause();
                this.sqlParametric(expression);
            } else if (parsedSql instanceof ParsedUpdate) {
                Expression expression = parsedSql.getWhereClause();
                this.sqlParametric(expression);
            } else if (parsedSql instanceof ParsedInsert && (itemsList = ((Insert)parsedSql.getStatement()).getItemsList()) instanceof ExpressionList) {
                ExpressionList expressionList = (ExpressionList)itemsList;
                List expressions = expressionList.getExpressions();
                this.checkExpressionList(expressions);
            }
            this.isSqlCorrect(sql);
            this.hasSubSelect = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkFilter(String sql) throws Throwable {
        block4: {
            Expression whereClause;
            block5: {
                this.flag = true;
                String temp = "Select * from temp Where " + sql;
                ParsedSql parsedSql = ParsedSqls.getInstance().getParsedSql(temp);
                if (parsedSql == null || (whereClause = parsedSql.getWhereClause()) == null) break block4;
                if (!CheckedSql.sqlList.contains(whereClause.toString())) break block5;
                return true;
            }
            try {
                this.sqlParametric(whereClause);
                if (!this.flag) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private void checkExpressionList(List expressions) {
        for (Object expression : expressions) {
            if (expression instanceof JdbcParameter) continue;
            String trim = expression.toString().trim();
            String matach = "\\s*[+-]{1}\\s*\\?*";
            Pattern pattern = Pattern.compile(matach);
            Matcher m = pattern.matcher(trim);
            if (m.find()) continue;
            this.flag = false;
            return;
        }
    }

    private boolean sqlParametric(Expression expression) {
        Expression value;
        LikeExpression likeExpression;
        if (expression instanceof Parenthesis) {
            this.sqlParametric(((Parenthesis)expression).getExpression());
        } else if (expression instanceof AndExpression) {
            this.sqlParametric(((AndExpression)expression).getLeftExpression());
            this.sqlParametric(((AndExpression)expression).getRightExpression());
        } else if (expression instanceof EqualsTo) {
            Expression value2;
            EqualsTo binaryExpression = (EqualsTo)expression;
            if (!(SqlParametricCheck.isConstant(binaryExpression.getLeftExpression()) && ParsedSqlUtil.isConstant(binaryExpression.getRightExpression()) || binaryExpression.isNot() || !(binaryExpression.getLeftExpression() instanceof Column) || (value2 = binaryExpression.getRightExpression()) instanceof JdbcParameter)) {
                if (SqlParametricCheck.isConstant(value2)) {
                    this.flag = false;
                } else if (value2 instanceof Parenthesis) {
                    this.sqlParametric(((AndExpression)expression).getRightExpression());
                }
            }
        } else if (expression instanceof GreaterThan || expression instanceof GreaterThanEquals || expression instanceof MinorThan || expression instanceof MinorThanEquals || expression instanceof NotEqualsTo) {
            Expression value3;
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (SqlParametricCheck.isConstant(binaryExpression.getLeftExpression())) {
                ParsedSqlUtil.isConstant(binaryExpression.getRightExpression());
            }
            if (!binaryExpression.isNot() && binaryExpression.getLeftExpression() instanceof Column) {
                Expression value4 = binaryExpression.getRightExpression();
                if (!(value4 instanceof JdbcParameter)) {
                    if (SqlParametricCheck.isConstant(value4)) {
                        String s = value4.toString();
                        Expression leftExpression = binaryExpression.getLeftExpression();
                        String s1 = leftExpression.toString();
                        if (!s.contains(".") || s1.contains(s)) {
                            this.flag = false;
                        }
                    } else if (value4 instanceof Parenthesis) {
                        this.sqlParametric(((BinaryExpression)expression).getRightExpression());
                    }
                }
            } else if (!binaryExpression.isNot() && binaryExpression.getRightExpression() instanceof Column && !((value3 = binaryExpression.getLeftExpression()) instanceof JdbcParameter)) {
                if (SqlParametricCheck.isConstant(value3)) {
                    this.flag = false;
                } else if (value3 instanceof Parenthesis) {
                    this.sqlParametric(((BinaryExpression)expression).getLeftExpression());
                }
            }
        } else if (expression instanceof InExpression) {
            InExpression inexp = (InExpression)expression;
            if (inexp.getItemsList() instanceof ExpressionList) {
                List expressionList = ((ExpressionList)inexp.getItemsList()).getExpressions();
                int count = expressionList.size();
                int j = 0;
                while (j < count) {
                    Object tmp = expressionList.get(j);
                    if (tmp instanceof JdbcParameter) {
                        ++j;
                    } else if (SqlParametricCheck.isConstant((Expression)tmp)) {
                        this.flag = false;
                    }
                    ++j;
                }
            } else if (inexp.getItemsList() instanceof SubSelect) {
                Expression where;
                boolean isError;
                SubSelect subSelect = (SubSelect)inexp.getItemsList();
                ParsedSql parsedSql = ParsedSqls.getInstance().createParsedSql(subSelect.getSelectBody().toString().toLowerCase());
                if (!(parsedSql instanceof ParsedOther) && !(isError = this.sqlParametric(where = parsedSql.getWhereClause()))) {
                    this.hasSubSelect = true;
                }
            }
        } else if (expression instanceof Between) {
            Between binaryExpression = (Between)expression;
            if (!binaryExpression.isNot()) {
                Expression value1;
                Expression value5 = binaryExpression.getBetweenExpressionStart();
                if (!(value5 instanceof JdbcParameter) && SqlParametricCheck.isConstant(value5)) {
                    this.flag = false;
                }
                if (!((value1 = binaryExpression.getBetweenExpressionEnd()) instanceof JdbcParameter) && SqlParametricCheck.isConstant(value1)) {
                    this.flag = false;
                }
            }
        } else if (expression instanceof OrExpression) {
            this.sqlParametric(((OrExpression)expression).getLeftExpression());
            this.sqlParametric(((OrExpression)expression).getRightExpression());
        } else if (expression instanceof LikeExpression && !(likeExpression = (LikeExpression)expression).isNot() && likeExpression.getLeftExpression() instanceof Column && !((value = likeExpression.getRightExpression()) instanceof JdbcParameter) && SqlParametricCheck.isConstant(value)) {
            this.flag = false;
        }
        return this.flag;
    }

    private void isSqlCorrect(String sql) throws Throwable {
        block9: {
            try {
                if (this.flag && StringUtils.isNotEmpty((CharSequence)sql)) {
                    CheckedSql.sqlList.add(sql);
                }
                if (this.flag) break block9;
                this.flag = true;
                if (checkModel.equalsIgnoreCase("log") && !CheckedSql.errorList.contains(sql) || this.hasSubSelect && !CheckedSql.errorList.contains(sql)) {
                    logger.error("\r\nSQL\u6ca1\u6709\u6b63\u786e\u53c2\u6570\u5316\uff0c\u5177\u4f53\u7247\u6bb5\u4e3a\r\n" + sql + "\r\n" + "\u8bf7\u68c0\u6d4bsql\u662f\u5426\u6b63\u786e\u53c2\u6570\u5316,SQL\u62fc\u63a5\u7684\u5177\u4f53\u8c03\u7528\u6808\u4e3a:");
                    CheckedSql.errorList.add(sql);
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    int i = 1;
                    while (i < 15) {
                        boolean print = true;
                        StackTraceElement stackTraceElement = stackTrace[i];
                        for (String s : list) {
                            if (!stackTraceElement.toString().contains(s)) continue;
                            print = false;
                            break;
                        }
                        if (print) {
                            logger.error(stackTraceElement.toString());
                        }
                        if (stackTraceElement.toString().contains("loadQueryTable")) {
                            logger.error("\u52a0\u8f7d\u6570\u636e\u6e90\u6216\u6570\u636e\u5bf9\u8c61SQL\u6ca1\u6709\u53c2\u6570\u5316\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u6570\u636e\u6e90\u6216\u6570\u636e\u5bf9\u8c61\u914d\u7f6e");
                        }
                        ++i;
                    }
                    break block9;
                }
                if (checkModel.equals("error") && !this.hasSubSelect) {
                    throw new Throwable("SQL\u6ca1\u6709\u6b63\u786e\u7684\u53c2\u6570\u5316\uff0c\u8bf7\u68c0\u67e5SQL\u62fc\u63a5\u65b9\u5f0f\uff0c\u6309\u7167\u6b63\u786e\u7684\u65b9\u5f0f\u5bf9SQL\u8fdb\u884c\u53c2\u6570\u5316" + sql);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isError(String sql) {
        return CheckedSql.errorList.contains(sql);
    }

    private static boolean isConstant(Expression exp) {
        return exp != null && (exp instanceof LongValue || exp instanceof StringValue || exp instanceof DoubleValue || exp instanceof DateValue || exp instanceof TimestampValue || exp instanceof TimeValue || exp instanceof NullValue);
    }

    public void errorLog(String metaFormKey, String fieldKey, String formula, String sql) throws Throwable {
        block4: {
            try {
                if (this.flag) break block4;
                this.flag = true;
                if (checkModel.equals("log") && !CheckedSql.errorList.contains(formula) || this.hasSubSelect && !CheckedSql.errorList.contains(sql)) {
                    logger.error("\r\nFilter\u516c\u5f0f\u7f16\u5199\u9519\u8bef\uff0c\u7ec4\u4ef6\u4ee5\u53ca\u5b9a\u4e49\u8868\u5355\u4f4d\u7f6e\u4e3a\r\n" + metaFormKey + "\u8868\u5355\u4e2d," + "\r\n" + fieldKey + "\u7ec4\u4ef6 " + "\r\n" + "\u8bf7\u68c0\u6d4b\u516c\u5f0f\u662f\u5426\u6b63\u786e\u53c2\u6570\u5316,\u516c\u5f0f\u5177\u4f53\u5185\u5bb9\u4e3a:" + formula);
                    CheckedSql.errorList.add(formula);
                    break block4;
                }
                if (checkModel.equals("error") && !this.hasSubSelect) {
                    throw new Throwable("Filter\u516c\u5f0f\u6ca1\u6709\u6b63\u786e\u7684\u53c2\u6570\u5316\uff0c \u8bf7\u68c0\u6d4b\u5171\u516c\u5f0f\u662f\u5426\u6b63\u786e\u53c2\u6570\u5316");
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void errorConditionLog(String metaFormKey, String fieldKey, String formula, String sql) throws Throwable {
        block4: {
            try {
                if (this.flag) break block4;
                this.flag = true;
                if (checkModel.equals("log") && !CheckedSql.errorList.contains(formula)) {
                    logger.error("\r\nCondition\u5b57\u6bb5\u67e5\u8be2\u5c5e\u6027\u7f16\u5199\u9519\u8bef\uff0c\u7ec4\u4ef6\u4ee5\u53ca\u5b9a\u4e49\u8868\u5355\u4f4d\u7f6e\u4e3a\r\n" + metaFormKey + "\u8868\u5355\u4e2d," + "\r\n" + fieldKey + "\u7ec4\u4ef6 " + "\r\n" + "\u8bf7\u68c0\u6d4b\u516c\u5f0f\u662f\u5426\u6b63\u786e\u53c2\u6570\u5316,\u516c\u5f0f\u5177\u4f53\u5185\u5bb9\u4e3a:" + formula);
                    CheckedSql.errorList.add(formula);
                    break block4;
                }
                if (checkModel.equals("error")) {
                    throw new Throwable("Condition\u5b57\u6bb5\u67e5\u8be2\u5c5e\u6027\u7f16\u5199\u9519\u8bef\uff0c \u8bf7\u68c0\u6d4b\u5171\u516c\u5f0f\u662f\u5426\u6b63\u786e\u53c2\u6570\u5316");
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void errorMapFunctionLog(String metaFormKey, String fieldKey, String formula) throws Throwable {
        block4: {
            try {
                if (this.flag) break block4;
                this.flag = true;
                if (checkModel.equals("log") && !CheckedSql.errorList.contains(formula)) {
                    logger.error("\r\n\u6620\u5c04\u516c\u5f0f\u4e2d\u8fc7\u6ee4\u6761\u4ef6\u53c2\u6570\u5316\u7f16\u5199\u9519\u8bef\uff0c\u4f4d\u7f6e\u4e3a\r\n" + metaFormKey + "\u8868\u5355\u4e2d," + "\r\n" + fieldKey + "\u7ec4\u4ef6 " + "\r\n" + "\u8bf7\u68c0\u6d4b\u516c\u5f0f\u662f\u5426\u6b63\u786e\u53c2\u6570\u5316,\u516c\u5f0f\u5177\u4f53\u5185\u5bb9\u4e3a:" + formula);
                    CheckedSql.errorList.add(formula);
                    break block4;
                }
                if (checkModel.equals("error")) {
                    throw new Throwable("\u6620\u5c04\u516c\u5f0f\u53c2\u6570\u6ca1\u6709\u6b63\u786e\u7684\u53c2\u6570\u5316\uff0c \u8bf7\u68c0\u6d4b\u5171\u516c\u5f0f\u662f\u5426\u6b63\u786e\u53c2\u6570\u5316");
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setCheckModel(String model) {
        checkModel = model;
    }
}

