/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.parameterizedsql;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.mid.parameterizedsql.SqlEncryptUtil;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlStringUtil {
    private static Pattern r = Pattern.compile("(\\s(?i)SOID|^(?i)SOID)\\s*=\\s*(\\d+|\\?)(?=\\s|$)");

    public static Long getSOID(SqlString sql) {
        String s = sql.getSql();
        Matcher m = r.matcher(s);
        if (m.find()) {
            String tmp = m.group(2);
            if ("?".equals(tmp)) {
                int posInStr = m.start(2);
                int pos = 0;
                char[] ch = s.toCharArray();
                int i = 0;
                while (i < posInStr) {
                    if (ch[i] == '?') {
                        ++pos;
                    }
                    ++i;
                }
                return TypeConvertor.toLong((Object)sql.getParameters()[pos]);
            }
            return Long.parseLong(tmp);
        }
        return null;
    }

    public static String SqlStringToString(SqlString sqlString) {
        String result;
        if (sqlString == null) {
            return "";
        }
        Object[] parameters = sqlString.getParameters();
        if (parameters.length == 0) {
            result = sqlString.getSql();
        } else {
            StringBuilder sb = new StringBuilder(1024).append(sqlString.getSql()).append(";Parameter:");
            ArrayList<Object> paras = new ArrayList<Object>();
            int i = 0;
            int size = parameters.length;
            while (i < size) {
                paras.add(parameters[i]);
                ++i;
            }
            String string = JSONObject.toJSONString(paras);
            sb.append(string).append(";");
            result = sb.toString();
        }
        return result;
    }

    public static SqlString StringToSqlString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        int pos = str.indexOf(";Parameter:");
        if (pos < 0) {
            return new SqlString(str.length()).append(str);
        }
        int posLast = str.lastIndexOf("];");
        SqlString result = new SqlString(str.length()).append(str.substring(0, pos)).append(str.substring(posLast + 2, str.length()));
        List<Object> parameterList = result.getParameterListNotNull();
        String parametersStr = str.substring(pos + ";Parameter:".length(), posLast + 1);
        JSONArray jsonArray = JSONArray.parseArray((String)parametersStr);
        parameterList.addAll((Collection<Object>)jsonArray);
        return result;
    }

    public static SqlString ToSqlString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof SqlString) {
            return (SqlString)obj;
        }
        if (obj instanceof String) {
            String tmp = (String)obj;
            if (tmp.startsWith("MARK(") && tmp.endsWith(")MARK")) {
                return SqlEncryptUtil.getDecryptByDESAddMD5(tmp);
            }
            return SqlStringUtil.StringToSqlString(tmp);
        }
        throw new RuntimeException("\u8f6c\u5316\u4e3aSqlString\uff0c\u4e0d\u652f\u6301\u6570\u636e" + obj);
    }

    public static SqlString genMultiParameters(String inValues) {
        String[] values = inValues.split(",");
        SqlString result = new SqlString();
        int i = 0;
        int size = values.length;
        while (i < size) {
            if (i > 0) {
                result.append(", ");
            }
            result.appendPara(values[i].trim());
            ++i;
        }
        return result;
    }

    public static <T> SqlString genInExpression(String target, Collection<T> inValues) {
        if (inValues.isEmpty()) {
            return new SqlString();
        }
        SqlString result = new SqlString();
        result.append(target).append(" in (");
        for (T val : inValues) {
            result.appendPara(val).append(",");
        }
        result.deleteRight(1).append(")");
        return result;
    }

    public static SqlString joinAnd(SqlString ... children) {
        SqlString result = new SqlString();
        SqlString[] sqlStringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            SqlString child = sqlStringArray[n2];
            if (child != null && !child.isEmpty()) {
                if (result.length() > 0) {
                    result.append(" and ");
                }
                result.append(child);
            }
            ++n2;
        }
        return result;
    }

    public static String toJsonString(Object content) {
        SqlString sqlString = content instanceof SqlString ? (SqlString)content : SqlStringUtil.StringToSqlString(content.toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sql", (Object)sqlString.sql);
        jsonObject.put("parameters", sqlString.parameters);
        jsonObject.put("isFinalResult", (Object)sqlString.isFinalResult);
        jsonObject.put("parametersType", SqlStringUtil.getParameterTypes(sqlString.parameters));
        return jsonObject.toString();
    }

    public static SqlString fromJson(String content) {
        SqlString sqlString = new SqlString();
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        StringBuilder sql = new StringBuilder().append(jsonObject.getString("sql"));
        Boolean isFinalResult = TypeConvertor.toBoolean((Object)jsonObject.getString("isFinalResult"));
        sqlString.sql = sql;
        sqlString.isFinalResult = isFinalResult;
        JSONArray parametersJson = jsonObject.getJSONArray("parameters");
        if (parametersJson != null) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.addAll((Collection<Object>)parametersJson);
            ArrayList paramatersType = new ArrayList();
            JSONArray parametersType = jsonObject.getJSONArray("parametersType");
            paramatersType.addAll(parametersType);
            int i = 0;
            int size = parameters.size();
            while (i < size) {
                Object value = parameters.get(i);
                int dataType = (Integer)paramatersType.get(i);
                value = SqlStringUtil.convert(value, dataType);
                parameters.set(i, value);
                ++i;
            }
            sqlString.parameters = parameters;
        }
        return sqlString;
    }

    private static ArrayList<Integer> getParameterTypes(List<Object> parameters) {
        ArrayList<Integer> parametersTypes = new ArrayList<Integer>();
        if (parameters == null) {
            return parametersTypes;
        }
        for (Object parameter : parameters) {
            Class<?> paraType = parameter.getClass();
            if (paraType == String.class) {
                parametersTypes.add(1002);
                continue;
            }
            if (paraType == BigDecimal.class) {
                parametersTypes.add(1005);
                continue;
            }
            if (paraType == Long.class || paraType == Long.TYPE) {
                parametersTypes.add(1010);
                continue;
            }
            if (paraType == Integer.TYPE || paraType == Integer.class) {
                parametersTypes.add(1001);
                continue;
            }
            if (paraType == Boolean.class || paraType == Boolean.TYPE) {
                parametersTypes.add(1009);
                continue;
            }
            if (paraType == Timestamp.class) {
                parametersTypes.add(1101);
                continue;
            }
            if (paraType == Date.class) {
                parametersTypes.add(1003);
                continue;
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b" + paraType.getName());
        }
        return parametersTypes;
    }

    private static Object convert(Object val, int dataType) {
        Object result = null;
        if (dataType == 1002) {
            result = TypeConvertor.toString((Object)val);
        } else if (dataType == 1005) {
            result = TypeConvertor.toBigDecimal((Object)val);
        } else if (dataType == 1010) {
            result = TypeConvertor.toLong((Object)val);
        } else if (dataType == 1001) {
            result = TypeConvertor.toInteger((Object)val);
        } else if (dataType == 1009) {
            result = TypeConvertor.toBoolean((Object)val);
        } else if (dataType == 1101) {
            result = VarUtil.toTimestamp(val);
        } else if (dataType == 1003) {
            result = TypeConvertor.toDate((Object)val);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b" + dataType);
        }
        return result;
    }
}

