/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.parameterizedsql;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.parameterizedsql.SqlStringUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SqlEncryptUtil {
    private static final String KEY_ALGORITHM = "DESede";
    private static final String DEFAULT_CIPHER_ALGORITHM = "DESede/ECB/PKCS5Padding";
    private static final String SECRET_KEY = "26395a57-67ad-47e1-9aa3-ff538b42ec1c";

    public static String getEncryptByDES(String content, String key) {
        try {
            if (StringUtil.isBlankOrNull((String)key)) {
                key = SECRET_KEY;
            }
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, SqlEncryptUtil.getSecretKey(key));
            byte[] result = cipher.doFinal(contentBytes);
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getDecryptByDES(String content, String key) {
        try {
            if (StringUtil.isBlankOrNull((String)key)) {
                key = SECRET_KEY;
            }
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, SqlEncryptUtil.getSecretKey(key));
            byte[] result = cipher.doFinal(Base64.decodeBase64((String)content));
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String key) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes("UTF-8"));
            keyGenerator.init(secureRandom);
            SecretKey secretKey = keyGenerator.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getEncryptByDESAddMD5(Object content) {
        StringBuilder sb = new StringBuilder();
        if (content == null) {
            return "";
        }
        String jsonContent = SqlStringUtil.toJsonString(content);
        String encryptData = SqlEncryptUtil.getEncryptByDES(jsonContent, SECRET_KEY);
        String md5Encode = SqlEncryptUtil.getMD5Encode(encryptData);
        sb.append("MARK(");
        sb.append(encryptData);
        sb.append(md5Encode);
        sb.append(")MARK");
        return sb.toString();
    }

    public static SqlString getDecryptByDESAddMD5(String content) {
        if (StringUtil.isBlankOrNull((String)content)) {
            return null;
        }
        SqlString encryptSQLByDFS = SqlEncryptUtil.getEncryptSQLByDFS(content, new SqlString());
        return encryptSQLByDFS;
    }

    private static SqlString getEncryptSQLByDFS(String content, SqlString result) {
        if (!content.contains("MARK(") && !content.contains(")MARK")) {
            return result;
        }
        String[] split = content.split("MARK\\(");
        int i = 0;
        while (i < split.length) {
            block9: {
                boolean flag;
                block10: {
                    block7: {
                        block8: {
                            boolean contains = split[i].contains(")MARK");
                            if (i % 2 != 0) break block7;
                            if (contains) break block8;
                            result.append(split[i]);
                            break block9;
                        }
                        flag = true;
                        break block10;
                    }
                    flag = true;
                }
                if (flag) {
                    String[] after = split[i].split("\\)MARK");
                    String encrypt = after[0];
                    String des3 = encrypt.substring(0, encrypt.length() - 32);
                    String md5Encrypt = encrypt.substring(encrypt.length() - 32);
                    String decryptByDESJson = SqlEncryptUtil.getDecryptByDES(des3, SECRET_KEY);
                    SqlString decryptByDES = SqlStringUtil.fromJson(decryptByDESJson);
                    result = result.append(decryptByDES);
                    result.isFinalResult = decryptByDES.isFinalResult;
                    if (!Objects.equals(SqlEncryptUtil.getMD5Encode(SqlEncryptUtil.getEncryptByDES(decryptByDESJson, SECRET_KEY)), md5Encrypt)) {
                        throw new RuntimeException("SQL\u8bed\u53e5\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    assert (decryptByDESJson != null);
                    if (decryptByDESJson.contains("MARK(") && decryptByDESJson.contains(")MARK")) {
                        SqlString encryptSQLByDFS = SqlEncryptUtil.getEncryptSQLByDFS(decryptByDESJson, result);
                        result = result.append(after.length > 1 ? encryptSQLByDFS : "");
                    } else {
                        result = result.append(after.length > 1 ? after[1] : "");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static String getMD5Encode(String inStr) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            return "";
        }
        byte[] byteArray = inStr.getBytes(StandardCharsets.UTF_8);
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuilder hexValue = new StringBuilder();
        byte[] byArray = md5Bytes;
        int n = md5Bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte md5Byte = byArray[n2];
            int val = md5Byte & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
            ++n2;
        }
        return hexValue.toString();
    }
}

