/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.service.convert.finals;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingGroupField;
import com.bokesoft.yes.mid.mysqls.route.meta.type.EGroupFieldType;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.IFinalConditionContext;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map.IGroupValueMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import net.boke.jsqlparser.expression.AllComparisonExpression;
import net.boke.jsqlparser.expression.AnyComparisonExpression;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.boke.jsqlparser.expression.operators.arithmetic.Concat;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExistsExpression;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.Matches;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MultiInExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.SubSelect;

public class FinalConditionConvertor
implements ExpressionVisitor {
    private IFinalConditionContext context = null;
    private final Stack<Expression> stackValues = new Stack();

    public FinalConditionConvertor(IFinalConditionContext context) {
        this.context = context;
    }

    public Expression calcExpression(Expression expression) {
        if (expression == null) {
            return null;
        }
        expression.accept(this);
        return this.stackValues.pop();
    }

    @Override
    public void visit(NullValue nullValue) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + nullValue);
    }

    @Override
    public void visit(Function function) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + function);
    }

    @Override
    public void visit(InverseExpression inverseExpression) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + jdbcParameter);
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + doubleValue);
    }

    @Override
    public void visit(LongValue longValue) {
        this.stackValues.push(longValue);
    }

    @Override
    public void visit(DateValue dateValue) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + dateValue);
    }

    @Override
    public void visit(TimeValue timeValue) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + timeValue);
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + timestampValue);
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        Expression result = this.calcExpression(parenthesis.getExpression());
        Parenthesis newParenthesis = null;
        if (result != null) {
            newParenthesis = new Parenthesis();
            if (parenthesis.isNot()) {
                throw new RuntimeException("\u5206\u5e93\u7ef4\u5ea6\u5b57\u6bb5\u4e0d\u652f\u6301\u7528\u4e8eNot\u6761\u4ef6\u8bed\u53e5:" + parenthesis.toString());
            }
            newParenthesis.setExpression(result);
        }
        this.stackValues.push(newParenthesis);
    }

    @Override
    public void visit(StringValue stringValue) {
        this.stackValues.push(stringValue);
    }

    @Override
    public void visit(Addition addition) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + addition);
    }

    @Override
    public void visit(Subtraction subtraction) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + subtraction);
    }

    @Override
    public void visit(Multiplication multiplication) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + multiplication);
    }

    @Override
    public void visit(Division division) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + division);
    }

    @Override
    public void visit(Modulo modulo) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + modulo);
    }

    @Override
    public void visit(AndExpression andExpression) {
        Expression result1 = this.calcExpression(andExpression.getLeftExpression());
        Expression result2 = this.calcExpression(andExpression.getRightExpression());
        Expression newExpression = null;
        if (result1 != null && result2 != null) {
            newExpression = new AndExpression(result1, result2);
        } else if (result1 != null) {
            newExpression = result1;
        } else if (result2 != null) {
            newExpression = result2;
        }
        this.stackValues.push(newExpression);
    }

    @Override
    public void visit(OrExpression orExpression) {
        Expression result1 = this.calcExpression(orExpression.getLeftExpression());
        Expression result2 = this.calcExpression(orExpression.getRightExpression());
        Expression newExpression = null;
        if (result1 != null && result2 != null) {
            newExpression = new OrExpression(result1, result2);
        } else if (result1 != null) {
            newExpression = result1;
        } else if (result2 != null) {
            newExpression = result2;
        }
        this.stackValues.push(newExpression);
    }

    @Override
    public void visit(Between between) {
        try {
            Expression left = this.calcExpression(between.getLeftExpression());
            if (left instanceof Column) {
                if (this.isFinalColumn((Column)left)) {
                    this.stackValues.push(between);
                    return;
                }
                Expression start = this.calcExpression(between.getBetweenExpressionStart());
                Expression finalStart = this.mapGroupValue2Final(start, (Column)left);
                Expression end = this.calcExpression(between.getBetweenExpressionEnd());
                Expression finalEnd = this.mapGroupValue2Final(end, (Column)left);
                Between newBetween = new Between();
                Column finalColumn = this.mapGroupColumn2Final((Column)left);
                newBetween.setLeftExpression(finalColumn);
                newBetween.setBetweenExpressionStart(finalStart);
                newBetween.setBetweenExpressionEnd(finalEnd);
                if (between.isNot()) {
                    throw new RuntimeException("\u5206\u5e93\u7ef4\u5ea6\u5b57\u6bb5\u4e0d\u652f\u6301\u7528\u4e8eNot\u6761\u4ef6\u8bed\u53e5:" + between.toString());
                }
                this.stackValues.push(newBetween);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visit(InExpression inExpression) {
        try {
            InExpression newInExpression;
            Expression left = this.calcExpression(inExpression.getLeftExpression());
            if (left instanceof Column) {
                if (this.isFinalColumn((Column)left)) {
                    this.stackValues.push(inExpression);
                    return;
                }
                newInExpression = new InExpression();
                Column finalColumn = this.mapGroupColumn2Final((Column)left);
                newInExpression.setLeftExpression(finalColumn);
                ExpressionList newValueList = this.calcExpressionListResults((ExpressionList)inExpression.getItemsList(), (Column)left);
                newInExpression.setItemsList(newValueList);
                if (inExpression.isNot()) {
                    throw new RuntimeException("\u5206\u5e93\u7ef4\u5ea6\u5b57\u6bb5\u4e0d\u652f\u6301\u7528\u4e8eNot\u6761\u4ef6\u8bed\u53e5:" + inExpression.toString());
                }
            } else {
                throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u5217\u8f6c\u5316\u5f02\u5e38:" + inExpression.toString());
            }
            this.stackValues.push(newInExpression);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        BinaryExpression result = this.calcBinaryExpressionResult(equalsTo, bNeedAddEqual -> new EqualsTo());
        this.stackValues.push(result);
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        BinaryExpression result = this.calcBinaryExpressionResult(greaterThan, bNeedAddEqual -> bNeedAddEqual ? new GreaterThanEquals() : new GreaterThan());
        this.stackValues.push(result);
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        BinaryExpression result = this.calcBinaryExpressionResult(greaterThanEquals, bNeedAddEqual -> new GreaterThanEquals());
        this.stackValues.push(result);
    }

    @Override
    public void visit(MinorThan minorThan) {
        BinaryExpression result = this.calcBinaryExpressionResult(minorThan, bNeedAddEqual -> bNeedAddEqual ? new MinorThanEquals() : new MinorThan());
        this.stackValues.push(result);
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        BinaryExpression result = this.calcBinaryExpressionResult(minorThanEquals, bNeedAddEqual -> new MinorThanEquals());
        this.stackValues.push(result);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        BinaryExpression result = this.calcBinaryExpressionResult(notEqualsTo, bNeedAddEqual -> new NotEqualsTo());
        this.stackValues.push(result);
    }

    @Override
    public void visit(Column column) {
        this.stackValues.push(column);
    }

    @Override
    public void visit(MultiInExpression inExpression) {
        throw new RuntimeException("Unsupport Expression:" + inExpression.toString());
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + isNullExpression);
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + likeExpression);
    }

    @Override
    public void visit(SubSelect subSelect) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + subSelect);
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + caseExpression);
    }

    @Override
    public void visit(WhenClause whenClause) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + whenClause);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + existsExpression);
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + allComparisonExpression);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + anyComparisonExpression);
    }

    @Override
    public void visit(Concat concat) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + concat);
    }

    @Override
    public void visit(Matches matches) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + matches);
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + bitwiseAnd);
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + bitwiseOr);
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        throw new RuntimeException("\u5206\u5e93\u7ec8\u503c\u8f6c\u6362\u672a\u652f\u6301\u7684\u7c7b\u578b:" + bitwiseXor);
    }

    private ExpressionList calcExpressionListResults(ExpressionList expList, Column groupColumn) throws Throwable {
        HashSet<String> repeatFilterSet = new HashSet<String>();
        ArrayList<Expression> newExpressions = new ArrayList<Expression>();
        for (Object obj : expList.getExpressions()) {
            Expression value = this.calcExpression((Expression)obj);
            Expression finalValue = this.mapGroupValue2Final(value, groupColumn);
            if (!repeatFilterSet.add(finalValue.toString())) continue;
            newExpressions.add(finalValue);
        }
        return new ExpressionList(newExpressions);
    }

    private BinaryExpression calcBinaryExpressionResult(BinaryExpression orgExpression, IBinaryExpressionCreator creator) {
        try {
            Expression result1 = this.calcExpression(orgExpression.getLeftExpression());
            Expression result2 = this.calcExpression(orgExpression.getRightExpression());
            BinaryExpression newExpression = null;
            if (result1 instanceof Column) {
                if (this.isFinalColumn((Column)result1)) {
                    return orgExpression;
                }
                String groupColumnName = ((Column)result1).getColumnName();
                MetaShardingGroupField groupField = this.context.getGroupField(groupColumnName);
                newExpression = creator.newBinaryExpression(this.isNeedAddEqual(groupField.getGroupType()));
                Column finalColumn = this.mapGroupColumn2Final((Column)result1);
                newExpression.setLeftExpression(finalColumn);
                Expression finalValue = this.mapGroupValue2Final(result2, (Column)result1);
                newExpression.setRightExpression(finalValue);
            } else if (result2 instanceof Column) {
                if (this.isFinalColumn((Column)result2)) {
                    return orgExpression;
                }
                String groupColumnName = ((Column)result2).getColumnName();
                MetaShardingGroupField groupField = this.context.getGroupField(groupColumnName);
                newExpression = creator.newBinaryExpression(this.isNeedAddEqual(groupField.getGroupType()));
                Column finalColumn = this.mapGroupColumn2Final((Column)result2);
                newExpression.setRightExpression(finalColumn);
                Expression finalValue = this.mapGroupValue2Final(result1, (Column)result2);
                newExpression.setLeftExpression(finalValue);
            } else {
                return orgExpression;
            }
            return newExpression;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFinalColumn(Column column) throws Throwable {
        String groupColumnName = column.getColumnName();
        return this.context.isFinalColumn(groupColumnName);
    }

    private Column mapGroupColumn2Final(Column groupColumn) throws Throwable {
        String groupColumnName = groupColumn.getColumnName();
        MetaShardingGroupField groupField = this.context.getGroupField(groupColumnName);
        return new Column(null, groupField.getFinalFieldKey());
    }

    private Expression mapGroupValue2Final(Expression groupValue, Column groupColumn) throws Throwable {
        String groupColumnName = groupColumn.getColumnName();
        MetaShardingGroupField groupField = this.context.getGroupField(groupColumnName);
        IGroupValueMap groupValueMap = this.context.getGroupValueMap(groupColumnName);
        if (groupValueMap == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u7ec8\u503c\u5173\u7cfb\u6620\u5c04\uff1a" + groupColumnName);
        }
        Object parsedValue = this.parseValue(groupValue);
        if (parsedValue == null) {
            return null;
        }
        Object finalValue = groupValueMap.getFinalValue(parsedValue);
        if (finalValue == null || StringUtil.isBlankOrNull((String)groupField.getFinalFieldKey())) {
            return null;
        }
        return new LongValue(finalValue.toString());
    }

    private Object parseValue(Expression value) {
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof LongValue) {
            return ((LongValue)value).getValue();
        }
        return null;
    }

    private boolean isNeedAddEqual(EGroupFieldType type) {
        return type == EGroupFieldType.DATE || type == EGroupFieldType.PERIOD;
    }

    private static interface IBinaryExpressionCreator {
        public BinaryExpression newBinaryExpression(boolean var1);
    }
}

