/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.erp.mid.util.NotImplemented;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.util.VarUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UnionResultSetMetaData
implements ResultSetMetaData {
    List<String> columnNames = new ArrayList<String>();
    List<String> columnLabels = new ArrayList<String>();
    List<Integer> columnDisplaySizes = new ArrayList<Integer>();
    List<Integer> columnTypes = new ArrayList<Integer>();
    List<Integer> columnScales = new ArrayList<Integer>();
    private HashMap<ResultSetGetObjectByPos, ColumnLabelIndexMap> diffColumnIndexMaps = new HashMap();
    public static final int INT_UnknownScale = -1;

    public UnionResultSetMetaData(List<ResultSetGetObjectByPos> allResultSet) throws SQLException {
        this.init(allResultSet);
    }

    private void init(List<ResultSetGetObjectByPos> allResultSet) throws SQLException {
        ResultSetMetaData metaData = allResultSet.get(0).getMetaData();
        int columnCount = metaData.getColumnCount() - allResultSet.get(0).getHiddenColumnCount();
        int i = 1;
        while (i < allResultSet.size()) {
            ResultSetGetObjectByPos tempResultSet = allResultSet.get(i);
            if (Performance.RUN_IN_DEBUG && tempResultSet.getMetaData().getColumnCount() - tempResultSet.getHiddenColumnCount() > columnCount) {
                throw new RuntimeException("union \u67e5\u8be2\u5217\u6570\u91cf\u4e0d\u4e00\u81f4");
            }
            this.calcDiffColumnIndex(allResultSet.get(0), tempResultSet);
            ++i;
        }
        i = 1;
        while (i <= columnCount) {
            this.columnNames.add(metaData.getColumnName(i));
            this.columnLabels.add(metaData.getColumnLabel(i));
            int columnType = metaData.getColumnType(i);
            int columnDisplaySize = metaData.getColumnDisplaySize(i);
            int j = 1;
            while (j < allResultSet.size()) {
                int realColumnIndex = this.getRealColumnIndex((ResultSet)allResultSet.get(j), i);
                if (realColumnIndex != -1) {
                    int tempColumnDisplaySize;
                    ResultSetMetaData tempMetaData = allResultSet.get(j).getMetaData();
                    int tempColumnType = tempMetaData.getColumnType(realColumnIndex);
                    if (columnType == 4 && tempColumnType == -5) {
                        columnType = -5;
                    }
                    if ((tempColumnDisplaySize = tempMetaData.getColumnDisplaySize(realColumnIndex)) >= columnDisplaySize) {
                        columnDisplaySize = tempColumnDisplaySize;
                    }
                }
                ++j;
            }
            this.columnTypes.add(columnType);
            this.columnDisplaySizes.add(columnDisplaySize);
            this.columnScales.add(metaData.getScale(i));
            ++i;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columnDisplaySizes.get(column - 1);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnLabels.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.columnTypes.get(column - 1);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.columnScales.get(column - 1);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new NotImplemented();
    }

    public int getRealColumnIndex(ResultSet rs, int columnIndex) throws SQLException {
        String matchColumnLabel = this.getColumnLabel(columnIndex);
        int indexInDiff = this.getRealColumnIndex(rs, matchColumnLabel);
        if (indexInDiff == -1) {
            return columnIndex <= rs.getMetaData().getColumnCount() ? columnIndex : -1;
        }
        return indexInDiff;
    }

    private int getRealColumnIndex(ResultSet rs, String columnLabel) throws SQLException {
        ColumnLabelIndexMap indexMap = this.diffColumnIndexMaps.get(rs);
        if (indexMap == null) {
            return -1;
        }
        return indexMap.getIndex(columnLabel);
    }

    private void calcDiffColumnIndex(ResultSetGetObjectByPos rs0, ResultSetGetObjectByPos checkRs) throws SQLException {
        if (checkRs == null) {
            return;
        }
        ResultSetMetaData metaData0 = rs0.getMetaData();
        ResultSetMetaData checkMetaData = checkRs.getMetaData();
        if (metaData0.getColumnCount() < checkMetaData.getColumnCount()) {
            throw new SQLException("union resultset columns count is not matched!");
        }
        String checkColumnLabel = null;
        int index = 1;
        while (index <= metaData0.getColumnCount()) {
            if (index > checkMetaData.getColumnCount()) break;
            checkColumnLabel = checkMetaData.getColumnLabel(index);
            if (!VarUtil.isSameStringIgnoreCase(metaData0.getColumnLabel(index), checkColumnLabel)) {
                this.ensureColumnNameIndexMap(checkRs).put(checkColumnLabel, index);
            }
            ++index;
        }
    }

    private ColumnLabelIndexMap ensureColumnNameIndexMap(ResultSetGetObjectByPos rs) {
        ColumnLabelIndexMap indexMap = this.diffColumnIndexMaps.get(rs);
        if (indexMap == null) {
            indexMap = new ColumnLabelIndexMap();
            this.diffColumnIndexMaps.put(rs, indexMap);
        }
        return indexMap;
    }

    class ColumnLabelIndexMap {
        private HashMap<String, Integer> map = null;

        ColumnLabelIndexMap() {
        }

        public void put(String columnLabel, int columnIndex) {
            this.ensureMap().put(columnLabel, columnIndex);
        }

        public int getIndex(String columnLabel) {
            if (!this.hasColumnName(columnLabel)) {
                return -1;
            }
            return this.map.get(columnLabel);
        }

        public boolean hasColumnName(String columnLabel) {
            if (this.map == null) {
                return false;
            }
            return this.map.containsKey(columnLabel);
        }

        private HashMap<String, Integer> ensureMap() {
            if (this.map == null) {
                this.map = new HashMap();
            }
            return this.map;
        }
    }
}

