/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.alibaba.druid.pool.DruidPooledResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSet;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import dm.jdbc.driver.DmdbResultSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.dbcp.DelegatingResultSet;

public class ResultSetUtil {
    public static boolean containsColumn(ResultSet rs, String columnName) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int i = 1;
        int size = metaData.getColumnCount();
        while (i < size) {
            if (metaData.getColumnLabel(i).equalsIgnoreCase(columnName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int getRowCount(ResultSet rs) throws SQLException {
        if (rs instanceof ResultSetImpl || rs instanceof DelegatingResultSet || rs instanceof DruidPooledResultSet || rs instanceof DmdbResultSet) {
            int count = 0;
            try {
                rs.last();
                count = rs.getRow();
                rs.beforeFirst();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return count;
        }
        if (rs instanceof UnionResultSet) {
            return ((UnionResultSet)rs).getRowCount();
        }
        if (rs instanceof JoinResultSet) {
            return ((JoinResultSet)rs).getRowCount();
        }
        if (rs instanceof DataTableResultSet) {
            return ((DataTableResultSet)rs).getDataTable().size();
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684ResultSet\u7c7b\u578b\uff0c" + rs.getClass().getName());
    }

    public static List<Object> getValues(ResultSet rs, String columnName) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        rs.beforeFirst();
        while (rs.next()) {
            Object value = rs.getObject(columnName);
            if (result.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    public static List<Integer> sort(final ResultSet rs, final String[] columnNames) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int p = 1;
        int len = ResultSetUtil.getRowCount(rs);
        while (p <= len) {
            result.add(p);
            ++p;
        }
        final int count = columnNames.length;
        result.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                try {
                    int compare = 0;
                    int i = 0;
                    while (i < count) {
                        String columnName = columnNames[i];
                        rs.absolute(o1);
                        Object value1 = rs.getObject(columnName);
                        rs.absolute(o2);
                        Object value2 = rs.getObject(columnName);
                        compare = ResultSetUtil.compare(value1, value2);
                        if (compare != 0) {
                            return compare;
                        }
                        ++i;
                    }
                    return compare;
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u5206\u5e93\u9519\u8bef\uff0c\u6392\u5e8f\u51fa\u9519\u3002", e);
                }
            }
        });
        return result;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            Object[] objArray1 = (Object[])o1;
            Object[] objArray2 = (Object[])o2;
            int result = 0;
            int i = 0;
            int len = objArray1.length;
            while (i < len) {
                result = ResultSetUtil.compare(objArray1[i], objArray2[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return result;
        }
        if (o1 instanceof Long && o2 instanceof Long) {
            return ((Long)o1).compareTo((Long)o2);
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return ((Integer)o1).compareTo((Integer)o2);
        }
        if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
            return ((BigDecimal)o1).compareTo((BigDecimal)o2);
        }
        if ((o1 instanceof String || o1 == null) && (o2 instanceof String || o2 == null)) {
            return TypeConvertor.toString((Object)o1).compareTo(TypeConvertor.toString((Object)o2));
        }
        throw new RuntimeException("\u5206\u5e93\u9519\u8bef\uff0c\u6bd4\u8f83\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\uff0c" + o1 + ":" + o1.getClass().getSimpleName() + "\uff0c" + o2 + ":" + o2.getClass().getSimpleName());
    }

    public static int getSameValueCount(ResultSet rs, List<Integer> sortedRowIDs, int sortIndex, String[] columnNames) throws SQLException {
        rs.absolute(sortedRowIDs.get(sortIndex));
        Object[] value = ResultSetUtil.getObjects(rs, columnNames);
        int result = 1;
        while (sortIndex < sortedRowIDs.size() - 1) {
            rs.absolute(sortedRowIDs.get(++sortIndex));
            Object[] value1 = ResultSetUtil.getObjects(rs, columnNames);
            if (ResultSetUtil.compare(value, value1) != 0) break;
            ++result;
        }
        return result;
    }

    public static Object[] getObjects(ResultSet rs, String[] columnNames) throws SQLException {
        int count = columnNames.length;
        Object[] result = new Object[count];
        int i = 0;
        while (i < count) {
            result[i] = rs.getObject(columnNames[i]);
            ++i;
        }
        return result;
    }

    public static int getJdbcType(ResultSet rightResultSet, String columnName) throws SQLException {
        ResultSetMetaData metaData = rightResultSet.getMetaData();
        int i = 0;
        while (i < metaData.getColumnCount()) {
            String tempColumnName = metaData.getColumnLabel(i + 1);
            if (tempColumnName.equalsIgnoreCase(columnName)) {
                return metaData.getColumnType(i + 1);
            }
            ++i;
        }
        return -1;
    }
}

