/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.erp.mid.util.NotImplemented;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.execute.QueryPlan;
import com.bokesoft.yes.mid.mysqls.processselect.RelationBetweenSubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuerys;
import com.bokesoft.yes.mid.mysqls.result.util.TypeUtils;
import com.bokesoft.yes.mid.mysqls.resultset.CalcUtil;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.EmptyResultSetMetaData;
import com.bokesoft.yes.mid.mysqls.resultset.GroupValue;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetUtil;
import com.bokesoft.yes.mid.mysqls.resultset.RsIndexColumnIndex;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import org.apache.commons.lang3.ArrayUtils;

public class JoinResultSet
implements ResultSetGetObjectByPos {
    final SelectSqlInfo select;
    private ResultSetGetObjectByPos[] srcRses;
    private int pos;
    private List<int[]> posList = null;
    HashMapIgnoreCase<RsIndexColumnIndex> columnNameToRsIndex = null;
    List<RsIndexColumnIndex> columnIndexToRsIndex = null;
    private ResultSetMetaData resultSetMetaData = null;
    private int hiddenColumnCount = 0;

    public JoinResultSet(SelectSqlInfo select, QueryPlan queryPlan, Map<SubQuery, ResultSetGetObjectByPos> datas, List<Parameters> parametersList) throws SQLException {
        int joinCount;
        this.select = select;
        List<SubQuery> subQuerys = queryPlan.getQuerys().getSubQuerys();
        int rsCount = joinCount = subQuerys.size();
        SubQuerys subSelects = queryPlan.getQuerys();
        List<SelectExpressionItem> calcItemsbeforeGroup = subSelects.getCalcItemsBeforeGroup();
        List<SelectExpressionItem> calcItems = subSelects.getCalcItems();
        if (calcItems != null || calcItemsbeforeGroup != null) {
            ++rsCount;
        }
        this.srcRses = new ResultSetGetObjectByPos[rsCount];
        int i = 0;
        while (i < joinCount) {
            this.srcRses[i] = datas.get(subQuerys.get(i));
            ++i;
        }
        this.posList = new ArrayList<int[]>();
        int p = 1;
        int len = ResultSetUtil.getRowCount(this.srcRses[0]);
        while (p <= len) {
            int[] row = new int[rsCount];
            row[0] = p++;
            this.posList.add(row);
        }
        List<RelationBetweenSubQuery> allRelations = queryPlan.getQuerys().getRelations();
        int i2 = 1;
        while (i2 < joinCount) {
            SubQuery curSubQuery = subQuerys.get(i2);
            if (queryPlan.isShowInResult(curSubQuery) && !curSubQuery.isInSelect()) {
                ArrayList<RelationBetweenSubQuery> relations = new ArrayList<RelationBetweenSubQuery>();
                int[] leftRsIndex = this.getLeftRsIndexes(subQuerys, curSubQuery, allRelations, relations);
                if (relations.size() == 0) {
                    if (i2 == 1 && subQuerys.get(0).isSelect0() && ResultSetUtil.getRowCount(this.srcRses[1]) == 0) {
                        this.posList.remove(0);
                    } else {
                        this.fullJoin(i2);
                    }
                } else {
                    RelationBetweenSubQuery relation = (RelationBetweenSubQuery)relations.get(0);
                    String[] leftColumnNames = this.getLeftColumnNames(relations, curSubQuery);
                    List<Integer> leftSortedRowIDs = this.sort(leftRsIndex, leftColumnNames, this.posList, queryPlan, datas, curSubQuery.getLeftJoinCondition());
                    String[] rightColumnNames = this.getRightColumnNames(relations, curSubQuery);
                    ResultSetGetObjectByPos rightRs = this.srcRses[i2];
                    List<Integer> rightSortedRowIDs = ResultSetUtil.sort(rightRs, rightColumnNames);
                    int leftPos = 0;
                    int rightPos = 0;
                    ArrayList<Integer> deletedRows = new ArrayList<Integer>();
                    ArrayList<int[]> posAddList = new ArrayList<int[]>();
                    while (leftPos < leftSortedRowIDs.size()) {
                        int j;
                        if (rightPos >= rightSortedRowIDs.size()) {
                            if (relation != null && relation.isLeft()) break;
                            int j2 = leftPos;
                            while (j2 < leftSortedRowIDs.size()) {
                                deletedRows.add(leftSortedRowIDs.get(j2));
                                ++j2;
                            }
                            break;
                        }
                        Object[] leftValue = this.getObjects(leftSortedRowIDs.get(leftPos), leftRsIndex, leftColumnNames, this.posList);
                        int leftSameValueCount = this.getSameValueCount(leftSortedRowIDs, leftPos, leftRsIndex, leftColumnNames, this.posList);
                        rightRs.absolute(rightSortedRowIDs.get(rightPos));
                        Object[] rightValue = ResultSetUtil.getObjects(rightRs, rightColumnNames);
                        int rightSameValueCount = ResultSetUtil.getSameValueCount(rightRs, rightSortedRowIDs, rightPos, rightColumnNames);
                        int compare = ResultSetUtil.compare(leftValue, rightValue);
                        if (compare == 0) {
                            if (leftSameValueCount > 1 && rightSameValueCount > 1) {
                                int leftIndex = 0;
                                while (leftIndex < leftSameValueCount) {
                                    this.posList.get((int)leftSortedRowIDs.get((int)(leftPos + leftIndex)).intValue())[i2] = rightSortedRowIDs.get(rightPos);
                                    int j3 = 1;
                                    while (j3 < rightSameValueCount) {
                                        int[] row = this.copyIntArray(this.posList.get(leftSortedRowIDs.get(leftPos + leftIndex)));
                                        row[i2] = rightSortedRowIDs.get(rightPos + j3);
                                        posAddList.add(row);
                                        ++j3;
                                    }
                                    ++leftIndex;
                                }
                            } else if (rightSameValueCount == 1) {
                                this.posList.get((int)leftSortedRowIDs.get((int)leftPos).intValue())[i2] = rightSortedRowIDs.get(rightPos);
                                j = 1;
                                while (j < leftSameValueCount) {
                                    this.posList.get((int)leftSortedRowIDs.get((int)(leftPos + j)).intValue())[i2] = rightSortedRowIDs.get(rightPos);
                                    ++j;
                                }
                            } else {
                                this.posList.get((int)leftSortedRowIDs.get((int)leftPos).intValue())[i2] = rightSortedRowIDs.get(rightPos);
                                j = 1;
                                while (j < rightSameValueCount) {
                                    int[] row = this.copyIntArray(this.posList.get(leftSortedRowIDs.get(leftPos)));
                                    row[i2] = rightSortedRowIDs.get(rightPos + j);
                                    posAddList.add(row);
                                    ++j;
                                }
                            }
                            leftPos += leftSameValueCount;
                            rightPos += rightSameValueCount;
                            continue;
                        }
                        if (compare < 0) {
                            if (relation == null || !relation.isLeft()) {
                                j = leftPos;
                                while (j < leftPos + leftSameValueCount) {
                                    deletedRows.add(leftSortedRowIDs.get(j));
                                    ++j;
                                }
                            }
                            leftPos += leftSameValueCount;
                            continue;
                        }
                        if (compare <= 0) continue;
                        rightPos += rightSameValueCount;
                    }
                    if (deletedRows.size() > 0) {
                        this.deleteRows(deletedRows);
                    }
                    if (posAddList.size() > 0) {
                        this.addRows(posAddList);
                    }
                }
            }
            ++i2;
        }
        if (this.posList.size() == 0 && select.getFunctions() != null && (select.getGroupColumns() == null || select.getGroupColumns().size() == 0)) {
            this.addEmptyRow(queryPlan, datas);
        }
        this.posList.sort(new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                int i = 0;
                while (i < o1.length) {
                    if (o1[i] != o2[i]) {
                        return o1[i] - o2[i];
                    }
                    ++i;
                }
                return 0;
            }
        });
        this.processInValueDistinct(queryPlan, datas);
        this.createCalcItemData(queryPlan);
        this.pos = 0;
        this.select.getFields(parametersList);
        this.initColumnIndex(queryPlan, datas);
    }

    private void processInValueDistinct(QueryPlan queryPlan, Map<SubQuery, ResultSetGetObjectByPos> datas) throws SQLException {
        List<SubQuery> subQuerys = queryPlan.getQuerys().getSubQuerys();
        int posListIndex = 0;
        int subQuerySize = subQuerys.size();
        while (posListIndex < subQuerySize) {
            SubQuery subQuery = subQuerys.get(posListIndex);
            if (subQuery.inValuesForSubQuery != null) {
                ArrayList<String> distinctFields = new ArrayList<String>();
                for (RelationBetweenSubQuery relation : queryPlan.getQuerys().getRelations()) {
                    if (relation.getLeftSubQuery() == subQuery && relation.getRightSubQuery() == subQuery.inValuesForSubQuery) {
                        distinctFields.add(relation.getLeftColumn().getColumnName());
                        continue;
                    }
                    if (relation.getRightSubQuery() != subQuery || relation.getLeftSubQuery() != subQuery.inValuesForSubQuery) continue;
                    distinctFields.add(relation.getRightColumn().getColumnName());
                }
                ResultSetGetObjectByPos data = datas.get(subQuery);
                int distinctFieldSize = distinctFields.size();
                int[] distinctColumnIndexes = new int[distinctFieldSize];
                int i = 0;
                while (i < distinctFieldSize) {
                    distinctColumnIndexes[i] = data.findColumn((String)distinctFields.get(i));
                    ++i;
                }
                HashMap<GroupValue, Integer> rows = new HashMap<GroupValue, Integer>();
                ArrayList<Integer> deletedRows = new ArrayList<Integer>();
                int rowIndex = 1;
                int rowCount = ResultSetUtil.getRowCount(data);
                while (rowIndex <= rowCount) {
                    int posListSize;
                    int posListRowIndex;
                    GroupValue groupValue = new GroupValue(distinctFieldSize);
                    int i2 = 0;
                    while (i2 < distinctFieldSize) {
                        groupValue.setValue(i2, data.getObject(rowIndex, distinctColumnIndexes[i2]));
                        ++i2;
                    }
                    if (rows.containsKey(groupValue)) {
                        posListRowIndex = 0;
                        posListSize = this.posList.size();
                        while (posListRowIndex < posListSize) {
                            if (this.posList.get(posListRowIndex)[posListIndex] == rowIndex) {
                                deletedRows.add(posListRowIndex);
                            }
                            ++posListRowIndex;
                        }
                    } else {
                        posListRowIndex = 0;
                        posListSize = this.posList.size();
                        while (posListRowIndex < posListSize) {
                            if (this.posList.get(posListRowIndex)[posListIndex] == rowIndex) {
                                rows.put(groupValue, rowIndex);
                                break;
                            }
                            ++posListRowIndex;
                        }
                    }
                    ++rowIndex;
                }
                if (deletedRows.size() > 0) {
                    this.deleteRows(deletedRows);
                }
            }
            ++posListIndex;
        }
    }

    private void addEmptyRow(QueryPlan queryPlan, Map<SubQuery, ResultSetGetObjectByPos> datas) throws SQLException {
        int[] row = new int[this.srcRses.length];
        int size = queryPlan.getQuerys().getSubQuerys().size();
        int i = 0;
        while (i < size) {
            int insertRow;
            DataTableResultSet rs = DataTableResultSet.wrap(this.srcRses[i]);
            this.srcRses[i] = rs;
            SubQuery subQuery = queryPlan.getQuerys().getSubQuerys().get(i);
            datas.put(subQuery, rs);
            row[i] = insertRow = rs.getDataTable().insert() + 1;
            ++i;
        }
        this.posList.add(row);
        i = 0;
        while (i < size) {
            SubQuery subQuery = queryPlan.getQuerys().getSubQuerys().get(i);
            List selectItems = subQuery.getPlainSelect().getSelectItems();
            DataTableResultSet rs = (DataTableResultSet)datas.get(subQuery);
            int insertRow = rs.getDataTable().getPos();
            int size2 = Math.min(rs.getDataTable().getMetaData().getColumnCount(), selectItems.size());
            int j = 0;
            while (j < size2) {
                Expression exp = ((SelectExpressionItem)selectItems.get(j)).getExpression();
                rs.getDataTable().setObject(insertRow, j, this.calcExpression(0, queryPlan, datas, exp));
                ++j;
            }
            ++i;
        }
    }

    private void fullJoin(int rsIndex) throws SQLException {
        int leftCount = this.posList.size();
        ResultSetGetObjectByPos rightRs = this.srcRses[rsIndex];
        int rightCount = ResultSetUtil.getRowCount(rightRs);
        if (rightCount == 0) {
            return;
        }
        int leftPos = 0;
        while (leftPos < leftCount) {
            this.posList.get((int)leftPos)[rsIndex] = 1;
            int rightPos = 2;
            while (rightPos <= rightCount) {
                int[] row = this.copyIntArray(this.posList.get(leftPos));
                row[rsIndex] = rightPos++;
                this.posList.add(row);
            }
            ++leftPos;
        }
    }

    private int[] getLeftRsIndexes(List<SubQuery> subQuerys, SubQuery subQuery, List<RelationBetweenSubQuery> allRelations, List<RelationBetweenSubQuery> relations) {
        ArrayList<Integer> leftList = new ArrayList<Integer>();
        if (allRelations != null) {
            int rightIndex = subQuerys.indexOf(subQuery);
            int i = 0;
            while (i < allRelations.size()) {
                SubQuery rightSubQuery;
                int leftIndex;
                RelationBetweenSubQuery relation = allRelations.get(i);
                if (subQuery == relation.getRightSubQuery()) {
                    SubQuery leftSubQuery = relation.getLeftSubQuery();
                    if (!leftSubQuery.isInSelect() && (leftIndex = subQuerys.indexOf(leftSubQuery)) < rightIndex) {
                        leftList.add(leftIndex);
                        relations.add(relation);
                    }
                } else if (subQuery == relation.getLeftSubQuery() && !(rightSubQuery = relation.getRightSubQuery()).isInSelect() && (leftIndex = subQuerys.indexOf(rightSubQuery)) < rightIndex) {
                    leftList.add(leftIndex);
                    relations.add(relation);
                }
                ++i;
            }
        }
        int[] result = ArrayUtils.toPrimitive((Integer[])leftList.toArray(new Integer[leftList.size()]));
        return result;
    }

    private String[] getLeftColumnNames(List<RelationBetweenSubQuery> relations, SubQuery rightSubQuery) {
        ArrayList<String> colList = new ArrayList<String>();
        int i = 0;
        while (i < relations.size()) {
            RelationBetweenSubQuery relation = relations.get(i);
            boolean leftIsInRelationLeft = relation.getRightSubQuery() == rightSubQuery;
            SelectExpressionItem selectItem = leftIsInRelationLeft ? relation.getLeftSelectItem() : relation.getRightSelectItem();
            SubQuery subQuery = leftIsInRelationLeft ? relation.getLeftSubQuery() : relation.getRightSubQuery();
            HashMapIgnoreCase<String> fieldsChangeAlias = subQuery.getFieldsChangeAlias();
            Column column = leftIsInRelationLeft ? relation.getLeftColumn() : relation.getRightColumn();
            String columnName = fieldsChangeAlias != null && fieldsChangeAlias.containsKey(column.getWholeColumnName()) ? (String)fieldsChangeAlias.get(column.getWholeColumnName()) : selectItem.getColumnNameInResultSet();
            colList.add(columnName);
            ++i;
        }
        String[] result = new String[colList.size()];
        colList.toArray(result);
        return result;
    }

    private String[] getRightColumnNames(List<RelationBetweenSubQuery> relations, SubQuery rightSubQuery) {
        ArrayList<String> colList = new ArrayList<String>();
        int i = 0;
        while (i < relations.size()) {
            RelationBetweenSubQuery relation = relations.get(i);
            boolean leftIsInRelationLeft = relation.getRightSubQuery() == rightSubQuery;
            SelectExpressionItem selectItem = leftIsInRelationLeft ? relation.getRightSelectItem() : relation.getLeftSelectItem();
            SubQuery subQuery = leftIsInRelationLeft ? relation.getRightSubQuery() : relation.getLeftSubQuery();
            HashMapIgnoreCase<String> fieldsChangeAlias = subQuery.getFieldsChangeAlias();
            Column column = leftIsInRelationLeft ? relation.getRightColumn() : relation.getLeftColumn();
            String columnName = fieldsChangeAlias != null && fieldsChangeAlias.containsKey(column.getWholeColumnName()) ? (String)fieldsChangeAlias.get(column.getWholeColumnName()) : selectItem.getColumnNameInResultSet();
            colList.add(columnName);
            ++i;
        }
        String[] result = new String[colList.size()];
        colList.toArray(result);
        return result;
    }

    private List<Integer> sort(final int[] srcRsIndex, final String[] columnNames, final List<int[]> subLeftPosList, QueryPlan queryPlan, Map<SubQuery, ResultSetGetObjectByPos> datas, Expression leftJoinCondition) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int p = 0;
        int len = subLeftPosList.size();
        while (p < len) {
            if (leftJoinCondition == null || ((Boolean)this.calcExpression(p, queryPlan, datas, leftJoinCondition)).booleanValue()) {
                result.add(p);
            }
            ++p;
        }
        final int count = srcRsIndex.length;
        result.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                try {
                    int compare = 0;
                    int i = 0;
                    while (i < count) {
                        ResultSetGetObjectByPos rs = JoinResultSet.this.srcRses[srcRsIndex[i]];
                        if (ResultSetUtil.getRowCount(rs) > 0) {
                            Object value2;
                            String columnName = columnNames[i];
                            boolean hasRow = rs.absolute(((int[])subLeftPosList.get(o1))[srcRsIndex[i]]);
                            Object value1 = hasRow ? rs.getObject(columnName) : null;
                            compare = ResultSetUtil.compare(value1, value2 = (hasRow = rs.absolute(((int[])subLeftPosList.get(o2))[srcRsIndex[i]])) ? rs.getObject(columnName) : null);
                            if (compare != 0) {
                                return compare;
                            }
                        }
                        ++i;
                    }
                    return compare;
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u5206\u5e93\u9519\u8bef\uff0c\u6392\u5e8f\u51fa\u9519\u3002", e);
                }
            }
        });
        return result;
    }

    private Object[] getObjects(int posIndex, int[] srcRsIndex, String[] columnNames, List<int[]> posLeftList) throws SQLException {
        int count = srcRsIndex.length;
        Object[] result = new Object[count];
        int i = 0;
        while (i < count) {
            ResultSetGetObjectByPos rs = this.srcRses[srcRsIndex[i]];
            String columnName = columnNames[i];
            int pos = posLeftList.get(posIndex)[srcRsIndex[i]];
            if (pos > 0) {
                rs.absolute(pos);
                result[i] = rs.getObject(columnName);
            } else {
                result[i] = null;
            }
            ++i;
        }
        return result;
    }

    private int getSameValueCount(List<Integer> sortedRowIDs, int sortIndex, int[] srcRsIndex, String[] columnNames, List<int[]> posLeftList) throws SQLException {
        Object[] value = this.getObjects(sortedRowIDs.get(sortIndex), srcRsIndex, columnNames, posLeftList);
        int result = 1;
        while (sortIndex < sortedRowIDs.size() - 1) {
            Object[] value1;
            if (ResultSetUtil.compare(value, value1 = this.getObjects(sortedRowIDs.get(++sortIndex), srcRsIndex, columnNames, posLeftList)) != 0) continue;
            ++result;
        }
        return result;
    }

    private void deleteRows(List<Integer> rowIDs) {
        rowIDs.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });
        for (Integer rowID : rowIDs) {
            this.posList.remove(rowID);
        }
    }

    private void addRows(List<int[]> addPosList) {
        if (addPosList == null || addPosList.size() == 0) {
            return;
        }
        int i = 0;
        while (i < addPosList.size()) {
            this.posList.add(addPosList.get(i));
            ++i;
        }
    }

    private int[] copyIntArray(int[] intArray) {
        int count = intArray.length;
        int[] result = new int[count];
        int i = 0;
        while (i < count) {
            result[i] = intArray[i];
            ++i;
        }
        return result;
    }

    private void createCalcItemData(QueryPlan queryPlan) throws SQLException {
        SelectExpressionItem calcItem;
        SubQuerys subSelects = queryPlan.getQuerys();
        List<SelectExpressionItem> calcItemsbeforeGroup = subSelects.getCalcItemsBeforeGroup();
        List<SelectExpressionItem> calcItems = subSelects.getCalcItems();
        if (calcItems == null && calcItemsbeforeGroup == null) {
            return;
        }
        DataTable dt = new DataTable();
        int i = 0;
        int size = calcItemsbeforeGroup != null ? calcItemsbeforeGroup.size() : 0;
        while (i < size) {
            calcItem = calcItemsbeforeGroup.get(i);
            dt.addColumn(new ColumnInfo(calcItem.getAlias(), TypeUtils.getCalcItemDataType(calcItem.getExpression())));
            ++i;
        }
        i = 0;
        size = calcItems != null ? calcItems.size() : 0;
        while (i < size) {
            calcItem = calcItems.get(i);
            dt.addColumn(new ColumnInfo(calcItem.getAlias(), TypeUtils.getCalcItemDataType(calcItem.getExpression())));
            ++i;
        }
        int posIndex = 0;
        int len = this.posList.size();
        while (posIndex < len) {
            dt.append();
            this.posList.get((int)posIndex)[this.srcRses.length - 1] = dt.getPos() + 1;
            ++posIndex;
        }
        this.srcRses[this.srcRses.length - 1] = new DataTableResultSet(dt, null);
    }

    private Object calcExpression(int posIndex, QueryPlan queryPlan, Map<SubQuery, ResultSetGetObjectByPos> datas, Expression exp) throws SQLException {
        assert (exp != null);
        if (exp instanceof LongValue) {
            return TypeConvertor.toInteger((Object)((LongValue)exp).getValue());
        }
        if (exp instanceof DoubleValue) {
            return TypeConvertor.toBigDecimal((Object)exp.toString());
        }
        if (exp instanceof StringValue) {
            return ((StringValue)exp).getValue();
        }
        if (exp instanceof DateValue) {
            return TypeConvertor.toDate((Object)((DateValue)exp).getValue());
        }
        if (exp instanceof Column) {
            Column column = (Column)exp;
            SubQuerys subQuerys = queryPlan.getQuerys();
            SubQuery subQuery = subQuerys.getSubSelectByColumnCalc(column);
            if (subQuery == null) {
                return null;
            }
            ResultSet rs = datas.get(subQuery);
            if (ResultSetUtil.getRowCount(rs) == 0) {
                return null;
            }
            int rsIndex = ArrayUtils.indexOf((Object[])this.srcRses, (Object)rs);
            int rsPos = this.posList.get(posIndex)[rsIndex];
            if (rsPos < 1) {
                return null;
            }
            rs.absolute(rsPos);
            String rsColName = column.getColumnName();
            if (subQuery.getFieldsChangeAlias() != null && subQuery.getFieldsChangeAlias().containsKey(column.getWholeColumnName())) {
                rsColName = (String)subQuery.getFieldsChangeAlias().get(column.getWholeColumnName());
            }
            return rs.getObject(rsColName);
        }
        if (exp instanceof Parenthesis) {
            return this.calcExpression(posIndex, queryPlan, datas, ((Parenthesis)exp).getExpression());
        }
        if (exp instanceof BinaryExpression) {
            Object leftValue = this.calcExpression(posIndex, queryPlan, datas, ((BinaryExpression)exp).getLeftExpression());
            Object rightValue = this.calcExpression(posIndex, queryPlan, datas, ((BinaryExpression)exp).getRightExpression());
            if (exp instanceof Addition) {
                return CalcUtil.addition(leftValue, rightValue);
            }
            if (exp instanceof Subtraction) {
                return CalcUtil.subtraction(leftValue, rightValue);
            }
            if (exp instanceof Multiplication) {
                return CalcUtil.multiplication(leftValue, rightValue);
            }
            if (exp instanceof Division) {
                return CalcUtil.division(leftValue, rightValue);
            }
            if (exp instanceof Modulo) {
                return CalcUtil.modulo(leftValue, rightValue);
            }
            if (exp instanceof EqualsTo) {
                return CalcUtil.equalsTo(leftValue, rightValue);
            }
            if (exp instanceof NotEqualsTo) {
                return CalcUtil.notEqualsTo(leftValue, rightValue);
            }
            if (exp instanceof GreaterThan) {
                return CalcUtil.greaterThan(leftValue, rightValue);
            }
            if (exp instanceof GreaterThanEquals) {
                return CalcUtil.greaterThanEquals(leftValue, rightValue);
            }
            if (exp instanceof MinorThan) {
                return CalcUtil.minorThan(leftValue, rightValue);
            }
            if (exp instanceof MinorThanEquals) {
                return CalcUtil.minorThanEquals(leftValue, rightValue);
            }
            if (exp instanceof AndExpression) {
                if (TypeConvertor.toBoolean((Object)leftValue).booleanValue() && TypeConvertor.toBoolean((Object)rightValue).booleanValue()) {
                    return true;
                }
                return false;
            }
            if (exp instanceof OrExpression) {
                if (!TypeConvertor.toBoolean((Object)leftValue).booleanValue() && !TypeConvertor.toBoolean((Object)rightValue).booleanValue()) {
                    return false;
                }
                return true;
            }
        } else {
            if (exp instanceof CaseExpression) {
                List whenClauses = ((CaseExpression)exp).getWhenClauses();
                for (Object tmp : whenClauses) {
                    Object whenResult = this.calcExpression(posIndex, queryPlan, datas, (Expression)tmp);
                    if (whenResult == null) continue;
                    return whenResult;
                }
                return this.calcExpression(posIndex, queryPlan, datas, ((CaseExpression)exp).getElseExpression());
            }
            if (exp instanceof WhenClause) {
                Object when = this.calcExpression(posIndex, queryPlan, datas, ((WhenClause)exp).getWhenExpression());
                if (TypeConvertor.toBoolean((Object)when).booleanValue()) {
                    return this.calcExpression(posIndex, queryPlan, datas, ((WhenClause)exp).getThenExpression());
                }
                return null;
            }
            if (exp instanceof Function) {
                if (((Function)exp).getName().equalsIgnoreCase("count")) {
                    return 0;
                }
                List expList = ((Function)exp).getParameters().getExpressions();
                if (((Function)exp).getName().equalsIgnoreCase("CONCAT")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object para : expList) {
                        Object paraResult = this.calcExpression(posIndex, queryPlan, datas, (Expression)para);
                        stringBuilder.append(paraResult.toString());
                    }
                    return stringBuilder;
                }
                for (Object para : expList) {
                    Object paraResult = this.calcExpression(posIndex, queryPlan, datas, (Expression)para);
                    if (paraResult == null) continue;
                    return paraResult;
                }
                return null;
            }
            if (exp instanceof IsNullExpression) {
                Object isnull = this.calcExpression(posIndex, queryPlan, datas, ((IsNullExpression)exp).getLeftExpression());
                if (isnull == null) {
                    return true;
                }
                return false;
            }
            if (exp instanceof InExpression) {
                Object leftValue = this.calcExpression(posIndex, queryPlan, datas, ((InExpression)exp).getLeftExpression());
                ItemsList itemsList = ((InExpression)exp).getItemsList();
                if (itemsList instanceof ExpressionList) {
                    List values = ((ExpressionList)itemsList).getExpressions();
                    int i = 0;
                    while (i < values.size()) {
                        if (((Boolean)CalcUtil.equalsTo(leftValue, this.calcExpression(posIndex, queryPlan, datas, (Expression)values.get(i)))).booleanValue()) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
    }

    private void initColumnIndex(QueryPlan queryPlan, Map<SubQuery, ResultSetGetObjectByPos> datas) throws SQLException {
        this.columnNameToRsIndex = new HashMapIgnoreCase();
        this.columnIndexToRsIndex = new ArrayList<RsIndexColumnIndex>();
        this.columnIndexToRsIndex.add(null);
        int i = 0;
        int len = this.select.getColumnCount();
        while (i < len) {
            int rsIndex;
            String columnName = this.select.getColumnNameInResultSet(i);
            Table table = this.select.getColumnTable(i);
            if (table != null) {
                rsIndex = queryPlan.getQueryIndexByTable(table);
            } else {
                rsIndex = queryPlan.getQueryIndexByAliasName(columnName);
                if (rsIndex == -1) {
                    rsIndex = this.srcRses.length - 1;
                }
            }
            if (rsIndex == -1) {
                throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5b57\u6bb5" + (table != null ? String.valueOf(table.getName()) + "." : "") + columnName + "\u5b9a\u4f4d\u6570\u636e\u96c6\u9519\u8bef\u3002");
            }
            int columnIndex = this.srcRses[rsIndex].findColumn(columnName);
            if (columnIndex == 0) {
                throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5b57\u6bb5" + (table != null ? String.valueOf(table.getName()) + "." : "") + columnName + "\u5b9a\u4f4d\u5b57\u6bb5\u9519\u8bef\u3002");
            }
            RsIndexColumnIndex rsIndexColumnIndex = new RsIndexColumnIndex(rsIndex, columnIndex);
            if (this.columnNameToRsIndex.containsKey(columnName)) {
                throw new RuntimeException("\u5217\u540d" + (this.select.getColumnTable(i) == null ? "" : String.valueOf(this.select.getColumnTable(i).getName()) + ".") + columnName + "\u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
            this.columnNameToRsIndex.put(columnName, (Object)rsIndexColumnIndex);
            this.columnIndexToRsIndex.add(rsIndexColumnIndex);
            ++i;
        }
        i = 0;
        int size = this.srcRses.length;
        while (i < size) {
            ResultSetGetObjectByPos rs = this.srcRses[i];
            if (rs != null) {
                ResultSetMetaData rsMetaData = rs.getMetaData();
                int j = 1;
                int columnSize = rsMetaData.getColumnCount();
                while (j <= columnSize) {
                    String columnName = rsMetaData.getColumnLabel(j);
                    if (!this.columnNameToRsIndex.containsKey(columnName)) {
                        RsIndexColumnIndex rsIndexColumnIndex = new RsIndexColumnIndex(i, j);
                        this.columnNameToRsIndex.put(columnName, (Object)rsIndexColumnIndex);
                        this.columnIndexToRsIndex.add(rsIndexColumnIndex);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.pos = row;
        return row > 0 && row <= this.posList.size();
    }

    @Override
    public void afterLast() throws SQLException {
        this.pos = this.posList.size() + 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.pos = 0;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void close() throws SQLException {
        ResultSetGetObjectByPos[] resultSetGetObjectByPosArray = this.srcRses;
        int n = this.srcRses.length;
        int n2 = 0;
        while (n2 < n) {
            ResultSetGetObjectByPos rs = resultSetGetObjectByPosArray[n2];
            rs.close();
            ++n2;
        }
        this.posList.clear();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.columnIndexToRsIndex.indexOf(this.columnNameToRsIndex.get(columnLabel));
    }

    @Override
    public boolean first() throws SQLException {
        int rowCount = this.posList.size();
        if (rowCount == 0) {
            this.pos = 0;
            return false;
        }
        this.absolute(1);
        return true;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getBigDecimal(rsIndexColumnIndex.columnIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getBigDecimal(rsIndexColumnIndex.columnIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return false;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getBoolean(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return false;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getBoolean(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getByte(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getByte(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getBytes(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getBytes(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getDate(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getDate(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0.0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getDouble(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0.0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getDouble(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0.0f;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getFloat(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0.0f;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getFloat(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getInt(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getInt(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0L;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getLong(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0L;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getLong(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new EmptyResultSetMetaData(this.select);
        }
        return this.resultSetMetaData;
    }

    @Override
    public void setHiddenColumnCount(int hiddenColumnCount) {
        this.hiddenColumnCount = hiddenColumnCount;
    }

    @Override
    public int getHiddenColumnCount() {
        return this.hiddenColumnCount;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        if (rsIndexColumnIndex == null) {
            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u6309\u7d22\u5f15" + columnIndex + "\u53d6\u4e0d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002");
        }
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        if (ResultSetUtil.getRowCount(rs) == 0) {
            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u6309\u7d22\u5f15" + columnIndex + "\u53d6\u4e0d\u5230\u6570\u636e\uff0c\u6ca1\u6709\u6570\u636e\u3002");
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getObject(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Object getObject(int pos, int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        return rs.getObject(this.posList.get(pos - 1)[rsIndexColumnIndex.rsIndex], rsIndexColumnIndex.columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getObject(rsIndexColumnIndex.columnIndex, type);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        if (rsIndexColumnIndex == null) {
            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u6309\u5b57\u6bb5" + columnLabel + "\u53d6\u4e0d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u3002");
        }
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        if (ResultSetUtil.getRowCount(rs) == 0) {
            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u6309\u5b57\u6bb5" + columnLabel + "\u53d6\u4e0d\u5230\u6570\u636e\uff0c\u6ca1\u6709\u6570\u636e\u3002");
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getObject(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Object getObject(int pos, String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        return rs.getObject(this.posList.get(pos - 1)[rsIndexColumnIndex.rsIndex], rsIndexColumnIndex.columnIndex);
    }

    public Object getObject(int[] pos, String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || pos[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        return rs.getObject(pos[rsIndexColumnIndex.rsIndex], rsIndexColumnIndex.columnIndex);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getObject(rsIndexColumnIndex.columnIndex, type);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getRow() throws SQLException {
        return this.pos;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getShort(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return 0;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getShort(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getString(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getString(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getTime(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getTime(rsIndexColumnIndex.columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getTime(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getTime(rsIndexColumnIndex.columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getTimestamp(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        RsIndexColumnIndex rsIndexColumnIndex = (RsIndexColumnIndex)this.columnNameToRsIndex.get(columnLabel);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (ResultSetUtil.getRowCount(rs) == 0 || this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex] == 0) {
            return null;
        }
        rs.absolute(this.posList.get(this.pos - 1)[rsIndexColumnIndex.rsIndex]);
        return rs.getTimestamp(rsIndexColumnIndex.columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getType() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.pos == this.posList.size() + 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.pos == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.srcRses[0].isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.pos == 1 && this.posList.size() > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.pos == this.posList.size();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean last() throws SQLException {
        this.pos = this.posList.size();
        return true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean next() throws SQLException {
        ++this.pos;
        if (this.pos > this.posList.size()) {
            this.afterLast();
            return false;
        }
        return this.absolute(this.pos);
    }

    @Override
    public boolean previous() throws SQLException {
        --this.pos;
        if (this.pos == 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(this.pos);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.posList.isEmpty();
    }

    public int getRowCount() {
        return this.posList.size();
    }

    public List<int[]> getPosList() {
        return this.posList;
    }

    public int getScale(int columnIndex, int defaultValue) throws SQLException {
        if (this.srcRses == null || this.srcRses.length == 0) {
            return defaultValue;
        }
        RsIndexColumnIndex rsIndexColumnIndex = this.columnIndexToRsIndex.get(columnIndex);
        ResultSetGetObjectByPos rs = this.srcRses[rsIndexColumnIndex.rsIndex];
        if (rs == null) {
            return defaultValue;
        }
        return rs.getMetaData().getScale(rsIndexColumnIndex.columnIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JoinResultSet:").append("\n");
        if (this.srcRses != null) {
            ResultSetGetObjectByPos[] resultSetGetObjectByPosArray = this.srcRses;
            int n = this.srcRses.length;
            int n2 = 0;
            while (n2 < n) {
                ResultSetGetObjectByPos rs = resultSetGetObjectByPosArray[n2];
                sb.append(rs.toString()).append("\n");
                ++n2;
            }
        }
        return sb.toString();
    }
}

