/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.process;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.result.eval.JSqlExpressionExecutor;
import com.bokesoft.yes.mid.mysqls.result.eval.context.DetailEvalContext;
import com.bokesoft.yes.mid.mysqls.result.process.IResultProcessor;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetUtil;
import java.sql.SQLException;
import java.util.List;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class ResultEvalDetailFunc
implements IResultProcessor<ResultSetGetObjectByPos> {
    private ResultSetGetObjectByPos rs;
    private Parameters parameters;
    private List<SelectExpressionItem> detailFunctionItems = null;

    public ResultEvalDetailFunc(ResultSetGetObjectByPos rs, Parameters parameters, List<SelectExpressionItem> detailFunctionItems) {
        this.rs = rs;
        this.parameters = parameters;
        this.detailFunctionItems = detailFunctionItems;
    }

    @Override
    public ResultSetGetObjectByPos process() throws SQLException {
        if (this.detailFunctionItems == null || this.detailFunctionItems.isEmpty()) {
            return this.rs;
        }
        DetailEvalContext context = new DetailEvalContext(this.rs, this.parameters);
        JSqlExpressionExecutor executor = new JSqlExpressionExecutor(context);
        DataTableResultSet result = DataTableResultSet.wrap(this.rs);
        int rowIndex = 1;
        int rowCount = ResultSetUtil.getRowCount(result);
        while (rowIndex <= rowCount) {
            result.absolute(rowIndex);
            for (SelectExpressionItem calcItem : this.detailFunctionItems) {
                Object value = executor.eval(calcItem.getExpression(), result, rowIndex);
                result.updateObject(calcItem.getAlias(), value);
            }
            ++rowIndex;
        }
        return result;
    }
}

