/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.eval;

import com.bokesoft.yes.mid.mysqls.result.eval.context.ISQLEvalContext;
import com.bokesoft.yes.mid.mysqls.result.function.ISqlFunction;
import com.bokesoft.yes.mid.mysqls.result.function.JSqlFunctions;
import com.bokesoft.yes.mid.mysqls.result.function.util.MathUtils;
import com.bokesoft.yes.mid.mysqls.result.util.TypeUtils;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetAndPos;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import java.util.Stack;
import net.boke.jsqlparser.expression.AllComparisonExpression;
import net.boke.jsqlparser.expression.AnyComparisonExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.boke.jsqlparser.expression.operators.arithmetic.Concat;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExistsExpression;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.Matches;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MultiInExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.SubSelect;

public class ExpressionExecuteVisitor
implements ExpressionVisitor {
    private static final Object VOID_RETURN = new Object();
    private ISQLEvalContext context = null;
    private Stack<Object> stackValues = new Stack();

    public ExpressionExecuteVisitor(ISQLEvalContext context) {
        this.context = context;
    }

    public Object calcExpression(Expression expression) {
        if (expression == null) {
            return null;
        }
        expression.accept(this);
        return this.stackValues.pop();
    }

    @Override
    public void visit(Function function) {
        try {
            String name;
            Object result = null;
            ExpressionList expList = function.getParameters();
            switch (name = function.getName().toLowerCase()) {
                case "sum": {
                    result = this.sum((Expression)expList.getExpressions().get(0), this.context.getCurGroupDetails());
                    break;
                }
                case "max": {
                    for (ResultSetAndPos pos : this.context.getCurGroupDetails()) {
                        this.context.setResultSetPos(pos);
                        result = MathUtils.max(result, this.calcExpression((Expression)expList.getExpressions().get(0)));
                    }
                    break;
                }
                case "min": {
                    for (ResultSetAndPos pos : this.context.getCurGroupDetails()) {
                        this.context.setResultSetPos(pos);
                        result = MathUtils.min(result, this.calcExpression((Expression)expList.getExpressions().get(0)));
                    }
                    break;
                }
                case "count": {
                    result = this.count(function.getParameters(), this.context.getCurGroupDetails());
                    break;
                }
                case "avg": {
                    result = this.avg(function.getParameters(), this.context.getCurGroupDetails());
                    break;
                }
                default: {
                    ISqlFunction func = JSqlFunctions.getInstance().getFunction(name);
                    if (func == null) {
                        throw new RuntimeException("\u5206\u5e93SQL\u51fd\u6570\u672a\u5b9e\u73b0:" + name);
                    }
                    result = func.eval(this.calcExpressionListResults(expList), this.context);
                }
            }
            this.stackValues.push(result);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5206\u5e93SQL\u51fd\u6570\u8ba1\u7b97\u51fa\u9519\uff0c" + function.toString());
        }
    }

    private Object sum(Expression exp, List<ResultSetAndPos> groupDetails) {
        Object result = null;
        for (ResultSetAndPos pos : groupDetails) {
            this.context.setResultSetPos(pos);
            result = MathUtils.sum(result, this.calcExpression(exp));
        }
        return result;
    }

    private int count(ExpressionList paras, List<ResultSetAndPos> groupDetails) throws SQLException {
        int result = groupDetails.size();
        if (paras == null) {
            return result;
        }
        List expressions = paras.getExpressions();
        if (expressions == null || expressions.isEmpty()) {
            return result;
        }
        Expression exp = (Expression)expressions.get(0);
        if (exp instanceof Column) {
            result = this.count((Column)exp, groupDetails);
        }
        return result;
    }

    private int count(Expression exp, List<ResultSetAndPos> groupDetails) throws SQLException {
        int result = groupDetails.size();
        for (ResultSetAndPos pos : groupDetails) {
            this.context.setResultSetPos(pos);
            Object value = this.calcExpression(exp);
            if (value != null) continue;
            --result;
        }
        return result;
    }

    private Object avg(ExpressionList paras, List<ResultSetAndPos> groupDetails) throws SQLException {
        if (paras == null || paras.getExpressions() == null || paras.getExpressions().isEmpty()) {
            throw new RuntimeException("Avg\u51fd\u6570\u672a\u6307\u5b9a\u53c2\u6570\uff01");
        }
        Expression exp = (Expression)paras.getExpressions().get(0);
        Object sumValue = this.sum(exp, groupDetails);
        int count = this.count(exp, groupDetails);
        BigDecimal d1 = TypeConvertor.toBigDecimal((Object)sumValue);
        BigDecimal d2 = TypeConvertor.toBigDecimal((Object)count);
        return d1.divide(d2, 10, 5);
    }

    @Override
    public void visit(NullValue nullValue) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(InverseExpression inverseExpression) {
        Object value = this.calcExpression(inverseExpression.getExpression());
        if (value instanceof Long) {
            this.stackValues.push(-1L * (Long)value);
            return;
        }
        if (value instanceof Integer) {
            this.stackValues.push(-1 * (Integer)value);
            return;
        }
        if (value instanceof Double) {
            this.stackValues.push(-1.0 * (Double)value);
            return;
        }
        throw new RuntimeException("Unsupport Expression:" + inverseExpression.toString());
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        int index = -1;
        index = jdbcParameter.getIndexInSql() < 0 ? jdbcParameter.getIndex() : jdbcParameter.getIndexInSql() + 1;
        Object value = this.context.getParameters().getValue(index);
        this.stackValues.push(value);
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.stackValues.push(doubleValue.getValue());
    }

    @Override
    public void visit(LongValue longValue) {
        this.stackValues.push(longValue.getValue());
    }

    @Override
    public void visit(DateValue dateValue) {
        this.stackValues.push(dateValue.getValue());
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.stackValues.push(timeValue.getValue());
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.stackValues.push(timestampValue.getValue());
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        Object result = this.calcExpression(parenthesis.getExpression());
        this.stackValues.push(result);
    }

    @Override
    public void visit(StringValue stringValue) {
        this.stackValues.push(stringValue.getValue());
    }

    @Override
    public void visit(Addition addition) {
        Object result1 = this.calcExpression(addition.getLeftExpression());
        Object result2 = this.calcExpression(addition.getRightExpression());
        if (this.containsNull(result1, result2)) {
            this.stackValues.push(null);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 + l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.add(d2));
                return;
            }
            case 2: {
                String s1 = TypeConvertor.toString((Object)result1);
                String s2 = TypeConvertor.toString((Object)result2);
                this.stackValues.push(String.valueOf(s1) + s2);
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + addition.toString());
    }

    @Override
    public void visit(Subtraction subtraction) {
        Object result1 = this.calcExpression(subtraction.getLeftExpression());
        Object result2 = this.calcExpression(subtraction.getRightExpression());
        if (this.containsNull(result1, result2)) {
            this.stackValues.push(null);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 - l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.subtract(d2));
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + subtraction.toString());
    }

    @Override
    public void visit(Multiplication multiplication) {
        Object result1 = this.calcExpression(multiplication.getLeftExpression());
        Object result2 = this.calcExpression(multiplication.getRightExpression());
        if (this.containsNull(result1, result2)) {
            this.stackValues.push(null);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 * l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.multiply(d2));
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + multiplication.toString());
    }

    @Override
    public void visit(Division division) {
        Object result1 = this.calcExpression(division.getLeftExpression());
        Object result2 = this.calcExpression(division.getRightExpression());
        if (this.containsNull(result1, result2)) {
            this.stackValues.push(null);
            return;
        }
        BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
        BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
        this.stackValues.push(d1.divide(d2, 10, 5));
    }

    @Override
    public void visit(AndExpression andExpression) {
        Object result1 = this.calcExpression(andExpression.getLeftExpression());
        Object result2 = this.calcExpression(andExpression.getRightExpression());
        this.stackValues.push(TypeConvertor.toBoolean((Object)result1) != false && TypeConvertor.toBoolean((Object)result2) != false);
    }

    @Override
    public void visit(OrExpression orExpression) {
        Object result1 = this.calcExpression(orExpression.getLeftExpression());
        Object result2 = this.calcExpression(orExpression.getRightExpression());
        this.stackValues.push(TypeConvertor.toBoolean((Object)result1) != false || TypeConvertor.toBoolean((Object)result2) != false);
    }

    @Override
    public void visit(Between between) {
        Object end;
        Object start;
        Object value = this.calcExpression(between.getLeftExpression());
        if (this.containsNull(value, start = this.calcExpression(between.getBetweenExpressionStart()), end = this.calcExpression(between.getBetweenExpressionEnd()))) {
            this.stackValues.push(false);
            return;
        }
        this.stackValues.push(VarUtil.compare(value, start) >= 0 && VarUtil.compare(value, end) <= 0);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        Object result2;
        Object result1 = this.calcExpression(equalsTo.getLeftExpression());
        if (this.containsNull(result1, result2 = this.calcExpression(equalsTo.getRightExpression()))) {
            this.stackValues.push(false);
            return;
        }
        this.stackValues.push(VarUtil.compare(result1, result2) == 0);
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        Object result2;
        Object result1 = this.calcExpression(greaterThan.getLeftExpression());
        if (this.containsNull(result1, result2 = this.calcExpression(greaterThan.getRightExpression()))) {
            this.stackValues.push(false);
            return;
        }
        this.stackValues.push(VarUtil.compare(result1, result2) > 0);
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        Object result2;
        Object result1 = this.calcExpression(greaterThanEquals.getLeftExpression());
        if (this.containsNull(result1, result2 = this.calcExpression(greaterThanEquals.getRightExpression()))) {
            this.stackValues.push(false);
            return;
        }
        this.stackValues.push(VarUtil.compare(result1, result2) >= 0);
    }

    @Override
    public void visit(InExpression inExpression) {
        Object[] inValues;
        Object value = this.calcExpression(inExpression.getLeftExpression());
        if (this.containsNull(value)) {
            this.stackValues.push(false);
            return;
        }
        Object[] objectArray = inValues = this.calcExpressionListResults((ExpressionList)inExpression.getItemsList());
        int n = inValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object invalue = objectArray[n2];
            if (VarUtil.compare(value, invalue) == 0) {
                this.stackValues.push(!inExpression.isNot());
                return;
            }
            ++n2;
        }
        this.stackValues.push(inExpression.isNot());
    }

    @Override
    public void visit(MultiInExpression inExpression) {
        throw new RuntimeException("Unsupport Expression:" + inExpression.toString());
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        boolean result;
        Object value = this.calcExpression(isNullExpression.getLeftExpression());
        boolean bl = result = value instanceof NullValue || value == null;
        if (isNullExpression.isNot()) {
            this.stackValues.push(!result);
        } else {
            this.stackValues.push(result);
        }
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        throw new RuntimeException("Unsupport Expression:" + likeExpression.toString());
    }

    @Override
    public void visit(MinorThan minorThan) {
        Object result2;
        Object result1 = this.calcExpression(minorThan.getLeftExpression());
        if (this.containsNull(result1, result2 = this.calcExpression(minorThan.getRightExpression()))) {
            this.stackValues.push(false);
            return;
        }
        this.stackValues.push(VarUtil.compare(result1, result2) < 0);
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        Object result2;
        Object result1 = this.calcExpression(minorThanEquals.getLeftExpression());
        if (this.containsNull(result1, result2 = this.calcExpression(minorThanEquals.getRightExpression()))) {
            this.stackValues.push(false);
            return;
        }
        this.stackValues.push(VarUtil.compare(result1, result2) <= 0);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        Object result2;
        Object result1 = this.calcExpression(notEqualsTo.getLeftExpression());
        if (this.containsNull(result1, result2 = this.calcExpression(notEqualsTo.getRightExpression()))) {
            this.stackValues.push(false);
            return;
        }
        this.stackValues.push(VarUtil.compare(result1, result2) != 0);
    }

    @Override
    public void visit(Column tableColumn) {
        try {
            this.stackValues.push(this.context.getValue(tableColumn));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5206\u5e93\u83b7\u53d6\u6570\u636e\u51fa\u9519:" + tableColumn.getColumnName());
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        throw new RuntimeException("Unsupport Expression:" + subSelect.toString());
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        if (caseExpression.getSwitchExpression() != null) {
            Expression switchValue = caseExpression.getSwitchExpression();
            List whens = caseExpression.getWhenClauses();
            for (Object obj : whens) {
                WhenClause whenClause = (WhenClause)obj;
                Object whenValue = this.calcExpression(whenClause.getWhenExpression());
                if (this.containsNull(whenValue) || VarUtil.compare(switchValue, whenValue) != 0) continue;
                Object thenValue = this.calcExpression(whenClause.getThenExpression());
                this.stackValues.push(thenValue);
                return;
            }
        } else {
            List whens = caseExpression.getWhenClauses();
            for (Object obj : whens) {
                Object result = this.calcExpression((WhenClause)obj);
                if (result == VOID_RETURN) continue;
                this.stackValues.push(result);
                return;
            }
        }
        Expression elseExpression = caseExpression.getElseExpression();
        if (elseExpression != null) {
            this.stackValues.push(this.calcExpression(elseExpression));
        }
    }

    @Override
    public void visit(WhenClause whenClause) {
        boolean when = TypeConvertor.toBoolean((Object)this.calcExpression(whenClause.getWhenExpression()));
        Object then = this.calcExpression(whenClause.getThenExpression());
        this.stackValues.push(when ? then : VOID_RETURN);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        throw new RuntimeException("Unsupport Expression:" + existsExpression.toString());
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        throw new RuntimeException("Unsupport Expression:" + allComparisonExpression.toString());
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        throw new RuntimeException("Unsupport Expression:" + anyComparisonExpression.toString());
    }

    @Override
    public void visit(Concat concat) {
        Object result1 = this.calcExpression(concat.getLeftExpression());
        Object result2 = this.calcExpression(concat.getRightExpression());
        if (this.containsNull(result1, result2)) {
            this.stackValues.push(null);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        if (dataType == 2) {
            String s1 = TypeConvertor.toString((Object)result1);
            String s2 = TypeConvertor.toString((Object)result2);
            this.stackValues.push(String.valueOf(s1) + s2);
            return;
        }
        throw new RuntimeException("Unsupport Expression:" + concat.toString());
    }

    @Override
    public void visit(Matches matches) {
        throw new RuntimeException("Unsupport Expression:" + matches.toString());
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        throw new RuntimeException("Unsupport Expression:" + bitwiseAnd.toString());
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        throw new RuntimeException("Unsupport Expression:" + bitwiseOr.toString());
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        throw new RuntimeException("Unsupport Expression:" + bitwiseXor.toString());
    }

    @Override
    public void visit(Modulo modulo) {
        Object result1 = this.calcExpression(modulo.getLeftExpression());
        Object result2 = this.calcExpression(modulo.getRightExpression());
        if (this.containsNull(result1, result2)) {
            this.stackValues.push(null);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 % l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.remainder(d2));
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + modulo.toString());
    }

    private Object[] calcExpressionListResults(ExpressionList expList) {
        if (expList == null || expList.getExpressions() == null) {
            return new Object[0];
        }
        int index = 0;
        Expression paraExp = null;
        Object[] results = new Object[expList.getExpressions().size()];
        for (Object obj : expList.getExpressions()) {
            paraExp = (Expression)obj;
            results[index] = this.calcExpression(paraExp);
            ++index;
        }
        return results;
    }

    private boolean containsNull(Object ... values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value == null || value instanceof NullValue) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

