/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.regular.actions;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.processselect.regular.AbstractRegularAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.util.SqlRegularUtil;
import java.util.IdentityHashMap;
import java.util.Map;
import net.boke.jsqlparser.base.ISqlElement;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Select;

public class RenameRepeatAliasAction
extends AbstractRegularAction {
    private static final String SP_ALIAS_SYMBO = "";

    public RenameRepeatAliasAction(Select select) {
        super(select);
    }

    @Override
    public void doAction() {
        HashMapIgnoreCase mapAllAliasIndexes = new HashMapIgnoreCase();
        this.prepareAllAliasIndexes((HashMapIgnoreCase<Integer>)mapAllAliasIndexes);
        IdentityHashMap mapRenameFromItemAlias = new IdentityHashMap();
        this.select.traversal(elem -> {
            String newAlias;
            FromItem formItem;
            if (elem instanceof FromItem && !mapRenameFromItemAlias.containsKey(formItem = (FromItem)elem) && !StringUtil.isBlankOrNull((String)(newAlias = this.createNoRepeatAliasKey(formItem, (HashMapIgnoreCase<Integer>)mapAllAliasIndexes)))) {
                mapRenameFromItemAlias.put(formItem, newAlias);
            }
            return true;
        });
        this.select.traversal(elem -> {
            this.updateColumnTable(elem, mapRenameFromItemAlias);
            return true;
        });
        for (Map.Entry entry : mapRenameFromItemAlias.entrySet()) {
            ((FromItem)entry.getKey()).setAlias((String)entry.getValue());
        }
    }

    private void updateColumnTable(ISqlElement elem, Map<FromItem, String> mapRenameFromItemAlias) {
        AllTableColumns allTableColumns;
        FromItem fromItem;
        if (elem instanceof Column) {
            Column column = (Column)elem;
            FromItem fromItem2 = column.getFormItemAsTable();
            String newAlias = mapRenameFromItemAlias.get(fromItem2);
            if (SqlRegularUtil.isColumnTableChanged(column, newAlias)) {
                column.getTable().setName(newAlias);
            }
        } else if (elem instanceof AllTableColumns && mapRenameFromItemAlias.containsKey(fromItem = (allTableColumns = (AllTableColumns)elem).getExtendFromItem()) && !SqlRegularUtil.isNullTable(allTableColumns.getTable())) {
            allTableColumns.getTable().setName(mapRenameFromItemAlias.get(fromItem));
        }
    }

    private void prepareAllAliasIndexes(HashMapIgnoreCase<Integer> mapAllAliasIndexes) {
        this.select.traversal(elem -> {
            if (elem instanceof FromItem) {
                FromItem formItem = (FromItem)elem;
                String alias = formItem.getAlias();
                if (!StringUtil.isBlankOrNull((String)alias)) {
                    mapAllAliasIndexes.put(alias, (Object)0);
                }
                if (elem instanceof Table) {
                    mapAllAliasIndexes.put(((Table)elem).getName(), (Object)0);
                }
            }
            return true;
        });
    }

    private String createNoRepeatAliasKey(FromItem fromItem, HashMapIgnoreCase<Integer> mapAllTableAndAliasIndexes) {
        int lastIndex;
        String alias = fromItem.getAlias();
        String tableName = null;
        if (fromItem instanceof Table) {
            tableName = ((Table)fromItem).getName();
        }
        if (StringUtil.isBlankOrNull((String)alias)) {
            if (!StringUtil.isBlankOrNull((String)tableName)) {
                alias = tableName;
            } else {
                return SP_ALIAS_SYMBO;
            }
        }
        if ((lastIndex = ((Integer)mapAllTableAndAliasIndexes.get(alias)).intValue()) == 0) {
            mapAllTableAndAliasIndexes.put(alias, (Object)1);
            if (!StringUtil.isBlankOrNull((String)tableName)) {
                mapAllTableAndAliasIndexes.put(tableName, (Object)1);
            }
            return SP_ALIAS_SYMBO;
        }
        String tmpKey = null;
        while (tmpKey == null || mapAllTableAndAliasIndexes.containsKey(tmpKey)) {
            int curExistAliasIndex = (Integer)mapAllTableAndAliasIndexes.get(alias) + 1;
            mapAllTableAndAliasIndexes.put(alias, (Object)curExistAliasIndex);
            tmpKey = String.valueOf(alias) + curExistAliasIndex;
        }
        return tmpKey;
    }

    @Override
    public String getName() {
        return "RenameRepeatAlias";
    }
}

