/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.processselect.GetAllTableVisitor;
import com.bokesoft.yes.mid.mysqls.processselect.InTableGroups;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.ISqlElement;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.parser.CCJSqlParser;
import net.boke.jsqlparser.parser.CCJSqlParserManager;
import net.boke.jsqlparser.parser.ParseException;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.Distinct;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubJoin;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;

public class ParsedSqlUtil {
    public static final Expression Exp_Impossible = ParsedSqlUtil.newEqualsToExpression(ParsedSqlUtil.newConstantExpression(1), ParsedSqlUtil.newConstantExpression(2));

    public static Expression newAndExpression(Expression exp1, Expression exp2) {
        if (exp1 == null) {
            return exp2;
        }
        if (exp2 == null) {
            return exp1;
        }
        if (exp1 instanceof OrExpression) {
            exp1 = new Parenthesis(exp1);
        }
        if (exp2 instanceof OrExpression) {
            exp2 = new Parenthesis(exp2);
        }
        AndExpression result = new AndExpression(exp1, exp2);
        return result;
    }

    public static EqualsTo newEqualsToExpression(Expression exp1, Expression exp2) {
        EqualsTo result = new EqualsTo();
        result.setLeftExpression(exp1);
        result.setRightExpression(exp2);
        return result;
    }

    public static NotEqualsTo newNotEqualsToExpression(Expression exp1, Expression exp2) {
        NotEqualsTo result = new NotEqualsTo();
        result.setLeftExpression(exp1);
        result.setRightExpression(exp2);
        return result;
    }

    public static Expression newExpression(Expression exp, boolean isEqual, boolean isInner, List<Object> values, int startFixedIndex) {
        Expression result;
        if (values.size() == 0) {
            result = isEqual ? Exp_Impossible : null;
        } else if (values.size() == 1) {
            result = isEqual ? ParsedSqlUtil.newEqualsToExpression(exp, new JdbcParameter(startFixedIndex, true)) : ParsedSqlUtil.newNotEqualsToExpression(exp, new JdbcParameter(startFixedIndex, true));
        } else {
            ArrayList<JdbcParameter> list = new ArrayList<JdbcParameter>();
            for (Object value : values) {
                JdbcParameter jdbcParameter = new JdbcParameter(startFixedIndex, true);
                ++startFixedIndex;
                list.add(jdbcParameter);
            }
            ExpressionList expList = new ExpressionList(list);
            result = new InExpression(exp, expList);
            if (!isEqual) {
                ((InExpression)result).setNot(true);
            }
        }
        return result;
    }

    public static Expression newConstantExpression(Object value) {
        if (value instanceof Integer || value instanceof Long) {
            return new LongValue(value.toString());
        }
        if (value instanceof String) {
            return new StringValue(value.toString());
        }
        if (value == null) {
            return new NullValue();
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u4e0d\u652f\u6301\u7684\u503c" + value + "\u3002");
    }

    public static String getNoRepeatTableAlias(HashMapIgnoreCase<FromItem> existTableAliases, List<Table> allTables, String tableAlias) {
        int i = 2;
        String newTableAlias = String.valueOf(tableAlias) + i;
        while (existTableAliases.containsKey(newTableAlias) || ParsedSqlUtil.getTableByTableNameOrAlias(allTables, newTableAlias) != null) {
            newTableAlias = String.valueOf(tableAlias) + ++i;
        }
        return newTableAlias;
    }

    public static String getNoRepeatColumnAlias(SelectSqlInfo selectSqlInfo, PlainSelect plainSelect, Expression exp, List<SelectExpressionItem> calcItemsBeforeGroup, List<SelectExpressionItem> calcItems) {
        String columnName;
        if (exp instanceof Column) {
            columnName = ((Column)exp).getColumnName();
        } else {
            String pattern = "[a-zA-Z0-9_]+";
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(exp.toString());
            StringBuilder sb = new StringBuilder(128);
            while (m.find()) {
                sb.append(m.group());
            }
            columnName = sb.length() >= 0 ? sb.toString() : "NewExp_";
        }
        boolean found = true;
        int postfix = 0;
        String result = null;
        while (found) {
            result = ++postfix == 1 ? columnName : String.valueOf(columnName) + postfix;
            found = ParsedSqlUtil.isRepeatColumnAlias(result, selectSqlInfo, plainSelect, calcItemsBeforeGroup, calcItems);
        }
        return result;
    }

    private static boolean isRepeatColumnAlias(String checkAlias, SelectSqlInfo selectSqlInfo, PlainSelect plainSelect, List<SelectExpressionItem> calcItemsBeforeGroup, List<SelectExpressionItem> calcItems) {
        List selectItems = plainSelect.getSelectItems();
        boolean hasSubSelect = plainSelect.getFromItem() instanceof SubSelect && ((SubSelect)plainSelect.getFromItem()).getSelectBody() instanceof PlainSelect;
        boolean found = false;
        int i = 0;
        int size = selectItems == null ? 0 : selectItems.size();
        while (i < size) {
            SelectItem selectItem = (SelectItem)selectItems.get(i);
            if (selectItem instanceof AllColumns) {
                found = hasSubSelect ? ParsedSqlUtil.isRepeatColumnAlias(checkAlias, selectSqlInfo, (PlainSelect)((SubSelect)plainSelect.getFromItem()).getSelectBody(), null, null) : DBStruct.isExistColumnInTable(checkAlias, ((Table)plainSelect.getFromItem()).getName());
            } else if (selectItem instanceof AllTableColumns) {
                if (hasSubSelect) {
                    found = ParsedSqlUtil.isRepeatColumnAlias(checkAlias, selectSqlInfo, (PlainSelect)((SubSelect)plainSelect.getFromItem()).getSelectBody(), null, null);
                } else {
                    String tableName = selectSqlInfo.getTableName(((AllTableColumns)selectItem).getTable().getName());
                    found = DBStruct.isExistColumnInTable(checkAlias, tableName);
                }
            } else if (selectItem instanceof SelectExpressionItem) {
                String alias = ParsedSqlUtil.getSelectItemShortName((SelectExpressionItem)selectItem);
                boolean bl = found = alias != null && alias.equalsIgnoreCase(checkAlias);
            }
            if (found) {
                return true;
            }
            ++i;
        }
        if (calcItemsBeforeGroup != null) {
            for (SelectExpressionItem selectItem : calcItemsBeforeGroup) {
                if (!checkAlias.equalsIgnoreCase(selectItem.getAlias())) continue;
                return true;
            }
        }
        if (calcItems != null) {
            for (SelectExpressionItem selectItem : calcItems) {
                if (!checkAlias.equalsIgnoreCase(selectItem.getAlias())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isColumnInTable(Expression expression, FromItem table) {
        if (expression instanceof Column) {
            Column column = (Column)expression;
            if (table == column.getExtendFromItem()) {
                return true;
            }
            SelectExpressionItem selectItem = column.getExtendSelectItemInGroupByOrderByHaving();
            if (selectItem != null) {
                return ParsedSqlUtil.isColumnInTable(selectItem.getExpression(), table);
            }
        }
        return false;
    }

    public static String getFromItemShortName(FromItem fromItem) {
        if (fromItem != null && fromItem.getAlias() != null) {
            return fromItem.getAlias();
        }
        if (fromItem instanceof Table) {
            return ((Table)fromItem).getName();
        }
        return null;
    }

    public static boolean isFitFromItem(FromItem fromItem, String tableName) {
        return tableName.equalsIgnoreCase(ParsedSqlUtil.getFromItemShortName(fromItem)) || fromItem instanceof Table && tableName.equalsIgnoreCase(((Table)fromItem).getName());
    }

    public static PlainSelect getPlainSelect(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            return (PlainSelect)selectBody;
        }
        Union union = (Union)selectBody;
        return (PlainSelect)union.getPlainSelects().get(0);
    }

    public static FromItem getFromItem(PlainSelect plainSelect, String tableName) {
        FromItem fromItem = plainSelect.getFromItem();
        if (tableName.equalsIgnoreCase(fromItem.getAlias()) || fromItem instanceof Table && ((Table)fromItem).getName().equalsIgnoreCase(tableName)) {
            return fromItem;
        }
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Object joinTmp : joins) {
                Join join = (Join)joinTmp;
                FromItem joinFromItem = join.getRightItem();
                if (!tableName.equalsIgnoreCase(joinFromItem.getAlias()) && (!(joinFromItem instanceof Table) || !((Table)joinFromItem).getName().equalsIgnoreCase(tableName))) continue;
                return joinFromItem;
            }
        }
        return null;
    }

    public static Join getJoinByFromItem(PlainSelect plainSelect, FromItem searchFromItem) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem == searchFromItem) {
            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5b50\u67e5\u8be2\u7b2c\u4e00\u5f20\u8868\u662fIn\u5b50\u53e5\u4e2d\u7684\u8868\uff0c\u800c\u5b58\u5728\u5176\u4ed6\u8868\u4e0d\u662fIn\u5b50\u53e5\u4e2d\u7684\u8868\u3002\n" + plainSelect.toString());
        }
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Object joinTmp : joins) {
                Join join = (Join)joinTmp;
                FromItem joinFromItem = join.getRightItem();
                if (joinFromItem != searchFromItem) continue;
                return join;
            }
        }
        return null;
    }

    public static List<Table> getAllTable(Select select, InTableGroups inTableGroups) {
        ArrayList<Table> result = new ArrayList<Table>();
        GetAllTableVisitor allTableVisitor = new GetAllTableVisitor(result, inTableGroups);
        SelectBody plainSelect = select.getSelectBody();
        plainSelect.accept(allTableVisitor);
        return result;
    }

    public static List<Table> getAllTableBySelectBody(SelectBody selectBody, InTableGroups inTableGroups) {
        ArrayList<Table> result = new ArrayList<Table>();
        GetAllTableVisitor allTableVisitor = new GetAllTableVisitor(result, inTableGroups);
        selectBody.accept(allTableVisitor);
        return result;
    }

    public static Table getTableByTableNameOrAlias(List<Table> tables, String tableNameOrAlias) {
        int i = 0;
        int size = tables != null ? tables.size() : 0;
        while (i < size) {
            Table table = tables.get(i);
            if (tableNameOrAlias.equalsIgnoreCase(table.getAlias()) || tableNameOrAlias.equalsIgnoreCase(table.getName())) {
                return table;
            }
            ++i;
        }
        return null;
    }

    public static void addGroupByField(PlainSelect plainSelect, Expression expression) {
        ArrayList<Expression> groupbyFields = plainSelect.getGroupByColumnReferences();
        if (groupbyFields == null) {
            groupbyFields = new ArrayList<Expression>();
            plainSelect.setGroupByColumnReferences(groupbyFields);
        }
        if (!groupbyFields.contains(expression)) {
            groupbyFields.add(expression);
        }
    }

    public static void addOrderByItem(PlainSelect plainSelect, OrderByElement orderby) {
        ArrayList<OrderByElement> orderByElements = plainSelect.getOrderByElements();
        if (orderByElements == null) {
            orderByElements = new ArrayList<OrderByElement>();
            plainSelect.setOrderByElements(orderByElements);
        }
        if (!orderByElements.contains(orderby)) {
            orderByElements.add(orderby);
        }
    }

    public static void addWhereExpression(PlainSelect plainSelect, Expression expression) {
        if (expression == null) {
            return;
        }
        Expression where = plainSelect.getWhere();
        if (where == null) {
            plainSelect.setWhere(expression);
        } else {
            where = ParsedSqlUtil.newAndExpression(where, expression);
            plainSelect.setWhere(where);
        }
    }

    public static void addJoinOnExpression(Join join, Expression exp) {
        Expression on = join.getOnExpression();
        if (on == null) {
            join.setOnExpression(exp);
        } else {
            on = ParsedSqlUtil.newAndExpression(on, exp);
            join.setOnExpression(on);
        }
    }

    public static boolean isConstant(Object exp) {
        return exp != null && (exp instanceof LongValue || exp instanceof StringValue || exp instanceof DoubleValue || exp instanceof DateValue || exp instanceof TimestampValue || exp instanceof TimeValue || exp instanceof NullValue || exp instanceof JdbcParameter);
    }

    public static boolean isConstantZero(Expression exp) {
        return exp != null && (exp instanceof LongValue && ((LongValue)exp).getValue() == 0L || exp instanceof DoubleValue && ((DoubleValue)exp).getValue() == 0.0);
    }

    public static boolean isConstantExpression(Expression exp) {
        RefObject result = new RefObject((Object)true);
        exp.traversal(elem -> {
            if (elem instanceof Column) {
                result.setValue((Object)false);
                return false;
            }
            return true;
        });
        return (Boolean)result.getValue();
    }

    public static Object getConstantValue(Expression exp) {
        if (exp instanceof LongValue) {
            return ((LongValue)exp).getValue();
        }
        if (exp instanceof DoubleValue) {
            return TypeConvertor.toBigDecimal((Object)((DoubleValue)exp).getValue());
        }
        if (exp instanceof StringValue) {
            return ((StringValue)exp).getValue();
        }
        if (exp instanceof NullValue) {
            return null;
        }
        throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f\uff0c" + exp.toString());
    }

    public static boolean hasOIDOrSOIDInWhereExpression(Expression exp) {
        boolean result = false;
        if (exp instanceof Parenthesis) {
            return ParsedSqlUtil.hasOIDOrSOIDInWhereExpression(((Parenthesis)exp).getExpression());
        }
        if (exp instanceof AndExpression) {
            return ParsedSqlUtil.hasOIDOrSOIDInWhereExpression(((AndExpression)exp).getLeftExpression()) || ParsedSqlUtil.hasOIDOrSOIDInWhereExpression(((AndExpression)exp).getRightExpression());
        }
        if (exp instanceof OrExpression) {
            return false;
        }
        if (exp instanceof EqualsTo) {
            Expression leftExp = ((EqualsTo)exp).getLeftExpression();
            Expression rightExp = ((EqualsTo)exp).getRightExpression();
            String columnName = null;
            if (leftExp instanceof Column && ParsedSqlUtil.isConstant(rightExp)) {
                columnName = ((Column)leftExp).getColumnName();
            } else if (ParsedSqlUtil.isConstant(leftExp) && rightExp instanceof Column) {
                columnName = ((Column)rightExp).getColumnName();
            }
            if (columnName != null && (columnName.equalsIgnoreCase("OID") || columnName.equalsIgnoreCase("SOID"))) {
                result = true;
            }
        } else if (exp instanceof InExpression) {
            result = false;
        }
        return result;
    }

    public static boolean hasRefOIDInWhereExpression(Expression exp) {
        boolean result = false;
        if (exp instanceof Parenthesis) {
            return ParsedSqlUtil.hasRefOIDInWhereExpression(((Parenthesis)exp).getExpression());
        }
        if (exp instanceof AndExpression) {
            return ParsedSqlUtil.hasRefOIDInWhereExpression(((AndExpression)exp).getLeftExpression()) || ParsedSqlUtil.hasRefOIDInWhereExpression(((AndExpression)exp).getRightExpression());
        }
        if (exp instanceof OrExpression) {
            return false;
        }
        if (exp instanceof EqualsTo) {
            Expression leftExp = ((EqualsTo)exp).getLeftExpression();
            Expression rightExp = ((EqualsTo)exp).getRightExpression();
            String columnName = null;
            if (leftExp instanceof Column && ParsedSqlUtil.isConstant(rightExp)) {
                columnName = ((Column)leftExp).getColumnName().toUpperCase();
            } else if (ParsedSqlUtil.isConstant(leftExp) && rightExp instanceof Column) {
                columnName = ((Column)rightExp).getColumnName().toUpperCase();
            }
            if (columnName != null && (columnName.equals("POID") || columnName.indexOf("BILLID") > -1 || columnName.indexOf("BILLDTLID") > -1 || columnName.indexOf("OID") > -1)) {
                result = true;
            }
        } else if (exp instanceof InExpression) {
            result = false;
        }
        return result;
    }

    public static void changeExpressionTableName(SubQuery subSelect, Expression exp) {
        if (exp instanceof Parenthesis) {
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((Parenthesis)exp).getExpression());
        } else if (exp instanceof AndExpression) {
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((AndExpression)exp).getLeftExpression());
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((AndExpression)exp).getRightExpression());
        } else if (exp instanceof OrExpression) {
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((OrExpression)exp).getLeftExpression());
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((OrExpression)exp).getRightExpression());
        } else if (exp instanceof BinaryExpression) {
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((BinaryExpression)exp).getLeftExpression());
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((BinaryExpression)exp).getRightExpression());
        } else if (exp instanceof InExpression) {
            ParsedSqlUtil.changeExpressionTableName(subSelect, ((InExpression)exp).getLeftExpression());
        } else if (exp instanceof Column) {
            Column column = (Column)exp;
            Table table = column.getTable();
            if (table != null) {
                String tableAlias = table.getAlias();
                if (tableAlias != null) {
                    table.setName(tableAlias);
                } else {
                    String tableName = table.getName();
                    String aliasName = subSelect.getAliasNameByTableName(tableName);
                    if (aliasName != null) {
                        table.setName(aliasName);
                    }
                }
            }
        } else {
            return;
        }
    }

    public static boolean isUseTableNotIsNull(Expression expression, FromItem fromItem) {
        if (expression instanceof Parenthesis) {
            return ParsedSqlUtil.isUseTableNotIsNull(((Parenthesis)expression).getExpression(), fromItem);
        }
        if (expression instanceof AndExpression) {
            return ParsedSqlUtil.isUseTableNotIsNull(((AndExpression)expression).getLeftExpression(), fromItem) || ParsedSqlUtil.isUseTableNotIsNull(((AndExpression)expression).getRightExpression(), fromItem);
        }
        if (expression instanceof OrExpression) {
            final RefObject hasIsNull = new RefObject((Object)false);
            BaseExpressionVisitor visitor = new BaseExpressionVisitor(){

                @Override
                public void visit(IsNullExpression isNullExpression) {
                    hasIsNull.setValue((Object)true);
                }

                @Override
                public void visit(Function function) {
                    String functionName = function.getName();
                    if (functionName.equalsIgnoreCase("IfNull") || functionName.equalsIgnoreCase("COALESCE")) {
                        hasIsNull.setValue((Object)true);
                    }
                    super.visit(function);
                }
            };
            ((OrExpression)expression).getLeftExpression().accept(visitor);
            if (((Boolean)hasIsNull.getValue()).booleanValue()) {
                return false;
            }
            ((OrExpression)expression).getRightExpression().accept(visitor);
            if (((Boolean)hasIsNull.getValue()).booleanValue()) {
                return false;
            }
            return ParsedSqlUtil.isUseTableNotIsNull(((OrExpression)expression).getLeftExpression(), fromItem) || ParsedSqlUtil.isUseTableNotIsNull(((OrExpression)expression).getRightExpression(), fromItem);
        }
        if (expression instanceof InExpression) {
            return ParsedSqlUtil.isUseTableNotIsNull(((InExpression)expression).getLeftExpression(), fromItem);
        }
        if (expression instanceof BinaryExpression) {
            return ParsedSqlUtil.isUseTableNotIsNull(((BinaryExpression)expression).getLeftExpression(), fromItem) || ParsedSqlUtil.isUseTableNotIsNull(((BinaryExpression)expression).getRightExpression(), fromItem);
        }
        if (expression instanceof Column) {
            if (!(fromItem instanceof Table)) {
                return false;
            }
            return ParsedSqlUtil.isColumnInTable(expression, fromItem);
        }
        return false;
    }

    public static boolean isNoGroup(SelectSqlInfo select) {
        List<String> allTableNames = select.getAllTableNames();
        for (String tableName : allTableNames) {
            TableGroupProp group = TableGroupProps.getInstance().getTableGroupProp(tableName);
            if (group == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameSingleGroup(List<String> allTableNames) {
        Group group = null;
        for (String tableName : allTableNames) {
            Group curGroup = TableGroupProps.getInstance().getFixedGroup(tableName);
            if (curGroup == null || curGroup.hasMoreDSN()) {
                return false;
            }
            if (group == curGroup) continue;
            if (group == null) {
                group = curGroup;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean isSameDataObject(String firstTableName, String tableName) {
        boolean isSame = false;
        try {
            List<MetaDataObject> dataObjects = DataObjects.getInstance().getDataObjectsByTableName(firstTableName);
            for (MetaDataObject dataObject : dataObjects) {
                for (MetaTable table : dataObject.getTableCollection()) {
                    if (!table.getKey().equalsIgnoreCase(tableName)) continue;
                    isSame = true;
                    break;
                }
                if (!isSame) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return isSame;
    }

    public static boolean isSingleTableOrSameSingleGroup(PlainSelect plainSelect) {
        String sql = plainSelect.toString();
        SelectSqlInfo sqlinfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        List<Table> allTables = sqlinfo.getAllTables();
        if (allTables.size() == 1) {
            return true;
        }
        return ParsedSqlUtil.isSameSingleGroup(sqlinfo.getAllTableNames());
    }

    public static boolean isDefaultGroup(FromItem fromItem) {
        if (fromItem instanceof Table) {
            return TableGroupProps.getInstance().getTableGroupProp(((Table)fromItem).getName()) == null;
        }
        if (fromItem instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() instanceof PlainSelect) {
            return ParsedSqlUtil.isDefaultGroup((PlainSelect)((SubSelect)fromItem).getSelectBody());
        }
        return false;
    }

    private static boolean isDefaultGroup(PlainSelect plainSelect) {
        String sql = plainSelect.toString();
        SelectSqlInfo sqlinfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        List<String> allTableNames = sqlinfo.getAllTableNames();
        for (String tableName : allTableNames) {
            if (TableGroupProps.getInstance().getTableGroupProp(tableName) == null) continue;
            return false;
        }
        return true;
    }

    public static String getMainTableName(FromItem fromItem) {
        SelectBody selectBody;
        String tableName = "";
        if (fromItem instanceof Table) {
            tableName = ((Table)fromItem).getName();
        } else if (fromItem instanceof SubSelect && (selectBody = ((SubSelect)fromItem).getSelectBody()) instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)selectBody;
            return ParsedSqlUtil.getMainTableName(select.getFromItem());
        }
        return tableName;
    }

    public static String getFilterByHaving(Expression exp, PlainSelect plainSelect) {
        StringBuilder result = new StringBuilder();
        if (exp instanceof Parenthesis) {
            String sExp = ParsedSqlUtil.getFilterByHaving(((Parenthesis)exp).getExpression(), plainSelect);
            result.append("(").append(sExp).append(")");
        } else if (exp instanceof AndExpression) {
            String sRight;
            String sLeft = ParsedSqlUtil.getFilterByHaving(((AndExpression)exp).getLeftExpression(), plainSelect);
            if (sLeft != null) {
                result.append(sLeft);
            }
            if ((sRight = ParsedSqlUtil.getFilterByHaving(((AndExpression)exp).getRightExpression(), plainSelect)) != null) {
                result.append(" && ").append(sRight);
            }
        } else if (exp instanceof OrExpression) {
            String sRight;
            String sLeft = ParsedSqlUtil.getFilterByHaving(((OrExpression)exp).getLeftExpression(), plainSelect);
            if (sLeft != null) {
                result.append(sLeft);
            }
            if ((sRight = ParsedSqlUtil.getFilterByHaving(((OrExpression)exp).getRightExpression(), plainSelect)) != null) {
                result.append(" || ").append(sRight);
            }
        } else if (exp instanceof NotEqualsTo) {
            String sLeft = ParsedSqlUtil.getFilterByHaving(((NotEqualsTo)exp).getLeftExpression(), plainSelect);
            if (sLeft == null) {
                return null;
            }
            String sRight = ParsedSqlUtil.getFilterByHaving(((NotEqualsTo)exp).getRightExpression(), plainSelect);
            result.append(sLeft).append(" <> ").append(sRight);
        } else if (exp instanceof EqualsTo) {
            String sLeft = ParsedSqlUtil.getFilterByHaving(((EqualsTo)exp).getLeftExpression(), plainSelect);
            if (sLeft == null) {
                return null;
            }
            String sRight = ParsedSqlUtil.getFilterByHaving(((EqualsTo)exp).getRightExpression(), plainSelect);
            result.append(sLeft).append(" == ").append(sRight);
        } else if (exp instanceof GreaterThan) {
            String sLeft = ParsedSqlUtil.getFilterByHaving(((GreaterThan)exp).getLeftExpression(), plainSelect);
            if (sLeft == null) {
                return null;
            }
            String sRight = ParsedSqlUtil.getFilterByHaving(((GreaterThan)exp).getRightExpression(), plainSelect);
            result.append(sLeft).append(" > ").append(sRight);
        } else if (exp instanceof GreaterThanEquals) {
            String sLeft = ParsedSqlUtil.getFilterByHaving(((GreaterThanEquals)exp).getLeftExpression(), plainSelect);
            if (sLeft == null) {
                return null;
            }
            String sRight = ParsedSqlUtil.getFilterByHaving(((GreaterThanEquals)exp).getRightExpression(), plainSelect);
            result.append(sLeft).append(" >= ").append(sRight);
        } else if (exp instanceof MinorThan) {
            String sLeft = ParsedSqlUtil.getFilterByHaving(((MinorThan)exp).getLeftExpression(), plainSelect);
            if (sLeft == null) {
                return null;
            }
            String sRight = ParsedSqlUtil.getFilterByHaving(((MinorThan)exp).getRightExpression(), plainSelect);
            result.append(sLeft).append(" < ").append(sRight);
        } else if (exp instanceof MinorThanEquals) {
            String sLeft = ParsedSqlUtil.getFilterByHaving(((MinorThanEquals)exp).getLeftExpression(), plainSelect);
            if (sLeft == null) {
                return null;
            }
            String sRight = ParsedSqlUtil.getFilterByHaving(((MinorThanEquals)exp).getRightExpression(), plainSelect);
            result.append(sLeft).append(" <= ").append(sRight);
        } else {
            if (ParsedSqlUtil.isConstant(exp)) {
                return exp.toString();
            }
            return ParsedSqlUtil.getColumnNameInSelectItems(exp, plainSelect);
        }
        return result.toString();
    }

    public static String getColumnNameInSelectItems(Expression exp, PlainSelect plainSelect) {
        if (exp instanceof Parenthesis) {
            exp = ((Parenthesis)exp).getExpression();
        }
        String expName = exp.toString();
        if (exp instanceof Column) {
            expName = ((Column)exp).getColumnName();
        }
        List selectItems = plainSelect.getSelectItems();
        for (Object selectItem : selectItems) {
            if (!(selectItem instanceof SelectExpressionItem)) continue;
            Expression itemExp = ((SelectExpressionItem)selectItem).getExpression();
            if (itemExp instanceof Parenthesis) {
                itemExp = ((Parenthesis)itemExp).getExpression();
            }
            if (itemExp instanceof Function && exp instanceof Function) {
                if (!((Function)itemExp).toString().equalsIgnoreCase(expName)) continue;
                return ((SelectExpressionItem)selectItem).getAlias();
            }
            if (itemExp instanceof Column && exp instanceof Column && ((Column)itemExp).getColumnName().equalsIgnoreCase(expName)) {
                return ((SelectExpressionItem)selectItem).getAlias() != null ? ((SelectExpressionItem)selectItem).getAlias() : ((Column)exp).getColumnName();
            }
            if (itemExp instanceof CaseExpression) {
                if (!itemExp.toString().equalsIgnoreCase(expName)) continue;
                return ((SelectExpressionItem)selectItem).getAlias();
            }
            String sAlias = ((SelectExpressionItem)selectItem).getAlias();
            if (sAlias == null || !sAlias.equalsIgnoreCase(expName)) continue;
            return expName;
        }
        LogSvr.getInstance().debug("\u672a\u627e\u5230\uff1a" + exp + "\uff0c\u5728" + plainSelect);
        return null;
    }

    public static Expression getFirstExpressionFromAnds(AndExpression andExpression) {
        Expression left = andExpression.getLeftExpression();
        if (left instanceof AndExpression) {
            return ParsedSqlUtil.getFirstExpressionFromAnds((AndExpression)left);
        }
        return left;
    }

    public static Expression removeFirstExpressionFromAnds(AndExpression andExpression) {
        Expression left = andExpression.getLeftExpression();
        if (left instanceof AndExpression) {
            Expression rightInLeft = ParsedSqlUtil.removeFirstExpressionFromAnds((AndExpression)left);
            AndExpression result = new AndExpression(rightInLeft, andExpression.getRightExpression());
            return result;
        }
        return andExpression.getRightExpression();
    }

    public static Expression removeFirstExpressionFromAnds(Expression expression, Expression firstExpression) {
        if (expression instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)expression;
            Expression left = andExpression.getLeftExpression();
            if (left instanceof AndExpression) {
                Expression rightInLeft = ParsedSqlUtil.removeFirstExpressionFromAnds((AndExpression)left, firstExpression);
                AndExpression result = new AndExpression(rightInLeft, andExpression.getRightExpression());
                return result;
            }
            if (left.toString().equals(firstExpression.toString())) {
                return andExpression.getRightExpression();
            }
            return andExpression;
        }
        if (expression == firstExpression) {
            return null;
        }
        return expression;
    }

    public static boolean addSelectItem(PlainSelect plainSelect, SelectItem selectExpressionItem) {
        ArrayList<SelectItem> selectItems = plainSelect.getSelectItems();
        if (selectItems == null) {
            selectItems = new ArrayList<SelectItem>();
            plainSelect.setSelectItems(selectItems);
        }
        String columnName = ParsedSqlUtil.getSelectItemShortName(selectExpressionItem);
        int i = 0;
        int size = selectItems.size();
        while (i < size) {
            SelectItem curSelectItem = (SelectItem)selectItems.get(i);
            if (curSelectItem.equals(selectExpressionItem)) {
                return false;
            }
            if (columnName != null && columnName.equalsIgnoreCase(ParsedSqlUtil.getSelectItemShortName(curSelectItem))) {
                return false;
            }
            ++i;
        }
        selectItems.add(selectExpressionItem);
        return true;
    }

    public static String getSelectItemShortName(SelectItem selectItem) {
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem tmp = (SelectExpressionItem)selectItem;
            if (tmp.getAlias() != null) {
                return tmp.getAlias();
            }
            if (tmp.getExpression() instanceof Column) {
                return ((Column)tmp.getExpression()).getColumnName();
            }
        }
        return null;
    }

    public static SubSelect getSubSelectInExpression(Expression expression, Column column) {
        if (expression == null) {
            return null;
        }
        ArrayList<SubSelect> allSubSelects = new ArrayList<SubSelect>();
        ParsedSqlUtil.getAllSubSelects(expression, allSubSelects);
        for (SubSelect subSelect : allSubSelects) {
            PlainSelect plainSelect = (PlainSelect)subSelect.getSelectBody();
            if (!ParsedSqlUtil.isUseTable((Expression)column, plainSelect.getFromItem())) continue;
            return subSelect;
        }
        return null;
    }

    private static void getAllSubSelects(Expression exp, List<SubSelect> allSubSelects) {
        if (exp instanceof Parenthesis) {
            ParsedSqlUtil.getAllSubSelects(((Parenthesis)exp).getExpression(), allSubSelects);
        } else if (exp instanceof BinaryExpression) {
            ParsedSqlUtil.getAllSubSelects(((BinaryExpression)exp).getLeftExpression(), allSubSelects);
            ParsedSqlUtil.getAllSubSelects(((BinaryExpression)exp).getRightExpression(), allSubSelects);
        } else if (exp instanceof InExpression) {
            ItemsList itemList = ((InExpression)exp).getItemsList();
            if (itemList instanceof SubSelect) {
                allSubSelects.add((SubSelect)itemList);
                PlainSelect plainSelect = (PlainSelect)((SubSelect)itemList).getSelectBody();
                ParsedSqlUtil.getAllSubSelects(plainSelect.getWhere(), allSubSelects);
            }
        } else if (exp instanceof SubSelect) {
            allSubSelects.add((SubSelect)exp);
            PlainSelect plainSelect = (PlainSelect)((SubSelect)exp).getSelectBody();
            ParsedSqlUtil.getAllSubSelects(plainSelect.getWhere(), allSubSelects);
        }
    }

    public static Expression removeAndReturnWhereOfTable(PlainSelect plainSelect, FromItem table) {
        Expression whereExpression = plainSelect.getWhere();
        ArrayList<Expression> whereOfTables = new ArrayList<Expression>();
        whereExpression = ParsedSqlUtil.removeAndReturnWhereOfTable(whereExpression, table, whereOfTables);
        plainSelect.setWhere(whereExpression);
        Expression result = null;
        int size = whereOfTables.size();
        if (size > 0) {
            result = (Expression)whereOfTables.get(0);
        }
        int i = 1;
        while (i < size) {
            result = ParsedSqlUtil.newAndExpression(result, (Expression)whereOfTables.get(i));
            ++i;
        }
        return result;
    }

    private static Expression removeAndReturnWhereOfTable(Expression whereExpression, FromItem table, List<Expression> whereOfTables) {
        Expression result;
        if (whereExpression instanceof AndExpression) {
            Expression orgLeft = ((AndExpression)whereExpression).getLeftExpression();
            Expression left = ParsedSqlUtil.removeAndReturnWhereOfTable(orgLeft, table, whereOfTables);
            Expression orgRight = ((AndExpression)whereExpression).getRightExpression();
            Expression right = ParsedSqlUtil.removeAndReturnWhereOfTable(orgRight, table, whereOfTables);
            result = left == null && right == null ? null : (left == null ? right : (right == null ? left : (left == orgLeft && right == orgRight ? whereExpression : ParsedSqlUtil.newAndExpression(left, right))));
        } else if (whereExpression instanceof BinaryExpression || whereExpression instanceof InExpression || whereExpression instanceof Between) {
            if (ParsedSqlUtil.isUseTable(whereExpression, table)) {
                whereOfTables.add(whereExpression);
                result = null;
            } else {
                result = whereExpression;
            }
        } else if (whereExpression instanceof Parenthesis) {
            if (ParsedSqlUtil.isUseTable(whereExpression, table)) {
                whereOfTables.add(whereExpression);
                result = null;
            } else {
                result = whereExpression;
            }
        } else {
            result = whereExpression;
        }
        return result;
    }

    public static Expression removeExpressionFromAnds(Expression whereExpression, List<FromItem> tables) {
        Object result;
        if (whereExpression instanceof AndExpression) {
            Expression orgLeft = ((AndExpression)whereExpression).getLeftExpression();
            Expression left = ParsedSqlUtil.removeExpressionFromAnds(orgLeft, tables);
            Expression orgRight = ((AndExpression)whereExpression).getRightExpression();
            Expression right = ParsedSqlUtil.removeExpressionFromAnds(orgRight, tables);
            result = left == null && right == null ? null : (left == null ? right : (right == null ? left : (left == orgLeft && right == orgRight ? whereExpression : ParsedSqlUtil.newAndExpression(left, right))));
        } else {
            result = whereExpression instanceof BinaryExpression || whereExpression instanceof InExpression ? (ParsedSqlUtil.isUseTable(whereExpression, tables) ? null : whereExpression) : (whereExpression instanceof Parenthesis ? (ParsedSqlUtil.isUseTable(whereExpression, tables) ? null : whereExpression) : whereExpression);
        }
        return result;
    }

    public static boolean existInExpression(PlainSelect plainSelect, InExpression inExpression) {
        Expression whereExpression = plainSelect.getWhere();
        return ParsedSqlUtil.existInExpression(whereExpression, inExpression);
    }

    private static boolean existInExpression(Expression whereExpression, InExpression inExpression) {
        if (whereExpression instanceof InExpression) {
            SelectBody selectBody;
            if (whereExpression == inExpression) {
                return true;
            }
            ItemsList itemList = ((InExpression)whereExpression).getItemsList();
            if (itemList instanceof SubSelect && (selectBody = ((SubSelect)itemList).getSelectBody()) instanceof PlainSelect) {
                return ParsedSqlUtil.existInExpression((PlainSelect)selectBody, inExpression);
            }
        } else {
            if (whereExpression instanceof Parenthesis) {
                return ParsedSqlUtil.existInExpression(((Parenthesis)whereExpression).getExpression(), inExpression);
            }
            if (whereExpression instanceof AndExpression) {
                AndExpression andExpression = (AndExpression)whereExpression;
                return ParsedSqlUtil.existInExpression(andExpression.getLeftExpression(), inExpression) || ParsedSqlUtil.existInExpression(andExpression.getRightExpression(), inExpression);
            }
        }
        return false;
    }

    public static boolean hasUnionInSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem instanceof SubSelect) {
                SubSelect subSelect = (SubSelect)fromItem;
                return ParsedSqlUtil.hasUnionInSelectBody(subSelect.getSelectBody());
            }
        } else if (selectBody instanceof Union) {
            return true;
        }
        return false;
    }

    public static Distinct findDistinctByFromItem(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            Distinct distinct = plainSelect.getDistinct();
            if (distinct == null) {
                FromItem fromItem = plainSelect.getFromItem();
                if (fromItem instanceof SubSelect) {
                    SubSelect subSelect = (SubSelect)fromItem;
                    return ParsedSqlUtil.findDistinctByFromItem(subSelect.getSelectBody());
                }
                return null;
            }
            return distinct;
        }
        if (selectBody instanceof Union) {
            return null;
        }
        return null;
    }

    public static boolean hasStatisticalFunction(List<?> selectItems) {
        for (Object tmp : selectItems) {
            if (!(tmp instanceof SelectExpressionItem) || !ParsedSqlUtil.hasStatisticalFunction(((SelectExpressionItem)tmp).getExpression())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasStatisticalFunction(Expression exp) {
        final RefObject result = new RefObject((Object)false);
        exp.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(Function function) {
                if (function.getName().equalsIgnoreCase("sum") || function.getName().equalsIgnoreCase("max") || function.getName().equalsIgnoreCase("min") || function.getName().equalsIgnoreCase("avg")) {
                    result.setValue((Object)true);
                }
            }
        });
        return (Boolean)result.getValue();
    }

    public static List<?> cloneList(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ISqlElement> newList = new ArrayList<ISqlElement>(list.size());
        int i = 0;
        int size = list.size();
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof OrderByElement) {
                OrderByElement newItem = new OrderByElement();
                newItem.setExpression(ParsedSqlUtil.cloneExpression(((OrderByElement)obj).getExpression()));
                newItem.setAsc(((OrderByElement)obj).isAsc());
                newList.add(newItem);
            } else if (obj instanceof Expression) {
                newList.add(ParsedSqlUtil.cloneExpression((Expression)obj));
            } else if (obj instanceof AllColumns) {
                newList.add(new AllColumns());
            } else if (obj instanceof AllTableColumns) {
                newList.add(new AllTableColumns(((AllTableColumns)obj).getTable()));
            } else if (obj instanceof SelectExpressionItem) {
                SelectExpressionItem tmp = (SelectExpressionItem)obj;
                SelectExpressionItem newItem = new SelectExpressionItem(ParsedSqlUtil.cloneExpression(tmp.getExpression()));
                if (tmp.getAlias() != null) {
                    newItem.setAlias(tmp.getAlias());
                }
                newList.add(newItem);
            } else if (obj instanceof Join) {
                newList.add(ParsedSqlUtil.cloneJoin((Join)obj));
            } else {
                throw new RuntimeException("\u5206\u5e93\u9519\u8bef\uff0c\u6df1\u5ea6\u590d\u5236\u8868\u8fbe\u5f0f\u5217\u8868\u4e0d\u652f\u6301 " + obj + "\u3002");
            }
            ++i;
        }
        return newList;
    }

    public static ItemsList cloneItemList(ItemsList itemsList) {
        if (itemsList instanceof ExpressionList) {
            ExpressionList result = new ExpressionList();
            result.setExpressions(ParsedSqlUtil.cloneList(((ExpressionList)itemsList).getExpressions()));
            return result;
        }
        if (itemsList instanceof SubSelect) {
            return (SubSelect)ParsedSqlUtil.cloneExpression((SubSelect)itemsList);
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u6df1\u5ea6\u590d\u5236\u8868\u8fbe\u5f0f\u5bf9\u8c61\u672a\u652f\u6301\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff0c" + itemsList + "\u3002");
    }

    public static Expression cloneExpression(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (exp instanceof LongValue) {
            return new LongValue(((LongValue)exp).getStringValue());
        }
        if (exp instanceof DoubleValue) {
            return new DoubleValue(((DoubleValue)exp).getStringValue());
        }
        if (exp instanceof StringValue) {
            return new StringValue(((StringValue)exp).getValue());
        }
        if (exp instanceof DateValue) {
            return new DateValue(((DateValue)exp).getValue());
        }
        if (exp instanceof Column) {
            Table table;
            Table orgTable = ((Column)exp).getTable();
            Table table2 = table = orgTable != null ? new Table(null, orgTable.getName()) : null;
            assert (orgTable == null || orgTable.getAlias() == null);
            Column result = new Column(table, ((Column)exp).getColumnName()).setExtendSameFromItem((Column)exp);
            result.setKeyWordEscapeStart(((Column)exp).getKeyWordEscapeStart());
            result.setKeyWordEscapeEnd(((Column)exp).getKeyWordEscapeEnd());
            return result;
        }
        if (exp instanceof Parenthesis) {
            return new Parenthesis(ParsedSqlUtil.cloneExpression(((Parenthesis)exp).getExpression()));
        }
        if (exp instanceof BinaryExpression) {
            BinaryExpression binaryExp = (BinaryExpression)exp;
            if (exp instanceof AndExpression) {
                return new AndExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()), ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
            }
            if (exp instanceof OrExpression) {
                return new OrExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()), ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
            }
            if (exp instanceof Addition) {
                Addition result = new Addition();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof Subtraction) {
                Subtraction result = new Subtraction();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof Multiplication) {
                Multiplication result = new Multiplication();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof Modulo) {
                Modulo result = new Modulo();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof Modulo) {
                Modulo result = new Modulo();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof EqualsTo) {
                EqualsTo result = new EqualsTo();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof NotEqualsTo) {
                NotEqualsTo result = new NotEqualsTo();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof GreaterThan) {
                GreaterThan result = new GreaterThan();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof GreaterThanEquals) {
                GreaterThanEquals result = new GreaterThanEquals();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof MinorThan) {
                MinorThan result = new MinorThan();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof MinorThanEquals) {
                MinorThanEquals result = new MinorThanEquals();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(binaryExp.getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(binaryExp.getRightExpression()));
                return result;
            }
            if (exp instanceof LikeExpression) {
                LikeExpression result = new LikeExpression();
                result.setEscape(((LikeExpression)exp).getEscape());
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(((LikeExpression)exp).getLeftExpression()));
                result.setRightExpression(ParsedSqlUtil.cloneExpression(((LikeExpression)exp).getRightExpression()));
                return result;
            }
            if (exp instanceof Division) {
                Division result = new Division();
                result.setLeftExpression(((Division)exp).getLeftExpression());
                result.setRightExpression(((Division)exp).getRightExpression());
                return result;
            }
        } else {
            if (exp instanceof CaseExpression) {
                CaseExpression result = new CaseExpression();
                result.setSwitchExpression(ParsedSqlUtil.cloneExpression(((CaseExpression)exp).getSwitchExpression()));
                List whenClauses = ((CaseExpression)exp).getWhenClauses();
                ArrayList<Expression> newWhenClauses = new ArrayList<Expression>(whenClauses.size());
                for (Object tmp : whenClauses) {
                    newWhenClauses.add(ParsedSqlUtil.cloneExpression((Expression)tmp));
                }
                result.setWhenClauses(newWhenClauses);
                result.setElseExpression(ParsedSqlUtil.cloneExpression(((CaseExpression)exp).getElseExpression()));
                return result;
            }
            if (exp instanceof WhenClause) {
                WhenClause result = new WhenClause();
                result.setWhenExpression(ParsedSqlUtil.cloneExpression(((WhenClause)exp).getWhenExpression()));
                result.setThenExpression(ParsedSqlUtil.cloneExpression(((WhenClause)exp).getThenExpression()));
                return result;
            }
            if (exp instanceof Function) {
                Function result = new Function();
                result.setName(((Function)exp).getName());
                if (((Function)exp).isAllColumns()) {
                    result.setAllColumns(true);
                } else if (((Function)exp).getParameters() != null) {
                    List expList = ((Function)exp).getParameters().getExpressions();
                    ArrayList<Expression> newExpList = new ArrayList<Expression>(expList.size());
                    result.setParameters(new ExpressionList(newExpList));
                    int i = 0;
                    int size = expList.size();
                    while (i < size) {
                        newExpList.add(ParsedSqlUtil.cloneExpression((Expression)expList.get(i)));
                        ++i;
                    }
                }
                return result;
            }
            if (exp instanceof IsNullExpression) {
                IsNullExpression result = new IsNullExpression();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(((IsNullExpression)exp).getLeftExpression()));
                return result;
            }
            if (exp instanceof InExpression) {
                InExpression result = new InExpression();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(((InExpression)exp).getLeftExpression()));
                result.setItemsList(ParsedSqlUtil.cloneItemList(((InExpression)exp).getItemsList()));
                return result;
            }
            if (exp instanceof Between) {
                Between result = new Between();
                result.setLeftExpression(ParsedSqlUtil.cloneExpression(((Between)exp).getLeftExpression()));
                result.setBetweenExpressionStart(ParsedSqlUtil.cloneExpression(((Between)exp).getBetweenExpressionStart()));
                result.setBetweenExpressionEnd(ParsedSqlUtil.cloneExpression(((Between)exp).getBetweenExpressionEnd()));
                return result;
            }
            if (exp instanceof JdbcParameter) {
                return exp;
            }
            if (exp instanceof SubSelect) {
                SubSelect result = new SubSelect();
                result.setSelectBody(ParsedSqlUtil.cloneSelectBody(((SubSelect)exp).getSelectBody()));
                if (((SubSelect)exp).getAlias() != null) {
                    result.setAlias(((SubSelect)exp).getAlias());
                }
                return result;
            }
            if (exp instanceof InverseExpression) {
                InverseExpression result = new InverseExpression();
                result.setExpression(ParsedSqlUtil.cloneExpression(((InverseExpression)exp).getExpression()));
                return result;
            }
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u6df1\u5ea6\u590d\u5236\u8868\u8fbe\u5f0f\u5bf9\u8c61\u672a\u652f\u6301\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
    }

    private static SelectBody cloneSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect org = (PlainSelect)selectBody;
            PlainSelect result = new PlainSelect();
            result.setSelectItems(ParsedSqlUtil.cloneList(org.getSelectItems()));
            result.setDistinct(org.getDistinct());
            result.setFromItem(ParsedSqlUtil.cloneFromItem(org.getFromItem()));
            result.setJoins(ParsedSqlUtil.cloneList(org.getJoins()));
            result.setWhere(ParsedSqlUtil.cloneExpression(org.getWhere()));
            result.setHaving(ParsedSqlUtil.cloneExpression(org.getHaving()));
            result.setGroupByColumnReferences(ParsedSqlUtil.cloneList(org.getGroupByColumnReferences()));
            result.setOrderByElements(ParsedSqlUtil.cloneList(org.getOrderByElements()));
            result.setLimit(ParsedSqlUtil.cloneLimit(org.getLimit()));
            if (org.isNoSplit()) {
                result.setNoSplit(true);
            }
            return result;
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u6df1\u5ea6\u590d\u5236\u4e0d\u652f\u6301Union\u3002\uff0c" + selectBody + "\u3002");
    }

    private static Limit cloneLimit(Limit limit) {
        if (limit == null) {
            return null;
        }
        Limit result = new Limit(limit);
        return result;
    }

    private static FromItem cloneFromItem(FromItem fromItem) {
        if (fromItem instanceof SubJoin) {
            SubJoin result = new SubJoin();
            SubJoin org = (SubJoin)fromItem;
            result.setLeft(ParsedSqlUtil.cloneFromItem(org.getLeft()));
            result.setJoin(ParsedSqlUtil.cloneJoin(org.getJoin()));
            if (org.getAlias() != null) {
                result.setAlias(org.getAlias());
            }
            return result;
        }
        if (fromItem instanceof SubSelect) {
            SubSelect result = new SubSelect();
            SubSelect org = (SubSelect)fromItem;
            result.setSelectBody(ParsedSqlUtil.cloneSelectBody(org.getSelectBody()));
            if (org.getAlias() != null) {
                result.setAlias(org.getAlias());
            }
            return result;
        }
        Table result = new Table();
        Table org = (Table)fromItem;
        if (org.getSchemaName() != null) {
            result.setSchemaName(org.getSchemaName());
        }
        result.setName(org.getName());
        if (org.getAlias() != null) {
            result.setAlias(org.getAlias());
        }
        return result;
    }

    private static Join cloneJoin(Join join) {
        Join result = new Join();
        result.setRightItem(ParsedSqlUtil.cloneFromItem(join.getRightItem()));
        result.setOnExpression(ParsedSqlUtil.cloneExpression(join.getOnExpression()));
        result.setInner(join.isInner());
        result.setLeft(join.isLeft());
        result.setRight(join.isRight());
        result.setOuter(join.isOuter());
        result.setFull(join.isFull());
        return result;
    }

    public static String getNameWithoutKeyWordEscape(String name) {
        int length;
        int n = length = name == null ? 0 : name.length();
        if (length > 2) {
            char first = name.charAt(0);
            char end = name.charAt(length - 1);
            if (!(first != '`' && first != '[' && first != '\"' || end != '`' && end != ']' && end != '\"')) {
                return name.substring(1, length - 1);
            }
        }
        return name;
    }

    public static boolean isSameNameMaybeWithKeyWordEscape(String name1, String name2) {
        return ParsedSqlUtil.getNameWithoutKeyWordEscape(name1).equalsIgnoreCase(ParsedSqlUtil.getNameWithoutKeyWordEscape(name2));
    }

    public static void removeJoin(PlainSelect plainSelect, Join join) {
        Iterator it = plainSelect.getJoins().iterator();
        while (it.hasNext()) {
            if (it.next() != join) continue;
            it.remove();
        }
    }

    public static SubSelect genSubSelect0() {
        PlainSelect plainSelect = new PlainSelect();
        ArrayList<SelectExpressionItem> selectItems = new ArrayList<SelectExpressionItem>(1);
        selectItems.add(new SelectExpressionItem(new LongValue("0")));
        plainSelect.setSelectItems(selectItems);
        SubSelect result = new SubSelect();
        result.setSelectBody(plainSelect);
        result.setAlias("TmpOnlyOneRow");
        return result;
    }

    public static Column getOneColumnByExpression(Expression exp) {
        if (exp == null) {
            return null;
        }
        RefObject ref = new RefObject(null);
        exp.traversal(elem -> {
            if (elem instanceof Column) {
                ref.setValue((Object)((Column)elem));
                return false;
            }
            return true;
        });
        return (Column)ref.getValue();
    }

    public static Expression getRealExpression(Expression expression, AbstractQuerySource<?> source) {
        AbstractSqlElement elem;
        if (source != null && expression instanceof Column && (elem = source.getResultItem((Column)expression)) instanceof SelectExpressionItem) {
            return ((SelectExpressionItem)elem).getExpression();
        }
        return expression;
    }

    public static SelectExpressionItem getRealSelectItem(Expression expression, AbstractQuerySource<?> source) {
        AbstractSqlElement elem;
        if (source != null && expression instanceof Column && (elem = source.getResultItem((Column)expression)) instanceof SelectExpressionItem) {
            return (SelectExpressionItem)elem;
        }
        return null;
    }

    public static boolean isSelectItem(String columnName, AbstractQuerySource<?> source) {
        if (source == null) {
            return false;
        }
        return source.isResultColumn(columnName);
    }

    public static SelectExpressionItem getSelectItem(Column column, AbstractQuerySource<?> source) {
        if (source == null || column == null) {
            return null;
        }
        return (SelectExpressionItem)source.getResultItem(column);
    }

    public static void findTablesByWhereExpressionExceptIsNull(PlainSelect subPlainSelect, Expression expression, List<FromItem> findTables) {
        if (expression == null) {
            return;
        }
        if (expression instanceof Parenthesis) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Parenthesis)expression).getExpression(), findTables);
        } else if (expression instanceof AndExpression) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((AndExpression)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((AndExpression)expression).getRightExpression(), findTables);
        } else if (expression instanceof EqualsTo) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((EqualsTo)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((EqualsTo)expression).getRightExpression(), findTables);
        } else if (expression instanceof NotEqualsTo) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((NotEqualsTo)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((NotEqualsTo)expression).getRightExpression(), findTables);
        } else if (expression instanceof GreaterThan) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((GreaterThan)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((GreaterThan)expression).getRightExpression(), findTables);
        } else if (expression instanceof Addition) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Addition)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Addition)expression).getRightExpression(), findTables);
        } else if (expression instanceof Subtraction) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Subtraction)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Subtraction)expression).getRightExpression(), findTables);
        } else if (expression instanceof Multiplication) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Multiplication)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Multiplication)expression).getRightExpression(), findTables);
        } else if (expression instanceof Division) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Division)expression).getLeftExpression(), findTables);
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Division)expression).getRightExpression(), findTables);
        } else if (expression instanceof InExpression) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((InExpression)expression).getLeftExpression(), findTables);
        } else if (expression instanceof Between) {
            ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Between)expression).getLeftExpression(), findTables);
        } else if (!(expression instanceof IsNullExpression)) {
            FromItem fromItem;
            if (expression instanceof Function) {
                String functionName = ((Function)expression).getName();
                if (!functionName.equalsIgnoreCase("ifnull") && !functionName.equalsIgnoreCase("coalesce")) {
                    for (Object parameter : ((Function)expression).getParameters().getExpressions()) {
                        ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, (Expression)parameter, findTables);
                    }
                }
            } else if (expression instanceof Column && (fromItem = ((Column)expression).getExtendFromItem()) != null) {
                boolean fromItemInSubPlainSelect;
                boolean bl = fromItemInSubPlainSelect = fromItem == subPlainSelect.getFromItem();
                if (!fromItemInSubPlainSelect && subPlainSelect.getJoins() != null) {
                    for (Object join : subPlainSelect.getJoins()) {
                        if (((Join)join).getRightItem() != fromItem) continue;
                        fromItemInSubPlainSelect = true;
                        break;
                    }
                }
                if (fromItemInSubPlainSelect) {
                    if (!findTables.contains(fromItem)) {
                        findTables.add(fromItem);
                    }
                } else if (((Column)expression).getExtendSelectItem() != null) {
                    ParsedSqlUtil.findTablesByWhereExpressionExceptIsNull(subPlainSelect, ((Column)expression).getExtendSelectItem().getExpression(), findTables);
                }
            }
        }
    }

    public static SelectItem findSelectItemByColumnOrExpression(PlainSelect plainSelect, Expression exp, boolean isForChangeField, boolean isOnlyFirstLevel, RefObject<PlainSelect> inSelect) {
        if (exp instanceof Column) {
            return ((Column)exp).getExtendSelectItem();
        }
        List selectItems = plainSelect.getSelectItems();
        String expString = exp.toString();
        int i = 0;
        int size = selectItems == null ? 0 : selectItems.size();
        while (i < size) {
            SelectItem selectItem = (SelectItem)selectItems.get(i);
            if (selectItem instanceof SelectExpressionItem && expString.equalsIgnoreCase(((SelectExpressionItem)selectItem).getExpression().toString())) {
                if (inSelect != null) {
                    inSelect.setValue((Object)plainSelect);
                }
                return selectItem;
            }
            ++i;
        }
        return null;
    }

    public static Expression findOnExpression(FromItem table, Expression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof Parenthesis) {
            return ParsedSqlUtil.findOnExpression(table, ((Parenthesis)expression).getExpression());
        }
        if (expression instanceof AndExpression) {
            Expression result = ParsedSqlUtil.findOnExpression(table, ((AndExpression)expression).getLeftExpression());
            if (result == null) {
                result = ParsedSqlUtil.findOnExpression(table, ((AndExpression)expression).getRightExpression());
            }
            return result;
        }
        if (expression instanceof EqualsTo) {
            if (ParsedSqlUtil.isColumnInTable(((EqualsTo)expression).getLeftExpression(), table)) {
                return ((EqualsTo)expression).getLeftExpression();
            }
            if (ParsedSqlUtil.isColumnInTable(((EqualsTo)expression).getRightExpression(), table)) {
                return ((EqualsTo)expression).getRightExpression();
            }
        } else {
            if (expression instanceof GreaterThan) {
                Expression result = ParsedSqlUtil.findOnExpression(table, ((GreaterThan)expression).getLeftExpression());
                if (result == null) {
                    result = ParsedSqlUtil.findOnExpression(table, ((GreaterThan)expression).getRightExpression());
                }
                return result;
            }
            if (expression instanceof Addition) {
                Expression result = ParsedSqlUtil.findOnExpression(table, ((Addition)expression).getLeftExpression());
                if (result == null) {
                    result = ParsedSqlUtil.findOnExpression(table, ((Addition)expression).getRightExpression());
                }
                return result;
            }
            if (expression instanceof Column && ParsedSqlUtil.isColumnInTable(expression, table)) {
                return expression;
            }
        }
        return null;
    }

    public static boolean isExistColumn(String columnName, Expression exp) {
        if (exp instanceof Parenthesis) {
            return ParsedSqlUtil.isExistColumn(columnName, ((Parenthesis)exp).getExpression());
        }
        if (exp instanceof CaseExpression) {
            List whenClauses = ((CaseExpression)exp).getWhenClauses();
            for (WhenClause whenExp : whenClauses) {
                if (!ParsedSqlUtil.isExistColumn(columnName, whenExp)) continue;
                return true;
            }
            return ParsedSqlUtil.isExistColumn(columnName, ((CaseExpression)exp).getElseExpression());
        }
        if (exp instanceof WhenClause) {
            return ParsedSqlUtil.isExistColumn(columnName, ((WhenClause)exp).getThenExpression()) || ParsedSqlUtil.isExistColumn(columnName, ((WhenClause)exp).getWhenExpression());
        }
        if (exp instanceof Column) {
            Column column = (Column)exp;
            if (columnName.equalsIgnoreCase(column.getWholeColumnName()) || columnName.equalsIgnoreCase(column.getColumnName())) {
                return true;
            }
        } else if (exp instanceof BinaryExpression) {
            return ParsedSqlUtil.isExistColumn(columnName, ((BinaryExpression)exp).getLeftExpression()) || ParsedSqlUtil.isExistColumn(columnName, ((BinaryExpression)exp).getRightExpression());
        }
        return false;
    }

    public static PlainSelect getPlainSelectByTable(PlainSelect plainSelect, Table table) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table && ((Table)fromItem).getAliasName().equalsIgnoreCase(table.toString())) {
            return plainSelect;
        }
        if (fromItem instanceof SubSelect) {
            if (fromItem.getAlias().equalsIgnoreCase(table.toString())) {
                return plainSelect;
            }
            return ParsedSqlUtil.getPlainSelectByTable((SubSelect)fromItem, table);
        }
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Object join : joins) {
                fromItem = ((Join)join).getRightItem();
                if (fromItem instanceof Table && ((Table)fromItem).getAliasName().equalsIgnoreCase(table.toString())) {
                    return plainSelect;
                }
                if (!(fromItem instanceof SubSelect)) continue;
                if (fromItem.getAlias().equalsIgnoreCase(table.toString())) {
                    return plainSelect;
                }
                return ParsedSqlUtil.getPlainSelectByTable((SubSelect)fromItem, table);
            }
        }
        return ParsedSqlUtil.getPlainSelectByTable(plainSelect.getWhere(), table);
    }

    private static PlainSelect getPlainSelectByTable(SubSelect subSelect, Table table) {
        List list;
        Iterator iterator;
        SelectBody selectBody = subSelect.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            return ParsedSqlUtil.getPlainSelectByTable((PlainSelect)selectBody, table);
        }
        if (selectBody instanceof Union && (iterator = (list = ((Union)selectBody).getPlainSelects()).iterator()).hasNext()) {
            Object tmp = iterator.next();
            return ParsedSqlUtil.getPlainSelectByTable((PlainSelect)tmp, table);
        }
        return null;
    }

    private static PlainSelect getPlainSelectByTable(Expression whereExpression, Table table) {
        if (whereExpression instanceof InExpression) {
            ItemsList itemList = ((InExpression)whereExpression).getItemsList();
            if (itemList instanceof SubSelect) {
                return ParsedSqlUtil.getPlainSelectByTable((SubSelect)itemList, table);
            }
        } else {
            if (whereExpression instanceof Parenthesis) {
                return ParsedSqlUtil.getPlainSelectByTable(((Parenthesis)whereExpression).getExpression(), table);
            }
            if (whereExpression instanceof BinaryExpression) {
                BinaryExpression andExpression = (BinaryExpression)whereExpression;
                PlainSelect result = ParsedSqlUtil.getPlainSelectByTable(andExpression.getLeftExpression(), table);
                if (result != null) {
                    return result;
                }
                return ParsedSqlUtil.getPlainSelectByTable(andExpression.getRightExpression(), table);
            }
        }
        return null;
    }

    public static boolean isUseTable(Expression expression, FromItem fromItem) {
        if (expression instanceof Parenthesis) {
            return ParsedSqlUtil.isUseTable(((Parenthesis)expression).getExpression(), fromItem);
        }
        if (expression instanceof AndExpression) {
            return ParsedSqlUtil.isUseTable(((AndExpression)expression).getLeftExpression(), fromItem) || ParsedSqlUtil.isUseTable(((AndExpression)expression).getRightExpression(), fromItem);
        }
        if (expression instanceof OrExpression) {
            return ParsedSqlUtil.isUseTable(((OrExpression)expression).getLeftExpression(), fromItem) || ParsedSqlUtil.isUseTable(((OrExpression)expression).getRightExpression(), fromItem);
        }
        if (expression instanceof InExpression) {
            return ParsedSqlUtil.isUseTable(((InExpression)expression).getLeftExpression(), fromItem);
        }
        if (expression instanceof Between) {
            return ParsedSqlUtil.isUseTable(((Between)expression).getLeftExpression(), fromItem);
        }
        if (expression instanceof BinaryExpression) {
            return ParsedSqlUtil.isUseTable(((BinaryExpression)expression).getLeftExpression(), fromItem) || ParsedSqlUtil.isUseTable(((BinaryExpression)expression).getRightExpression(), fromItem);
        }
        if (expression instanceof Column) {
            if (!(fromItem instanceof Table)) {
                return false;
            }
            return ParsedSqlUtil.isColumnInTable(expression, fromItem);
        }
        return false;
    }

    public static boolean isUseTable(Expression expression, List<FromItem> tables) {
        if (expression instanceof Parenthesis) {
            return ParsedSqlUtil.isUseTable(((Parenthesis)expression).getExpression(), tables);
        }
        if (expression instanceof AndExpression) {
            return ParsedSqlUtil.isUseTable(((AndExpression)expression).getLeftExpression(), tables) || ParsedSqlUtil.isUseTable(((AndExpression)expression).getRightExpression(), tables);
        }
        if (expression instanceof OrExpression) {
            return ParsedSqlUtil.isUseTable(((OrExpression)expression).getLeftExpression(), tables) || ParsedSqlUtil.isUseTable(((OrExpression)expression).getRightExpression(), tables);
        }
        if (expression instanceof InExpression) {
            return ParsedSqlUtil.isUseTable(((InExpression)expression).getLeftExpression(), tables);
        }
        if (expression instanceof BinaryExpression) {
            return ParsedSqlUtil.isUseTable(((BinaryExpression)expression).getLeftExpression(), tables) || ParsedSqlUtil.isUseTable(((BinaryExpression)expression).getRightExpression(), tables);
        }
        if (expression instanceof Column) {
            int i = 0;
            int size = tables != null ? tables.size() : 0;
            while (i < size) {
                if (((Column)expression).getExtendFromItem() == tables.get(i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public static EqualsTo findEqualsToInExpression(Expression expression, FromItem fromItem0, FromItem fromItem1) {
        if (expression instanceof Parenthesis) {
            return ParsedSqlUtil.findEqualsToInExpression(((Parenthesis)expression).getExpression(), fromItem0, fromItem1);
        }
        if (expression instanceof AndExpression) {
            EqualsTo equalsTo = ParsedSqlUtil.findEqualsToInExpression(((AndExpression)expression).getLeftExpression(), fromItem0, fromItem1);
            if (equalsTo != null) {
                return equalsTo;
            }
            return ParsedSqlUtil.findEqualsToInExpression(((AndExpression)expression).getRightExpression(), fromItem0, fromItem1);
        }
        if (expression instanceof EqualsTo && ((EqualsTo)expression).getLeftExpression() instanceof Column && ((EqualsTo)expression).getRightExpression() instanceof Column) {
            Column leftColumn = (Column)((EqualsTo)expression).getLeftExpression();
            Column rightColumn = (Column)((EqualsTo)expression).getRightExpression();
            if (leftColumn.getExtendFromItem() == fromItem0 && rightColumn.getExtendFromItem() == fromItem1 || leftColumn.getExtendFromItem() == fromItem1 && rightColumn.getExtendFromItem() == fromItem0) {
                return (EqualsTo)expression;
            }
        }
        return null;
    }

    public static Select getSelect(String sql) throws JSQLParserException {
        CCJSqlParserManager parser = new CCJSqlParserManager();
        return (Select)parser.parse(sql);
    }

    public static boolean hasGroupFunc(Expression expression) {
        RefObject refResult = new RefObject((Object)false);
        expression.traversal(elem -> {
            if (elem instanceof Function && ParsedSqlUtil.isGroupFunc((Function)elem)) {
                refResult.setValue((Object)true);
                return false;
            }
            return !(elem instanceof SubSelect);
        });
        return (Boolean)refResult.getValue();
    }

    public static boolean isGroupFunc(Expression expression) {
        if (expression instanceof Function) {
            String name = ((Function)expression).getName();
            return ParsedSqlUtil.isGroupFunc(name);
        }
        return false;
    }

    public static boolean isGroupFunc(String name) {
        return "sum".equalsIgnoreCase(name) || "max".equalsIgnoreCase(name) || "min".equalsIgnoreCase(name) || "avg".equalsIgnoreCase(name) || "count".equalsIgnoreCase(name);
    }

    public static String getFunctionName(Expression expression) {
        if (expression instanceof Function) {
            return ((Function)expression).getName();
        }
        return "";
    }

    public static boolean hasSelectColumnItem(Column column, List<?> selectItems) {
        for (Object item : selectItems) {
            if (!(item instanceof SelectExpressionItem)) continue;
            SelectExpressionItem selectItem = (SelectExpressionItem)item;
            return column.getColumnName().equalsIgnoreCase(selectItem.getColumnNameInResultSet());
        }
        return false;
    }

    public static String getFuncAlias(String sFunc) {
        String pattern = "[a-zA-Z0-9_]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(sFunc);
        StringBuilder sb = new StringBuilder(128);
        int index = 0;
        while (m.find() && index < 128) {
            sb.append(m.group());
            ++index;
        }
        return sb.toString();
    }

    public static Expression parseExpresssion(String sExp) throws JSQLParserException, ParseException {
        if (sExp == null || sExp.length() == 0) {
            throw new JSQLParserException("\u6267\u884c\u51fd\u6570\u4e3a\u7a7a\uff01");
        }
        CCJSqlParser parser = new CCJSqlParser(new StringReader(sExp));
        return parser.SimpleExpression();
    }

    public static void fetchFuncLinkedColumns(Function func, List<Column> linkedColumns) {
        ExpressionList paras = func.getParameters();
        if (paras == null) {
            return;
        }
        for (Object item : paras.getExpressions()) {
            ((Expression)item).traversal(elem -> {
                if (elem instanceof Column) {
                    linkedColumns.add((Column)elem);
                    return false;
                }
                return !(elem instanceof SubSelect);
            });
        }
    }

    public static boolean isColumnsInSameFromItem(List<Column> columns) {
        if (columns.size() == 0) {
            return true;
        }
        FromItem baseFromItem = columns.get(0).getFormItemAsTable();
        for (Column column : columns) {
            if (baseFromItem == column.getFormItemAsTable()) continue;
            return false;
        }
        return true;
    }

    public static List<Column> getAllGroupFunctionColumns(List<?> selectItems) {
        ArrayList<Column> groupFunctionColumns = new ArrayList<Column>();
        for (Object item : selectItems) {
            SelectExpressionItem selectItem;
            Expression expression;
            if (!(item instanceof SelectExpressionItem) || !ParsedSqlUtil.hasGroupFunc(expression = (selectItem = (SelectExpressionItem)item).getExpression())) continue;
            ParsedSqlUtil.fetchExpressionLinkedColumns(expression, groupFunctionColumns);
        }
        return groupFunctionColumns;
    }

    public static void fetchExpressionLinkedColumns(Expression expression, List<Column> linkedColumns) {
        expression.traversal(elem -> {
            if (elem instanceof Column) {
                linkedColumns.add((Column)elem);
                return false;
            }
            return !(elem instanceof SubSelect);
        });
    }

    public static boolean isGroupFunctionColumnsInSameFromItem(List<?> selectItems) {
        List<Column> groupFunctionColumns = ParsedSqlUtil.getAllGroupFunctionColumns(selectItems);
        return ParsedSqlUtil.isColumnsInSameFromItem(groupFunctionColumns);
    }

    public static Expression fetchWhereByColumn(PlainSelect plainSelect, String columnKey) {
        List joins;
        Expression where = plainSelect.getWhere();
        if (ParsedSqlUtil.containsColumnInExpression(columnKey, where)) {
            return where;
        }
        Expression result = null;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof SubSelect) {
            PlainSelect subPlainSelect = ParsedSqlUtil.getPlainSelect(((SubSelect)fromItem).getSelectBody());
            result = ParsedSqlUtil.fetchWhereByColumn(subPlainSelect, columnKey);
        }
        if (result == null && (joins = plainSelect.getJoins()) != null) {
            for (Object join : joins) {
                FromItem rightItem = ((Join)join).getRightItem();
                if (!(rightItem instanceof SubSelect)) continue;
                PlainSelect subPlainSelect = ParsedSqlUtil.getPlainSelect(((SubSelect)rightItem).getSelectBody());
                result = ParsedSqlUtil.fetchWhereByColumn(subPlainSelect, columnKey);
            }
        }
        return result;
    }

    public static boolean containsColumnInExpression(String columnKey, Expression expression) {
        if (expression == null || columnKey == null) {
            return false;
        }
        RefObject result = new RefObject((Object)false);
        expression.traversal(elem -> {
            if (elem instanceof Column && columnKey.equalsIgnoreCase(((Column)elem).getColumnName())) {
                result.setValue((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)result.getValue();
    }
}

