/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.resultset.SimpleDocumentDBUtil;
import com.bokesoft.yes.parser.BaseFunImpl;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class GroupsFunImplCluster
extends BaseFunImplCluster {
    private DataTable bk_companyCodeDataTable;

    private String getResult(int year, int period, Long companyCodeID) throws Throwable {
        String result = "";
        if (year < 2020) {
            result = "DB" + year;
        } else if (period < 3) {
            result = "DB" + year + String.format("%03d", period);
        } else {
            if (this.bk_companyCodeDataTable == null) {
                String dsnName = TableGroupProps.getInstance().getOneDSNName("BK_CompanyCode");
                Connection connection = null;
                Statement preparedStatement = null;
                ResultSet rs = null;
                try {
                    connection = MultiDBManager.getJDBCConnection(dsnName);
                    String sql = new StringBuilder(128).append("SELECT oid,groupvalue").append(" FROM ").append("BK_CompanyCode").toString();
                    preparedStatement = connection.prepareStatement(sql);
                    rs = preparedStatement.executeQuery();
                    this.bk_companyCodeDataTable = SimpleDocumentDBUtil.populate(rs);
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
            }
            String group = "";
            int pos = 0;
            int count = this.bk_companyCodeDataTable.size();
            while (pos < count) {
                if (this.bk_companyCodeDataTable.getLong(pos, 0).equals(companyCodeID)) {
                    group = this.bk_companyCodeDataTable.getString(pos, 1);
                    break;
                }
                ++pos;
            }
            result = "DB" + year + String.format("%03d", period) + "_" + group;
        }
        return result;
    }

    public Object[][] getImplTable() {
        return new Object[][]{{"ToUpper", new ToupperImpl()}, {"getDBNames", new getDBNamesImpl()}, {"getBalanceDBNames", new getBalanceDBNamesImpl()}, {"mod", new ModImpl()}};
    }

    class ModImpl
    extends BaseFunImpl {
        ModImpl() {
        }

        public Object eval(String name, IEvalContext context, Object[] args, IExecutor executor) throws Throwable {
            if (args.length != 2) {
                throw new RuntimeException("mod\u516c\u5f0f\u5fc5\u987b\u8981\u6709\u4e24\u4e2a\u53c2\u6570");
            }
            BigDecimal v1 = TypeConvertor.toBigDecimal((Object)args[0]);
            BigDecimal v2 = TypeConvertor.toBigDecimal((Object)args[1]);
            BigDecimal result = v1.remainder(v2);
            return TypeConvertor.toInteger((Object)result);
        }
    }

    class ToupperImpl
    extends BaseFunImpl {
        ToupperImpl() {
        }

        public Object eval(String name, IEvalContext context, Object[] args, IExecutor executor) throws Throwable {
            String value = TypeConvertor.toString((Object)args[0]);
            String result = value.toUpperCase();
            return result;
        }
    }

    class getBalanceDBNamesImpl
    extends BaseFunImpl {
        getBalanceDBNamesImpl() {
        }

        public Object eval(String name, IEvalContext context, Object[] args, IExecutor executor) throws Throwable {
            Long companyCodeID;
            Object arg = args[0];
            if (arg.getClass().getName().equalsIgnoreCase("java.util.ArrayList")) {
                ArrayList argList = (ArrayList)arg;
                companyCodeID = TypeConvertor.toLong(argList.get(0));
            } else {
                companyCodeID = TypeConvertor.toLong((Object)args[0]);
            }
            Long fiscalYearPeriod = TypeConvertor.toLong((Object)args[1]);
            int year = TypeConvertor.toInteger((Object)(fiscalYearPeriod / 1000L));
            int period = TypeConvertor.toInteger((Object)(fiscalYearPeriod % 10000L));
            String result = GroupsFunImplCluster.this.getResult(year, period, companyCodeID);
            return result;
        }
    }

    class getDBNamesImpl
    extends BaseFunImpl {
        getDBNamesImpl() {
        }

        public Object eval(String name, IEvalContext context, Object[] args, IExecutor executor) throws Throwable {
            int year = TypeConvertor.toInteger((Object)args[0]);
            int period = TypeConvertor.toInteger((Object)args[1]);
            Long companyCodeID = TypeConvertor.toLong((Object)args[2]);
            String result = GroupsFunImplCluster.this.getResult(year, period, companyCodeID);
            return result;
        }
    }
}

