/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.Node;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.RelationTable;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.route.service.ShardingRouteService;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Group {
    final String key;
    List<GroupField> groupFields;
    HashMapIgnoreCase<GroupTable> groupTables = new HashMapIgnoreCase();
    HashMapIgnoreCase<HeadDetailTable> detailTableExtras = new HashMapIgnoreCase();
    private String[] allDSNNames;
    private List<MultiDBDSNItem> allDSNList = new ArrayList<MultiDBDSNItem>();
    private List<RelationTable> relationTables;

    public Group(String key) {
        this.key = key;
    }

    public String getDSNName(String tableName, OneGroupValue oneGroupValue) throws Throwable {
        String result = null;
        for (MultiDBDSNItem dsn : this.allDSNList) {
            if (!dsn.isFitStrict(this, oneGroupValue)) continue;
            result = dsn.getName();
            break;
        }
        if (result == null) {
            result = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
        }
        return result;
    }

    private List<String> getDSNNameNotStrict(String tableName, OneGroupValue oneGroupValue) throws Throwable {
        ArrayList<String> result = new ArrayList<String>(this.allDSNList.size());
        for (MultiDBDSNItem dsn : this.allDSNList) {
            RefObject isStrictFit;
            if (!dsn.isFitNoStrict(this, oneGroupValue, (RefObject<Boolean>)(isStrictFit = new RefObject((Object)false)))) continue;
            if (((Boolean)isStrictFit.getValue()).booleanValue()) {
                ArrayList<String> tmp = new ArrayList<String>(1);
                tmp.add(dsn.getName());
                return tmp;
            }
            result.add(dsn.getName());
        }
        result.add(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
        return result;
    }

    public GroupField getGroupField(String groupFieldKey) {
        for (GroupField groupField : this.groupFields) {
            if (!groupField.getKey().equals(groupFieldKey)) continue;
            return groupField;
        }
        return null;
    }

    public void addGroupField(GroupField groupField) {
        if (this.groupFields == null) {
            this.groupFields = new ArrayList<GroupField>();
        }
        this.groupFields.add(groupField);
    }

    public void addTable(String tableName, GroupTable groupTable) {
        this.groupTables.put(tableName, (Object)groupTable);
    }

    public Map<String, GroupTable> getDefTableNams() {
        return this.groupTables;
    }

    public GroupTable getGroupTable(String tableName) {
        return (GroupTable)this.groupTables.get(tableName);
    }

    public boolean containGroupTable(String tableName) {
        return this.groupTables.containsKey(tableName);
    }

    public String getKey() {
        return this.key;
    }

    public void addRelationTable(RelationTable relationTable) {
        if (this.relationTables == null) {
            this.relationTables = new ArrayList<RelationTable>();
        }
        relationTable.checkColumnName(this);
        this.relationTables.add(relationTable);
    }

    public Collection<RelationTable> getRelationTables() {
        return this.relationTables;
    }

    public void addDSN(MultiDBDSNItem dsn) {
        if (!this.allDSNList.contains((Object)dsn)) {
            this.allDSNList.add(dsn);
            Object[] actions = new Object[]{this.key, "\u589e\u52a0\u6570\u636e\u6e90", dsn.getName(), "\uff0c\u5206\u7ec4\u4fe1\u606f\uff1a", dsn.getGroupValuesList()};
            Performance.endActive((int)Performance.startAction((Object[])actions), (Object[])actions);
        }
        this.allDSNNames = null;
    }

    public String[] getAllDSNNames() {
        if (this.allDSNNames == null) {
            int size = this.allDSNList.size();
            this.allDSNNames = new String[size];
            int i = 0;
            while (i < size) {
                this.allDSNNames[i] = this.allDSNList.get(i).getName();
                ++i;
            }
        }
        return this.allDSNNames;
    }

    public boolean hasMoreDSN() {
        return this.getAllDSNNames().length > 1;
    }

    public boolean isOnlyDSN() {
        return this.getAllDSNNames().length == 1;
    }

    public boolean containsDSNName(String dsnName) {
        if (this.allDSNList != null) {
            int i = 0;
            while (i < this.allDSNList.size()) {
                if (this.allDSNList.get(i).getName().equalsIgnoreCase(dsnName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private OneOrMultiValue<OneGroupValue> getGroupValues(String tableName, SqlInfo sqlInfo, Parameters parameters) throws Throwable {
        ArrayList<OneGroupValue> groupValueList = new ArrayList<OneGroupValue>();
        Node root = new Node(-1, null);
        this.expandGroupValues(root, 0, tableName, this.groupFields, sqlInfo, parameters, groupValueList);
        return new OneOrMultiValue<OneGroupValue>(groupValueList);
    }

    public Object getGroupFieldValue(String tableName, GroupField groupField, OneGroupValue parentGroupValue, SqlInfo sqlInfo, Parameters parameters) throws Throwable {
        Object result = null;
        String columnKey = this.getColumnNameInTable(groupField, tableName);
        if (columnKey != null && sqlInfo.hasGroupNewValue(columnKey)) {
            result = sqlInfo.getGroupNewValue(columnKey, parameters);
        } else if (this.relationTables != null) {
            for (RelationTable relationTable : this.relationTables) {
                OneOrMultiValue<Object> groupValues;
                if (!relationTable.isLastField(groupField.getKey()) || (groupValues = relationTable.getGroupValues(this, groupField, parentGroupValue, tableName, sqlInfo, parameters, true)) == null) continue;
                result = groupValues.getSingleValue();
                break;
            }
        }
        return result;
    }

    public Object getGroupFieldValueByRelationTables(String tableName, GroupField groupField, OneGroupValue parentGroupValue) throws Throwable {
        if (this.relationTables != null) {
            for (RelationTable relationTable : this.relationTables) {
                OneOrMultiValue<Object> tmp;
                if (!relationTable.isLastField(groupField.getKey()) || (tmp = relationTable.getGroupValues(this, groupField, parentGroupValue, tableName, null, null, true)) == null) continue;
                return tmp.getSingleValue();
            }
        }
        return null;
    }

    private void expandGroupValues(Node parentNode, int groupFieldIndex, String tableName, List<GroupField> depGroupFields, SqlInfo sqlInfo, Parameters parameters, List<OneGroupValue> groupValueList) throws Throwable {
        GroupField groupField = depGroupFields.get(groupFieldIndex);
        OneOrMultiValue<Object> groupFieldValues = null;
        String columnKey = this.getColumnNameInTable(groupField, tableName);
        if (columnKey != null && sqlInfo.hasGroupOriginalValue(columnKey)) {
            groupFieldValues = sqlInfo.getGroupOriginalValue(groupField, columnKey, parameters);
        }
        if ((groupFieldValues == null || groupFieldValues.isEmpty()) && this.relationTables != null) {
            for (RelationTable relationTable : this.relationTables) {
                OneGroupValue parentGroupValue;
                if (relationTable.isLastField(groupField.getKey()) && (groupFieldValues = relationTable.getGroupValues(this, groupField, parentGroupValue = parentNode.getGroupValue(depGroupFields), tableName, sqlInfo, parameters, false)) != null) break;
            }
        }
        if (columnKey != null && (groupFieldValues == null || groupFieldValues.isEmpty())) {
            groupFieldValues = sqlInfo.getGroupOriginalValue(groupField, columnKey, parameters);
        }
        if (groupFieldValues == null || groupFieldValues.isEmpty()) {
            if (groupFieldIndex != depGroupFields.size() - 1) {
                this.expandGroupValues(parentNode, groupFieldIndex + 1, tableName, depGroupFields, sqlInfo, parameters, groupValueList);
            } else {
                OneGroupValue oneGroupValue = parentNode.getGroupValue(depGroupFields);
                groupValueList.add(oneGroupValue);
            }
            return;
        }
        for (Object value : groupFieldValues) {
            Node node = new Node(groupFieldIndex, value);
            node.parent = parentNode;
            parentNode.children.add(node);
            if (groupFieldIndex != depGroupFields.size() - 1) {
                this.expandGroupValues(node, groupFieldIndex + 1, tableName, depGroupFields, sqlInfo, parameters, groupValueList);
                continue;
            }
            OneGroupValue oneGroupValue = node.getGroupValue(depGroupFields);
            groupValueList.add(oneGroupValue);
        }
    }

    public List<GroupField> getGroupFields() {
        return this.groupFields;
    }

    public OneOrMultiValue<DSNTableName> getDSNName(String tableName, SqlInfo sqlInfo, Parameters parameters, IDBManager dbm) throws Throwable {
        if (sqlInfo instanceof SelectSqlInfo) {
            return ShardingRouteService.fetchDSN(tableName, (SelectSqlInfo)sqlInfo, parameters, dbm);
        }
        OneOrMultiValue<OneGroupValue> groupValues = this.getGroupValues(tableName, sqlInfo, parameters);
        OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
        HashSet<String> addedDSNName = new HashSet<String>();
        DSNTableName dsnTableName = new DSNTableName();
        result.addValue(dsnTableName);
        int i = 0;
        int count = groupValues.getValueCount();
        while (i < count) {
            OneGroupValue groupValue = groupValues.getValue(i);
            groupValue.expandValueByRelation(TableGroupProps.getInstance().getTableGroupProp(tableName));
            if (groupValue.hasUnDefinedGroupValue()) {
                List<String> dsnNames = this.getDSNNameNotStrict(tableName, groupValue);
                for (String dsnName : dsnNames) {
                    if (addedDSNName.contains(dsnName)) continue;
                    dsnTableName.addDSNName(dsnName);
                    addedDSNName.add(dsnName);
                }
                if (!dsnTableName.isDsnNameEmpty()) {
                    result.addValue(dsnTableName);
                }
            } else {
                String dsnName = this.getDSNName(tableName, groupValue);
                dsnTableName.addDSNName(dsnName);
            }
            ++i;
        }
        return result;
    }

    public String getOneDSNName(String tableName) throws Throwable {
        if (!this.groupFields.isEmpty()) {
            throw new RuntimeException("\u8868" + tableName + "\u5e94\u8be5\u5904\u5728\u4e00\u4e2a\u786e\u5b9a\u7684\u6570\u636e\u5e93\u4e2d\uff0c\u4e0d\u5e94\u8be5\u51fa\u73b0\u5728\u5206\u7ec4" + this.getKey() + "\u4e2d\u3002");
        }
        return this.getDSNName(tableName, null);
    }

    public void addDetailTableExtra(HeadDetailTable detailTableExtra) {
        String detailTableName = detailTableExtra.detailTableName;
        if (this.detailTableExtras.containsKey(detailTableName)) {
            throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u6269\u5c55\u660e\u7ec6\u8868\u53ea\u652f\u6301\u6302\u5728\u4e00\u5f20\u4e3b\u8868\u4e0a\uff0c\u800c" + detailTableName + "\u51fa\u73b0\u5728\u591a\u5f20\u4e3b\u8868\u4e0a\u3002");
        }
        this.detailTableExtras.put(detailTableName, (Object)detailTableExtra);
    }

    public Collection<HeadDetailTable> getDetailTableExtras() {
        return this.detailTableExtras.values();
    }

    public String getColumnNameInTable(GroupField groupField, String tableName) {
        int groupFieldIndex = this.groupFields.indexOf(groupField);
        return ((GroupTable)this.groupTables.get(tableName)).getGroupColumnNames()[groupFieldIndex];
    }

    public void clearDsn() {
        this.allDSNList = new ArrayList<MultiDBDSNItem>();
        this.allDSNNames = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.key).append("[");
        for (String tableName : this.groupTables.keySet()) {
            sb.append(tableName).append(",");
        }
        sb.delete(sb.length() - 1, sb.length()).append("]");
        return sb.toString();
    }
}

