/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.resultset.SimpleDocumentDBUtil;
import com.bokesoft.yes.mid.mysqls.route.meta.type.EGroupFieldType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.commons.lang3.NotImplementedException;

public class DictGroupField
extends GroupField {
    public static final String STR_ClientID = "ClientID";
    final String itemKey;
    boolean hasClientID;
    private DataTable allData;

    public DictGroupField(String key, String itemKey) {
        super(key);
        this.itemKey = itemKey;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    private DataTable getDataTable() throws Throwable {
        if (this.allData == null) {
            MetaTable metaTable = (MetaTable)MetaFactory.getGlobalInstance().getDataObject(this.itemKey).getTableCollection().get(0);
            this.hasClientID = metaTable.containsKey(STR_ClientID);
            String tableName = metaTable.getKey();
            String dsnName = TableGroupProps.getInstance().getOneDSNName(tableName);
            Connection connection = MultiDBManager.getJDBCConnection(dsnName);
            String sql = new StringBuilder(128).append("SELECT oid, code").append(this.hasClientID ? ", ClientID" : "").append(" FROM ").append(tableName).toString();
            PreparedStatement preparedStatement = connection.prepareStatement(sql, 1004, 1007);
            ResultSet rs = preparedStatement.executeQuery();
            this.allData = SimpleDocumentDBUtil.populate(rs);
            connection.close();
        }
        return this.allData;
    }

    @Override
    public String getCaption(Object value) throws Throwable {
        Long itemID = TypeConvertor.toLong((Object)value);
        DataTable allData = this.getDataTable();
        String result = null;
        int pos = 0;
        int count = allData.size();
        while (pos < count) {
            if (allData.getLong(pos, 0).equals(itemID)) {
                result = allData.getString(pos, 1);
                break;
            }
            ++pos;
        }
        return result;
    }

    public Long[] getAllData(long clientID) throws Throwable {
        DataTable allData = this.getDataTable();
        ArrayList<Long> dataList = new ArrayList<Long>();
        int pos = 0;
        int count = allData.size();
        while (pos < count) {
            if (allData.getLong(pos, 2).equals(clientID)) {
                dataList.add(allData.getLong(pos, 0));
            }
            ++pos;
        }
        Long[] result = new Long[dataList.size()];
        return dataList.toArray(result);
    }

    public Long[] getAllData() throws Throwable {
        DataTable allData = this.getDataTable();
        int count = allData.size();
        ArrayList<Long> dataList = new ArrayList<Long>(count);
        int pos = 0;
        while (pos < count) {
            dataList.add(allData.getLong(pos, 0));
            ++pos;
        }
        Long[] result = new Long[count];
        return dataList.toArray(result);
    }

    @Override
    public Object convertType(Object value) throws Throwable {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            DataTable dataTable = this.getDataTable();
            int rowIndex = dataTable.fastFindFirst(new String[]{"code"}, (Object[])new String[]{(String)value});
            if (rowIndex >= 0) {
                return dataTable.getLong(rowIndex, 0);
            }
            return null;
        }
        return TypeConvertor.toLong((Object)value);
    }

    @Override
    public void setDefaultValues(String defaultValues) {
        throw new NotImplementedException("Code is not implemented");
    }

    @Override
    public EGroupFieldType getGroupType() {
        return EGroupFieldType.DICT;
    }
}

