/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.dsntablename.DeleteDSNTableNameCalc;
import com.bokesoft.yes.mid.mysqls.execute.ExecuteUtil;
import com.bokesoft.yes.mid.mysqls.execute.MoveHeadDataAfterGroupDetailChangeDSN;
import com.bokesoft.yes.mid.mysqls.group.DataObjectRelationTable;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.RefDataObject;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.oidpool.OIDPool;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.mid.mysqls.sql.UpdateSqlInfo;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.boke.jsqlparser.expression.Expression;

public class UpdateExecute {
    public static int[] execute(MultiDBManager dbManager, MultiDBPreparedStatement mdbPreparedStatement) throws SQLException {
        int[] result = null;
        String sql = mdbPreparedStatement.getSql();
        UpdateSqlInfo sqlInfo = (UpdateSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        if (Performance.RUN_IN_DEBUG && !sqlInfo.isNoGroup()) {
            sqlInfo.checkSupportMultiDBs();
        }
        Map<DSNTableName, List<Parameters>> dsnNameToParametersList = mdbPreparedStatement.getDSNNameToParametersList();
        for (Map.Entry<DSNTableName, List<Parameters>> entry : dsnNameToParametersList.entrySet()) {
            OneOrMultiValue<String> newDSNNames;
            DSNTableName dsnTableName = entry.getKey();
            String tableName = sqlInfo.getTableName();
            DBStruct dbStruct = dbManager.getDBStruct();
            if (!dbStruct.existTableName(dsnTableName.getDsnNames(), tableName)) continue;
            String newSql = sql;
            List<Parameters> parametersList = entry.getValue();
            UpdateExecute.checkHasWhere(sqlInfo);
            if (DBStruct.existComfirmedColumn(dsnTableName.getDsnNames(), tableName, "OID")) {
                OneOrMultiValue<Long> oids = sqlInfo.getPrimaryKeyLongOriginalValue("OID", parametersList);
                for (Long oid : oids) {
                    if (!dsnTableName.hasNewDSNName()) continue;
                    try {
                        UpdateExecute.moveData(dbManager, tableName, oid, dsnTableName);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u79fb\u52a8\u6570\u636e" + tableName + "\u4e2d" + oid + "\u51fa\u9519\u3002", e);
                    }
                }
            }
            if ((newDSNNames = dsnTableName.getNewDSNNames()) == null) {
                newDSNNames = dsnTableName.getDsnNames();
            }
            for (String dsnName : newDSNNames) {
                if (parametersList != null && parametersList.size() > 1) {
                    int[] is = (int[])UpdateExecute.execute(dbManager, dsnName, newSql, parametersList);
                    result = ExecuteUtil.mergeExecuteBatchResult(mdbPreparedStatement, result, parametersList, is);
                    continue;
                }
                int tmp = (Integer)UpdateExecute.execute(dbManager, dsnName, newSql, parametersList);
                Parameters parameters = parametersList == null ? null : parametersList.get(0);
                result = ExecuteUtil.mergeExecuteBatchResult(mdbPreparedStatement, result, parameters, tmp);
            }
        }
        mdbPreparedStatement.setExecuted();
        mdbPreparedStatement.clearDsnNameParaList();
        return result;
    }

    public static Object execute(MultiDBManager mdbm, String dsnName, String sql, List<Parameters> parametersList) throws SQLException {
        Connection connection = mdbm.getConnectionByDSNName(dsnName);
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = connection.prepareStatement(sql);
            if (parametersList != null && parametersList.size() > 1) {
                for (Parameters parameters : parametersList) {
                    ExecuteUtil.setParameters(preparedStatement, parameters);
                    preparedStatement.addBatch();
                }
                Object[] actions = new Object[]{dsnName, ": ", sql, parametersList};
                int action = Performance.startAction((Object[])actions);
                int[] result = preparedStatement.executeBatch();
                Performance.endActive((int)action, (Object[])actions);
                int[] nArray = result;
                return nArray;
            }
            Parameters parameters = parametersList == null ? null : parametersList.get(0);
            ExecuteUtil.setParameters(preparedStatement, parameters);
            Object[] actions = new Object[]{dsnName, ": ", sql, parameters};
            int action = Performance.startAction((Object[])actions);
            preparedStatement.execute();
            Performance.endActive((int)action, (Object[])actions);
            Integer n = preparedStatement.getUpdateCount();
            return n;
        }
    }

    private static void checkHasWhere(UpdateSqlInfo sqlInfo) throws SQLException {
        Expression where = sqlInfo.getWhere();
        if (where == null) {
            throw new RuntimeException("Update\u8bed\u53e5" + sqlInfo.getSql() + "\u6ca1\u6709where\u5b50\u53e5\uff0c\u4e0d\u652f\u6301\u3002");
        }
    }

    private static void moveData(MultiDBManager dbManager, String tableName, Long oid, DSNTableName dsnTableName) throws Throwable {
        TableGroupProp tableGroupProp;
        List<String> insertDSNNames;
        List<String> deleteDSNNames;
        String queryDSNName = dsnTableName.getDsnNames().getValue(0);
        Long soid = UpdateExecute.moveData(dbManager, tableName, oid, queryDSNName, deleteDSNNames = dsnTableName.getDeleteDSNNames(), insertDSNNames = dsnTableName.getInsertDSNNames());
        if (soid.equals(oid)) {
            OIDPool oidPool = dbManager.getOIDToDSNName();
            oidPool.setOIDDSNName(soid, dsnTableName);
        }
        if ((tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(tableName)).getFixedType() == TableGroupType.DetailTableInGroupByDetailTable) {
            MoveHeadDataAfterGroupDetailChangeDSN delayMove = dbManager.getMoveHeadDataAfterGroupDetailChangeDSN();
            String headTableName = tableGroupProp.getHeadTableName();
            for (String deleteDSNName : deleteDSNNames) {
                delayMove.addDeleteDSNTableName(headTableName, soid, deleteDSNName);
            }
            for (String insertDSNName : insertDSNNames) {
                delayMove.addInsertDSNTableName(headTableName, soid, insertDSNName);
            }
        }
    }

    public static Long moveData(MultiDBManager dbManager, String tableName, Long oid, String queryDSNName, List<String> deleteDSNNames, List<String> insertDSNNames) throws Throwable {
        StringBuilder sb = new StringBuilder(2048).append("SELECT ").append(ExecuteUtil.getAllColumnName(dbManager, tableName)).append(" FROM ");
        dbManager.appendKeyWordEscape(sb, tableName).append(" WHERE OID = ? FOR UPDATE");
        String selectSql = sb.toString();
        DataTable headDataTable = dbManager.execPrepareQuery(queryDSNName, selectSql, oid);
        Long soid = headDataTable.getLong(0, "SOID");
        TableGroupProp tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(tableName);
        TableGroupType type = tableGroupProp.getFixedType();
        List<HeadDetailTable> detailTables = tableGroupProp.getDetailTables();
        int detailTableCount = detailTables != null ? detailTables.size() : 0;
        DataTable[] detailDataTables = new DataTable[detailTableCount];
        boolean isMoveHeadTable = type == TableGroupType.HeadTableInGroupByHeadTable || type == TableGroupType.HeadTableInGroupByDetailTable;
        int i = 0;
        while (i < detailTableCount) {
            HeadDetailTable detailTable = detailTables.get(i);
            String detailTableName = detailTable.detailTableName;
            if (isMoveHeadTable) {
                sb = new StringBuilder(512).append("SELECT ").append(ExecuteUtil.getAllColumnName(dbManager, detailTableName)).append(" FROM ");
                dbManager.appendKeyWordEscape(sb, detailTableName).append(" WHERE ").append(detailTable.columnNameRefHeadOID).append(" = ? FOR UPDATE");
                selectSql = sb.toString();
                detailDataTables[i] = dbManager.execPrepareQuery(queryDSNName, selectSql, oid);
            } else {
                String parentTableName = detailTable.headTableName;
                if (parentTableName.equalsIgnoreCase(tableName)) {
                    sb = new StringBuilder(512).append("SELECT ").append(ExecuteUtil.getAllColumnName(dbManager, detailTableName)).append(" FROM ");
                    dbManager.appendKeyWordEscape(sb, detailTableName).append(" WHERE ").append("POID").append(" = ? AND ").append("SOID").append(" = ? FOR UPDATE");
                    selectSql = sb.toString();
                    detailDataTables[i] = dbManager.execPrepareQuery(queryDSNName, selectSql, oid, soid);
                } else {
                    int parentIndex = 0;
                    while (parentIndex < detailTableCount) {
                        if (detailTables.get((int)parentIndex).detailTableName.equalsIgnoreCase(parentTableName)) break;
                        ++parentIndex;
                    }
                    Long[] oids = DataTableExUtil.getLongValues(detailDataTables[parentIndex], "OID");
                    if (oids.length > 0) {
                        sb = new StringBuilder(512).append("SELECT ").append(ExecuteUtil.getAllColumnName(dbManager, detailTableName)).append(" FROM ");
                        dbManager.appendKeyWordEscape(sb, detailTableName).append(" WHERE ").append("POID").append(" IN (?");
                        int j = 1;
                        int size1 = oids.length;
                        while (j < size1) {
                            sb.append(",?");
                            ++j;
                        }
                        selectSql = sb.append(") AND ").append("SOID").append(" = ? FOR UPDATE").toString();
                        ArrayList<Object> parameters = new ArrayList<Object>(oids.length + 1);
                        parameters.addAll(Arrays.asList(oids));
                        parameters.add(soid);
                        detailDataTables[i] = dbManager.execPrepareQuery(queryDSNName, selectSql, parameters);
                    }
                }
            }
            ++i;
        }
        for (String deleteDSNName : deleteDSNNames) {
            String deleteSql = "";
            int i2 = 0;
            while (i2 < detailTableCount) {
                DataTable detailDataTable = detailDataTables[i2];
                if (detailDataTable != null && detailDataTable.size() > 0) {
                    HeadDetailTable detailTable = detailTables.get(i2);
                    String detailTableName = detailTable.detailTableName;
                    if (isMoveHeadTable) {
                        sb = new StringBuilder(128).append("DELETE FROM ");
                        dbManager.appendKeyWordEscape(sb, detailTableName).append(" WHERE ").append(detailTable.columnNameRefHeadOID).append(" = ?").toString();
                        deleteSql = sb.toString();
                        dbManager.execPrepareUpdate(deleteDSNName, deleteSql, oid);
                    } else {
                        Long[] oids = DataTableExUtil.getLongValues(detailDataTable, "OID");
                        sb = new StringBuilder(512).append("DELETE FROM ");
                        dbManager.appendKeyWordEscape(sb, detailTableName).append(" WHERE ").append("OID").append(" IN (?");
                        int j = 1;
                        int size1 = oids.length;
                        while (j < size1) {
                            sb.append(",?");
                            ++j;
                        }
                        deleteSql = sb.append(")").toString();
                        dbManager.execPrepareUpdate(deleteDSNName, deleteSql, Arrays.asList(oids));
                    }
                }
                ++i2;
            }
            sb = new StringBuilder(128).append("DELETE FROM ");
            dbManager.appendKeyWordEscape(sb, tableName).append(" WHERE OID = ?");
            deleteSql = sb.toString();
            dbManager.execPrepareUpdate(deleteDSNName, deleteSql, oid);
        }
        for (String insertDSNName : insertDSNNames) {
            LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(tableName);
            sb = new StringBuilder(2048).append("INSERT INTO ");
            dbManager.appendKeyWordEscape(sb, tableName).append("(").append(ExecuteUtil.getAllColumnName(dbManager, tableName)).append(") VALUES (").append(ExecuteUtil.getJDBCParameters(columns.size())).append(")");
            String insertSql = sb.toString();
            DataTableBatchPsPara newBatchPsPara = new DataTableBatchPsPara(insertSql, headDataTable, columns.size());
            dbManager.executeUpdate(insertDSNName, newBatchPsPara);
            int i3 = 0;
            while (i3 < detailTableCount) {
                DataTable detailDataTable = detailDataTables[i3];
                if (detailDataTable != null && detailDataTable.size() > 0) {
                    HeadDetailTable detailTable = detailTables.get(i3);
                    String detailTableName = detailTable.detailTableName;
                    columns = DataObjects.getInstance().getColumnsByTableName(detailTableName);
                    sb = new StringBuilder(3072).append("INSERT INTO ");
                    dbManager.appendKeyWordEscape(sb, detailTableName).append("(").append(ExecuteUtil.getAllColumnName(dbManager, detailTableName)).append(") VALUES (").append(ExecuteUtil.getJDBCParameters(columns.size())).append(")");
                    insertSql = sb.toString();
                    newBatchPsPara = new DataTableBatchPsPara(insertSql, detailDataTable, columns.size());
                    dbManager.executeUpdate(insertDSNName, newBatchPsPara);
                }
                ++i3;
            }
        }
        if (isMoveHeadTable) {
            UpdateExecute.moveDataObjectRelationTable(dbManager, tableName, soid, queryDSNName, deleteDSNNames, insertDSNNames);
        }
        return soid;
    }

    private static void moveDataObjectRelationTable(MultiDBManager dbManager, String tableName, Long oid, String queryDSNName, List<String> deleteDSNNames, List<String> insertDSNNames) throws Throwable {
        DataObjectRelationTable[] dataObjectRelationTableArray = GroupConfig.instance.getDataObjectRelationTables();
        int n = dataObjectRelationTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjectRelationTable dataObjectRelationTable = dataObjectRelationTableArray[n2];
            String sql = dataObjectRelationTable.getQuerySql(dbManager, tableName);
            if (sql != null) {
                int parameterSize;
                List<Object> parameters;
                DataTable data;
                String relationTableName = dataObjectRelationTable.name;
                if (dbManager.getDBStruct().existTableOrViewName(queryDSNName, relationTableName) && (data = dbManager.execPrepareQuery(queryDSNName, sql, parameters = UpdateExecute.getParameters(oid, parameterSize = dataObjectRelationTable.getRefDataObjects().size()))).first()) {
                    OneOrMultiValue<String> otherSOIDDSNNames = new OneOrMultiValue<String>();
                    for (RefDataObject refDataObject : dataObjectRelationTable.getRefDataObjects()) {
                        TableGroupProp headTable;
                        Long otherSOID = data.getLong(0, refDataObject.refSOIDColumnName);
                        if (oid.equals(otherSOID) || otherSOID.equals(0L)) continue;
                        String dataObjectKey = refDataObject.refKey;
                        if (dataObjectKey == null || dataObjectKey.length() > 0) {
                            dataObjectKey = data.getString(0, refDataObject.refKeyColumnName);
                        }
                        if ((headTable = DeleteDSNTableNameCalc.getHeadTableGroupProp(dataObjectKey)) == null) {
                            otherSOIDDSNNames.addValue(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
                            continue;
                        }
                        DSNTableName tmp = dbManager.getOIDToDSNName().getDSNTableName(otherSOID, headTable);
                        otherSOIDDSNNames.addAllValue(tmp.hasNewDSNName() ? tmp.getNewDSNNames() : tmp.getDsnNames());
                    }
                    for (String deleteDSNName : deleteDSNNames) {
                        if (otherSOIDDSNNames.hasValue(deleteDSNName)) continue;
                        StringBuilder sb = new StringBuilder(128).append("DELETE FROM ");
                        dbManager.appendKeyWordEscape(sb, relationTableName).append(" WHERE ").append("OID").append(" = ?").toString();
                        String deleteSql = sb.toString();
                        dbManager.execPrepareUpdate(deleteDSNName, deleteSql, data.getLong(0, "OID"));
                    }
                    for (String insertDSNName : insertDSNNames) {
                        if (otherSOIDDSNNames.hasValue(insertDSNName)) continue;
                        LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(relationTableName);
                        StringBuilder sb = new StringBuilder(2048).append("INSERT INTO ");
                        dbManager.appendKeyWordEscape(sb, relationTableName).append("(").append(ExecuteUtil.getAllColumnName(dbManager, relationTableName)).append(") VALUES (").append(ExecuteUtil.getJDBCParameters(columns.size())).append(")").toString();
                        String insertSql = sb.toString();
                        DataTableBatchPsPara newBatchPsPara = new DataTableBatchPsPara(insertSql, data, columns.size());
                        dbManager.executeUpdate(insertDSNName, newBatchPsPara);
                    }
                }
            }
            ++n2;
        }
    }

    private static List<Object> getParameters(Long oid, int size) {
        ArrayList<Object> result = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            result.add(oid);
            ++i;
        }
        return result;
    }
}

