/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.connection.util.SystemTables;
import com.bokesoft.yes.mid.dbcache.datatable.OrderByUtil;
import com.bokesoft.yes.mid.dbcache.structure.OrderBy;
import com.bokesoft.yes.mid.mysqls.dbstruct.RuntimeDDL;
import com.bokesoft.yes.mid.mysqls.execute.ExecuteUtil;
import com.bokesoft.yes.mid.mysqls.execute.SelectCrossGroupExecute;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.processselect.IComplexSQL;
import com.bokesoft.yes.mid.mysqls.processselect.SelectMulitInConvert;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuerys;
import com.bokesoft.yes.mid.mysqls.result.process.util.ResultProcessUtils;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetUtil;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSet;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.mid.util.DocumentDBUtil;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.util.RefParameter;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.query.extend.ParseHelper;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.Select;

public class SelectExecute {
    public static ResultSetGetObjectByPos execute(MultiDBManager dbManager, MultiDBPreparedStatement preparedStatement) throws SQLException {
        ResultSetGetObjectByPos result;
        String sql = preparedStatement.getSql();
        SelectSqlInfo sqlInfo = null;
        String tableName = null;
        boolean sqlChanged = false;
        if (MetaFactory.getGlobalInstance() != null) {
            sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
            sqlInfo.processFunctionGroupByOrderBy();
            sqlInfo.prepareGroupFunctionChanges();
            if (!sqlInfo.isNoGroup() && sqlInfo.getAllTables().size() > 1 && !sqlInfo.isSameSingleGroup()) {
                List<OrderBy> orderbyObjects = sqlInfo.getOrderByElements();
                sqlChanged = sqlInfo.commitGroupFunctionChanges();
                if (sqlInfo.getComplexSQL() != null) {
                    ResultSetGetObjectByPos execute = SelectCrossGroupExecute.execute(dbManager, preparedStatement, sqlInfo);
                    if (orderbyObjects != null && orderbyObjects.size() > 0) {
                        SelectExecute.reOrderBy(execute, sqlInfo, orderbyObjects);
                    }
                    if (sqlChanged) {
                        sqlInfo.clearJdbcParameters();
                        SqlInfos.instance.remove(sql);
                    }
                    return execute;
                }
                List<Parameters> newParameters = SelectExecute.rebuildParametersIfChanged(sqlInfo.getSelect(), preparedStatement.getParametersList());
                if (newParameters != preparedStatement.getParametersList()) {
                    preparedStatement.setParametersList(newParameters);
                    if (!newParameters.isEmpty()) {
                        Parameters first = newParameters.get(0);
                        preparedStatement.setParameterCount(first.getCount());
                    }
                }
            }
            tableName = sqlInfo.getTableName();
        }
        if (tableName != null && !SystemTables.isSystemTable(tableName) && sqlInfo != null && !sqlInfo.isNoGroup()) {
            if (SelectMulitInConvert.isMultiJdbcParasMultiIn(sqlInfo.getSelect()) && preparedStatement.getParametersList().size() == 1) {
                RefParameter<List<Parameters>> parasListRef = new RefParameter<List<Parameters>>();
                Select newSelect = SelectMulitInConvert.convertFromMultiJdbcParasToMultiSqlParas(sqlInfo.getSelect(), preparedStatement.getParametersList().get(0), parasListRef);
                String newSql = newSelect.toString();
                sqlInfo = ParseHelper.createSelectInfo(newSql, newSelect);
                preparedStatement.changeSql(newSelect.toString(), parasListRef.getValue());
            }
            sqlInfo.prepareGroupFunctionChanges();
            sqlChanged = sqlInfo.commitGroupFunctionChanges();
            ArrayList<ResultSetGetObjectByPos> rsList = new ArrayList<ResultSetGetObjectByPos>();
            Map<DSNTableName, List<Parameters>> dsnNameToParametersList = preparedStatement.getDSNNameToParametersList();
            Map<DSNTableName, List<Parameters>> newdsnNameToParametersList = SelectExecute.filterDsnNameToParametersList(dbManager, dsnNameToParametersList, preparedStatement, sqlInfo);
            int addFieldCount = sqlInfo.getAddColumnCount();
            if (addFieldCount > 0) {
                preparedStatement.changeSql(sqlInfo.getSelect().toString(), preparedStatement.getParametersList());
            }
            for (Map.Entry<DSNTableName, List<Parameters>> entry : newdsnNameToParametersList.entrySet()) {
                DSNTableName dsnTableName = entry.getKey();
                if (dsnTableName.getDsnNames() == null) continue;
                for (String dsnName : dsnTableName.getDsnNames()) {
                    if (dsnName == null || !dbManager.getDBStruct().existTableOrViewName(dsnName, sqlInfo.getAllTableNames())) continue;
                    String newSql = preparedStatement.getSql();
                    List<Parameters> parametersList = entry.getValue();
                    if ((parametersList = ResultProcessUtils.genNewPrametersList(parametersList, sqlInfo.getRemovedParameterIndexes())) != null && parametersList.size() > 1 && SelectMulitInConvert.isMultiSqlParasMultiIn(sqlInfo.getSelect())) {
                        RefParameter<Parameters> parasRef = new RefParameter<Parameters>();
                        Select newSelect = SelectMulitInConvert.convertFromMultiSqlParasToMultiJdbcParas(sqlInfo.getSelect(), parametersList, parasRef);
                        Parameters paras = parasRef.getValue();
                        parametersList = new ArrayList<Parameters>(1);
                        parametersList.add(paras);
                        newSql = newSelect.toString();
                    }
                    ResultSetGetObjectByPos rs = SelectExecute.executeQueryInner(dbManager, dsnName, newSql, parametersList);
                    if (rsList.size() != 0 && ResultSetUtil.getRowCount(rs) <= 0) continue;
                    if (dsnName.equalsIgnoreCase(dbManager.getKey())) {
                        rsList.add(0, rs);
                        continue;
                    }
                    rsList.add(rs);
                }
            }
            result = ResultProcessUtils.processResults(sqlInfo, rsList, ResultProcessUtils.getParameters(preparedStatement), false);
        } else {
            String defaultDSNName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
            sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
            sqlInfo.checkSelectItemAllColumnWithJoin(sqlInfo.getSelect().getSelectBody());
            result = SelectExecute.executeQueryInner(dbManager, defaultDSNName, sql, preparedStatement.getParametersList());
        }
        if (sqlChanged) {
            sqlInfo.clearJdbcParameters();
            SqlInfos.instance.remove(sql);
        }
        preparedStatement.setExecuted();
        preparedStatement.clearDsnNameParaList();
        return result;
    }

    private static List<Parameters> rebuildParametersIfChanged(Select select, List<Parameters> orgParameterDatas) {
        if (orgParameterDatas == null || orgParameterDatas.isEmpty()) {
            return orgParameterDatas;
        }
        Parameters firstParameterData = orgParameterDatas.get(0);
        List<JdbcParameter> jdbcParas = ResultProcessUtils.getJdbcParameters(select);
        if (firstParameterData.size() == jdbcParas.size()) {
            return orgParameterDatas;
        }
        ArrayList<Parameters> newParametersList = new ArrayList<Parameters>();
        for (Parameters parameterData : orgParameterDatas) {
            int index = 1;
            Parameters newPara = new Parameters(jdbcParas.size());
            for (JdbcParameter jdbcPara : jdbcParas) {
                Object value = ResultProcessUtils.getParamenterValue(jdbcPara, parameterData);
                int type = ResultProcessUtils.getParamenterType(jdbcPara, parameterData);
                newPara.setArg(index, type, value);
                ++index;
            }
            newParametersList.add(newPara);
        }
        return newParametersList;
    }

    public static void reOrderBy(ResultSetGetObjectByPos execute, SelectSqlInfo sqlInfo, List<OrderBy> orderbyObjects) throws SQLException {
        if (orderbyObjects == null) {
            return;
        }
        boolean needReOrderBy = true;
        IComplexSQL complexSQL = sqlInfo.getComplexSQL();
        if (complexSQL instanceof SubQuerys) {
            Object orderByElements;
            SubQuery subQuery2;
            List<SubQuery> subQuerys = ((SubQuerys)complexSQL).getSubQuerys();
            boolean hasInValues = false;
            for (SubQuery subQuery2 : subQuerys) {
                if (subQuery2.inValuesForSubQuery == null) continue;
                hasInValues = true;
                break;
            }
            if (!hasInValues && (orderByElements = (subQuery2 = subQuerys.get(0)).getPlainSelect().getOrderByElements()) != null && orderByElements.size() == orderbyObjects.size()) {
                needReOrderBy = false;
            }
        }
        if (execute instanceof UnionResultSet) {
            UnionResultSet unionResultSet = (UnionResultSet)execute;
            OrderByUtil.orderBy(unionResultSet.getRows(), orderbyObjects);
        } else if (execute instanceof JoinResultSet) {
            if (needReOrderBy) {
                JoinResultSet joinResultSet = (JoinResultSet)execute;
                OrderByUtil.orderBy(joinResultSet, orderbyObjects);
            }
        } else if (execute instanceof DataTableResultSet) {
            SortCriteria[] vCriteria = new SortCriteria[orderbyObjects.size()];
            int index = 0;
            for (OrderBy orderbyObject : orderbyObjects) {
                vCriteria[index] = new SortCriteria(orderbyObject.getColumnName(), orderbyObject.getAsc().booleanValue());
                ++index;
            }
            if (needReOrderBy) {
                DataTable dataTable = ((DataTableResultSet)execute).getDataTable();
                try {
                    DocumentDBUtil.processTableSort(dataTable, vCriteria);
                }
                catch (Throwable e) {
                    throw new RuntimeException("\u6392\u5e8f\u51fa\u9519,\u9519\u8bef\u539f\u56e0\u4e3a" + e.getMessage());
                }
            }
        }
    }

    private static Map<DSNTableName, List<Parameters>> filterDsnNameToParametersList(MultiDBManager dbManager, Map<DSNTableName, List<Parameters>> dsnNameToParametersList, MultiDBPreparedStatement preparedStatement, SelectSqlInfo sqlInfo) throws SQLException {
        int offset;
        int startIndex;
        Limit limit = sqlInfo.getLimit();
        if (limit == null) {
            return dsnNameToParametersList;
        }
        if (dsnNameToParametersList.size() != 1) {
            throw new RuntimeException("\u5206\u5e93\u5904\u7406\uff0c\u5e26Limit\u7684SQL\u8bed\u53e5\u5e94\u8be5\u53ea\u6709\u4e00\u7ec4\u6570\u636e\u6e90\u3002" + sqlInfo.getSql());
        }
        DSNTableName dsnTableName = dsnNameToParametersList.keySet().iterator().next();
        if (dsnTableName.getDsnNames().getValueCount() == 1) {
            return dsnNameToParametersList;
        }
        List<Parameters> parametersList = dsnNameToParametersList.get(dsnTableName);
        int parameterListSize = parametersList.size();
        Parameters parameters = parametersList.get(parameterListSize - 1);
        int parametersCount = parameters.getCount();
        if (!limit.isOffsetJdbcParameter()) {
            startIndex = 0;
            offset = TypeConvertor.toInteger((Object)parameters.getValue(parametersCount));
        } else {
            startIndex = TypeConvertor.toInteger((Object)parameters.getValue(parametersCount - 1));
            offset = TypeConvertor.toInteger((Object)parameters.getValue(parametersCount));
        }
        int endIndex = startIndex + offset;
        Parameters withoutLimitParameters = !limit.isOffsetJdbcParameter() ? parameters.subParameters(1, parametersCount - 1) : parameters.subParameters(1, parametersCount - 2);
        ArrayList<Parameters> withoutLimitParametersList = new ArrayList<Parameters>();
        withoutLimitParametersList.add(withoutLimitParameters);
        int allSize = 0;
        LinkedHashMap<DSNTableName, List<Parameters>> newDsnNameToParametersList = new LinkedHashMap<DSNTableName, List<Parameters>>();
        boolean dataMayRepeat = dsnTableName.isDataMayRepeat();
        ArrayList<String> orderedDSNName = new ArrayList<String>();
        for (String dsnName : dsnTableName.getDsnNames()) {
            if (dsnName == null || !dbManager.getDBStruct().existTableOrViewName(dsnName, sqlInfo.getAllTableNames())) continue;
            orderedDSNName.add(dsnName);
        }
        orderedDSNName.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String dsnName : orderedDSNName) {
            int curStartIndex;
            String preExcuteSql = sqlInfo.getSqlWithoutLimit();
            ResultSetGetObjectByPos rs = SelectExecute.executeQueryInner(dbManager, dsnName, preExcuteSql, withoutLimitParametersList);
            int curResultSetSize = 0;
            if (rs instanceof DataTableResultSet) {
                DataTableResultSet dataTableResultSet = (DataTableResultSet)rs;
                curResultSetSize = dataTableResultSet.getDataTable().size();
            }
            if (curResultSetSize == 0) continue;
            int n = curStartIndex = allSize < startIndex ? startIndex - allSize : 0;
            if ((allSize += curResultSetSize) <= startIndex) continue;
            int curOffset = curResultSetSize - (allSize > endIndex ? allSize - endIndex : 0) - curStartIndex;
            Parameters newParameters = parameters.cloneParameters();
            int tempParametersSize = newParameters.size();
            if (!limit.isOffsetJdbcParameter()) {
                newParameters.setArg(tempParametersSize, 4, curOffset);
            } else {
                newParameters.setArg(tempParametersSize - 1, 4, curStartIndex);
                newParameters.setArg(tempParametersSize, 4, curOffset);
            }
            ArrayList<Parameters> tempParametersList = new ArrayList<Parameters>();
            tempParametersList.add(newParameters);
            DSNTableName newDSNTableName = new DSNTableName(dsnName);
            if (dataMayRepeat) {
                newDSNTableName.setIsDataMayRepeat();
            }
            newDsnNameToParametersList.put(newDSNTableName, tempParametersList);
            if (allSize > endIndex) break;
        }
        return newDsnNameToParametersList;
    }

    private static ResultSetGetObjectByPos executeQueryInner(MultiDBManager dbManager, String dsnName, String sql, List<Parameters> parameters) throws SQLException {
        DataTableResultSet result;
        Connection connection = dbManager.getConnectionByDSNName(dsnName);
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = connection.prepareStatement(sql, 1004, 1007);
            if (parameters != null && parameters.size() > 1) {
                throw new RuntimeException("\u67e5\u8be2\u8bed\u53e5" + sql + "\u7684\u53c2\u6570\u6700\u591a\u4e00\u7ec4\uff0c\u76ee\u524d\u4e3a" + parameters + "\u3002");
            }
            if (parameters != null && parameters.size() > 0) {
                ExecuteUtil.setParameters(preparedStatement, parameters.get(0));
            }
            try {
                Object[] actions = new Object[]{dsnName, ": ", sql, parameters != null && parameters.size() > 0 ? parameters.get(0) : null};
                int action = Performance.startAction((Object[])actions);
                ResultSet resultSet = preparedStatement.executeQuery();
                Performance.endActive((int)action, (Object[])actions);
                result = DataTableResultSet.wrap(resultSet);
            }
            catch (SQLException e) {
                if (e != null && RuntimeDDL.isMySqlNotExistTableOrFieldOrView(e)) {
                    throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u6709\u53d8\u52a8\uff0c\u672a\u80fd\u521b\u5efa\u5bf9\u5e94\u7684\u8868\u6216\u5b57\u6bb5\uff0c\u8bf7\u5728server.properties\u4e2d\u8bbe\u7f6eMaster=true\u5e76\u91cd\u542f\u670d\u52a1", e);
                }
                throw e;
            }
        }
        return result;
    }
}

