/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSqls;
import com.bokesoft.yes.mid.mysqls.execute.OneQuery;
import com.bokesoft.yes.mid.mysqls.execute.QueryPlan;
import com.bokesoft.yes.mid.mysqls.execute.SelectExecute;
import com.bokesoft.yes.mid.mysqls.processselect.IComplexSQL;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.RelationBetweenSubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQueryWithRelation;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuerys;
import com.bokesoft.yes.mid.mysqls.processselect.Unions;
import com.bokesoft.yes.mid.mysqls.result.process.util.ResultProcessUtils;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.FunctionGroupProcess;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetUtil;
import com.bokesoft.yes.mid.mysqls.sql.FindJdbcParameter;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.Distinct;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.Union;

public class SelectCrossGroupExecute {
    public static ResultSetGetObjectByPos execute(MultiDBManager dbManager, MultiDBPreparedStatement preparedStatement) throws SQLException {
        String sql = preparedStatement.getSql();
        SelectSqlInfo sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        sqlInfo.processFunctionGroupByOrderBy();
        return SelectCrossGroupExecute.execute(dbManager, preparedStatement, sqlInfo);
    }

    public static ResultSetGetObjectByPos execute(MultiDBManager dbManager, MultiDBPreparedStatement preparedStatement, SelectSqlInfo sqlInfo) throws SQLException {
        return SelectCrossGroupExecute.execute(dbManager, preparedStatement, sqlInfo, false);
    }

    public static ResultSetGetObjectByPos execute(MultiDBManager dbManager, MultiDBPreparedStatement preparedStatement, SelectSqlInfo sqlInfo, boolean fromUnion) throws SQLException {
        IComplexSQL complexSQL = sqlInfo.getComplexSQL();
        if (complexSQL instanceof Unions) {
            return SelectCrossGroupExecute.execute(dbManager, sqlInfo, (Unions)complexSQL, preparedStatement, true);
        }
        ResultSetGetObjectByPos result = SelectCrossGroupExecute.execute(dbManager, sqlInfo, (SubQuerys)complexSQL, preparedStatement);
        Parameters paras = ResultProcessUtils.getParameters(preparedStatement);
        return FunctionGroupProcess.processFinal(sqlInfo, result, paras, fromUnion);
    }

    private static ResultSetGetObjectByPos execute(MultiDBManager dbManager, SelectSqlInfo sqlInfo, Unions unions, MultiDBPreparedStatement preparedStatement, boolean fromUnion) throws SQLException {
        Parameters paras = ResultProcessUtils.getParameters(preparedStatement);
        ArrayList<ResultSetGetObjectByPos> rsList = new ArrayList<ResultSetGetObjectByPos>();
        int i = 0;
        int size = unions.getSubSelectsList().size();
        while (i < size) {
            SubQuerys subSelects = unions.getSubSelectsList().get(i);
            SelectSqlInfo subSqlInfo = subSelects.getSelectSqlInfo();
            ResultSetGetObjectByPos rs = SelectCrossGroupExecute.execute(dbManager, preparedStatement, subSqlInfo, fromUnion);
            boolean bSum = false;
            for (SubQuery subQuery : subSelects.getSubQuerys()) {
                if (!subQuery.getPlainSelect().hasAssistCol()) continue;
                bSum = true;
            }
            if (bSum) {
                ResultSetGetObjectByPos sumRS = FunctionGroupProcess.processFinal(subSqlInfo, rs, paras, fromUnion);
                rsList.add(sumRS);
            } else {
                rsList.add(rs);
            }
            ++i;
        }
        return ResultProcessUtils.processResults(sqlInfo, rsList, paras, !unions.isAll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResultSetGetObjectByPos execute(MultiDBManager dbManager, SelectSqlInfo sqlInfo, SubQuerys subSelects, MultiDBPreparedStatement preparedStatement) throws SQLException {
        QueryPlan queryPlan;
        QueryPlan queryPlan2 = queryPlan = subSelects != null ? subSelects.getQueryPlan() : null;
        if (queryPlan == null) {
            try (MultiDBPreparedStatement ps = null;){
                ResultSetGetObjectByPos resultSet;
                ps = (MultiDBPreparedStatement)dbManager.prepareStatementJDBC(sqlInfo.getSql());
                List<JdbcParameter> curJdbcParameters = FindJdbcParameter.getAllJdbcParameters(sqlInfo.getSelect());
                List<Parameters> psParametersList = preparedStatement.getParametersList();
                psParametersList = ResultProcessUtils.genNewPrametersList(psParametersList, sqlInfo.getRemovedParameterIndexes());
                int parasListSize = psParametersList.size();
                int curParasSize = curJdbcParameters.size();
                if (parasListSize > 0) {
                    ArrayList<Parameters> subParametersList = new ArrayList<Parameters>(parasListSize);
                    int i = 0;
                    while (i < parasListSize) {
                        Parameters allParameters = psParametersList.get(i);
                        Parameters subParamters = new Parameters(curParasSize);
                        int j = 0;
                        while (j < curParasSize) {
                            Integer indexInSql = curJdbcParameters.get(j).getIndexInSql();
                            subParamters.setArg(j + 1, allParameters.getType(indexInSql + 1), allParameters.getValue(indexInSql + 1));
                            ++j;
                        }
                        subParametersList.add(subParamters);
                        ++i;
                    }
                    ps.setParametersList(subParametersList);
                } else if (curParasSize > 0) {
                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5b50\u53e5\u6267\u884c\u65f6\u6ca1\u6709\u53c2\u6570\u3002");
                }
                ResultSetGetObjectByPos resultSetGetObjectByPos = resultSet = SelectExecute.execute(dbManager, ps);
                return resultSetGetObjectByPos;
            }
        }
        HashMap<SubQuery, ResultSetGetObjectByPos> datas = new HashMap<SubQuery, ResultSetGetObjectByPos>();
        for (OneQuery oneQuery : queryPlan.queries) {
            DataTableResultSet rs;
            Object rightSelectItem;
            SubQuery subSelect = oneQuery.subQuery;
            SubQueryWithRelation subQueryWithRelation = new SubQueryWithRelation(subSelect);
            boolean isNoResult = false;
            ArrayList<Integer> jdbcTypeList = new ArrayList<Integer>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            ArrayList<Parameters> allSubParametersList = new ArrayList<Parameters>();
            if (oneQuery.relations != null) {
                for (RelationBetweenSubQuery relation : oneQuery.relations) {
                    Expression exp;
                    SubQuery rightSubSelect = relation.getRightSubQuery();
                    ResultSet rightResultSet = (ResultSet)datas.get(rightSubSelect);
                    if (rightSubSelect.isInSelect()) {
                        queryPlan.addHasInOtherQuery(rightSubSelect);
                    }
                    rightSelectItem = relation.getRightSelectItem();
                    HashMapIgnoreCase<String> fieldsChangeAlias = rightSubSelect.getFieldsChangeAlias();
                    Column rightColumn = relation.getRightColumn();
                    String columnName = fieldsChangeAlias != null && fieldsChangeAlias.containsKey(rightColumn.getWholeColumnName()) ? (String)fieldsChangeAlias.get(rightColumn.getWholeColumnName()) : ((SelectExpressionItem)rightSelectItem).getColumnNameInResultSet();
                    List<Object> values = ResultSetUtil.getValues(rightResultSet, columnName);
                    int allvaluesSize = valueList.size();
                    if (values != null && values.size() > 0) {
                        int jdbcType = ResultSetUtil.getJdbcType(rightResultSet, columnName);
                        if (jdbcType == -9) {
                            jdbcType = 12;
                        }
                        jdbcTypeList.add(jdbcType);
                        valueList.addAll(values);
                        int size = values.size();
                        int i = 1;
                        while (i < size) {
                            jdbcTypeList.add(jdbcType);
                            ++i;
                        }
                    }
                    if ((exp = ParsedSqlUtil.newExpression(relation.getLeftExpression(), relation.isEqual(), relation.isInner(), values, allvaluesSize)) == ParsedSqlUtil.Exp_Impossible) {
                        isNoResult = true;
                    }
                    subQueryWithRelation.addRelationExp(exp);
                    if (rightSubSelect.isInSelect()) continue;
                    subQueryWithRelation.addColumn(relation.getLeftColumn());
                }
            }
            if (subSelect.isMainSelect() && subSelect.getPlainSelect().hasInAllTable(sqlInfo.getInTableGroups())) {
                subSelect.getPlainSelect().setDistinct(new Distinct());
            }
            String sql = subQueryWithRelation.getSql(preparedStatement, allSubParametersList, subSelect, valueList, jdbcTypeList);
            if (isNoResult) {
                DataTableMetaData dataTableMetaData;
                block31: {
                    ParsedSelect parsedSelect = (ParsedSelect)ParsedSqls.getInstance().getParsedSql(sql);
                    dataTableMetaData = null;
                    try {
                        dataTableMetaData = parsedSelect.getDataTableMetaData();
                        if (dataTableMetaData != null) break block31;
                        rightSelectItem = parsedSelect;
                        synchronized (rightSelectItem) {
                            dataTableMetaData = parsedSelect.getDataTableMetaData();
                            if (dataTableMetaData == null) {
                                String dsnName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
                                DataTable dataTable = allSubParametersList.size() == 0 ? dbManager.execPrepareQuery(dsnName, sql, new Object[0]) : dbManager.execPrepareQuery(dsnName, sql, ((Parameters)allSubParametersList.get(0)).asValueList());
                                dataTableMetaData = dataTable.getMetaData();
                                parsedSelect.setDataTableMetaData(dataTableMetaData);
                            }
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u5206\u6b65\u6267\u884c" + sql + "\u51fa\u9519\u3002", e);
                    }
                }
                rs = new DataTableResultSet(new DataTable(dataTableMetaData), null);
            } else {
                try (MultiDBPreparedStatement ps = null;){
                    ps = (MultiDBPreparedStatement)dbManager.prepareStatementJDBC(sql);
                    ps.setParametersList(allSubParametersList);
                    ResultSetGetObjectByPos resultSet = SelectExecute.execute(dbManager, ps);
                    rs = DataTableResultSet.wrap(resultSet);
                }
            }
            datas.put(subSelect, rs);
        }
        boolean hasUnion = subSelects.getParentSelectSqlInfo().getSelect().getSelectBody() instanceof Union;
        JoinResultSet result = new JoinResultSet(hasUnion ? sqlInfo : subSelects.getParentSelectSqlInfo(), queryPlan, datas, preparedStatement.getParametersList());
        return result;
    }
}

