/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExecuteUtil {
    private static final HashMapIgnoreCase<String> tableAllColumnNames = new HashMapIgnoreCase();
    private static final String[] jdbcParameters = new String[200];

    public static void setParameters(PreparedStatement preparedStatement, Parameters parameters) throws SQLException {
        if (parameters == null) {
            return;
        }
        int size = parameters.size();
        int i = 1;
        while (i <= size) {
            int type = parameters.getType(i);
            Object value = parameters.getValue(i);
            if (value == null) {
                preparedStatement.setNull(i, type);
            } else {
                switch (type) {
                    case 2: 
                    case 3: {
                        preparedStatement.setBigDecimal(i, (BigDecimal)value);
                        break;
                    }
                    case 91: {
                        preparedStatement.setDate(i, (Date)value);
                        break;
                    }
                    case 4: {
                        preparedStatement.setInt(i, (Integer)value);
                        break;
                    }
                    case -5: {
                        preparedStatement.setLong(i, (Long)value);
                        break;
                    }
                    case 12: {
                        preparedStatement.setString(i, (String)value);
                        break;
                    }
                    case 92: {
                        preparedStatement.setTime(i, (Time)value);
                        break;
                    }
                    case 93: {
                        preparedStatement.setTimestamp(i, (Timestamp)value);
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u76ee\u524d\u4e0d\u652f\u6301\u7684\u7c7b\u578b" + type);
                    }
                }
            }
            ++i;
        }
    }

    public static boolean isDDL(String sql) {
        return StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"ALTER") || StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"DROP") || StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"CREATE") || StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"RENAME");
    }

    public static boolean isMerge(String sql) {
        return StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"merge");
    }

    public static String getAllColumnName(IDBManager dbm, String tableName) {
        String result = (String)tableAllColumnNames.get(tableName);
        if (result == null) {
            StringBuilder allFields = new StringBuilder(256);
            try {
                for (MetaColumn column : DataObjects.getInstance().getColumnsByTableName(tableName).values()) {
                    if (allFields.length() > 0) {
                        allFields.append(", ");
                    }
                    dbm.appendKeyWordEscape(allFields, column.getBindingDBColumnName());
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("\u53d6\u8868" + tableName + "\u7ed3\u6784\u51fa\u9519\u3002", e);
            }
            result = allFields.toString();
            tableAllColumnNames.put(tableName, (Object)result);
        }
        return result;
    }

    public static String getJDBCParameters(int count) {
        if (count < 200) {
            if (jdbcParameters[count] == null) {
                ExecuteUtil.jdbcParameters[count] = ExecuteUtil.getJDBCParametersNoCache(count);
            }
            return jdbcParameters[count];
        }
        return ExecuteUtil.getJDBCParametersNoCache(count);
    }

    private static String getJDBCParametersNoCache(int count) {
        StringBuilder sb = new StringBuilder(count * 2);
        if (count > 0) {
            sb.append("?");
        }
        int i = 1;
        while (i < count) {
            sb.append(",?");
            ++i;
        }
        return sb.toString();
    }

    public static int[] mergeExecuteBatchResult(MultiDBPreparedStatement mdbPreparedStatement, int[] result, List<Parameters> subParametersList, int[] subResult) {
        List<Parameters> parametersList = mdbPreparedStatement.getParametersList();
        int size = parametersList.size();
        if (result == null) {
            result = new int[size];
        }
        int i = 0;
        int subSize = subParametersList.size();
        while (i < subSize) {
            Parameters tmp = subParametersList.get(i);
            int j = 0;
            while (j < size) {
                if (parametersList.get(j) == tmp) {
                    int n = j;
                    result[n] = result[n] + subResult[i];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int[] mergeExecuteBatchResult(MultiDBPreparedStatement mdbPreparedStatement, int[] result, Parameters subParameters, int subResult) {
        int size;
        List<Parameters> parametersList = mdbPreparedStatement.getParametersList();
        int n = size = parametersList == null || parametersList.size() == 0 ? 1 : parametersList.size();
        if (result == null) {
            result = new int[size];
        }
        if (subParameters == null) {
            result[0] = result[0] + subResult;
        } else {
            int j = 0;
            while (j < size) {
                if (parametersList.size() == 0) {
                    result[0] = result[0] + subResult;
                    break;
                }
                if (parametersList.get(j) == subParameters) {
                    int n2 = j;
                    result[n2] = result[n2] + subResult;
                    break;
                }
                ++j;
            }
        }
        return result;
    }
}

