/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dbstruct;

import com.bokesoft.erp.index.ERPCreateIndex;
import com.bokesoft.erp.index.TableIndex;
import com.bokesoft.erp.index.TableIndexes;
import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.erp.mid.schema.ERPSchemaViewDependSchemaTable;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.dbstruct.SchemaProcess;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RuntimeDDL {
    public static void checkViewStruct(String dsnName, ERPSchemaViewDependSchemaTable views, HashMapIgnoreCase<String> ensureViewNameOneDSN, DBStruct dbStruct) throws Throwable {
        IDBManager dbManager = MultiDBManager.createDBManager(dsnName);
        Map<String, String> viewSqls = views.generateViewSqls(dbManager);
        String viewName = "";
        String viewSql = "";
        try {
            try {
                for (Map.Entry<String, String> entry : viewSqls.entrySet()) {
                    viewName = entry.getKey();
                    viewSql = entry.getValue();
                    if (ensureViewNameOneDSN.containsKey(viewName)) continue;
                    if (dbStruct.existTableOrViewName(dsnName, viewName)) {
                        String sql = new SqlString().append("drop view ").append(viewName).getSql();
                        dbManager.execPrepareUpdate(sql, new Object[0]);
                    }
                    dbManager.execPrepareUpdate(viewSql, new Object[0]);
                    ensureViewNameOneDSN.put(viewName, (Object)viewName);
                }
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
                throw new SQLException("\u68c0\u67e5\u89c6\u56fe" + viewName + "\u7ed3\u6784\u5931\u8d25\u3002DSN=" + dsnName, e);
            }
        }
        finally {
            dbManager.commit();
            dbManager.close();
        }
    }

    public static void checkTableStruct(IDBManager dbManager, String dsnName, String tableName, DBStruct dbStruct, ERPSchemaProcess schemaProcess) throws SQLException {
        try {
            List<MetaDataObject> dataObjects = DataObjects.getInstance().getDataObjectsByTableName(tableName);
            if (dataObjects == null) {
                return;
            }
            block2: for (MetaDataObject dataObject : dataObjects) {
                for (MetaTable metaTable : dataObject.getTableCollection()) {
                    if (!metaTable.getKey().equalsIgnoreCase(tableName)) continue;
                    if (!metaTable.isPersist().booleanValue() || metaTable.getSourceType() == 1 || metaTable.getSourceType() == 2) break;
                    RuntimeDDL.checkTableStruct(dbManager, dataObject, tableName, dsnName, dbStruct);
                    break;
                }
                if (dataObject.getSecondaryType() != 6 || dataObject.getMigrationUpdateStrategy() != 5) continue;
                ArrayList tableList = dataObject.getSchemeTableList();
                for (MetaSchemaTable metaSchemaTable : tableList) {
                    if (!metaSchemaTable.getKey().equalsIgnoreCase(tableName)) continue;
                    RuntimeDDL.checkTableStruct(dbManager, dataObject, tableName, dsnName, dbStruct);
                    continue block2;
                }
            }
            TableIndexes tableIndexes = ERPCreateIndex.getTableIndexes();
            List<TableIndex> tableIndexesTheTable = tableIndexes.getIndexesByTableName(tableName);
            if (tableIndexesTheTable != null) {
                for (TableIndex tableIndex : tableIndexesTheTable) {
                    ERPCreateIndex.createIndex(dbManager, schemaProcess, tableIndex);
                }
            }
            dbManager.commit();
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            throw new SQLException("\u68c0\u67e5\u8868" + tableName + "\u7ed3\u6784\u5931\u8d25\u3002DSN=" + dsnName, e);
        }
    }

    private static void checkTableStruct(IDBManager dbManager, MetaDataObject dataObject, String tableName, String dsnName, DBStruct dbStruct) throws Throwable {
        ArrayList tableList = dataObject.getSchemeTableList();
        if (tableList == null) {
            return;
        }
        Iterator it = tableList.iterator();
        MetaSchemaTable metaTable = null;
        while (it.hasNext()) {
            metaTable = (MetaSchemaTable)it.next();
            if (!metaTable.getKey().equalsIgnoreCase(tableName) && !metaTable.getKey().equalsIgnoreCase(String.valueOf(tableName) + "_LP")) continue;
            SchemaProcess.instance.tableRebuild(dbManager, dsnName, dbStruct, metaTable);
            if (dbStruct == null) continue;
            dbStruct.changeTableStruct(dsnName, metaTable.getKey());
        }
    }

    public static void updateTableStruct(IDBManager dbManager, MetaDataObject dataObject, String dsnName, DBStruct dbStruct, ERPSchemaProcess schemaProcess) throws Throwable {
        ArrayList tableList = dataObject.getSchemeTableList();
        if (tableList == null) {
            return;
        }
        Iterator it = tableList.iterator();
        MetaSchemaTable metaTable = null;
        while (it.hasNext()) {
            metaTable = (MetaSchemaTable)it.next();
            SchemaProcess.instance.tableRebuild(dbManager, dsnName, dbStruct, metaTable);
        }
        if (dataObject.getSecondaryType() == 6 && dataObject.getMigrationUpdateStrategy() == 5) {
            MetaTable table = dataObject.getMigrationLastPointTable();
            if (table != null) {
                dbStruct.ensureTableName(dbManager, dsnName, table.getKey(), schemaProcess);
            }
            ERPSchemaViewDependSchemaTable views = new ERPSchemaViewDependSchemaTable(dataObject);
            RuntimeDDL.checkViewStruct(dsnName, views, (HashMapIgnoreCase<String>)new HashMapIgnoreCase(), dbStruct);
            dbStruct.ensureViewName(dsnName, views);
        }
    }

    public static void checkMetaSchemaTable(String dsnName, MetaSchemaTable metaTable, DBStruct dbStruct) throws SQLException {
        try {
            IDBManager dbManager = MultiDBManager.createDBManager(dsnName);
            SchemaProcess.instance.tableRebuild(dbManager, dsnName, dbStruct, metaTable);
            dbManager.commit();
            dbManager.close();
            if (dbStruct != null) {
                dbStruct.changeTableStruct(dsnName, metaTable.getKey());
            }
        }
        catch (Throwable e) {
            throw new SQLException("\u5efa\u8868" + metaTable.getKey() + "\u5931\u8d25\u3002", e);
        }
    }

    public static boolean isMySqlNotExistTableOrFieldOrView(SQLException ex) {
        String sqlState = ex.getSQLState();
        int errorCode = ex.getErrorCode();
        if (sqlState != null && sqlState.equals("42S02") || errorCode == 1146) {
            return true;
        }
        return errorCode == -204 || errorCode == -206 || errorCode == -575 || errorCode == 1054;
    }

    public static MetaSchemaTable newMetaSchemaTable(String tableName) {
        MetaSchemaTable result = new MetaSchemaTable();
        result.setKey(tableName);
        return result;
    }

    public static MetaSchemaColumn addLongField(MetaSchemaTable table, String columnName) {
        MetaSchemaColumn column = new MetaSchemaColumn();
        column.setKey(columnName);
        column.setDataType(1010);
        table.getColumnCollection().add((KeyPairMetaObject)column);
        return column;
    }

    public static MetaSchemaColumn addStringField(MetaSchemaTable table, String columnName, int length) {
        MetaSchemaColumn column = new MetaSchemaColumn();
        column.setKey(columnName);
        column.setDataType(1002);
        column.setLength(length);
        table.getColumnCollection().add((KeyPairMetaObject)column);
        return column;
    }

    public static void addMetaColumns(MetaSchemaTable table, Collection<MetaColumn> metaColumns) {
        for (MetaColumn column : metaColumns) {
            MetaSchemaColumn schemaColumn = new MetaSchemaColumn();
            schemaColumn.setKey(column.getKey());
            schemaColumn.setCaption(column.getCaption());
            schemaColumn.setDataType(column.getDataType().intValue());
            schemaColumn.setPrecision(column.getPrecision());
            schemaColumn.setScale(column.getScale());
            schemaColumn.setLength(column.getLength());
            schemaColumn.setPK(column.isPrimaryKey().booleanValue());
            table.getColumnCollection().add((KeyPairMetaObject)schemaColumn);
        }
    }
}

