/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration.process;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.migration.groupkeys.GroupKeysUtil;
import com.bokesoft.yes.mid.migration.groupkeys.RowData;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yes.mid.migration.period.PeriodUtil;
import com.bokesoft.yes.mid.migration.process.KeysTableSaveData;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.migration.IPeriodProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MDBKeysTableSaveData {
    public RowData[] saveKeysTable(DefaultContext context, DataTable dataTable, MigrationStruct struct) throws Throwable {
        HashMap<String, ICache<Object>> caches = new HashMap<String, ICache<Object>>();
        int dataTableSize = dataTable.size();
        RowData[] result = new RowData[dataTableSize];
        Object[][] keyValuesArray = new Object[dataTableSize][struct.getMetaGroupColumnsForGroupID().size()];
        MDBKeysTableSaveData.loadData(dataTable, struct, result, keyValuesArray);
        String newTableName = struct.getNewTableName();
        TableGroupProp tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(newTableName);
        Group group = tableGroupProp.getGroup();
        GroupField[] groupFields = struct.getGroupFields(group);
        int groupFieldSize = groupFields.length;
        String[] columnNames = new String[groupFieldSize];
        int i = 0;
        while (i < groupFieldSize) {
            String columnName;
            columnNames[i] = columnName = group.getColumnNameInTable(groupFields[i], newTableName);
            ++i;
        }
        MetaColumn periodColumn = struct.getMetaPeriodColumn();
        if (periodColumn != null) {
            int periodColumnIndex = dataTable.getMetaData().findColumnIndexByKey(periodColumn.getBindingDBColumnName());
            IPeriodProcess periodProcess = this.getPeriodImpl(context, periodColumn);
            List<MetaColumn> metaPeriodGroupColumns = struct.getMetaPeriodGroupColumns();
            int periodGroupColumnSize = metaPeriodGroupColumns.size();
            String[] periodGroupColumnNames = new String[periodGroupColumnSize];
            int i2 = 0;
            while (i2 < periodGroupColumnSize) {
                periodGroupColumnNames[i2] = metaPeriodGroupColumns.get(i2).getBindingDBColumnName();
                ++i2;
            }
            String loadLastPoindSql = struct.getLoadLastPointSql();
            Object[][] periodGroupValueses = dataTable.fastDistinctValues(periodGroupColumnNames);
            int i3 = 0;
            int size = periodGroupValueses.length;
            while (i3 < size) {
                int minPeriod;
                int maxPeriod;
                DataTable lpDataTable = context.getDBManager().execPrepareQuery(loadLastPoindSql, Arrays.asList(periodGroupValueses[i3]));
                int[] rowIndexes = dataTable.fastFilter(periodGroupColumnNames, periodGroupValueses[i3]);
                if (lpDataTable == null || !lpDataTable.first()) {
                    maxPeriod = DataTableExUtil.getMaxIntValue(dataTable, rowIndexes, periodColumnIndex);
                    minPeriod = DataTableExUtil.getMinIntValue(dataTable, rowIndexes, periodColumnIndex);
                } else {
                    maxPeriod = lpDataTable.getInt(0, 0);
                    minPeriod = DataTableExUtil.getMinIntValue(dataTable, rowIndexes, periodColumnIndex);
                    if (minPeriod > maxPeriod) {
                        maxPeriod = minPeriod;
                    }
                }
                HashMap<String, Object> groupFieldValue = new HashMap<String, Object>();
                int j = 0;
                while (j < periodGroupColumnSize) {
                    groupFieldValue.put(periodGroupColumnNames[j], periodGroupValueses[i3][j]);
                    ++j;
                }
                ArrayList afterPeriodList = new ArrayList();
                periodProcess.getBetweenPeriod(context, (Object)minPeriod, (Object)maxPeriod, periodColumn.getPeriodGranularity().intValue(), groupFieldValue, afterPeriodList);
                Object[][] distinctValues = dataTable.fastDistinctValues(columnNames);
                int distinctValueIndex = 0;
                int distinctValuesize = distinctValues.length;
                while (distinctValueIndex < distinctValuesize) {
                    Object[] groupValue = distinctValues[distinctValueIndex];
                    int[] subRowIndexes = dataTable.fastFilter(columnNames, groupValue);
                    int subRowIndexSize = subRowIndexes.length;
                    RowData[] subRowDatas = new RowData[subRowIndexSize];
                    int j2 = 0;
                    while (j2 < subRowIndexSize) {
                        subRowDatas[j2] = result[subRowIndexes[j2]];
                        ++j2;
                    }
                    for (Object periodTmp : afterPeriodList) {
                        int otherPeriod = TypeConvertor.toInteger(periodTmp);
                        OneGroupValue oneGroupValue = new OneGroupValue();
                        int periodGroudValueIndex = 0;
                        while (periodGroudValueIndex < periodGroupColumnSize) {
                            oneGroupValue.setGroupValue(periodGroupColumnNames[periodGroudValueIndex], periodGroupValueses[i3][periodGroudValueIndex]);
                            ++periodGroudValueIndex;
                        }
                        oneGroupValue.setGroupValue(periodColumn.getBindingDBColumnName(), otherPeriod);
                        oneGroupValue.expandValueByRelation(tableGroupProp);
                        String dsnName = group.getDSNName(newTableName, oneGroupValue);
                        RowData[] rowDataArray = subRowDatas;
                        int n = subRowDatas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RowData data = rowDataArray[n2];
                            data.setGroupId(Long.valueOf(0L));
                            ++n2;
                        }
                        this.saveKeysTable(context, dsnName, subRowDatas, keyValuesArray, struct, caches);
                    }
                    ++distinctValueIndex;
                }
                ++i3;
            }
        } else {
            Object[][] distinctValues = dataTable.fastDistinctValues(columnNames);
            int i4 = 0;
            int size = distinctValues.length;
            while (i4 < size) {
                Object[] groupValue = distinctValues[i4];
                OneGroupValue oneGroupValue = new OneGroupValue();
                int j = 0;
                while (j < groupFieldSize) {
                    oneGroupValue.setGroupValue(groupFields[j].getKey(), groupValue[j]);
                    ++j;
                }
                oneGroupValue.expandValueByRelation(tableGroupProp);
                String dsnName = group.getDSNName(newTableName, oneGroupValue);
                int[] rowIndexes = dataTable.fastFilter(columnNames, groupValue);
                int rowIndexSize = rowIndexes.length;
                RowData[] subRowDatas = new RowData[rowIndexSize];
                int j3 = 0;
                while (j3 < rowIndexSize) {
                    subRowDatas[j3] = result[rowIndexes[j3]];
                    ++j3;
                }
                this.saveKeysTable(context, dsnName, subRowDatas, keyValuesArray, struct, caches);
                ++i4;
            }
        }
        return result;
    }

    private IPeriodProcess getPeriodImpl(DefaultContext context, MetaColumn periodColumn) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String periodImpl = periodColumn.getPeriodImpl();
        Object periodProcess = periodImpl != null && !periodImpl.isEmpty() ? (IPeriodProcess)ReflectHelper.newInstance((VE)context.getVE(), (String)periodImpl) : new PeriodUtil();
        return periodProcess;
    }

    private ICache<Object> getCacheByDSN(Map<String, ICache<Object>> caches, MigrationStruct struct, String dsnName) throws Throwable {
        ICache<Object> result = caches.get(dsnName);
        if (result == null) {
            result = KeysTableSaveData.getCache(struct, dsnName);
            caches.put(dsnName, result);
        }
        return result;
    }

    public static void loadData(DataTable dataTable, MigrationStruct struct, RowData[] rowDatas, Object[][] keyValuesArray) throws Throwable {
        List<MetaColumn> metaGroupColumnsForGroupID = struct.getMetaGroupColumnsForGroupID();
        int columnSize = metaGroupColumnsForGroupID.size();
        int[] columnIndexes = new int[columnSize];
        int i = 0;
        while (i < columnSize) {
            MetaColumn metaColumn = metaGroupColumnsForGroupID.get(i);
            columnIndexes[i] = dataTable.getMetaData().findColumnIndexByKey(metaColumn.getKey());
            ++i;
        }
        int rowIndex = 0;
        int len = dataTable.size();
        while (rowIndex < len) {
            RowData rowData = new RowData();
            int i2 = 0;
            while (i2 < columnSize) {
                Object obj;
                keyValuesArray[rowIndex][i2] = obj = dataTable.getObject(rowIndex, columnIndexes[i2]);
                ++i2;
            }
            rowData.setRowIndex(rowIndex);
            rowData.setGroupId(Long.valueOf(0L));
            rowDatas[rowIndex] = rowData;
            ++rowIndex;
        }
    }

    private static Long getHashCode(RowData rowData, MigrationStruct struct, Object[] keyValues) throws Throwable {
        Long result = rowData.getHashCode();
        if (result == null) {
            int[] dataTypes = struct.getGroupColumnDataTypesForGroupID();
            Long hashCode = 0L;
            int i = 0;
            int size = keyValues.length;
            while (i < size) {
                Object obj = keyValues[i];
                Long value = 0L;
                switch (dataTypes[i]) {
                    case 1010: {
                        value = TypeConvertor.toLong((Object)obj);
                        break;
                    }
                    case 1001: {
                        value = TypeConvertor.toInteger((Object)obj).longValue();
                        break;
                    }
                    case 1002: {
                        String s = TypeConvertor.toString((Object)obj);
                        if (s == null || s.length() <= 0) break;
                        value = Integer.valueOf(s.hashCode()).longValue();
                        break;
                    }
                    default: {
                        String str = TypeConvertor.toString((Object)obj);
                        if (str == null || str.length() <= 0) break;
                        value = Integer.valueOf(str.hashCode()).longValue();
                    }
                }
                if (value != 0L) {
                    hashCode = hashCode * (long)GroupKeysUtil.HASHCODE_STEP + value;
                }
                ++i;
            }
            rowData.setHashCode(result);
            result = hashCode;
        }
        return result;
    }

    private void saveKeysTable(DefaultContext context, String dsnName, RowData[] rowDatas, Object[][] keyValuesArray, MigrationStruct struct, Map<String, ICache<Object>> caches) throws Throwable {
        int keyValueCount = keyValuesArray[0].length;
        ICache<Object> cacheCurDB = this.getCacheByDSN(caches, struct, dsnName);
        int notFoundInCacheCurDB = MDBKeysTableSaveData.loadGroupFromCache(cacheCurDB, rowDatas, keyValuesArray);
        if (notFoundInCacheCurDB > 0) {
            RowData[] notFoundRowDatas = MDBKeysTableSaveData.getGroupIDEqualZeroRowDatas(rowDatas, notFoundInCacheCurDB);
            DataTable keysCurDBData = this.loadKeysFromDB(context, dsnName, notFoundRowDatas, struct, keyValuesArray);
            int notFoundInCurDB = MDBKeysTableSaveData.getGroupIDIntoRowDatas(struct, keysCurDBData, notFoundRowDatas, keyValuesArray);
            MDBKeysTableSaveData.saveKeysDataInCache(keysCurDBData, cacheCurDB, keyValueCount);
            if (notFoundInCurDB > 0) {
                RowData[] notfoundInCurDBRowDatas = MDBKeysTableSaveData.getGroupIDEqualZeroRowDatas(notFoundRowDatas, notFoundInCurDB);
                String defaultDSNName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
                if (!defaultDSNName.equalsIgnoreCase(dsnName)) {
                    ICache<Object> cacheDefaultDB = this.getCacheByDSN(caches, struct, defaultDSNName);
                    int notFoundInCacheDefaultDB = MDBKeysTableSaveData.loadGroupFromCache(cacheCurDB, rowDatas, keyValuesArray);
                    if (notFoundInCacheDefaultDB > 0) {
                        RowData[] notFoundInCacheDefaultDBRowDatas = MDBKeysTableSaveData.getGroupIDEqualZeroRowDatas(notfoundInCurDBRowDatas, notFoundInCacheDefaultDB);
                        DataTable keysDefaultDBData = this.loadKeysFromDB(context, defaultDSNName, notFoundInCacheDefaultDBRowDatas, struct, keyValuesArray);
                        int notFoundInDefaultDB = MDBKeysTableSaveData.getGroupIDIntoRowDatas(struct, keysDefaultDBData, notFoundInCacheDefaultDBRowDatas, keyValuesArray);
                        MDBKeysTableSaveData.saveKeysDataInCache(keysDefaultDBData, cacheDefaultDB, keyValueCount);
                        this.saveInsertKeysInDB(context, dsnName, keysDefaultDBData, struct);
                        MDBKeysTableSaveData.saveKeysDataInCache(keysDefaultDBData, cacheCurDB, keyValueCount);
                        if (notFoundInDefaultDB > 0) {
                            RowData[] notfoundInDefaultDBRowDatas = MDBKeysTableSaveData.getGroupIDEqualZeroRowDatas(notFoundInCacheDefaultDBRowDatas, notFoundInDefaultDB);
                            DataTable insertKeysDefaultDB = MDBKeysTableSaveData.genInsertKeys(context, notfoundInDefaultDBRowDatas, keyValuesArray, struct);
                            this.saveInsertKeysInDB(context, defaultDSNName, insertKeysDefaultDB, struct);
                            MDBKeysTableSaveData.saveKeysDataInCache(keysDefaultDBData, cacheDefaultDB, keyValueCount);
                            this.saveInsertKeysInDB(context, dsnName, insertKeysDefaultDB, struct);
                            MDBKeysTableSaveData.saveKeysDataInCache(insertKeysDefaultDB, cacheCurDB, keyValueCount);
                        }
                    }
                } else {
                    DataTable insertKeysCurDB = MDBKeysTableSaveData.genInsertKeys(context, notfoundInCurDBRowDatas, keyValuesArray, struct);
                    this.saveInsertKeysInDB(context, dsnName, insertKeysCurDB, struct);
                    MDBKeysTableSaveData.saveKeysDataInCache(insertKeysCurDB, cacheCurDB, keyValueCount);
                }
            }
        }
    }

    protected static int loadGroupFromCache(ICache<Object> cache, RowData[] rowDatas, Object[][] keyValuesArray) {
        int notFound = 0;
        Object[][] dsnKeyValueses = MDBKeysTableSaveData.getKeyValueses(rowDatas, keyValuesArray);
        Long[] groupIDs = cache.findGroupIds(dsnKeyValueses);
        int i = 0;
        int rowSize = rowDatas.length;
        while (i < rowSize) {
            Long groupID = groupIDs[i];
            if (groupID == null || groupID.equals(0L)) {
                ++notFound;
            } else {
                rowDatas[i].setGroupId(groupID);
            }
            ++i;
        }
        return notFound;
    }

    private DataTable loadKeysFromDB(DefaultContext context, String dsnName, RowData[] rowDatas, MigrationStruct struct, Object[][] keyValuesArray) throws Throwable {
        String loadSql = struct.getLoadGroupIDFromKeysByHashCodeSql(rowDatas.length);
        MultiDBManager dbManager = (MultiDBManager)context.getDBManager();
        List<Object> notFoundHashCodes = MDBKeysTableSaveData.getHashCodeList(struct, rowDatas, keyValuesArray);
        DataTable keysDBData = dbManager.execPrepareQuery(dsnName, loadSql, notFoundHashCodes);
        return keysDBData;
    }

    private static Object[][] getKeyValueses(RowData[] rowDatas, Object[][] keyValuesArray) {
        int rowSize = rowDatas.length;
        int keyValueCount = keyValuesArray[0].length;
        Object[][] result = new Object[rowSize][keyValueCount];
        int i = 0;
        while (i < rowSize) {
            result[i] = keyValuesArray[rowDatas[i].getRowIndex()];
            ++i;
        }
        return result;
    }

    protected static RowData[] getGroupIDEqualZeroRowDatas(RowData[] rowDatas, int groupIDEqualZeroCount) {
        if (rowDatas.length == groupIDEqualZeroCount) {
            return rowDatas;
        }
        RowData[] groupIDEqualZeroRowDatas = new RowData[groupIDEqualZeroCount];
        int i = 0;
        int j = 0;
        int size = rowDatas.length;
        while (i < size) {
            RowData rowData = rowDatas[i];
            Long groupID = rowData.getGroupId();
            if (groupID == null || groupID.equals(0L)) {
                groupIDEqualZeroRowDatas[j] = rowData;
                ++j;
            }
            ++i;
        }
        return groupIDEqualZeroRowDatas;
    }

    protected static List<Object> getHashCodeList(MigrationStruct struct, RowData[] rowDatas, Object[][] keyValuesArray) throws Throwable {
        int size = rowDatas.length;
        Long[] hashCodes = new Long[size];
        int i = 0;
        while (i < size) {
            RowData rowData = rowDatas[i];
            hashCodes[i] = MDBKeysTableSaveData.getHashCode(rowData, struct, keyValuesArray[rowData.getRowIndex()]);
            ++i;
        }
        return new ArrayList<Object>(Arrays.asList(hashCodes));
    }

    protected static int getGroupIDIntoRowDatas(MigrationStruct struct, DataTable keysDBData, RowData[] rowDatas, Object[][] keyValuesArray) throws Throwable {
        int dbDataSize = keysDBData.size();
        if (dbDataSize == 0) {
            return rowDatas.length;
        }
        int oidColumnIndex = keysDBData.getMetaData().findColumnIndexByKey("OID");
        int noMatch = 0;
        int keyValueCount = keyValuesArray[0].length;
        int rowDataSize = rowDatas.length;
        ArrayList<Integer> foundRowIndexes = new ArrayList<Integer>(rowDataSize);
        int i = 0;
        while (i < rowDataSize) {
            RowData rowData = rowDatas[i];
            Object[] keyValues = keyValuesArray[rowData.getRowIndex()];
            Long hashCode = MDBKeysTableSaveData.getHashCode(rowData, struct, keyValues);
            int[] rowIndexes = keysDBData.fastFilter("HashCode", (Object)hashCode);
            int rowIndexSize = rowIndexes.length;
            boolean found = false;
            if (rowIndexSize > 0) {
                int j = 0;
                while (j < rowIndexSize) {
                    int dbDataIndex = rowIndexes[j];
                    boolean isSame = true;
                    int k = 0;
                    while (k < keyValueCount) {
                        if (TypeConvertor.compare((Object)keyValues[k], (Object)keysDBData.getObject(dbDataIndex, k)) != 0) {
                            isSame = false;
                            break;
                        }
                        ++k;
                    }
                    if (isSame) {
                        rowData.setGroupId(keysDBData.getLong(dbDataIndex, oidColumnIndex));
                        foundRowIndexes.add(dbDataIndex);
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                ++noMatch;
            }
            ++i;
        }
        if (foundRowIndexes.size() != keysDBData.size()) {
            int rowIndex = keysDBData.size() - 1;
            while (rowIndex >= 0) {
                if (!foundRowIndexes.contains(rowIndex)) {
                    keysDBData.delete(rowIndex);
                }
                --rowIndex;
            }
        }
        return noMatch;
    }

    protected static void saveKeysDataInCache(DataTable keysDBData, ICache<Object> cache, int keyValueCount) {
        int dbDataSize = keysDBData.size();
        if (dbDataSize == 0) {
            return;
        }
        int oidColumnIndex = keysDBData.getMetaData().findColumnIndexByKey("OID");
        Object[][] keysArrayInsert = new Object[dbDataSize][keyValueCount];
        Long[] groupIdsInsert = new Long[dbDataSize];
        int dbDataIndex = 0;
        while (dbDataIndex < dbDataSize) {
            Object[] dataList = keysDBData.getRowByIndex(dbDataIndex).getDataList();
            groupIdsInsert[dbDataIndex] = TypeConvertor.toLong((Object)dataList[oidColumnIndex]);
            System.arraycopy(dataList, 0, keysArrayInsert[dbDataIndex], 0, keyValueCount);
            ++dbDataIndex;
        }
        if (!cache.insertGroupIds(keysArrayInsert, groupIdsInsert).booleanValue()) {
            throw new RuntimeException("\u5206\u7ec4\u5b57\u6bb5\u503c\u53ca\u5bf9\u5e94\u7684\u5206\u7ec4id\u63d2\u5165\u7f13\u5b58\u5931\u8d25");
        }
    }

    protected static DataTable genInsertKeys(DefaultContext context, RowData[] rowDatas, Object[][] keyValuesArray, MigrationStruct struct) throws Throwable {
        DataTableMetaData dataTableMetaData = struct.getKeysDataTableMetaData();
        DataTable dataTable = new DataTable(dataTableMetaData);
        int keyValueCount = keyValuesArray[0].length;
        int oidColumnIndex = dataTableMetaData.findColumnIndexByKey("OID");
        int groupCountField = dataTableMetaData.findColumnIndexByKey("GroupCountField");
        int veridColumnIndex = dataTableMetaData.findColumnIndexByKey("VERID");
        int hashCodeColumnIndex = dataTableMetaData.findColumnIndexByKey("HashCode");
        RowData[] rowDataArray = rowDatas;
        int n = rowDatas.length;
        int n2 = 0;
        while (n2 < n) {
            RowData rowData = rowDataArray[n2];
            Long groupID = rowData.getGroupId();
            if (groupID == null || groupID.equals(0L)) {
                groupID = context.applyNewOID();
                rowData.setGroupId(groupID);
            }
            int rowIndex = dataTable.append();
            Object[] dataList = dataTable.getRowByIndex(rowIndex).getDataList();
            Object[] keyValues = keyValuesArray[rowData.getRowIndex()];
            int length = keyValues.length;
            if (length > 16) {
                StringBuilder groupCountFieldValue = new StringBuilder(128);
                int i = 15;
                while (i < length) {
                    groupCountFieldValue.append(keyValues[i]).append("/");
                    ++i;
                }
                groupCountFieldValue.deleteCharAt(groupCountFieldValue.length() - 1);
                dataList[groupCountField] = groupCountFieldValue.toString();
            }
            System.arraycopy(keyValues, 0, dataList, 0, keyValueCount);
            dataList[oidColumnIndex] = groupID;
            dataList[veridColumnIndex] = 0;
            dataList[hashCodeColumnIndex] = MDBKeysTableSaveData.getHashCode(rowData, struct, keyValues);
            ++n2;
        }
        return dataTable;
    }

    private void saveInsertKeysInDB(DefaultContext context, String dsnName, DataTable insertKeysCurDB, MigrationStruct struct) throws Throwable {
        if (insertKeysCurDB.size() == 0) {
            return;
        }
        RefObject argumentSize = new RefObject((Object)0);
        String insertSql = struct.getInsertKeysSql((RefObject<Integer>)argumentSize);
        DataTableBatchPsPara batchPsPara = new DataTableBatchPsPara(insertSql, insertKeysCurDB, (Integer)argumentSize.getValue());
        try (IDBManager dbManager = null;){
            dbManager = MultiDBManager.createDBManager(dsnName);
            dbManager.executeUpdate((BatchPsPara)batchPsPara);
            dbManager.commit();
        }
    }
}

