/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration;

import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.migration.AbstractRemigrateStrategy;
import com.bokesoft.yes.mid.migration.TableArgs;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;

public class InsertFastSqlServerStrategy
extends AbstractRemigrateStrategy {
    @Override
    public void batchUpdateData(DefaultContext context, DataTable changeData) throws Throwable {
        ArrayList<MetaColumn> megreColumnList = new ArrayList<MetaColumn>();
        IDBManager dbm = context.getDBManager();
        String megreSQL = this.getInsterMegreSQL(dbm, megreColumnList);
        try (PsPara insertOrUpdatePP = null;){
            insertOrUpdatePP = new PsPara(dbm.preparedUpdateStatement(megreSQL), megreSQL);
            BatchPsPara bpp = new BatchPsPara(megreSQL);
            changeData.beforeFirst();
            while (changeData.next()) {
                TableArgs insertOrUpdateArgs = new TableArgs(changeData, megreColumnList);
                bpp.putArgs((PSArgs)insertOrUpdateArgs);
            }
            dbm.executeUpdate(bpp);
        }
    }

    @Override
    public String getInsterMegreSQL(IDBManager dbm, ArrayList<MetaColumn> megreColumnList) {
        if (this.insterMegreSQL != null) {
            return this.insterMegreSQL;
        }
        MetaTable targetMetaTable = this.migrationParas.getTgtDataObject().getErpMigrationNewTable();
        String DBTableName = targetMetaTable.getKey();
        StringBuilder megreSb = new StringBuilder("merge into ");
        megreSb.append(DBTableName);
        megreSb.append(" as tt using (select ");
        for (MetaColumn column : targetMetaTable) {
            if (!column.isPersist().booleanValue() || column.getKey().equals("SOID") || column.getKey().equals("MapCount") || !column.isPersist().booleanValue()) continue;
            megreSb.append("? as ");
            megreSb.append(dbm.keyWordEscape(column.getBindingDBColumnName()));
            megreSb.append(",");
            megreColumnList.add(column);
        }
        megreSb.setLength(megreSb.length() - 1);
        megreSb.append(") as ts on ");
        megreSb.append("tt.[");
        megreSb.append("GroupId");
        megreSb.append("]=ts.[");
        megreSb.append("GroupId");
        megreSb.append("]");
        MetaColumn periodColumn = this.migrationParas.getPeriodColumn();
        if (periodColumn != null) {
            megreSb.append(" and ");
            megreSb.append("tt.[");
            megreSb.append(periodColumn.getBindingDBColumnName());
            megreSb.append("]=ts.[");
            megreSb.append(periodColumn.getBindingDBColumnName());
            megreSb.append("]");
        }
        megreSb.append(" when matched then update set ");
        for (MetaColumn column : this.migrationParas.getDataColumnList()) {
            MetaDMSourceField sourceField;
            if (!column.isPersist().booleanValue() || column.isSystemControlField().booleanValue() || column.getKey().equals("MapCount") || (sourceField = (MetaDMSourceField)this.migrationParas.getFieldMap().get(column.getKey())) == null) continue;
            String fieldKey = dbm.keyWordEscape(column.getBindingDBColumnName());
            megreSb.append("tt.");
            megreSb.append(fieldKey);
            if (sourceField.getOpSign() == 2) {
                megreSb.append("=ts.");
                megreSb.append(fieldKey);
            } else {
                megreSb.append("=tt.");
                megreSb.append(fieldKey);
                megreSb.append("+ts.");
                megreSb.append(fieldKey);
            }
            megreSb.append(",");
            if (column.getSplitType() != 0) continue;
            String endFiledKey = dbm.keyWordEscape(this.migrationParas.getPeriodEndColumn(column));
            megreSb.append("tt.");
            megreSb.append(endFiledKey);
            megreSb.append("=ts.");
            megreSb.append(fieldKey);
            megreSb.append("+tt.");
            megreSb.append(endFiledKey);
            megreSb.append(",");
        }
        megreSb.setLength(megreSb.length() - 1);
        megreSb.append(" when not matched then insert( ");
        for (MetaColumn column : targetMetaTable) {
            if (!column.isPersist().booleanValue() || column.getKey().equals("MapCount") || !column.isPersist().booleanValue()) continue;
            megreSb.append(dbm.keyWordEscape(column.getBindingDBColumnName()));
            megreSb.append(",");
        }
        megreSb.setLength(megreSb.length() - 1);
        megreSb.append(")values( ");
        for (MetaColumn column : targetMetaTable) {
            if (!column.isPersist().booleanValue() || column.getKey().equals("MapCount") || !column.isPersist().booleanValue()) continue;
            String DBColumnName = dbm.keyWordEscape(column.getBindingDBColumnName());
            MetaColumn dataField = this.migrationParas.getDataFieldByPeriodEndField(column);
            if (dataField != null) {
                DBColumnName = dbm.keyWordEscape(dataField.getBindingDBColumnName());
            }
            megreSb.append("ts.");
            megreSb.append(DBColumnName);
            megreSb.append(",");
        }
        megreSb.setLength(megreSb.length() - 1);
        megreSb.append(");");
        this.insterMegreSQL = megreSb.toString();
        return this.insterMegreSQL;
    }
}

