/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.io.migration.process.merge;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.meta.datamigration.calculate.MigrationDatabjectParas;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.struct.datatype.DataTypeAction;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import org.apache.commons.lang3.ArrayUtils;

public class ErpMigrationDataProcess {
    public DataTable loadData(DefaultContext context, MigrationStruct struct, RefObject<Boolean> hasLoadAll) throws Throwable {
        PrepareSQL limtString;
        String selectIncrSql = struct.getLoadIncrSql();
        IDBManager dbm = context.getDBManager();
        DataTable resulTable = dbm.execPrepareQuery((limtString = dbm.getLimitString(selectIncrSql, "GroupId", true, 0, 1000)).getSQL(), limtString.getPrepareValues());
        hasLoadAll.setValue((Object)(resulTable == null || resulTable.size() < 1000 ? 1 : 0));
        return resulTable;
    }

    public int[] mergeData(DefaultContext context, MigrationStruct struct, DataTable changeData) throws Throwable {
        int changeDataSize = changeData.size();
        if (changeDataSize == 0) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        if (changeDataSize == 1) {
            return new int[1];
        }
        String[] periodAndGroupIDColumns = struct.getPeriodAndGroupIDColumnNames();
        Object[][] periodAndGroupIDValues = changeData.fastDistinctValues(periodAndGroupIDColumns);
        int groupCount = periodAndGroupIDValues.length;
        int[] result = new int[groupCount];
        int i = 0;
        int size = groupCount;
        while (i < size) {
            int[] rowIndexes = changeData.fastFilter(periodAndGroupIDColumns, periodAndGroupIDValues[i]);
            result[i] = rowIndexes[0];
            int j = 1;
            int rowIndexSize = rowIndexes.length;
            while (j < rowIndexSize) {
                int[] sumColumnIndexes;
                int rowIndex = rowIndexes[j];
                int[] nArray = sumColumnIndexes = struct.getIncrSumColumnIndexes();
                int n = sumColumnIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    int columnIndex = nArray[n2];
                    Object value = ErpMigrationDataProcess.add(changeData.getObject(rowIndexes[0], columnIndex), changeData.getObject(rowIndex, columnIndex));
                    changeData.setObject(rowIndexes[0], columnIndex, value);
                    ++n2;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static Object add(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            throw new RuntimeException("\u76ee\u524d\u4f59\u989d\u8868\u7684\u6570\u636e\u4e0d\u652f\u6301nulls\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return TypeConvertor.toBigDecimal((Object)o1).add(TypeConvertor.toBigDecimal((Object)o2));
        }
        if (o1 instanceof Integer || o2 instanceof Integer) {
            return TypeConvertor.toInteger((Object)o1) + TypeConvertor.toInteger((Object)o2);
        }
        throw new RuntimeException("\u76ee\u524d\u4f59\u989d\u8868\u7684\u6570\u636e\u53ea\u652f\u6301BigDecimal\u548cInteger\uff0c\u800c\u73b0\u5728\u7684\u7c7b\u578b\u4e3a" + o1.getClass().getName() + "\u548c" + o2.getClass().getName() + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
    }

    public void calLastPeriod(DataTable changeData, MigrationDatabjectParas migrationParas) throws Throwable {
        if (changeData == null || changeData.isEmpty()) {
            return;
        }
        SortCriteria[] vCriteria = new SortCriteria[]{new SortCriteria("GroupId", true)};
        changeData.setSort(vCriteria);
        changeData.sort();
        changeData.last();
        Long activeRowGid = changeData.getLong("GroupId");
        Long previousRowGid = null;
        boolean createNewKey = false;
        String pk = migrationParas.getPeriodColumn().getKey();
        while (true) {
            int pos = changeData.getPos();
            if (createNewKey) {
                activeRowGid = previousRowGid;
            }
            if (!changeData.previous()) break;
            previousRowGid = changeData.getLong("GroupId");
            if (previousRowGid.compareTo(activeRowGid) == 0) {
                DataTypeAction action = changeData.getMetaData().getColumnInfo(pk).getDataTypeAction();
                if (action.compare(changeData.getObject(pk), changeData.getObject(pos, pk)) > 0) {
                    changeData.setObject(pk, changeData.getObject(pos, pk));
                }
                changeData.delete(pos);
                createNewKey = false;
                continue;
            }
            createNewKey = true;
        }
    }
}

