/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.structure;

import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.dbcache.datatable.ValueDiff;
import com.bokesoft.yes.mid.dbcache.datatable.ValueNotLoad;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;

public class Eval {
    public static Object eval(DataTable data, Row row, Expression expression, ParsedSql sql, QueryArguments paras, int dataType) {
        if (expression instanceof JdbcParameter) {
            JdbcParameter jdbcParameter = (JdbcParameter)expression;
            int jdbcParaIndex = jdbcParameter.getIndexInSql();
            if (jdbcParaIndex == -1) {
                jdbcParaIndex = sql.getJdbcParameters().indexOf(jdbcParameter);
                jdbcParameter.setIndexInSql(jdbcParaIndex);
            }
            return paras.get(jdbcParaIndex);
        }
        if (expression instanceof Column) {
            Column column = (Column)expression;
            int columnIndex = column.getIndexInCache();
            if (columnIndex == -1) {
                String columnName = column.getColumnName();
                columnIndex = data.getMetaData().findColumnIndexByKey(columnName);
                column.setIndexInCache(columnIndex);
            }
            Object value = row.getObject(columnIndex);
            return value;
        }
        if (expression instanceof Parenthesis) {
            return Eval.eval(data, row, ((Parenthesis)expression).getExpression(), sql, paras, dataType);
        }
        if (expression instanceof AndExpression) {
            Object resultLeft = Eval.eval(data, row, ((AndExpression)expression).getLeftExpression(), sql, paras, dataType);
            if (!TypeConvertor.toBoolean((Object)resultLeft).booleanValue()) {
                return false;
            }
            Object resultRight = Eval.eval(data, row, ((AndExpression)expression).getRightExpression(), sql, paras, dataType);
            return TypeConvertor.toBoolean((Object)resultRight);
        }
        if (expression instanceof OrExpression) {
            Object resultLeft = Eval.eval(data, row, ((OrExpression)expression).getLeftExpression(), sql, paras, dataType);
            if (TypeConvertor.toBoolean((Object)resultLeft).booleanValue()) {
                return true;
            }
            Object resultRight = Eval.eval(data, row, ((OrExpression)expression).getRightExpression(), sql, paras, dataType);
            return TypeConvertor.toBoolean((Object)resultRight);
        }
        if (expression instanceof EqualsTo) {
            EqualsTo binaryExpression = (EqualsTo)expression;
            Expression leftExpression = binaryExpression.getLeftExpression();
            Object left = Eval.eval(data, row, leftExpression, sql, paras, dataType);
            Object right = Eval.eval(data, row, binaryExpression.getRightExpression(), sql, paras, dataType);
            boolean leftIsColumn = leftExpression instanceof Column;
            return Eval.isEqual(left, right, leftIsColumn);
        }
        if (expression instanceof InExpression) {
            InExpression inexp = (InExpression)expression;
            ItemsList itemsList = inexp.getItemsList();
            Object result = Eval.eval(data, row, inexp.getLeftExpression(), sql, paras, dataType);
            ExpressionList itemsList1 = (ExpressionList)itemsList;
            List expressions = itemsList1.getExpressions();
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object e : expressions) {
                Expression ex = (Expression)e;
                Object value = Eval.eval(data, row, ex, sql, paras, dataType);
                values.add(value);
            }
            for (Object e : values) {
                boolean isMatch = Eval.isEqual(result, e, true);
                if (!isMatch) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof IsNullExpression) {
            return false;
        }
        if (expression instanceof GreaterThanEquals) {
            boolean leftIsColumn;
            Expression rightExpression;
            Object rightResult;
            GreaterThanEquals greaterThanEx = (GreaterThanEquals)expression;
            Expression leftExpression = greaterThanEx.getLeftExpression();
            Object leftResult = Eval.eval(data, row, leftExpression, sql, paras, dataType);
            return Eval.isEqual(leftResult, rightResult = Eval.eval(data, row, rightExpression = greaterThanEx.getRightExpression(), sql, paras, dataType), leftIsColumn = leftExpression instanceof Column) ? Boolean.valueOf(true) : Eval.greaterThanOrMinor(leftResult, rightResult);
        }
        if (expression instanceof MinorThanEquals) {
            boolean leftIsColumn;
            Expression rightExpression;
            Object rightResult;
            MinorThanEquals minorThanEquals = (MinorThanEquals)expression;
            Expression leftExpression = minorThanEquals.getLeftExpression();
            Object leftResult = Eval.eval(data, row, leftExpression, sql, paras, dataType);
            return Eval.isEqual(leftResult, rightResult = Eval.eval(data, row, rightExpression = minorThanEquals.getRightExpression(), sql, paras, dataType), leftIsColumn = leftExpression instanceof Column) ? Boolean.valueOf(true) : Eval.greaterThanOrMinor(rightResult, leftResult);
        }
        if (expression instanceof NotEqualsTo) {
            boolean leftIsColumn;
            Object rightResult;
            NotEqualsTo notEqualsTo = (NotEqualsTo)expression;
            Object leftResult = Eval.eval(data, row, notEqualsTo.getLeftExpression(), sql, paras, dataType);
            return !Eval.isEqual(leftResult, rightResult = Eval.eval(data, row, notEqualsTo.getRightExpression(), sql, paras, dataType), leftIsColumn = notEqualsTo.getLeftExpression() instanceof Column);
        }
        if (expression instanceof GreaterThan) {
            GreaterThan binaryExpression = (GreaterThan)expression;
            Object left = Eval.eval(data, row, binaryExpression.getLeftExpression(), sql, paras, dataType);
            Object right = Eval.eval(data, row, binaryExpression.getRightExpression(), sql, paras, dataType);
            return Eval.greaterThanOrMinor(left, right);
        }
        if (expression instanceof MinorThan) {
            MinorThan binaryExpression = (MinorThan)expression;
            Object left = Eval.eval(data, row, binaryExpression.getLeftExpression(), sql, paras, dataType);
            Object right = Eval.eval(data, row, binaryExpression.getRightExpression(), sql, paras, dataType);
            return Eval.greaterThanOrMinor(right, left);
        }
        if (!(expression instanceof Between)) {
            if (expression instanceof LongValue) {
                return ((LongValue)expression).getValue();
            }
            if (expression instanceof StringValue) {
                return ((StringValue)expression).getValue();
            }
            if (expression instanceof Addition) {
                Addition binaryExpression = (Addition)expression;
                Object left = Eval.eval(data, row, binaryExpression.getLeftExpression(), sql, paras, dataType);
                Object right = Eval.eval(data, row, binaryExpression.getRightExpression(), sql, paras, dataType);
                boolean leftIsColumn = binaryExpression.getLeftExpression() instanceof Column;
                return Eval.add(left, right, dataType, leftIsColumn);
            }
            if (expression instanceof Subtraction) {
                Subtraction binaryExpression = (Subtraction)expression;
                Object left = Eval.eval(data, row, binaryExpression.getLeftExpression(), sql, paras, dataType);
                Object right = Eval.eval(data, row, binaryExpression.getRightExpression(), sql, paras, dataType);
                boolean leftIsColumn = binaryExpression.getLeftExpression() instanceof Column;
                return Eval.subtract(left, right, dataType, leftIsColumn);
            }
            if (expression instanceof Function) {
                return false;
            }
        }
        throw new RuntimeException("com.bokesoft.yes.mid.dbcache.structure.CachedTable.eval()\uff0c\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u3002" + expression);
    }

    private static boolean isEqual(Object left, Object right, boolean leftIsColumn) {
        Object compareValue;
        Object columnValue;
        Object object = columnValue = leftIsColumn ? left : right;
        if (columnValue == null) {
            return false;
        }
        Object object2 = compareValue = leftIsColumn ? right : left;
        if (columnValue instanceof Long) {
            return ((Long)columnValue).equals(TypeConvertor.toLong((Object)compareValue));
        }
        if (columnValue instanceof Integer) {
            return ((Integer)columnValue).equals(TypeConvertor.toInteger((Object)compareValue));
        }
        if (columnValue instanceof BigDecimal) {
            return ((BigDecimal)columnValue).compareTo(TypeConvertor.toBigDecimal((Object)compareValue)) == 0;
        }
        if (columnValue instanceof String) {
            String stringCompareValue = TypeConvertor.toString((Object)compareValue);
            if ("".equals(columnValue) && "  ".equals(stringCompareValue) || "".equals(stringCompareValue) && "  ".equals(columnValue)) {
                return true;
            }
            return ((String)columnValue).equals(stringCompareValue);
        }
        throw new RuntimeException("isEqual()\u4e0d\u652f\u6301\u7684\u8ba1\u7b97\u7c7b\u578bleft:" + left + "\tright:" + right);
    }

    private static Object add(Object left, Object right, int dataType, boolean leftIsColumn) {
        if (left instanceof ValueNotLoad) {
            return new ValueDiff(right);
        }
        if (dataType > 0) {
            if (dataType == 1001) {
                return Math.addExact(TypeConvertor.toInteger((Object)left), TypeConvertor.toInteger((Object)right));
            }
            if (dataType == 1010) {
                return Math.addExact(TypeConvertor.toLong((Object)left), TypeConvertor.toLong((Object)right));
            }
            if (dataType == 1005) {
                return TypeConvertor.toBigDecimal((Object)left).add(TypeConvertor.toBigDecimal((Object)right));
            }
            if (left == null && right != null) {
                return right;
            }
        }
        if (leftIsColumn) {
            if (left instanceof Integer) {
                return Math.addExact(TypeConvertor.toInteger((Object)left), TypeConvertor.toInteger((Object)right));
            }
            if (left instanceof Long) {
                return Math.addExact(TypeConvertor.toLong((Object)left), TypeConvertor.toLong((Object)right));
            }
            if (left instanceof BigDecimal) {
                return TypeConvertor.toBigDecimal((Object)left).add(TypeConvertor.toBigDecimal((Object)right));
            }
            if (left == null && right != null) {
                return right;
            }
        } else {
            if (right instanceof Integer) {
                return Math.addExact(TypeConvertor.toInteger((Object)left), TypeConvertor.toInteger((Object)right));
            }
            if (right instanceof Long) {
                return Math.addExact(TypeConvertor.toLong((Object)left), TypeConvertor.toLong((Object)right));
            }
            if (right instanceof BigDecimal) {
                return TypeConvertor.toBigDecimal((Object)left).add(TypeConvertor.toBigDecimal((Object)right));
            }
            if (right == null && left != null) {
                return left;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8ba1\u7b97\u7c7b\u578bleft:" + left + "\tright:" + right);
    }

    private static Object subtract(Object left, Object right, int dataType, boolean leftIsColumn) {
        if (left instanceof ValueNotLoad) {
            return new ValueDiff(Eval.negate(right));
        }
        if (dataType > 0) {
            if (dataType == 1001) {
                return Math.addExact(TypeConvertor.toInteger((Object)left), TypeConvertor.toInteger((Object)right));
            }
            if (dataType == 1010) {
                return Math.addExact(TypeConvertor.toLong((Object)left), TypeConvertor.toLong((Object)right));
            }
            if (dataType == 1005) {
                return TypeConvertor.toBigDecimal((Object)left).add(TypeConvertor.toBigDecimal((Object)right));
            }
            if (left == null && right != null) {
                return right;
            }
        }
        if (leftIsColumn) {
            if (left instanceof Integer) {
                return Math.subtractExact(TypeConvertor.toInteger((Object)left), TypeConvertor.toInteger((Object)right));
            }
            if (left instanceof Long) {
                return Math.subtractExact(TypeConvertor.toLong((Object)left), TypeConvertor.toLong((Object)right));
            }
            if (left instanceof BigDecimal) {
                return TypeConvertor.toBigDecimal((Object)left).add(TypeConvertor.toBigDecimal((Object)right));
            }
        } else {
            if (right instanceof Integer) {
                return Math.subtractExact(TypeConvertor.toInteger((Object)left), TypeConvertor.toInteger((Object)right));
            }
            if (right instanceof Long) {
                return Math.subtractExact(TypeConvertor.toLong((Object)left), TypeConvertor.toLong((Object)right));
            }
            if (right instanceof BigDecimal) {
                return TypeConvertor.toBigDecimal((Object)left).subtract(TypeConvertor.toBigDecimal((Object)right));
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8ba1\u7b97\u7c7b\u578bleft:" + left + "\tright:" + right);
    }

    private static Object negate(Object obj) {
        if (obj instanceof Integer) {
            return -TypeConvertor.toInteger((Object)obj).intValue();
        }
        if (obj instanceof Long) {
            return -TypeConvertor.toLong((Object)obj).longValue();
        }
        if (obj instanceof BigDecimal) {
            return TypeConvertor.toBigDecimal((Object)obj).negate();
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8ba1\u7b97\u7c7b\u578bobj:" + obj);
    }

    private static Object max(Object left, Object right) {
        Number result = null;
        if (left instanceof Integer) {
            result = Math.max(TypeConvertor.toInteger((Object)left), TypeConvertor.toInteger((Object)right));
        } else if (left instanceof Long) {
            result = Math.max(TypeConvertor.toLong((Object)left), TypeConvertor.toLong((Object)right));
        } else if (left instanceof BigDecimal) {
            result = TypeConvertor.toBigDecimal((Object)left).max(TypeConvertor.toBigDecimal((Object)right));
        }
        return result;
    }

    private static Object greaterThanOrMinor(Object left, Object right) {
        BigDecimal value2;
        BigDecimal value1 = TypeConvertor.toBigDecimal((Object)left);
        if (value1.compareTo(value2 = TypeConvertor.toBigDecimal((Object)right)) > 0) {
            return true;
        }
        return false;
    }
}

