/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.preload;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.connection.dbmanager.PreparedStatementWithLog;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.dbcache.WhereExpressionForCache;
import com.bokesoft.yes.mid.dbcache.config.TablePrimarySetting;
import com.bokesoft.yes.mid.dbcache.parsedsql.LongOrLongArray;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.preload.PreLoadData;
import com.bokesoft.yes.mid.dbcache.structure.CacheTable;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PreLoad {
    private static final int ARGS_LIMIT_LENGTH = 512;

    public static boolean preLoad(CacheTable cacheTable, IDBManager dbm, String tableName, ParsedSelect select, QueryArguments paras) throws Throwable {
        Long soid;
        List<WhereExpressionForCache> preLoadingArguments = cacheTable.getPreLoadingArguments();
        if (preLoadingArguments != null && preLoadingArguments.size() > 0) {
            return PreLoad.preLoadByPreLoadingArguments(cacheTable, dbm, preLoadingArguments);
        }
        if (cacheTable.dataIsNull()) {
            if (select.hasOIDWhere()) {
                LongOrLongArray startLoadOIDs = LongOrLongArray.getLongs(paras, select.getOIDIndex());
                return PreLoad.preLoadByOID_Impl(cacheTable, dbm, startLoadOIDs);
            }
            if (select.getSOIDIndex() >= 0 && select.getSecondFieldIndex() >= 0) {
                Long startLoadSOID = TypeConvertor.toLong((Object)paras.get(select.getSOIDIndex()));
                Long startLoadSecondFieldID = TypeConvertor.toLong((Object)paras.get(select.getSecondFieldIndex()));
                return PreLoad.preLoadBySOIDSecondFiled(cacheTable, dbm, tableName, startLoadSOID, startLoadSecondFieldID);
            }
        }
        if (select.hasOIDWhere()) {
            LongOrLongArray oids = LongOrLongArray.getLongs(paras, select.getOIDIndex());
            if (!cacheTable.existOIDs(oids)) {
                Long[] oidArray = oids.getValueArray();
                if (oidArray != null) {
                    return PreLoad.preLoadByOIDs_Impl2(cacheTable, dbm, oidArray);
                }
                return PreLoad.preLoadByOneOID_Impl2(cacheTable, dbm, oids.getValue());
            }
        } else if (select.getSOIDIndex() >= 0 && !cacheTable.existSOID(soid = TypeConvertor.toLong((Object)paras.get(select.getSOIDIndex())))) {
            return PreLoad.preLoadBySOID(cacheTable, dbm, soid);
        }
        return false;
    }

    public static boolean preLoadByOID(CacheTable cacheTable, IDBManager dbm, Long oid) throws Throwable {
        List<WhereExpressionForCache> preLoadingArguments = cacheTable.getPreLoadingArguments();
        if (preLoadingArguments != null && preLoadingArguments.size() > 0) {
            return PreLoad.preLoadByPreLoadingArguments(cacheTable, dbm, preLoadingArguments);
        }
        if (cacheTable.dataIsNull()) {
            return PreLoad.preLoadByOID_Impl(cacheTable, dbm, oid);
        }
        if (!cacheTable.existOID(oid)) {
            return PreLoad.preLoadByOneOID_Impl2(cacheTable, dbm, oid);
        }
        return false;
    }

    public static boolean preLoadByExpression(CacheTable cacheTable, IDBManager dbm, WhereExpressionForCache whereExpression) throws Throwable {
        Long soid;
        String secondField;
        List<WhereExpressionForCache> preLoadingArguments = cacheTable.getPreLoadingArguments();
        if (preLoadingArguments != null && preLoadingArguments.size() > 0) {
            return PreLoad.preLoadByPreLoadingArguments(cacheTable, dbm, preLoadingArguments);
        }
        String tableName = cacheTable.tableName;
        String string = secondField = TablePrimarySetting.hasGroupSOIDUniqueIndex(tableName) ? TablePrimarySetting.getGroupSOIDUniqueIndexSecondField(tableName) : null;
        if (!whereExpression.soid.equals(WhereExpressionForCache.Long_NotExist) && secondField != null && whereExpression.hasField(secondField) && cacheTable.dataIsNull()) {
            Long startLoadSOID = whereExpression.soid;
            Long startLoadSecondFieldID = (Long)whereExpression.hasValue(secondField);
            return PreLoad.preLoadBySOIDSecondFiled(cacheTable, dbm, tableName, startLoadSOID, startLoadSecondFieldID);
        }
        if (!whereExpression.soid.equals(WhereExpressionForCache.Long_NotExist) && !cacheTable.existSOID(soid = whereExpression.soid)) {
            return PreLoad.preLoadBySOID(cacheTable, dbm, soid);
        }
        if (!whereExpression.oid.equals(WhereExpressionForCache.Long_NotExist)) {
            if (cacheTable.dataIsNull()) {
                return PreLoad.preLoadByOID_Impl(cacheTable, dbm, whereExpression.oid);
            }
            if (!cacheTable.existOID(whereExpression.oid)) {
                return PreLoad.preLoadByOneOID_Impl2(cacheTable, dbm, whereExpression.oid);
            }
        }
        return false;
    }

    private static boolean preLoadByOID_Impl(CacheTable cacheTable, IDBManager dbm, Long startLoadOID) throws Throwable {
        Long[] oids = PreLoadData.getPreLoadOID(cacheTable.tableName, startLoadOID);
        if (oids != null) {
            return PreLoad.preLoadByOIDs_Impl2(cacheTable, dbm, oids);
        }
        return PreLoad.preLoadByOneOID_Impl2(cacheTable, dbm, startLoadOID);
    }

    private static boolean preLoadByOID_Impl(CacheTable cacheTable, IDBManager dbm, LongOrLongArray startLoadOIDs) throws Throwable {
        Long[] oids = PreLoadData.getPreLoadOID(cacheTable.tableName, startLoadOIDs);
        if (oids != null) {
            return PreLoad.preLoadByOIDs_Impl2(cacheTable, dbm, oids);
        }
        Long[] startOIDs = startLoadOIDs.getValueArray();
        if (startOIDs != null) {
            return PreLoad.preLoadByOIDs_Impl2(cacheTable, dbm, startOIDs);
        }
        return PreLoad.preLoadByOneOID_Impl2(cacheTable, dbm, startLoadOIDs.getValue());
    }

    private static boolean preLoadByOIDs_Impl2(CacheTable cacheTable, IDBManager dbm, Long[] oids) throws Throwable {
        boolean result = false;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            SqlString defaultSelect = MetaTableCache.getDefaultSelect(cacheTable.tableName, dbm);
            int count = oids.length % 512 == 0 ? oids.length / 512 : oids.length / 512 + 1;
            int j = 0;
            while (j < count) {
                int from;
                int to = oids.length - (from = j * 512) >= 512 ? from + 512 : oids.length;
                Long[] newOIDs = Arrays.copyOfRange(oids, from, to);
                SqlString sqlString = PreLoad.getSqlStringByOIDs(dbm, defaultSelect, newOIDs);
                statement = dbm.preparedQueryStatement(sqlString.getSql());
                if (statement instanceof PreparedStatementWithLog) {
                    ((PreparedStatementWithLog)statement).noCache();
                }
                Object[] paras = sqlString.getParameters();
                int i = 0;
                int size = paras.length;
                while (i < size) {
                    statement.setObject(i + 1, paras[i]);
                    ++i;
                }
                resultSet = statement.executeQuery();
                if (resultSet != null && cacheTable.appendPreLoad(dbm, resultSet, null)) {
                    result = true;
                }
                ++j;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return result;
    }

    private static boolean preLoadByOneOID_Impl2(CacheTable cacheTable, IDBManager dbm, Long oid) throws Throwable {
        boolean result = false;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            SqlString defaultSelect = MetaTableCache.getDefaultSelect(cacheTable.tableName, dbm);
            SqlString sqlString = PreLoad.getSqlStringByOneOID(dbm, defaultSelect, oid);
            statement = dbm.preparedQueryStatement(sqlString.getSql());
            if (statement instanceof PreparedStatementWithLog) {
                ((PreparedStatementWithLog)statement).noCache();
            }
            List<Object> parameterList = sqlString.getParameterList();
            int i = 0;
            int size = parameterList.size();
            while (i < size) {
                statement.setObject(i + 1, parameterList.get(i));
                ++i;
            }
            resultSet = statement.executeQuery();
            if (resultSet != null && cacheTable.appendPreLoadOneOID(dbm, resultSet, oid)) {
                result = true;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return result;
    }

    public static boolean preLoadByOIDs(CacheTable cacheTable, IDBManager dbm, Long[] oids) throws Throwable {
        if (oids == null || oids.length == 0) {
            return false;
        }
        return PreLoad.preLoadByOIDs_Impl2(cacheTable, dbm, oids);
    }

    private static SqlString getSqlStringByOIDs(IDBManager dbm, SqlString defaultSelect, Long[] oids) throws Throwable {
        SqlString sqlString = new SqlString(defaultSelect.length() + oids.length * 6).append(defaultSelect);
        sqlString.append(" where OID in (").appendPara(oids[0]);
        int i = 1;
        int size = oids.length;
        while (i < size) {
            sqlString.append(", ").appendPara(oids[i]);
            ++i;
        }
        sqlString.append(")");
        return sqlString;
    }

    private static SqlString getSqlStringByOneOID(IDBManager dbm, SqlString defaultSelect, Long startLoadOID) throws Throwable {
        SqlString sqlString = new SqlString().append(defaultSelect);
        sqlString.append(" where OID = ").appendPara(startLoadOID);
        return sqlString;
    }

    private static boolean preLoadBySOIDSecondFiled(CacheTable cacheTable, IDBManager dbm, String tableName, Long startLoadSOID, Long startLoadSecondFieldID) throws Throwable {
        Map<Long, Set<Long>> secondFieldSOIDs = PreLoadData.getPreLoadSecondFieldSOID(tableName, startLoadSecondFieldID, startLoadSOID);
        if (secondFieldSOIDs == null) {
            return PreLoad.preLoadBySOID(cacheTable, dbm, startLoadSOID);
        }
        boolean result = false;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            SqlString defaultSelect = MetaTableCache.getDefaultSelect(tableName, dbm);
            SqlString sqlString = PreLoad.getSqlStringBySecondFieldSOID(defaultSelect, tableName, secondFieldSOIDs, startLoadSecondFieldID, startLoadSOID);
            statement = dbm.preparedQueryStatement(sqlString.getSql());
            if (statement instanceof PreparedStatementWithLog) {
                ((PreparedStatementWithLog)statement).noCache();
            }
            List<Object> parameterList = sqlString.getParameterList();
            int i = 0;
            int size = parameterList.size();
            while (i < size) {
                statement.setObject(i + 1, parameterList.get(i));
                ++i;
            }
            resultSet = statement.executeQuery();
            if (resultSet != null && cacheTable.appendPreLoad(dbm, resultSet, null)) {
                result = true;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return result;
    }

    private static SqlString getSqlStringBySecondFieldSOID(SqlString defaultSelect, String tableName, Map<Long, Set<Long>> secondFieldSOIDs, Long startLoadSOID, Long startLoadSecondFieldID) {
        SqlString sqlString = new SqlString().append(defaultSelect);
        sqlString.append(" where ");
        String secondField = TablePrimarySetting.getGroupSOIDUniqueIndexSecondField(tableName);
        if (secondFieldSOIDs != null) {
            for (Map.Entry<Long, Set<Long>> entry : secondFieldSOIDs.entrySet()) {
                Long secondFieldID = entry.getKey();
                sqlString.append("(").append(secondField).append("=").appendPara(secondFieldID).append(" and SOID in (");
                Set<Long> soids = entry.getValue();
                for (Long soid : soids) {
                    sqlString.appendPara(soid).append(",");
                }
                sqlString.deleteRight(1);
                sqlString.append(")) or ");
            }
            sqlString.deleteRight(4);
        } else {
            sqlString.append("SOID = ").appendPara(startLoadSOID).append(" and ", secondField, " = ").appendPara(startLoadSecondFieldID);
        }
        return sqlString;
    }

    private static boolean preLoadBySOID(CacheTable cacheTable, IDBManager dbm, Long soid) throws Throwable {
        boolean isNewSOID = dbm.getCacheDBRequest().hasSOIDLoadAllInCacheTable(cacheTable.tableName, soid);
        if (isNewSOID) {
            cacheTable.setSOIDLoadAll(soid);
            return true;
        }
        Object[] actions = new Object[]{"preLoadBySOID"};
        int action = Performance.startAction((Object[])actions);
        boolean result = false;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            SqlString defaultSelect = MetaTableCache.getDefaultSelect(cacheTable.tableName, dbm);
            SqlString sqlString = PreLoad.getSqlStringBySOID(defaultSelect, soid);
            statement = dbm.preparedQueryStatement(sqlString.getSql());
            List<Object> parameterList = sqlString.getParameterList();
            int i = 0;
            int size = parameterList.size();
            while (i < size) {
                statement.setObject(i + 1, parameterList.get(i));
                ++i;
            }
            if (statement instanceof PreparedStatementWithLog) {
                ((PreparedStatementWithLog)statement).setParameterCount(parameterList.size());
                ((PreparedStatementWithLog)statement).noCache();
            }
            resultSet = statement.executeQuery();
            Performance.endActive((int)action, (Object[])actions);
            result = cacheTable.appendPreLoad(dbm, resultSet, soid);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return result;
    }

    private static SqlString getSqlStringBySOID(SqlString defaultSelect, Long soid) throws Throwable {
        SqlString sqlString = new SqlString().append(defaultSelect);
        sqlString.append(" where SOID=").appendPara(soid);
        return sqlString;
    }

    private static boolean preLoadByPreLoadingArguments(CacheTable cacheTable, IDBManager dbm, List<WhereExpressionForCache> preLoadingArguments) throws Throwable {
        boolean useIn = dbm.getDBType() != 1;
        List<List<WhereExpressionForCache>> lists = WhereExpressionForCache.groupByColumns(preLoadingArguments);
        SqlString defaultSelect = MetaTableCache.getDefaultSelect(cacheTable.tableName, dbm);
        for (List<WhereExpressionForCache> list : lists) {
            WhereExpressionForCache expression = list.get(0);
            boolean hasOID = !expression.oid.equals(WhereExpressionForCache.Long_NotExist);
            boolean hasSOID = !expression.soid.equals(WhereExpressionForCache.Long_NotExist);
            String[] columnNames = expression.columnNames;
            int columnSize = columnNames == null ? 0 : columnNames.length;
            int singleGoupeCount = 512 % columnSize == 0 ? 512 / columnSize : 512 / columnSize + 1;
            int groupCount = list.size() % singleGoupeCount == 0 ? list.size() / singleGoupeCount : list.size() / singleGoupeCount + 1;
            int ind = 0;
            while (ind < groupCount) {
                int j;
                int to;
                SqlString sqlString = new SqlString().append(defaultSelect).append(" where ");
                int from = ind * singleGoupeCount;
                int n = to = list.size() - from >= singleGoupeCount ? from + singleGoupeCount : list.size();
                if (useIn) {
                    sqlString.append("(");
                    if (hasOID) {
                        sqlString.append("OID,");
                    }
                    if (hasSOID) {
                        sqlString.append("SOID,");
                    }
                    int i = 0;
                    while (i < columnSize) {
                        sqlString.append(columnNames[i]).append(",");
                        ++i;
                    }
                    sqlString.deleteRight(1).append(") in (");
                    j = from;
                    while (j < to) {
                        sqlString.append("(");
                        if (hasOID) {
                            sqlString.append("?,");
                        }
                        if (hasSOID) {
                            sqlString.append("?,");
                        }
                        int i2 = 0;
                        while (i2 < columnSize) {
                            sqlString.append("?,");
                            ++i2;
                        }
                        sqlString.deleteRight(1).append("),");
                        ++j;
                    }
                    sqlString.deleteRight(1).append(")");
                } else {
                    j = from;
                    while (j < to) {
                        sqlString.append("(");
                        if (hasOID) {
                            sqlString.append("OID=? and ");
                        }
                        if (hasSOID) {
                            sqlString.append("SOID=? and ");
                        }
                        int i = 0;
                        while (i < columnSize) {
                            sqlString.append(columnNames[i]).append("=? and ");
                            ++i;
                        }
                        sqlString.deleteRight(" and ".length()).append(") or ");
                        ++j;
                    }
                    sqlString.deleteRight(" or ".length());
                }
                ResultSet resultSet = null;
                PreparedStatement statement = null;
                try {
                    statement = dbm.preparedQueryStatement(sqlString.getSql());
                    int paramentIndex = 1;
                    int j2 = from;
                    while (j2 < to) {
                        WhereExpressionForCache expression1 = list.get(j2);
                        if (hasOID) {
                            statement.setLong(paramentIndex++, expression1.oid);
                        }
                        if (hasSOID) {
                            statement.setLong(paramentIndex++, expression1.soid);
                        }
                        int i = 0;
                        while (i < columnSize) {
                            statement.setObject(paramentIndex++, expression1.columnValues[i]);
                            ++i;
                        }
                        ++j2;
                    }
                    if (statement instanceof PreparedStatementWithLog) {
                        ((PreparedStatementWithLog)statement).noCache();
                    }
                    resultSet = statement.executeQuery();
                    cacheTable.appendPreLoad(dbm, resultSet, null);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                ++ind;
            }
        }
        cacheTable.clearPreLoadingArguments();
        return true;
    }
}

