/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.parsedsql;

import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.dbcache.config.IgnoreSqlCacheSetting;
import com.bokesoft.yes.mid.dbcache.config.TablePrimarySetting;
import com.bokesoft.yes.mid.dbcache.parsedsql.DeParser;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.util.deparser.InsertDeParser;
import org.apache.commons.lang3.ArrayUtils;

public class ParsedInsert
extends ParsedSql {
    final Insert insert;
    private Boolean isSupportCache = null;
    private int[] columnIndexes;

    public ParsedInsert(String sql, Insert insert) {
        super(sql);
        this.insert = insert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupportCache() throws Throwable {
        if (this.isSupportCache == null) {
            ParsedInsert parsedInsert = this;
            synchronized (parsedInsert) {
                if (this.isSupportCache == null) {
                    String oidField = TablePrimarySetting.getOIDField(this.getCacheTableName());
                    boolean containsPrimaryKey = false;
                    List columns = this.insert.getColumns();
                    if (columns != null) {
                        for (Object obj : columns) {
                            Column column = (Column)obj;
                            String field = column.getColumnName();
                            if (!oidField.equalsIgnoreCase(field)) continue;
                            containsPrimaryKey = true;
                            break;
                        }
                    }
                    this.isSupportCache = !(this.insert.getItemsList() instanceof SubSelect) && containsPrimaryKey && MetaTableCache.getFullMetaTable(this.getCacheTableName()) != null && !this.insert.isUseOnDuplicateKeyUpdate() && IgnoreSqlCacheSetting.isSupportCacheTables(this.getTableNames());
                }
            }
        }
        return this.isSupportCache;
    }

    @Override
    protected List<String> findTableNames() {
        ArrayList<String> tmp = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer(512);
        DeParser deParser = ParsedInsert.getSelectDeParser(tmp, buffer);
        InsertDeParser insertDeParser = new InsertDeParser(deParser.getExpressionDeParser(), deParser.getSelectDeParser(), buffer);
        insertDeParser.deParse(this.insert);
        tmp.add(this.insert.getTable().getName());
        return tmp;
    }

    @Override
    public Statement getStatement() {
        return this.insert;
    }

    public int[] getColumnIndexes(DataTable cache) {
        if (this.columnIndexes == null) {
            if (this.insert.getItemsList() instanceof ExpressionList) {
                List columns = this.insert.getColumns();
                int size = columns.size();
                int[] result = new int[size];
                DataTableMetaData metaData = cache.getMetaData();
                int i = 0;
                while (i < size) {
                    Column column = (Column)columns.get(i);
                    int columnIndex = metaData.findColumnIndexByKey(column.getColumnName());
                    if (columnIndex < 0) {
                        throw new RuntimeException("\u5b57\u6bb5" + column.getColumnName() + "\u5728\u8868" + this.getCacheTableName() + "\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173SQL\u8bed\u53e5\u3002" + this.sql);
                    }
                    result[i] = columnIndex;
                    ++i;
                }
                this.columnIndexes = result;
            } else {
                this.columnIndexes = ArrayUtils.EMPTY_INT_ARRAY;
            }
        }
        return this.columnIndexes;
    }
}

